/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.stragegy.order.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyStrategy;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyType;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.third.build.yangguang.YGGCService;
import com.bcxin.ins.third.build.yangguang.yggc.Result;
import com.bcxin.ins.third.build.yangguang.yggc.ResultDTO;
import com.bcxin.ins.third.build.yangguang.yggc.YGGC;
import com.bcxin.ins.vo.AdviceNoteVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.PolicyTransactionVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.SpecialBidVo;
import com.bcxin.ins.vo.UnderwriteVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.xiaoleilu.hutool.thread.ThreadUtil;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;

@Component
@OrderSupplyType(type=OrderSupplyType.OrderSupplyTypeEnum.PAYMENT_REQUEST)
public class StragegyPaymentRequest
implements OrderSupplyStrategy {
    @Autowired
    private PolicyService policyService;
    @Autowired
    private ProductService productService;
    @Autowired
    private InsTransactionAPIService insTransactionAPIService;
    @Autowired
    private YGGCService yGGCService;

    @Override
    public ModelAndView policyInitService(HttpServletRequest request, Long product_id) {
        return null;
    }

    @Override
    public ModelAndView getPolicyService(Long order_id, int page) {
        return null;
    }

    @Override
    public ResultDto pendingPolicyService(Object object, HttpServletRequest request) {
        return null;
    }

    @Override
    public ModelAndView confirmPolicyService(Long order_id) {
        return null;
    }

    @Override
    public ModelAndView paymentRequestService(Long order_id) {
        ModelAndView view = new ModelAndView();
        OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        ProductVo pd = this.productService.getProduct(Long.parseLong(vo.getProduct_oid()));
        if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && (pd.getProduct_code().contains("XYX-DQCK") || pd.getProduct_code().contains("XYX-XWCK"))) {
            this.xyxPayment(vo, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("BZX-SSBQ")) {
            this.ssPayment(vo, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GZX")) {
            this.gzxPayment(vo, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("TYX")) {
            this.tyxPayment(vo, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GZZRX")) {
            this.gzzrxPayment(vo, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("ZZX")) {
            this.zzxPayment(vo, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && (pd.getProduct_code().contains("GCTB") || pd.getProduct_code().contains("GCLY"))) {
            this.gcPayment(vo, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GYX")) {
            this.gyxPayment(vo, view);
        }
        view.addObject("pd", (Object)pd);
        view.addObject("dto", (Object)vo);
        view.addObject("nowTime", (Object)new Date());
        return view;
    }

    @Override
    public ResultDto underwritingRequestService(HttpServletRequest request) {
        return null;
    }

    @Override
    public ResultDto insuranceCalculationService(HttpServletRequest request) {
        return null;
    }

    @Override
    public ResultDto getElectronicInsuranceService(Long order_id) {
        return null;
    }

    private void xyxPayment(OrderFormVo vo, ModelAndView view) {
        if (vo.getPolicy_status().equals("2")) {
            view = new ModelAndView("/coninsweb/insurance/customs/transaction/waitOffer");
        } else if (vo.getPolicy_status().equals("6")) {
            view = new ModelAndView("/coninsweb/insurance/customs/transaction/passUnderwriting");
        } else if (vo.getPolicy_status().equals("15")) {
            view = new ModelAndView("/coninsweb/insurance/customs/transaction/declinature");
        } else if (vo.getPolicy_status().equals("3")) {
            UnderwriteVo underwriteVo = this.policyService.accordingToOrderIDGainInsUnderwrite(Long.valueOf(Long.parseLong(vo.getOid())));
            view = new ModelAndView("/coninsweb/insurance/customs/transaction/offer");
            view.addObject("underwriteVo", (Object)underwriteVo);
        } else if (vo.getPolicy_status().equals("16")) {
            AdviceNoteVo anVo = this.policyService.accordingToOrderIDToGetAdviceNoteVo(Long.valueOf(Long.parseLong(vo.getOid())));
            String path_sign = this.policyService.accordingToOrderIDGainPathSign(Long.valueOf(Long.parseLong(vo.getOid())));
            view = new ModelAndView("/coninsweb/insurance/customs/transaction/paymentNotice");
            view.addObject("path_sign", (Object)path_sign);
            view.addObject("anVo", (Object)anVo);
        } else if (vo.getPolicy_status().equals("5")) {
            if (!org.apache.commons.lang.StringUtils.isEmpty((String)vo.getProduct_code()) && "XYX-XWCK".equals(vo.getProduct_code())) {
                ThreadUtil.excAsync(() -> this.policyService.yxTimer(Long.valueOf(Long.parseLong(vo.getOid()))), (boolean)false);
                view = new ModelAndView("/coninsweb/insurance/customs/transaction/finishPay_xw");
            } else {
                view = new ModelAndView("/coninsweb/insurance/customs/transaction/finishPay");
            }
        }
    }

    private void ssPayment(OrderFormVo vo, ModelAndView view) {
        if (vo.getPolicy_status().equals("2")) {
            view = new ModelAndView("/coninsweb/insurance/lawsuit/transaction/waitOffer");
        } else if (vo.getPolicy_status().equals("6")) {
            view = new ModelAndView("/coninsweb/insurance/lawsuit/transaction/passUnderwriting");
        } else if (vo.getPolicy_status().equals("15")) {
            view = new ModelAndView("/coninsweb/insurance/lawsuit/transaction/declinature");
        } else if (vo.getPolicy_status().equals("4")) {
            try {
                AdviceNoteVo anVo = this.policyService.accordingToOrderIDToGetAdviceNoteVo(Long.valueOf(Long.parseLong(vo.getOid())));
                String path_sign = this.policyService.accordingToOrderIDGainPathSign(Long.valueOf(Long.parseLong(vo.getOid())));
                view = new ModelAndView("/coninsweb/insurance/transaction/paymentNotice");
                view.addObject("anVo", (Object)anVo);
                view.addObject("path_sign", (Object)path_sign);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (vo.getPolicy_status().equals("5")) {
            view = new ModelAndView("/coninsweb/insurance/lawsuit/transaction/finishPay");
        }
    }

    private void gzxPayment(OrderFormVo vo, ModelAndView view) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getPay_methods())) {
            AdviceNoteVo anVo = this.policyService.accordingToOrderIDToGetAdviceNoteVo(Long.valueOf(Long.parseLong(vo.getOid())));
            view = new ModelAndView("/coninsweb/api/gzx/transaction/paymentNotice");
            view.addObject("anVo", (Object)anVo);
        } else if (vo.getPolicy_status().equals("2")) {
            view = new ModelAndView("/coninsweb/api/gzx/transaction/waitOffer");
        } else if (vo.getPolicy_status().equals("6")) {
            view = new ModelAndView("/coninsweb/api/gzx/transaction/passUnderwriting");
        } else if (vo.getPolicy_status().equals("15")) {
            view = new ModelAndView("/coninsweb/api/gzx/transaction/declinature");
        } else if (vo.getPolicy_status().equals("4")) {
            if (this.productService.api_request_sign(vo.getProduct_code()) == 2) {
                view = new ModelAndView("/coninsweb/api/gzx/transaction/policyPayment_PAC");
            }
        } else if (vo.getPolicy_status().equals("5")) {
            view = new ModelAndView("/coninsweb/api/gzx/transaction/finishPay");
        }
    }

    private void tyxPayment(OrderFormVo vo, ModelAndView view) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getPay_methods()) && this.productService.api_request_sign(vo.getProduct_code()) == ConstProp.INT_NUMBER_ONE.intValue()) {
            AdviceNoteVo anVo = this.policyService.accordingToOrderIDToGetAdviceNoteVo(Long.valueOf(Long.parseLong(vo.getOid())));
            view.setViewName("/coninsweb/api/gmr/transaction/paymentNotice");
            view.addObject("anVo", (Object)anVo);
        } else if (vo.getPolicy_status().equals("2")) {
            view.setViewName("/coninsweb/api/gmr/transaction/waitOffer");
        } else if (vo.getPolicy_status().equals("6")) {
            view.setViewName("/coninsweb/api/gmr/transaction/passUnderwriting");
        } else if (vo.getPolicy_status().equals("15")) {
            view.setViewName("/coninsweb/api/gmr/transaction/declinature");
        } else if (vo.getPolicy_status().equals("4")) {
            if (this.productService.api_request_sign(vo.getProduct_code()) == ConstProp.INT_NUMBER_ONE.intValue()) {
                view.setViewName("/coninsweb/api/gmr/transaction/policyPayment");
            } else if (this.productService.api_request_sign(vo.getProduct_code()) == ConstProp.INT_NUMBER_TWO.intValue()) {
                view.setViewName("/coninsweb/api/gmr/transaction/policyPayment_PA");
            } else if (this.productService.api_request_sign(vo.getProduct_code()) == ConstProp.INT_NUMBER_FOUR.intValue()) {
                view.setViewName("/coninsweb/api/gmr/transaction/policyPayment_RB");
            }
        } else if (vo.getPolicy_status().equals("5")) {
            view.setViewName("/coninsweb/api/gmr/transaction/finishPay");
        }
    }

    private void gzzrxPayment(OrderFormVo vo, ModelAndView view) {
        try {
            this.policyService.payUrlChange(Long.valueOf(Long.parseLong(vo.getOid())));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (vo.getPolicy_status().equals("4") && vo.getProduct_code().contains("GZZRX-RB")) {
            view = new ModelAndView("/coninsweb/api/gzzrx/transaction/policyPaymentRB");
        }
    }

    private void zzxPayment(OrderFormVo vo, ModelAndView view) {
        if (vo.getPolicy_status().equals("2")) {
            view = new ModelAndView("/coninsweb/api/lote/transaction/waitOffer");
        } else if (vo.getPolicy_status().equals("6")) {
            view = new ModelAndView("/coninsweb/api/lote/transaction/passUnderwriting");
        } else if (vo.getPolicy_status().equals("15")) {
            view = new ModelAndView("/coninsweb/api/lote/transaction/declinature");
        } else if (vo.getPolicy_status().equals("4")) {
            if (this.productService.api_request_sign(vo.getProduct_code()) == 1) {
                view = new ModelAndView("/coninsweb/api/lote/transaction/policyPayment_ZA");
            } else if (this.productService.api_request_sign(vo.getProduct_code()) == 2) {
                view = new ModelAndView("/coninsweb/api/lote/transaction/policyPayment_PAC");
            } else if (this.productService.api_request_sign(vo.getProduct_code()) == 3) {
                view = new ModelAndView("/coninsweb/api/lote/transaction/policyPayment_YA");
                List tList = this.insTransactionAPIService.selectInsTransactionByInsOrderForm(Long.valueOf(Long.parseLong(vo.getOid())));
                if (tList.size() > 0) {
                    String du = ((InsTransaction)tList.get(0)).getDeal_url();
                    view.addObject("deal_url", (Object)du);
                }
            }
        } else if (vo.getPolicy_status().equals("5")) {
            view = new ModelAndView("/coninsweb/api/lote/transaction/finishPay");
        }
    }

    private void gcPayment(OrderFormVo vo, ModelAndView view) {
        if (vo.getPolicy_status().equals("2")) {
            view = new ModelAndView("/coninsweb/insurance/build/transaction/waitOffer");
        } else if (vo.getPolicy_status().equals("6")) {
            view = new ModelAndView("/coninsweb/insurance/build/transaction/finishPay");
            view.addObject("code", (Object)"200");
            view.addObject("msg", (Object)"\u652f\u4ed8\u6210\u529f\uff01");
        } else if (vo.getPolicy_status().equals("15")) {
            view = new ModelAndView("/coninsweb/insurance/build/transaction/declinature");
        } else if (vo.getPolicy_status().equals("4")) {
            if (!StringUtils.isEmpty((CharSequence)vo.getProduct_code()) && "BZX-TB-GCTB".equals(vo.getProduct_code())) {
                view = new ModelAndView("/coninsweb/insurance/build/transaction/policyPayment");
            } else if (!StringUtils.isEmpty((CharSequence)vo.getProduct_code()) && "BZX-YG-GCTB".equals(vo.getProduct_code())) {
                String url = null;
                boolean isSuccess = true;
                try {
                    SpecialBidVo specialBidVo = this.policyService.accordingToOrderIDToGetSpecialBidVo(Long.valueOf(vo.getOid()));
                    Result result = this.yGGCService.underwritingHttpSend(JSON.toJSONString((Object)YGGC.getDemo((OrderFormVo)vo, (SpecialBidVo)specialBidVo)), "1");
                    String errorCode = ((ResultDTO)result.getTbResultList().get(0)).getErrorCode();
                    String policyNo = ((ResultDTO)result.getTbResultList().get(0)).getPolicyNo();
                    String premiumP = specialBidVo.getPremium();
                    if ("SUCCESS00000".equals(errorCode)) {
                        R r = this.yGGCService.payUrlZFB(policyNo, premiumP);
                        if (r.getSuccess().booleanValue()) {
                            PolicyTransactionVo pvo = new PolicyTransactionVo();
                            pvo.setPolicy_id(vo.getOid());
                            pvo.setPolicy_serial_number(policyNo);
                            this.policyService.saveTransaction(pvo);
                            url = r.getMsg();
                        }
                    } else {
                        String operateMessage = ((ResultDTO)result.getTbResultList().get(0)).getOperateMessage();
                        isSuccess = false;
                        url = "/insurance/build/policy/updateOrderFormStatus";
                        view.addObject("wrongMessage", (Object)operateMessage);
                    }
                    view = new ModelAndView("/coninsweb/insurance/build/transaction/policyPaymentYG");
                    view.addObject("oid", (Object)vo.getOid());
                    view.addObject("isSuccess", (Object)isSuccess);
                    view.addObject("url", (Object)url);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (!StringUtils.isEmpty((CharSequence)vo.getProduct_code()) && "BZX-DB-GCTB".equals(vo.getProduct_code())) {
                view = new ModelAndView("/coninsweb/insurance/build/transaction/policyPaymentDB");
            } else if (!StringUtils.isEmpty((CharSequence)vo.getProduct_code()) && "BZX-GCLY".equals(vo.getProduct_code())) {
                AdviceNoteVo anVo = this.policyService.accordingToOrderIDToGetAdviceNoteVo(Long.valueOf(Long.parseLong(vo.getOid())));
                String path_sign = this.policyService.accordingToOrderIDGainPathSign(Long.valueOf(Long.parseLong(vo.getOid())));
                view = new ModelAndView("/coninsweb/insurance/transaction/paymentNotice");
                view.addObject("anVo", (Object)anVo);
                view.addObject("path_sign", (Object)path_sign);
            }
        } else if (vo.getPolicy_status().equals("5")) {
            view = new ModelAndView("/coninsweb/insurance/build/transaction/finishPay_ly");
        }
    }

    private void gyxPayment(OrderFormVo vo, ModelAndView view) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getPay_methods())) {
            AdviceNoteVo anVo = this.policyService.accordingToOrderIDToGetAdviceNoteVo(Long.valueOf(Long.parseLong(vo.getOid())));
            view = new ModelAndView("/coninsweb/api/gyx/transaction/paymentNotice");
            view.addObject("anVo", (Object)anVo);
        } else if (vo.getPolicy_status().equals("4")) {
            if ("GYX".equals(vo.getProduct_code().split("-")[0])) {
                view = new ModelAndView("/coninsweb/api/gyx/transaction/policyPayment_TB");
            }
        } else if (vo.getPolicy_status().equals("5")) {
            view = new ModelAndView("/coninsweb/api/gyx/transaction/finishPay");
        }
    }
}

