/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.stragegy.order.impl;

import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyStrategy;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyType;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.util.enums.NatureLinkage;
import com.bcxin.ins.util.enums.OfficeType;
import com.bcxin.ins.vo.CommonExportVo_1;
import com.bcxin.ins.vo.CommonExportVo_2;
import com.bcxin.ins.vo.CommonExportVo_3;
import com.bcxin.ins.vo.GMRPolicyVo;
import com.bcxin.ins.vo.LOTEPolicyVo;
import com.bcxin.ins.vo.MicroExportVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.SpecialBidVo;
import com.bcxin.ins.vo.SpecialHirelingVo;
import com.bcxin.ins.vo.SpecialLitigationVo_1;
import com.bcxin.ins.vo.SpecialLitigationVo_2;
import com.bcxin.ins.vo.SpecialLitigationVo_3;
import com.bcxin.ins.vo.SpecialPerformanceVo_1;
import com.bcxin.ins.vo.SpecialPerformanceVo_2;
import com.bcxin.ins.vo.SpecialPerformanceVo_3;
import com.bcxin.ins.vo.SpecialPublicDutyVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;

@Component
@OrderSupplyType(type=OrderSupplyType.OrderSupplyTypeEnum.CONFIRM_POLICY)
public class StragegyConfirmPolicy
implements OrderSupplyStrategy {
    @Autowired
    private PolicyService policyService;
    @Autowired
    private ProductService productService;

    @Override
    public ModelAndView policyInitService(HttpServletRequest request, Long product_id) {
        return null;
    }

    @Override
    public ModelAndView getPolicyService(Long order_id, int page) {
        return null;
    }

    @Override
    public ResultDto pendingPolicyService(Object object, HttpServletRequest request) {
        return null;
    }

    @Override
    public ModelAndView confirmPolicyService(Long order_id) {
        ModelAndView view = new ModelAndView();
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
        if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("XYX-DQCK")) {
            this.dqckConfirm(dto, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("XYX-XWCK")) {
            this.xwckConfirm(dto, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("BZX-SSBQ")) {
            this.ssbqConfirm(dto, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GZX")) {
            this.gzxConfirm(dto, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("TYX")) {
            this.tyxConfirm(dto, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GZZRX")) {
            this.gzzrxConfirm(dto, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("ZZX")) {
            this.zzxConfirm(dto, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GCTB")) {
            this.gctbConfirm(dto, view);
        } else if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GCLY")) {
            this.gclyConfirm(dto, view);
        }
        view.addObject("pd", (Object)pd);
        view.addObject("dto", (Object)dto);
        return view;
    }

    @Override
    public ModelAndView paymentRequestService(Long order_id) {
        return null;
    }

    @Override
    public ResultDto underwritingRequestService(HttpServletRequest request) {
        return null;
    }

    @Override
    public ResultDto insuranceCalculationService(HttpServletRequest request) {
        return null;
    }

    @Override
    public ResultDto getElectronicInsuranceService(Long order_id) {
        return null;
    }

    private void dqckConfirm(OrderFormVo dto, ModelAndView view) {
        view.setViewName("/coninsweb/insurance/customs/policy/policyConfirm_my");
        long order_id = Long.parseLong(dto.getOid());
        CommonExportVo_1 vo1 = this.policyService.accordingToOrderIDToGetCommonExportVo_1(Long.valueOf(order_id));
        CommonExportVo_2 vo2 = this.policyService.accordingToOrderIDToGetCommonExportVo_2(Long.valueOf(order_id));
        CommonExportVo_3 vo3 = this.policyService.accordingToOrderIDToGetCommonExportVo_3(Long.valueOf(order_id));
        view.addObject("vo1", (Object)vo1);
        view.addObject("vo2", (Object)vo2);
        view.addObject("vo3", (Object)vo3);
        view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo1.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo1.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo1.getRoleSubjectList().get(0)).getReg_district()));
    }

    private void xwckConfirm(OrderFormVo dto, ModelAndView view) {
        view.setViewName("/coninsweb/insurance/customs/policy/policyConfirm_mi");
        MicroExportVo vo = this.policyService.accordingToOrderIDToGetMicroExportVo(Long.valueOf(Long.parseLong(dto.getOid())));
        view.addObject("vo", (Object)vo);
        view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
        view.addObject("reg_rule", (Object)(RegionUtils.getRegionNameByALLCode((String)vo.getLawsuit_province(), (String)vo.getLawsuit_city(), (String)vo.getLawsuit_area()) + vo.getLawsuit_address()));
    }

    private void ssbqConfirm(OrderFormVo dto, ModelAndView view) {
        view.setViewName("/coninsweb/insurance/lawsuit/policy/policyConfirm_ss");
        long order_id = Long.parseLong(dto.getOid());
        SpecialLitigationVo_1 vo1 = this.policyService.accordingToOrderIDToGetSpecialLitigationVo_1(Long.valueOf(order_id));
        SpecialLitigationVo_2 vo2 = this.policyService.accordingToOrderIDToGetSpecialLitigationVo_2(Long.valueOf(order_id));
        SpecialLitigationVo_3 vo3 = this.policyService.accordingToOrderIDToGetSpecialLitigationVo_3(Long.valueOf(order_id));
        view.addObject("vo1", (Object)vo1);
        view.addObject("vo2", (Object)vo2);
        view.addObject("vo3", (Object)vo3);
        view.addObject("reg_policy", (Object)RegionUtils.getRegionNameByALLCode((String)vo1.getProvince(), (String)vo1.getCity(), (String)vo1.getArea_code()));
        view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo1.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo1.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo1.getRoleSubjectList().get(0)).getReg_district()));
    }

    private void gzxConfirm(OrderFormVo dto, ModelAndView view) {
        view.addObject("comTypeList", (Object)IdType.comList());
        view.setViewName("/coninsweb/api/gzx/policy/policyConfirm");
        SpecialPublicDutyVo vo = this.policyService.accordingToOrderIDToGetSpecialPublicDutyVo(Long.valueOf(Long.parseLong(dto.getOid())));
        view.addObject("vo", (Object)vo);
        view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
        view.addObject("reg_role_1", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_district()));
    }

    private void tyxConfirm(OrderFormVo dto, ModelAndView view) {
        view.setViewName("/coninsweb/api/gmr/policy/policyConfirm");
        GMRPolicyVo vo = this.policyService.accordingToOrderIDToGetGMRPolicyVo(Long.valueOf(Long.parseLong(dto.getOid())));
        List natureList = NatureLinkage.doList();
        List typeList = IdType.doList();
        view.addObject("vo", (Object)vo);
        view.addObject("typeList", (Object)typeList);
        view.addObject("natureList", (Object)natureList);
        view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
    }

    private void gzzrxConfirm(OrderFormVo dto, ModelAndView view) {
        view.setViewName("/coninsweb/api/gzzrx/policy/policy_confirm");
        SpecialHirelingVo vo = this.policyService.accordingToOrderIDToGetSpecialHirelingVo(Long.valueOf(Long.parseLong(dto.getOid())));
        List natureList = NatureLinkage.doList();
        List typeList = IdType.doList();
        view.addObject("vo", (Object)vo);
        view.addObject("typeList", (Object)typeList);
        view.addObject("natureList", (Object)natureList);
        view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
    }

    private void zzxConfirm(OrderFormVo dto, ModelAndView view) {
        view.addObject("comTypeList", (Object)IdType.comList());
        view.setViewName("/coninsweb/api/lote/policy/policyConfirm");
        LOTEPolicyVo vo = this.policyService.accordingToOrderIDToGetLOTEPolicyVo(Long.valueOf(Long.parseLong(dto.getOid())));
        view.addObject("vo", (Object)vo);
        view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
        view.addObject("reg_role_1", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_district()));
        view.addObject("ex_pca", (Object)RegionUtils.getRegionNameByALLCode((String)vo.getSpecialExhibitionVo().getEx_province(), (String)vo.getSpecialExhibitionVo().getEx_city(), (String)vo.getSpecialExhibitionVo().getEx_county()));
    }

    private void gctbConfirm(OrderFormVo dto, ModelAndView view) {
        view.setViewName("/coninsweb/insurance/build/policy/policyConfirm_bd");
        SpecialBidVo vo = this.policyService.accordingToOrderIDToGetSpecialBidVo(Long.valueOf(Long.parseLong(dto.getOid())));
        view.addObject("otList", (Object)OfficeType.listT((String)(dto.getProduct_code().contains("DB") ? "DB" : "OT")));
        view.addObject("vo", (Object)vo);
        view.addObject("reg_policy", (Object)RegionUtils.getRegionNameByALLCode((String)vo.getProvince(), (String)vo.getCity(), (String)vo.getArea_code()));
        view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
        view.addObject("reg_role_1", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_district()));
    }

    private void gclyConfirm(OrderFormVo dto, ModelAndView view) {
        view.setViewName("/coninsweb/insurance/build/policy/policyConfirm_ly");
        long order_id = Long.parseLong(dto.getOid());
        SpecialPerformanceVo_1 vo1 = this.policyService.accordingToOrderIDToGetSpecialPerformanceVo_1(Long.valueOf(order_id));
        SpecialPerformanceVo_2 vo2 = this.policyService.accordingToOrderIDToGetSpecialPerformanceVo_2(Long.valueOf(order_id));
        SpecialPerformanceVo_3 vo3 = this.policyService.accordingToOrderIDToGetSpecialPerformanceVo_3(Long.valueOf(order_id));
        view.addObject("vo1", (Object)vo1);
        view.addObject("vo2", (Object)vo2);
        view.addObject("vo3", (Object)vo3);
        view.addObject("reg_policy", (Object)RegionUtils.getRegionNameByALLCode((String)vo1.getProvince(), (String)vo1.getCity(), (String)vo1.getArea_code()));
        view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo2.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo2.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo2.getRoleSubjectList().get(0)).getReg_district()));
    }
}

