/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.controller.lawsuit;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.util.DSUtil;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.vo.AdviceNoteVo;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.SpecialLitigationVo_1;
import com.bcxin.ins.vo.SpecialLitigationVo_2;
import com.bcxin.ins.vo.SpecialLitigationVo_3;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/insurance/lawsuit"})
public class Lawsuit_Policy_Controller
extends BaseController {
    @Autowired
    private ProductService productService;
    @Autowired
    private PolicyService policyService;

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u4ea7\u54c1-\u8bbf\u95ee\u6295\u4fdd\u9875")
    @RequestMapping(value={"/policyInit/{product_id}"})
    public ModelAndView policyInit(HttpServletRequest request, @PathVariable Long product_id, ModelMap model) throws Exception {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView(DSUtil.operation() + "/insurance/lawsuit/policyInit/" + product_id);
        }
        ModelAndView view = new ModelAndView();
        ProductVo pd = this.productService.getProduct(product_id.longValue());
        view.addObject("recommend_code", (Object)UserSupportUtil.getRecommendCode());
        view.addObject("userdetail", (Object)userdetail);
        view.addObject("pd", (Object)pd);
        view.addObject("sigId", (Object)String.valueOf(IdWorker.getId()));
        view.setViewName("/coninsweb/insurance/lawsuit/policy/enterBasicInfo_ss_1");
        this.initEnumList(view);
        this.setTokenByApi(view);
        return view;
    }

    private void initEnumList(ModelAndView view) {
        view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
    }

    @RequestMapping(value={"/policy/lt_policy/{order_id}/{page}"})
    public ModelAndView pg_policy(@PathVariable Long order_id, @PathVariable int page, HttpServletRequest reqeust) throws Exception {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView(DSUtil.operation() + "/insurance/lawsuit/policy/lt_policy/" + order_id + "/" + page);
        }
        ModelAndView view = new ModelAndView();
        view.addObject("userdetail", (Object)userdetail);
        if (page <= 0) {
            return view;
        }
        view.addObject("dto", (Object)this.policyService.accordingToOrderIDToGetPolicyDto(order_id));
        if (page == 1) {
            view.setViewName("/coninsweb/insurance/lawsuit/policy/enterBasicInfo_ss_1");
            SpecialLitigationVo_1 vo = this.policyService.accordingToOrderIDToGetSpecialLitigationVo_1(order_id);
            view.addObject("vo", (Object)vo);
            view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
            if (StringUtils.isNotEmpty((CharSequence)vo.getProvince())) {
                view.addObject("cityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)vo.getProvince()));
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getProvince())) {
                view.addObject("areaList", (Object)RegionUtils.findDistrictByParentCode((String)"3", (String)vo.getCity()));
            }
            if (vo.getRoleSubjectList().size() <= 0) {
                this.initEnumList(view);
                this.setTokenByApi(view);
                return view;
            }
            if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province())) {
                view.addObject("reg_cityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province()));
            }
            if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city())) {
                view.addObject("reg_areaList", (Object)RegionUtils.findDistrictByParentCode((String)"3", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city()));
            }
        } else if (page == 2) {
            view.setViewName("/coninsweb/insurance/lawsuit/policy/enterBasicInfo_ss_2");
            SpecialLitigationVo_2 vo = this.policyService.accordingToOrderIDToGetSpecialLitigationVo_2(order_id);
            view.addObject("vo", (Object)vo);
            view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
            view.addObject("bankCityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)vo.getMailPolicyVo().getBank_province()));
        } else if (page == 3) {
            view.setViewName("/coninsweb/insurance/lawsuit/policy/enterBasicInfo_ss_3");
            view.addObject("vo", (Object)this.policyService.accordingToOrderIDToGetSpecialLitigationVo_3(order_id));
        }
        this.initEnumList(view);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/policy/confirmPage/{order_id}"})
    public ModelAndView confirmPage(@PathVariable Long order_id, HttpServletRequest reqeust) throws Exception {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView(DSUtil.operation() + "/insurance/lawsuit/policy/confirmPage/" + order_id);
        }
        ModelAndView view = new ModelAndView();
        view.addObject("userdetail", (Object)userdetail);
        view.addObject("dto", (Object)this.policyService.accordingToOrderIDToGetPolicyDto(order_id));
        view.setViewName("/coninsweb/insurance/lawsuit/policy/policyConfirm_ss");
        SpecialLitigationVo_1 vo1 = this.policyService.accordingToOrderIDToGetSpecialLitigationVo_1(order_id);
        SpecialLitigationVo_2 vo2 = this.policyService.accordingToOrderIDToGetSpecialLitigationVo_2(order_id);
        SpecialLitigationVo_3 vo3 = this.policyService.accordingToOrderIDToGetSpecialLitigationVo_3(order_id);
        view.addObject("vo1", (Object)vo1);
        view.addObject("vo2", (Object)vo2);
        view.addObject("vo3", (Object)vo3);
        view.addObject("reg_policy", (Object)RegionUtils.getRegionNameByALLCode((String)vo1.getProvince(), (String)vo1.getCity(), (String)vo1.getArea_code()));
        view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo1.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo1.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo1.getRoleSubjectList().get(0)).getReg_district()));
        this.setTokenByApi(view);
        return view;
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_ORDER, title="\u3010\u8bf7\u6c42\u3011\u4ea7\u54c1-\u8ba2\u5355\u6295\u4fdd")
    @RequestMapping(value={"/policy/pendingSpecialLitigation_1VoPolicy"})
    @ResponseBody
    public ResultDto pendingSpecialLitigation_1VoPolicy(SpecialLitigationVo_1 vo, HttpServletRequest reqeust, HttpServletResponse response, ModelMap model) throws Exception {
        String recommendCode = reqeust.getParameter("recommend_code");
        return this.policyService.pendingSpecialLitigation_1VoPolicy(vo, recommendCode);
    }

    @RequestMapping(value={"/policy/pendingSpecialLitigation_2VoPolicy"})
    @ResponseBody
    public ResultDto pendingSpecialLitigation_2VoPolicy(SpecialLitigationVo_2 vo, HttpServletRequest reqeust, HttpServletResponse response, ModelMap model) throws Exception {
        return this.policyService.pendingSpecialLitigation_2VoPolicy(vo);
    }

    @RequestMapping(value={"/policy/pendingSpecialLitigation_3VoPolicy"})
    @ResponseBody
    public ResultDto pendingSpecialLitigation_3VoPolicy(SpecialLitigationVo_3 vo, HttpServletRequest reqeust, HttpServletResponse response, ModelMap model) throws Exception {
        return this.policyService.pendingSpecialLitigation_3VoPolicy(vo);
    }

    @RequestMapping(value={"/policy/updateOrderFormStatus"})
    @ResponseBody
    public ResultDto updateOrderFormStatus(HttpServletRequest reqeust) throws Exception {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ResultDto("\u8d26\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c", "/");
        }
        String order_id = reqeust.getParameter("order_id");
        String status = reqeust.getParameter("status");
        if (StringUtils.isEmpty((CharSequence)order_id) || StringUtils.isEmpty((CharSequence)status)) {
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        OrderFormVo vo = new OrderFormVo();
        vo.setOid(String.valueOf(order_id));
        vo.setPolicy_status(status);
        String orderID = this.policyService.updateOrderFormStatus(vo);
        if (StringUtils.isNotEmpty((CharSequence)orderID)) {
            return new ResultDto("\u8ba2\u5355\u5f55\u5165\u6210\u529f\u3002", "200", orderID, "", "");
        }
        return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
    }

    @RequestMapping(value={"/policy/policyPayment/{oid}"})
    public ModelAndView policyPayment(@PathVariable long oid) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView(DSUtil.operation() + "/insurance/lawsuit/policy/policyPayment/" + oid);
        }
        OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(oid));
        ModelAndView view = null;
        if (vo.getPolicy_status().equals("2")) {
            view = new ModelAndView("/coninsweb/insurance/lawsuit/transaction/waitOffer");
        } else if (vo.getPolicy_status().equals("6")) {
            view = new ModelAndView("/coninsweb/insurance/lawsuit/transaction/passUnderwriting");
        } else if (vo.getPolicy_status().equals("15")) {
            view = new ModelAndView("/coninsweb/insurance/lawsuit/transaction/declinature");
        } else if (vo.getPolicy_status().equals("4")) {
            try {
                AdviceNoteVo anVo = this.policyService.accordingToOrderIDToGetAdviceNoteVo(Long.valueOf(oid));
                String path_sign = this.policyService.accordingToOrderIDGainPathSign(Long.valueOf(oid));
                view = new ModelAndView("/coninsweb/insurance/transaction/paymentNotice");
                view.addObject("anVo", (Object)anVo);
                view.addObject("path_sign", (Object)path_sign);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (vo.getPolicy_status().equals("5")) {
            view = new ModelAndView("/coninsweb/insurance/lawsuit/transaction/finishPay");
        }
        view.addObject("userdetail", (Object)userdetail);
        view.addObject("nowTime", (Object)new Date());
        view.addObject("dto", (Object)vo);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/policy/deleteLnAccusedByOid"})
    @ResponseBody
    public ResultDto deleteLnAccusedByOid(HttpServletRequest request) {
        String lna_id = request.getParameter("lna_id");
        if (StringUtils.isEmpty((CharSequence)lna_id)) {
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u5220\u9664\u5931\u8d25\uff01", "300", "", "", "");
        }
        if (this.policyService.deleteLnAccusedByOid(lna_id)) {
            return new ResultDto("\u5220\u9664\u6210\u529f\uff01", "200", "", "", "");
        }
        return new ResultDto("\u8fd0\u884c\u65f6\u5f02\u5e38\uff0c\u5220\u9664\u5931\u8d25\uff01", "300", "", "", "");
    }
}

