/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.controller.insurance.tyx;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.third.tyx.changan.TYX_CARequestService;
import com.bcxin.ins.third.tyx.huatai.TYX_HTRequestService;
import com.bcxin.ins.third.tyx.pingan.PARequestService;
import com.bcxin.ins.third.tyx.pingancai.PACRequestService;
import com.bcxin.ins.third.tyx.qianhai.TYX_QHRequestService;
import com.bcxin.ins.third.tyx.renbao.RBRequestService;
import com.bcxin.ins.third.tyx.taikang.TKRequestService;
import com.bcxin.ins.util.DSUtil;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.InsureVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.PolicyTransactionVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/insurance/tyx/transaction"})
public class TYXTransactionController
extends BaseController {
    @Autowired
    private TKRequestService tKRequestService;
    @Autowired
    private PARequestService pARequestService;
    @Autowired
    private PACRequestService pACRequestService;
    @Autowired
    private TYX_QHRequestService tYX_QHRequestService;
    @Autowired
    private InsInsuranceSlipAPIService insInsuranceSlipService;
    @Autowired
    private ProductService productService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private RBRequestService rBRequestService;
    @Autowired
    private TYX_CARequestService tYX_CARequestService;
    @Autowired
    private TYX_HTRequestService tYX_HTRequestService;
    @Autowired
    private InsTransactionAPIService transactionService;
    @Autowired
    private MyAsyncExecutor myAsyncExecutor;
    private String ONLINE = "ONLINE";
    private String OFFLINE = "OFFLINE";

    @LoginRequired
    @RequestMapping(value={"/policyPayment"})
    @ResponseBody
    public ResultDto policyPayment(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String oid = request.getParameter("policyId");
        String payType = request.getParameter("payType");
        String doType = "";
        if (this.ONLINE.equals(payType)) {
            doType = "3";
        } else if (this.OFFLINE.equals(payType)) {
            doType = "6";
        }
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(oid)));
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (StringUtils.isNotEmpty((CharSequence)doType)) {
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setStart_time(new Date());
            pvo.setPayment_method("1");
            pvo.setPay_type(doType);
            pvo.setPolicy_id(oid);
            pvo.setUser_id(Long.valueOf(Long.parseLong(userdetail.getOid())));
            IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
            pvo.setTrade_serial_number(String.valueOf(idWorker.nextId()));
            this.policyService.saveTransaction(pvo);
            return new ResultDto("", "200", "", "", "");
        }
        return new ResultDto("\u652f\u4ed8\u65b9\u5f0f\u4e22\u5931", "300", "", "", "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @LoginRequired
    @RequestMapping(value={"/API_Underwriting"})
    @ResponseBody
    public ResultDto API_Underwriting(HttpServletRequest request, HttpServletResponse response) throws Exception {
        PolicyTransactionVo pvo;
        String user_id = request.getParameter("user_id");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html; charset=UTF-8");
        String oid = request.getParameter("policyId");
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(oid)));
        String result = "";
        String[] strs = null;
        if (this.productService.api_request_sign(dto.getProduct_code()) == 1) {
            result = this.tKRequestService.requestTK(Long.valueOf(Long.parseLong(oid)), "01");
            strs = result.split("#");
        } else if (this.productService.api_request_sign(dto.getProduct_code()) == 2) {
            result = this.pARequestService.requestPA(Long.valueOf(Long.parseLong(oid)), "1", null);
            strs = result.split("#");
        } else if (this.productService.api_request_sign(dto.getProduct_code()) == 4) {
            result = this.rBRequestService.request_rb_tyx(Long.valueOf(Long.parseLong(oid)), "1", null);
            strs = result.split("#");
        } else if (this.productService.api_request_sign(dto.getProduct_code()) == 5) {
            result = this.pACRequestService.requestPAC(Long.valueOf(Long.parseLong(oid)), "1", null);
            strs = result.split("#");
        } else if (this.productService.api_request_sign(dto.getProduct_code()) == 6) {
            result = this.tYX_CARequestService.request_ca_tyx(Long.valueOf(Long.parseLong(oid)), "1", null);
            strs = result.split("#");
        } else {
            if (this.productService.api_request_sign(dto.getProduct_code()) == 7) {
                IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
                result = this.tYX_QHRequestService.request_qh_tyx(Long.valueOf(Long.parseLong(oid)), "1", null);
                strs = result.split("#");
                if (!"200".equals(strs[0])) {
                    return new ResultDto(strs[1], "300", "", "", "");
                }
                if (StringUtils.isEmpty((CharSequence)strs[1])) {
                    return new ResultDto("\uff08APP-TYX-009\uff09\u6570\u636e\u4e22\u5931\uff01", "300", "", "", "");
                }
                String payNo = String.valueOf(idWorker.nextId());
                String payPath = strs[2];
                PolicyTransactionVo pvo2 = new PolicyTransactionVo();
                pvo2.setPolicy_id(oid);
                pvo2.setPolicy_serial_number(strs[1]);
                pvo2.setDeal_url(payPath);
                pvo2.setPayment_method("1");
                pvo2.setPay_type("7");
                pvo2.setPay_amount(new BigDecimal(dto.getGross_premium()));
                pvo2.setTransaction_status("2");
                pvo2.setPath_sign("1");
                pvo2.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
                pvo2.setPay_order_number(payNo);
                pvo2.setTrade_serial_number(String.valueOf(idWorker.nextId()));
                this.policyService.saveTransaction(pvo2);
                return new ResultDto("", "200", "", "", "");
            }
            if (this.productService.api_request_sign(dto.getProduct_code()) != 8) return new ResultDto("\u4ea7\u54c1\u672a\u5339\u914d\u5230\u5bf9\u5e94\u63a5\u53e3\uff01", "300", "", "", "");
            String hbRet = this.tYX_HTRequestService.request_ht_tyx(Long.valueOf(Long.parseLong(oid)), "1", null);
            if (!hbRet.contains("200")) return new ResultDto("\uff08APP-GZX-001\uff09" + hbRet.split("#")[1], "300", "", "", "");
            result = this.tYX_HTRequestService.request_ht_tyx(Long.valueOf(Long.parseLong(oid)), "25", null);
            strs = result.split("#");
        }
        if (!"200".equals(strs[0])) {
            return new ResultDto(strs[1], "300", "", "", "");
        }
        if (StringUtils.isEmpty((CharSequence)strs[1])) {
            return new ResultDto("\uff08APP-TYX-009\uff09\u6570\u636e\u4e22\u5931\uff01", "300", "", "", "");
        }
        if (this.productService.api_request_sign(dto.getProduct_code()) == 4) {
            String payPath = "";
            String payNo = "";
            if (strs[2].contains("\uff1a")) {
                payNo = strs[2].split(",")[0].split("\uff1a")[1];
                payPath = strs[2].split(",")[1].split("\uff1a")[1];
            }
            if (StringUtils.isEmpty((CharSequence)payNo) || StringUtils.isEmpty((CharSequence)payPath)) {
                return new ResultDto("\u672a\u83b7\u53d6\u5230\u652f\u4ed8\u4fe1\u606f\uff01", "300", "", "", "");
            }
            PolicyTransactionVo pvo3 = new PolicyTransactionVo();
            pvo3.setPolicy_id(oid);
            pvo3.setPolicy_serial_number(strs[1]);
            pvo3.setDeal_url(payPath);
            pvo3.setPayment_method("1");
            pvo3.setPay_type("2");
            pvo3.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo3.setTransaction_status("2");
            pvo3.setPath_sign("1");
            pvo3.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
            pvo3.setPay_order_number(payNo);
            IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
            pvo3.setTrade_serial_number(String.valueOf(idWorker.nextId()));
            this.policyService.saveTransaction(pvo3);
            return new ResultDto("", "200", "", "", "");
        } else if (this.productService.api_request_sign(dto.getProduct_code()) == 5) {
            pvo = new PolicyTransactionVo();
            pvo.setPolicy_id(oid);
            pvo.setPolicy_serial_number(strs[1]);
            pvo.setNotice_no(strs[2]);
            this.policyService.saveTransaction(pvo);
            return new ResultDto("", "200", "", "", "");
        } else if (this.productService.api_request_sign(dto.getProduct_code()) == 6) {
            pvo = new PolicyTransactionVo();
            pvo.setPolicy_id(oid);
            pvo.setPolicy_serial_number(strs[1]);
            this.policyService.saveTransaction(pvo);
            return new ResultDto("", "200", "", "", "");
        } else if (this.productService.api_request_sign(dto.getProduct_code()) == 8) {
            pvo = new PolicyTransactionVo();
            pvo.setPolicy_id(oid);
            pvo.setPolicy_serial_number(strs[1]);
            if (strs.length == 6) {
                if (StringUtils.isNotEmpty((CharSequence)strs[4])) {
                    pvo.setNotice_no(strs[1] + "_" + strs[4]);
                }
                if (StringUtils.isNotEmpty((CharSequence)strs[2])) {
                    pvo.setLg_path(strs[2]);
                }
                if (StringUtils.isNotEmpty((CharSequence)strs[3])) {
                    pvo.setInsure_path(strs[3]);
                }
            }
            this.policyService.saveTransaction(pvo);
            return new ResultDto("", "200", "", "", "");
        } else {
            pvo = new PolicyTransactionVo();
            pvo.setPolicy_id(oid);
            pvo.setPolicy_serial_number(strs[1]);
            this.policyService.saveTransaction(pvo);
        }
        return new ResultDto("", "200", "", "", "");
    }

    @RequestMapping(value={"/failMessage"})
    public ModelAndView failMessage(HttpServletRequest request) {
        String msg = request.getParameter("msg");
        ModelAndView view = new ModelAndView("/coninsweb/insurance/tyx/transaction/failMessage");
        view.addObject("msg", (Object)msg);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/finish_iframe/{oid}"})
    public ModelAndView finish_iframe(@PathVariable long oid) {
        ModelAndView view = new ModelAndView("/coninsweb/insurance/tyx/gmr_order_finish");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return new ModelAndView(DSUtil.operation() + "/insurance/tyx/transaction/finish_iframe/" + oid);
        }
        view.addObject("userdetail", (Object)userdetail);
        view.addObject("order_id", (Object)String.valueOf(oid));
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/syntony-service/{oid}"})
    public ModelAndView syntonyService(@PathVariable long oid) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail != null && (userdetail.getWeb_type().contains("PSS") || userdetail.getWeb_type().contains("PASP"))) {
            ModelAndView view = new ModelAndView("forward:/api/syntony-service/" + oid);
            this.setTokenByApi(view);
            return view;
        }
        ModelAndView view = new ModelAndView("/coninsweb/insurance/tyx/transaction/finishPay");
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(oid));
        ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
        view.addObject("pd", (Object)pd);
        view.addObject("dto", (Object)dto);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/uploadPayMentFile"})
    public JSONObject uploadPayMentFile(InsureVo insInsuranceSlip, HttpServletRequest request) {
        JSONObject json = new JSONObject();
        String message = "";
        String status = "300";
        boolean endUpload = false;
        String paymentPath = request.getParameter("paymentPath");
        InsInsuranceSlip oldPolicy = this.insInsuranceSlipService.selectById(insInsuranceSlip.getIns_insurance_slip_id());
        InsTransaction transaction = this.transactionService.getTranctionByorderIDAndStatus(oldPolicy.getIns_insurance_slip_id());
        if (StringUtils.isNotEmpty((CharSequence)paymentPath)) {
            transaction.setPay_order_url(paymentPath);
            if (StringUtils.isNotEmpty((CharSequence)oldPolicy.getInsure_path()) && StringUtils.isNotEmpty((CharSequence)transaction.getPay_order_url())) {
                endUpload = true;
            }
            this.transactionService.updateById((Object)transaction);
            if (endUpload) {
                this.policyService.saveOrUpdateTransaction_ss(String.valueOf(oldPolicy.getIns_insurance_slip_id()), transaction.getPay_order_url(), "", transaction.getPath_sign());
            }
            this.myAsyncExecutor.execute(() -> this.policyService.JFPZ_SendEmail(oldPolicy.getIns_insurance_slip_id(), transaction.getPay_order_url()));
            message = "\u4e0a\u4f20\u6210\u529f\uff01";
            status = "200";
        } else {
            message = "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5";
        }
        json.put((Object)"message", (Object)message);
        json.put((Object)"status", (Object)status);
        json.put((Object)"endUpload", (Object)endUpload);
        return json;
    }

    @RequestMapping(value={"/comUploadPayMentFile"})
    @ResponseBody
    public ResultDto comUploadPayMentFile(HttpServletRequest request) {
        String doPayments = request.getParameter("doPayments");
        String payAmount = request.getParameter("payAmount");
        String oid = request.getParameter("oid");
        String paymentPath = request.getParameter("paymentPath");
        if (StringUtils.isEmpty((CharSequence)doPayments) || StringUtils.isEmpty((CharSequence)payAmount) || StringUtils.isEmpty((CharSequence)oid) || StringUtils.isEmpty((CharSequence)paymentPath)) {
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u64cd\u4f5c\u5931\u8d25\uff01", "300", "", "", "");
        }
        String orderID = this.policyService.uploadPayMentFileToTranction(paymentPath, oid, doPayments, payAmount);
        if (StringUtils.isNotEmpty((CharSequence)orderID)) {
            this.myAsyncExecutor.execute(() -> this.policyService.JFPZ_SendEmail(Long.valueOf(Long.parseLong(oid)), paymentPath));
            return new ResultDto("\u4e0a\u4f20\u6210\u529f\uff01", "200", "true", "", "");
        }
        return new ResultDto("\u6570\u636e\u5b58\u50a8\u5931\u8d25\uff01", "300", "", "", "");
    }

    @RequestMapping(value={"/finishPay/{oid}"})
    public ModelAndView finishPay(@PathVariable long oid, HttpServletRequest request) {
        ModelAndView view = new ModelAndView("/coninsweb/insurance/tyx/transaction/finishPay");
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(oid));
        ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
        view.addObject("pd", (Object)pd);
        view.addObject("dto", (Object)dto);
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/isPaySuccess/{oid}"})
    @ResponseBody
    public String isPaySuccess(@PathVariable long oid) {
        InsTransaction it;
        com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
        List tranList = this.transactionService.selectInsTransactionByInsOrderForm(Long.valueOf(oid));
        String status = "300";
        if (tranList.size() > 0 && "1".equals((it = (InsTransaction)tranList.get(0)).getTransaction_status())) {
            status = "200";
        }
        json.put("status", (Object)status);
        return json.toJSONString();
    }

    @RequestMapping(value={"/isPolicyUnderwrite/{oid}"})
    @ResponseBody
    public String isPolicyUnderwrite(@PathVariable long oid) {
        com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
        OrderFormVo orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(oid));
        String status = "300";
        if (orderVo != null && "6".equals(orderVo.getPolicy_status())) {
            status = "200";
        }
        json.put("status", (Object)status);
        return json.toJSONString();
    }

    @RequestMapping(value={"/policyUnderwrite/{oid}"})
    public ModelAndView policyUnderwrite(@PathVariable(value="oid") String oid, HttpServletRequest request) {
        this.logger.info("\u56e2\u610f\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-star");
        this.logger.info("\u56e2\u610f\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-policyUnderwrite\uff1aoid:" + oid);
        ModelAndView view = new ModelAndView("/coninsweb/insurance/tyx/transaction/finishPay");
        if (StringUtils.isNotEmpty((CharSequence)oid)) {
            OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(Long.parseLong(oid)));
            ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
            view.addObject("pd", (Object)pd);
            view.addObject("dto", (Object)dto);
            this.logger.info("\u56e2\u610f\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-OrderFormVo\uff1a" + dto.toString());
        }
        view.addObject("oid", (Object)oid);
        this.logger.info("\u56e2\u610f\u9669\u627f\u4fdd\u5b8c\u6210\u540e\u9875\u9762\u5c55\u793a-end");
        this.setTokenByApi(view);
        return view;
    }
}

