/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.controller.export.web;

import com.bcxin.ins.common.http.MessageUtils;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.SysDict;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.entity.common.ComBuyers;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.entity.policy_core.InsShipDeclare;
import com.bcxin.ins.entity.policy_core.InsShipInvoices;
import com.bcxin.ins.entity.policy_core.InsShipReceive;
import com.bcxin.ins.entity.policy_special.StTopBuyers;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.InsBuyersAPIService;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.InsTopBuyersAPIService;
import com.bcxin.ins.service.order.ShipDeclareAPIService;
import com.bcxin.ins.service.order.ShipInvoicesAPIService;
import com.bcxin.ins.service.order.ShipReceiveAPIService;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.vo.BuyersVo_one;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.InsuredListAndBD;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.ShipDeclareAddVo;
import com.bcxin.ins.vo.ShipDeclareMultipleVo;
import com.bcxin.ins.vo.ShipDeclareStepTwoSearchVo;
import com.bcxin.ins.vo.ShipDeclareStepTwoVo;
import com.bcxin.ins.vo.ShipDeclareVo;
import com.bcxin.ins.vo.TopBuyersVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/ship/declare"})
public class ShipDeclareAPIController
extends BaseController {
    @Autowired
    private ShipDeclareAPIService shipDeclareService;
    @Autowired
    private InsBuyersAPIService insBuyersService;
    @Autowired
    private InsTopBuyersAPIService insTopBuyersService;
    @Autowired
    private ShipInvoicesAPIService shipInvoicesService;
    @Autowired
    private InsInsuranceSlipAPIService insInsuranceSlipService;
    @Autowired
    private ShipReceiveAPIService shipReceiveService;

    @RequestMapping(value={"/", "/index"})
    public ModelAndView getReceiveAccountsCenter(HttpServletRequest request, ModelMap model, DwzPage page) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/index");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            view.setViewName("/");
        } else {
            view.addObject("userdetail", (Object)userdetail);
            page.setNumPerPage(6);
            List lis = this.shipDeclareService.getCanShipDeclareList(Long.valueOf(Long.parseLong(userdetail.getOid())), page);
            view.addObject("orderFormVoList", (Object)lis);
        }
        return view;
    }

    @RequestMapping(value={"/getPolicyListForPage"})
    public ModelAndView getPolicyListForPage(DwzPage page) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/policyList_table");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        view.addObject("userdetail", (Object)userdetail);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userdetail.getOid());
        map.put("page", (String)page);
        List lis = this.shipDeclareService.getCanShipDeclareList(Long.valueOf(Long.parseLong(userdetail.getOid())), page);
        if (lis != null) {
            view.addObject("orderFormVoList", (Object)lis);
        }
        return view;
    }

    @RequestMapping(value={"/choise/{orderFormId}"})
    public ModelAndView getPolicyListForPage(@PathVariable Long orderFormId, DwzPage page) {
        List shipDeclareList;
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/searchResult");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        view.addObject("orderFormId", (Object)orderFormId);
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        view.addObject("userdetail", (Object)userdetail);
        page.setNumPerPage(6);
        OrderFormVo orderFormVo = this.shipDeclareService.getOrderFormVoByOrderFormId(orderFormId);
        if (orderFormVo == null) {
            return view;
        }
        ShipDeclareStepTwoVo shipDeclareStepTwoVo = new ShipDeclareStepTwoVo();
        shipDeclareStepTwoVo.setOrderFormVo(orderFormVo);
        List insuredNameList = this.shipDeclareService.getInsureNameList(orderFormId);
        if (null != insuredNameList) {
            shipDeclareStepTwoVo.setInsuredNameList(this.rmDuplication(insuredNameList));
        }
        if (null != (shipDeclareList = this.shipDeclareService.getShipDeclareByInsOrderFormId(orderFormId, null))) {
            ArrayList<String> countryList2 = new ArrayList<String>();
            for (InsShipDeclare shipDeclare : shipDeclareList) {
                Long insTopBuyersId = shipDeclare.getSt_top_buyers_id();
                StTopBuyers insTopBuyers = (StTopBuyers)this.insTopBuyersService.selectById((Serializable)insTopBuyersId);
                ComBuyers comBuyers = (ComBuyers)this.insBuyersService.selectById((Serializable)insTopBuyers.getCom_buyer().getCom_buyer_id());
                String country = insTopBuyers.getCom_buyer().getCountry();
                countryList2.add(country);
            }
            shipDeclareStepTwoVo.setCountryList(this.rmDuplication(countryList2));
        }
        List lis = this.shipDeclareService.getShipDeclareVoByInsOrderFormId(orderFormId, page);
        view.addObject("vo", (Object)shipDeclareStepTwoVo);
        view.addObject("page", (Object)page);
        return view;
    }

    private List<String> rmDuplication(List<String> list) {
        ArrayList<String> listReturn = new ArrayList<String>();
        for (String s : list) {
            if (Collections.frequency(listReturn, s) >= 1) continue;
            listReturn.add(s);
        }
        return listReturn;
    }

    @RequestMapping(value={"/choise_new/{orderFormId}"})
    public ModelAndView getDetailSearch(@PathVariable Long orderFormId, DwzPage page) {
        List shipDeclareList;
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/choiseDetailSearch_new");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        view.addObject("orderFormId", (Object)orderFormId);
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        view.addObject("userdetail", (Object)userdetail);
        page.setNumPerPage(6);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("orderFormId", orderFormId);
        map.put("page", (Long)page);
        ShipDeclareStepTwoVo shipDeclareStepTwoVo = new ShipDeclareStepTwoVo();
        OrderFormVo orderFormVo = this.shipDeclareService.getOrderFormVoByOrderFormId(orderFormId);
        shipDeclareStepTwoVo.setOrderFormVo(orderFormVo);
        List insuredNameList = this.shipDeclareService.getInsureNameList(orderFormId);
        if (null != insuredNameList) {
            shipDeclareStepTwoVo.setInsuredNameList(this.rmDuplication(insuredNameList));
        }
        if (null != (shipDeclareList = this.shipDeclareService.getShipDeclareByInsOrderFormId(orderFormId, null))) {
            ArrayList<String> countryList2 = new ArrayList<String>();
            for (InsShipDeclare shipDeclare : shipDeclareList) {
                Long insTopBuyersId = shipDeclare.getSt_top_buyers_id();
                StTopBuyers insTopBuyers = (StTopBuyers)this.insTopBuyersService.selectById((Serializable)insTopBuyersId);
                ComBuyers comBuyers = (ComBuyers)this.insBuyersService.selectById((Serializable)insTopBuyers.getCom_buyer().getCom_buyer_id());
                String country = comBuyers.getCountry();
                countryList2.add(country);
            }
            shipDeclareStepTwoVo.setCountryList(this.rmDuplication(countryList2));
        }
        map.put("shipDeclareStepTwoVo", (Long)shipDeclareStepTwoVo);
        map.put("page", (Long)page);
        view.addObject("shipDeclareStepTwoVo", (Object)shipDeclareStepTwoVo);
        return view;
    }

    @RequestMapping(value={"/getDeclareByPolicyIdForPage_new/{orderFormId}"})
    public ModelAndView getDeclaration_noSearch(@PathVariable Long orderFormId, DwzPage page, ShipDeclareStepTwoSearchVo searchVo, String searchType) {
        ModelAndView view = null;
        if (this.voIsEmpty(searchVo)) {
            view = StringUtils.isBlank((String)searchType) && page.getTotalCount() > 0 ? new ModelAndView("/coninsweb/personalCenter/exports/declare/declarationList_table_only_new") : new ModelAndView("/coninsweb/personalCenter/exports/declare/declarationList_table_new");
        } else if (StringUtils.isNotBlank((String)searchType) && searchType.equals("search2")) {
            view = new ModelAndView("/coninsweb/personalCenter/exports/declare/declarationList_table_only_new");
        } else {
            page.setPageNum(1);
            view = new ModelAndView("/coninsweb/personalCenter/exports/declare/declarationList_table_search_new");
        }
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        view.addObject("userdetail", (Object)userdetail);
        page.setNumPerPage(3);
        List lis = null;
        lis = searchVo == null ? this.shipDeclareService.getShipDeclareVoByInsOrderFormId(orderFormId, page) : this.shipDeclareService.getShipDeclareVoByInsOrderFormIdAndVo(orderFormId, searchVo, page);
        if (lis != null && lis.size() > 0) {
            view.addObject("externalReference", (Object)((ShipDeclareMultipleVo)lis.get(0)).getExternal_reference());
            view.addObject("voList", (Object)lis);
        }
        view.addObject("orderFormId", (Object)orderFormId);
        return view;
    }

    private boolean voIsEmpty(ShipDeclareStepTwoSearchVo searchVo) {
        boolean flag = false;
        if (StringUtils.isBlank((String)searchVo.getBuyer_name()) && StringUtils.isBlank((String)searchVo.getCountry()) && StringUtils.isBlank((String)searchVo.getEnd_date()) && StringUtils.isBlank((String)searchVo.getInsured()) && StringUtils.isBlank((String)searchVo.getStart_date())) {
            flag = true;
        }
        return flag;
    }

    @RequestMapping(value={"/getDeclareByPolicyIdForPage/{orderFormId}"})
    public ModelAndView getDeclaration(@PathVariable Long orderFormId, DwzPage page, ShipDeclareStepTwoSearchVo searchVo) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/declarationList_table");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        view.addObject("userdetail", (Object)userdetail);
        List lis = null;
        lis = searchVo == null ? this.shipDeclareService.getShipDeclareVoByInsOrderFormId(orderFormId, page) : this.shipDeclareService.getShipDeclareVoByInsOrderFormIdAndVo(orderFormId, searchVo, page);
        view.addObject("pageBack", (Object)page);
        view.addObject("numPerPage", (Object)9);
        if (lis != null) {
            view.addObject("vo", (Object)lis);
        }
        return view;
    }

    @RequestMapping(value={"/deleteShipDeclareById/{shipDeclareId}/{invoiceId}"})
    public ResultDto deleteShipDeclare(@PathVariable Long shipDeclareId, @PathVariable Long invoiceId) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shipDeclareId", shipDeclareId);
        map.put("invoiceId", invoiceId);
        map.put("userId", userdetail.getOid());
        InsShipDeclare shipDeclare = (InsShipDeclare)this.shipDeclareService.selectById((Serializable)shipDeclareId);
        Long insTopBuyersIdBefore = shipDeclare.getSt_top_buyers_id();
        StTopBuyers insTopBuyers = (StTopBuyers)this.insTopBuyersService.selectById((Serializable)insTopBuyersIdBefore);
        List lis = this.shipInvoicesService.getShipInvoicesByShipDeclareId(shipDeclareId);
        if (lis.size() == 1) {
            InsShipInvoices shipInvoices = (InsShipInvoices)lis.get(0);
            shipInvoices.setStatus(Integer.valueOf(1));
            BigDecimal amount = shipInvoices.getInvoice_amounts();
            if (!this.insTopBuyersService.updTopFreeAmount(String.valueOf(insTopBuyers.getSt_top_buyers_id()), Long.valueOf(Long.parseLong(userdetail.getOid())), Long.valueOf(2L), amount)) {
                MessageUtils.returnFailMessage(map, (HttpServletResponse)this.response);
                return null;
            }
            boolean invoices = this.shipInvoicesService.updateById((Object)shipInvoices);
            if (!invoices) {
                MessageUtils.returnFailMessage(map, (HttpServletResponse)this.response);
                return null;
            }
            shipDeclare.setStatus(Integer.valueOf(1));
            boolean declare = this.shipDeclareService.updateById((Object)shipDeclare);
            if (!declare) {
                return new ResultDto("\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", "300", "", "", "");
            }
            return new ResultDto("\u53d6\u6d88\u7533\u62a5\u6210\u529f\uff01", "200", "", "", "");
        }
        if (lis.size() > 1) {
            InsShipInvoices shipInvoices = (InsShipInvoices)this.shipInvoicesService.selectById((Serializable)invoiceId);
            shipInvoices.setStatus(Integer.valueOf(1));
            BigDecimal amount = shipInvoices.getInvoice_amounts();
            if (!this.insTopBuyersService.updTopFreeAmount(String.valueOf(insTopBuyers.getSt_top_buyers_id()), Long.valueOf(Long.parseLong(userdetail.getOid())), Long.valueOf(2L), amount)) {
                MessageUtils.returnFailMessage(map, (HttpServletResponse)this.response);
                return null;
            }
            boolean invoices = this.shipInvoicesService.updateById((Object)shipInvoices);
            if (!invoices) {
                return new ResultDto("\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", "300", "", "", "");
            }
            return new ResultDto("\u53d6\u6d88\u7533\u62a5\u6210\u529f\uff01", "200", "", "", "");
        }
        return null;
    }

    @RequestMapping(value={"/addDeclare/{orderFormId}"})
    public ModelAndView addDeclarationPage(@PathVariable Long orderFormId) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/addDeclare");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        view.addObject("orderFormId", (Object)orderFormId);
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        view.addObject("userdetail", (Object)userdetail);
        view.addObject("orderFormId", (Object)orderFormId);
        InsuredListAndBD vo = new InsuredListAndBD();
        List insuredNameList = this.shipDeclareService.getInsureNameList(orderFormId);
        if (insuredNameList != null) {
            vo.setInsuredList(this.rmDuplication(insuredNameList));
        }
        view.addObject("insuredListAndBd", (Object)vo);
        view.addObject("paymentTermsList", (Object)SysDictUtils.getDictList((String)"paymentTerms"));
        view.addObject("transportTypeList", (Object)SysDictUtils.getDictList((String)"transportType"));
        return view;
    }

    @RequestMapping(value={"/addDeclareWithBuyers/{orderFormId}/{insTopBuyersId}"})
    public ModelAndView addDeclareWithBuyers(@PathVariable Long orderFormId, @PathVariable String insTopBuyersId, String insured) throws Exception {
        InsuredListAndBD vo;
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/addDeclare");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        view.addObject("insured", (Object)insured);
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        if (StringUtils.isNotBlank((String)insTopBuyersId) && !"undefined".equals(insTopBuyersId)) {
            StTopBuyers insTopBuyers = this.insTopBuyersService.packagingInsTopBuyers(Long.valueOf(Long.parseLong(insTopBuyersId)));
            vo = this.insTopBuyersService.accordingToInsTopBuyersIntoTopBuyersVo(insTopBuyers);
            view.addObject("topBuyersVo", (Object)vo);
        }
        OrderFormVo orderFormVo = this.shipDeclareService.getOrderFormVoByOrderFormId(orderFormId);
        vo = new InsuredListAndBD();
        List insuredNameList = this.shipDeclareService.getInsureNameList(orderFormId);
        if (insuredNameList != null) {
            vo.setInsuredList(this.rmDuplication(insuredNameList));
        }
        vo.setExternal_reference(orderFormVo.getExternal_reference());
        view.addObject("insuredListAndBd", (Object)vo);
        view.addObject("paymentTermsList", (Object)SysDictUtils.getDictList((String)"paymentTerms"));
        view.addObject("transportTypeList", (Object)SysDictUtils.getDictList((String)"transportType"));
        view.addObject("userdetail", (Object)userdetail);
        view.addObject("ins_top_buyers_id", (Object)insTopBuyersId);
        return view;
    }

    @RequestMapping(value={"/modifyDeclareWithBuyers/{orderFormId}/{insTopBuyersId}/{code}/{declareId}/{invoiceId}/{externalReference}"})
    public ModelAndView modifyDeclareWithBuyers(@PathVariable Long orderFormId, @PathVariable String insTopBuyersId, @PathVariable String code, @PathVariable Long declareId, @PathVariable Long invoiceId, @PathVariable String externalReference) throws Exception {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/addDeclare_Modify_NewBuyers");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        StTopBuyers insTopBuyers = this.insTopBuyersService.packagingInsTopBuyers(Long.valueOf(Long.parseLong(insTopBuyersId)));
        TopBuyersVo vo = this.insTopBuyersService.accordingToInsTopBuyersIntoTopBuyersVo(insTopBuyers);
        view.addObject("topBuyersVo", (Object)vo);
        HashMap<String, Long> map2 = new HashMap<String, Long>();
        map2.put("declareId", declareId);
        map2.put("invoiceId", invoiceId);
        ShipDeclareVo shipDeclareVo = new ShipDeclareVo();
        InsShipDeclare shipDeclare = (InsShipDeclare)this.shipDeclareService.selectById((Serializable)declareId);
        InsShipInvoices shipInvoices = (InsShipInvoices)this.shipInvoicesService.selectById((Serializable)invoiceId);
        BeanUtils.copyProperties((Object)shipDeclare, (Object)shipDeclareVo);
        shipDeclareVo.setInvoice_amounts(shipInvoices.getInvoice_amounts());
        shipDeclareVo.setInvoice_no(shipInvoices.getInvoice_no());
        shipDeclareVo.setInsuredNameList(this.getInsuredNameList(shipDeclare.getIns_order_form_id()));
        view.addObject("paymentTermsList", (Object)SysDictUtils.getDictList((String)"paymentTerms"));
        view.addObject("transportTypeList", (Object)SysDictUtils.getDictList((String)"transportType"));
        view.addObject("userdetail", (Object)userdetail);
        view.addObject("externalReference", (Object)externalReference);
        view.addObject("shipDeclareVo", (Object)shipDeclareVo);
        view.addObject("insTopBuyersId", (Object)insTopBuyersId);
        view.addObject("orderFormId", (Object)orderFormId);
        view.addObject("code", (Object)code);
        view.addObject("declareId", (Object)declareId);
        view.addObject("invoiceId", (Object)invoiceId);
        return view;
    }

    private List<String> getInsuredNameList(Long orderFormId) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.packagingInsOrderForm(orderFormId);
        List insRoleInpolicy = insInsuranceSlip.getRolesOfKind("1");
        ArrayList<String> insuredNameList = new ArrayList<String>();
        if (insRoleInpolicy != null) {
            for (InsRoleInpolicy role : insRoleInpolicy) {
                insuredNameList.add(role.getName_cn());
            }
        }
        return insuredNameList.size() > 0 ? insuredNameList : null;
    }

    @RequestMapping(value={"/findBuyers/{orderFormId}"})
    public ModelAndView findBuyers(@PathVariable Long orderFormId, DwzPage page, String modifyType, Long declareId, Long invoiceId, String externalReference) throws Exception {
        page.setNumPerPage(10);
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/findBuyers_one");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        if (StringUtils.isNotBlank((String)modifyType) && "1".equals(modifyType)) {
            view.addObject("modifyType", (Object)modifyType);
            view.addObject("declareId", (Object)declareId);
            view.addObject("invoiceId", (Object)invoiceId);
            view.addObject("externalReference", (Object)externalReference);
        }
        view.addObject("userdetail", (Object)userdetail);
        List lis = this.insTopBuyersService.getInsTopBuyersByOrderFormId(orderFormId, page);
        ArrayList<String> countryList = new ArrayList<String>();
        BuyersVo_one vo = new BuyersVo_one();
        if (lis == null) {
            return view;
        }
        for (StTopBuyers insTopBuyers : lis) {
            if (insTopBuyers == null || insTopBuyers.getCom_buyer() == null || !StringUtils.isNotBlank((String)insTopBuyers.getCom_buyer().getCountry())) continue;
            countryList.add(insTopBuyers.getCom_buyer().getCountry());
        }
        if (countryList.size() > 0) {
            vo.setCountryList(this.rmDuplication(countryList));
            view.addObject("vo", (Object)vo);
        }
        return view;
    }

    @RequestMapping(value={"/findBuyers2/{orderFormId}"})
    public ModelAndView findBuyers2(@PathVariable Long orderFormId, DwzPage page, String insured) throws Exception {
        page.setNumPerPage(10);
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/findBuyers_one");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        view.addObject("insured", (Object)insured);
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        view.addObject("userdetail", (Object)userdetail);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("orderFormId", orderFormId);
        map.put("page", (Long)page);
        List lis = this.insTopBuyersService.getInsTopBuyersByOrderFormId(orderFormId, page);
        ArrayList<String> countryList = new ArrayList<String>();
        BuyersVo_one vo = new BuyersVo_one();
        if (lis == null) {
            return view;
        }
        for (StTopBuyers insTopBuyers : lis) {
            if (insTopBuyers == null || insTopBuyers.getCom_buyer() == null || !StringUtils.isNotBlank((String)insTopBuyers.getCom_buyer().getCountry())) continue;
            countryList.add(insTopBuyers.getCom_buyer().getCountry());
        }
        if (countryList.size() > 0) {
            vo.setCountryList(this.rmDuplication(countryList));
            view.addObject("vo", (Object)vo);
        }
        return view;
    }

    @RequestMapping(value={"/findBuyersByOrderFormId/{orderFormId}"})
    public ModelAndView findBuyersByOrderFormId(@PathVariable Long orderFormId, DwzPage page, String countrySearch, String companySearch) throws Exception {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/declare/findBuyers_table");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        view.addObject("userdetail", (Object)userdetail);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderFormId", orderFormId);
        map.put("page", page);
        if (StringUtils.isBlank((String)countrySearch) && StringUtils.isBlank((String)companySearch)) {
            List lis = this.insTopBuyersService.getBuyersVoTwoByOrderFormId(orderFormId, page);
            view.addObject("buyersVoList", (Object)lis);
            return view;
        }
        if (StringUtils.isNotBlank((String)countrySearch)) {
            map.put("countrySearch", countrySearch);
        } else {
            map.put("countrySearch", "");
        }
        if (StringUtils.isNotBlank((String)companySearch)) {
            map.put("companySearch", companySearch);
        } else {
            map.put("companySearch", "");
        }
        List lis = this.insTopBuyersService.findBuyersListByOrderFormIdAndSearch(orderFormId, page, countrySearch, companySearch);
        view.addObject("buyersVoList", (Object)lis);
        return view;
    }

    @RequestMapping(value={"/addShipDeclare/{orderFormId}"})
    @ResponseBody
    public ResultDto addShipDeclare(@PathVariable Long orderFormId, ShipDeclareAddVo shipDeclareAddVo) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.msgNotFull(shipDeclareAddVo)) {
            return new ResultDto("\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u5e76\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        map.put("shipDeclareAddVo", shipDeclareAddVo);
        map.put("userId", userdetail.getOid());
        map.put("orderFormId", orderFormId);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        InsShipDeclare sd = new InsShipDeclare();
        StTopBuyers insTopBuyers = (StTopBuyers)this.insTopBuyersService.selectById((Serializable)((Object)shipDeclareAddVo.getIns_top_buyers_id()));
        BigDecimal invoiceAmountNow = new BigDecimal(shipDeclareAddVo.getInvoice_amount());
        if (!this.insTopBuyersService.updTopFreeAmount(String.valueOf(insTopBuyers.getSt_top_buyers_id()), Long.valueOf(Long.parseLong(userdetail.getOid())), Long.valueOf(1L), invoiceAmountNow)) {
            return new ResultDto("\u8be5\u4e70\u5bb6\u4fe1\u7528\u989d\u5ea6\u4e0d\u8db3\uff01", "300", "", "", "");
        }
        sd.setIns_order_form_id(orderFormId);
        sd.setInsured(shipDeclareAddVo.getInsured());
        sd.setCoverage(new BigDecimal(shipDeclareAddVo.getCoverage()));
        try {
            sd.setDelivery_time(format.parse(shipDeclareAddVo.getDelivery_time()));
            sd.setPay_expire_time(format.parse(shipDeclareAddVo.getPay_expire_time()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        sd.setTrade_name(shipDeclareAddVo.getTrade_name());
        sd.setShip_trade_no(shipDeclareAddVo.getShip_trade_no());
        sd.setShip_trade_name(shipDeclareAddVo.getShip_trade_name());
        sd.setPack_num(shipDeclareAddVo.getPack_num());
        sd.setRatio(shipDeclareAddVo.getRatio());
        sd.setIssuing_swift(shipDeclareAddVo.getIssuing_swift());
        sd.setContract_days(shipDeclareAddVo.getContract_days());
        sd.setDeclaration_no(shipDeclareAddVo.getDeclaration_no());
        sd.setDeclare_type("0");
        sd.setTransport_type(shipDeclareAddVo.getTransport_type());
        sd.setPayment_terms(shipDeclareAddVo.getPayment_terms());
        sd.setSt_top_buyers_id(Long.valueOf(Long.parseLong(shipDeclareAddVo.getIns_top_buyers_id())));
        sd.setStatus(ConstProp.INT_NUMBER_ZERO);
        sd.setCreate_time((Date)DateUtil.getTimestamp());
        boolean sdinsert = this.shipDeclareService.insert((Object)sd);
        if (!sdinsert) {
            return new ResultDto("\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", "300", "", "", "");
        }
        InsShipInvoices si = new InsShipInvoices();
        si.setIns_ship_declare_id(sd.getIns_ship_declare_id());
        si.setInvoice_no(shipDeclareAddVo.getInvoice_no());
        si.setInvoice_amounts(new BigDecimal(shipDeclareAddVo.getInvoice_amount()));
        si.setStatus(Integer.valueOf(0));
        boolean siinsert = this.shipInvoicesService.insert((Object)si);
        if (!siinsert) {
            return new ResultDto("\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", "300", "", "", "");
        }
        InsShipReceive sr = new InsShipReceive();
        sr.setIns_ship_declare_id(sd.getIns_ship_declare_id());
        sr.setCreate_time((Date)DateUtil.getTimestamp());
        sr.setOver_due_status("0");
        sr.setReceive_status("0");
        try {
            sr.setPay_time(format.parse(shipDeclareAddVo.getPay_expire_time()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        sr.setStatus(ConstProp.INT_NUMBER_ZERO);
        sr.setTotal_amounts(invoiceAmountNow);
        sr.setUn_received_amounts(invoiceAmountNow);
        sr.setReceived_amounts(new BigDecimal("0"));
        boolean srinsert = this.shipReceiveService.insert((Object)sr);
        if (!srinsert) {
            return new ResultDto("\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", "300", "", "", "");
        }
        return new ResultDto("\u6dfb\u52a0\u51fa\u8fd0\u6210\u529f\uff01", "200", "", "", "");
    }

    @RequestMapping(value={"/goDeclareDetail/{type}/{declareId}/{invoiceId}/{externalReference}"})
    public ModelAndView goDeclareDetail(@PathVariable Long declareId, @PathVariable Long invoiceId, @PathVariable String externalReference, @PathVariable String type) {
        ModelAndView view = new ModelAndView();
        if ("1".equals(type)) {
            view.setViewName("/coninsweb/personalCenter/exports/declare/addDeclare_ReadOnly");
        } else if ("2".equals(type)) {
            view.setViewName("/coninsweb/personalCenter/exports/declare/addDeclare_Modify");
        }
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            view.setViewName("/");
            return view;
        }
        view.addObject("userdetail", (Object)userdetail);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("declareId", declareId);
        map.put("invoiceId", invoiceId);
        ShipDeclareVo shipDeclareVo = new ShipDeclareVo();
        InsShipDeclare shipDeclare = (InsShipDeclare)this.shipDeclareService.selectById((Serializable)declareId);
        InsShipInvoices shipInvoices = (InsShipInvoices)this.shipInvoicesService.selectById((Serializable)invoiceId);
        BeanUtils.copyProperties((Object)shipDeclare, (Object)shipDeclareVo);
        shipDeclareVo.setInvoice_amounts(shipInvoices.getInvoice_amounts());
        shipDeclareVo.setInvoice_no(shipInvoices.getInvoice_no());
        shipDeclareVo.setInsuredNameList(this.getInsuredNameList(shipDeclare.getIns_order_form_id()));
        Long insTopBuyersId = shipDeclare.getSt_top_buyers_id();
        StTopBuyers insTopBuyers = (StTopBuyers)this.insTopBuyersService.selectById((Serializable)insTopBuyersId);
        ComBuyers buyerscode = (ComBuyers)this.insBuyersService.selectById((Serializable)insTopBuyers.getCom_buyer().getCom_buyer_id());
        String code = buyerscode.getCode();
        TopBuyersVo buyers = this.insTopBuyersService.getBuyersVoById(insTopBuyersId);
        if ("1".equals(type)) {
            for (SysDict sysDict : SysDictUtils.getDictList((String)"paymentTerms")) {
                if (!shipDeclareVo.getPayment_terms().equals(sysDict.getValue())) continue;
                shipDeclareVo.setPayment_terms(sysDict.getLabel());
            }
            for (SysDict sysDict : SysDictUtils.getDictList((String)"transportType")) {
                if (!shipDeclareVo.getTransport_type().equals(sysDict.getValue())) continue;
                shipDeclareVo.setTransport_type(sysDict.getLabel());
            }
        }
        view.addObject("paymentTermsList", (Object)SysDictUtils.getDictList((String)"paymentTerms"));
        view.addObject("transportTypeList", (Object)SysDictUtils.getDictList((String)"transportType"));
        view.addObject("shipDeclareVo", (Object)shipDeclareVo);
        view.addObject("topBuyersVo", (Object)buyers);
        view.addObject("code", (Object)code);
        view.addObject("externalReference", (Object)externalReference);
        view.addObject("invoiceId", (Object)invoiceId);
        view.addObject("ins_top_buyers_id", (Object)insTopBuyersId);
        view.addObject("declareId", (Object)declareId);
        view.addObject("orderFormId", (Object)shipDeclare.getIns_order_form_id());
        return view;
    }

    @RequestMapping(value={"/modifyShipDeclare/{declareId}/{invoiceId}"})
    @ResponseBody
    public ResultDto modifyShipDeclare(@PathVariable Long declareId, @PathVariable Long invoiceId, ShipDeclareAddVo shipDeclareAddVo) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        map.put("shipDeclareAddVo", shipDeclareAddVo);
        map.put("declareId", declareId);
        map.put("invoiceId", invoiceId);
        map.put("userId", userdetail.getOid());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        InsShipDeclare sd = (InsShipDeclare)this.shipDeclareService.selectById((Serializable)declareId);
        Long insTopBuyersIdBefore = sd.getSt_top_buyers_id();
        InsShipInvoices si = (InsShipInvoices)this.shipInvoicesService.selectById((Serializable)invoiceId);
        StTopBuyers insTopBuyers = (StTopBuyers)this.insTopBuyersService.selectById((Serializable)insTopBuyersIdBefore);
        BigDecimal invoiceAmountBefore = si.getInvoice_amounts();
        BigDecimal invoiceAmountNow = new BigDecimal(shipDeclareAddVo.getInvoice_amount());
        BigDecimal result = invoiceAmountNow.subtract(invoiceAmountBefore);
        if (shipDeclareAddVo.getIns_top_buyers_id().equals(String.valueOf(insTopBuyers.getSt_top_buyers_id()))) {
            return this.buyersNotChange(shipDeclareAddVo, map, userdetail, format, sd, si, insTopBuyers, invoiceAmountBefore, invoiceAmountNow, result);
        }
        if (this.insTopBuyersService.updTopFreeAmount(String.valueOf(insTopBuyersIdBefore), Long.valueOf(Long.parseLong(userdetail.getOid())), Long.valueOf(2L), invoiceAmountBefore)) {
            sd.setInsured(shipDeclareAddVo.getInsured());
            sd.setCoverage(new BigDecimal(shipDeclareAddVo.getCoverage()));
            try {
                sd.setDelivery_time(format.parse(shipDeclareAddVo.getDelivery_time()));
                sd.setPay_expire_time(format.parse(shipDeclareAddVo.getPay_expire_time()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            sd.setTrade_name(shipDeclareAddVo.getTrade_name());
            sd.setShip_trade_no(shipDeclareAddVo.getShip_trade_no());
            sd.setShip_trade_name(shipDeclareAddVo.getShip_trade_name());
            sd.setPack_num(shipDeclareAddVo.getPack_num());
            sd.setRatio(shipDeclareAddVo.getRatio());
            sd.setIssuing_swift(shipDeclareAddVo.getIssuing_swift());
            sd.setContract_days(shipDeclareAddVo.getContract_days());
            sd.setDeclaration_no(shipDeclareAddVo.getDeclaration_no());
            sd.setDeclare_type(shipDeclareAddVo.getDeclare_type());
            sd.setTransport_type(shipDeclareAddVo.getTransport_type());
            sd.setPayment_terms(shipDeclareAddVo.getPayment_terms());
            sd.setSt_top_buyers_id(Long.valueOf(Long.parseLong(shipDeclareAddVo.getIns_top_buyers_id())));
            sd.setStatus(Integer.valueOf(0));
            sd.setUpdate_time((Date)DateUtil.getTimestamp());
            boolean sdinsert = this.shipDeclareService.updateById((Object)sd);
            if (!sdinsert) {
                return new ResultDto("\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", "300", "", "", "");
            }
            si.setIns_ship_declare_id(sd.getIns_ship_declare_id());
            si.setInvoice_no(shipDeclareAddVo.getInvoice_no());
            si.setInvoice_amounts(new BigDecimal(shipDeclareAddVo.getInvoice_amount()));
            si.setStatus(Integer.valueOf(0));
            boolean siinsert = this.shipInvoicesService.updateById((Object)si);
            if (!siinsert) {
                return new ResultDto("\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", "300", "", "", "");
            }
            return new ResultDto("\u4fee\u6539\u51fa\u8fd0\u6210\u529f\uff01", "200", "", "", "");
        }
        if (!this.insTopBuyersService.updTopFreeAmount(shipDeclareAddVo.getIns_top_buyers_id(), Long.valueOf(Long.parseLong(userdetail.getOid())), Long.valueOf(1L), invoiceAmountNow)) {
            return new ResultDto("\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", "300", "", "", "");
        }
        sd.setDelivery_time(format.parse(shipDeclareAddVo.getDelivery_time()));
        sd.setPay_expire_time(format.parse(shipDeclareAddVo.getPay_expire_time()));
        try {
            sd.setDelivery_time(format.parse(shipDeclareAddVo.getDelivery_time()));
            sd.setPay_expire_time(format.parse(shipDeclareAddVo.getPay_expire_time()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        sd.setTrade_name(shipDeclareAddVo.getTrade_name());
        sd.setShip_trade_no(shipDeclareAddVo.getShip_trade_no());
        sd.setShip_trade_name(shipDeclareAddVo.getShip_trade_name());
        sd.setPack_num(shipDeclareAddVo.getPack_num());
        sd.setRatio(shipDeclareAddVo.getRatio());
        sd.setIssuing_swift(shipDeclareAddVo.getIssuing_swift());
        sd.setContract_days(shipDeclareAddVo.getContract_days());
        sd.setDeclaration_no(shipDeclareAddVo.getDeclaration_no());
        sd.setDeclare_type(shipDeclareAddVo.getDeclare_type());
        sd.setTransport_type(shipDeclareAddVo.getTransport_type());
        sd.setPayment_terms(shipDeclareAddVo.getPayment_terms());
        sd.setSt_top_buyers_id(Long.valueOf(Long.parseLong(shipDeclareAddVo.getIns_top_buyers_id())));
        sd.setStatus(Integer.valueOf(0));
        sd.setUpdate_time((Date)DateUtil.getTimestamp());
        boolean sdinsert = this.shipDeclareService.updateById((Object)sd);
        if (!sdinsert) {
            return new ResultDto("\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", "300", "", "", "");
        }
        si.setIns_ship_declare_id(sd.getIns_ship_declare_id());
        si.setInvoice_no(shipDeclareAddVo.getInvoice_no());
        si.setInvoice_amounts(new BigDecimal(shipDeclareAddVo.getInvoice_amount()));
        si.setStatus(Integer.valueOf(0));
        boolean siinsert = this.shipInvoicesService.updateById((Object)si);
        if (!siinsert) {
            return new ResultDto("\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", "300", "", "", "");
        }
        return new ResultDto("\u4fee\u6539\u51fa\u8fd0\u6210\u529f\uff01", "200", "", "", "");
    }

    private ResultDto buyersNotChange(ShipDeclareAddVo shipDeclareAddVo, Map<String, Object> map, ClientUserVo userdetail, DateFormat format, InsShipDeclare sd, InsShipInvoices si, StTopBuyers insTopBuyers, BigDecimal invoiceAmountBefore, BigDecimal invoiceAmountNow, BigDecimal result) {
        if (result.compareTo(BigDecimal.ZERO) >= 0) {
            BigDecimal addAmount = invoiceAmountNow.subtract(invoiceAmountBefore);
            if (!this.insTopBuyersService.updTopFreeAmount(String.valueOf(insTopBuyers.getSt_top_buyers_id()), Long.valueOf(Long.parseLong(userdetail.getOid())), Long.valueOf(1L), addAmount)) {
                return new ResultDto("\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", "300", "", "", "");
            }
            sd.setInsured(shipDeclareAddVo.getInsured());
            sd.setCoverage(new BigDecimal(shipDeclareAddVo.getCoverage()));
            try {
                sd.setDelivery_time(format.parse(shipDeclareAddVo.getDelivery_time()));
                sd.setPay_expire_time(format.parse(shipDeclareAddVo.getPay_expire_time()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            sd.setTrade_name(shipDeclareAddVo.getTrade_name());
            sd.setShip_trade_no(shipDeclareAddVo.getShip_trade_no());
            sd.setShip_trade_name(shipDeclareAddVo.getShip_trade_name());
            sd.setPack_num(shipDeclareAddVo.getPack_num());
            sd.setRatio(shipDeclareAddVo.getRatio());
            sd.setIssuing_swift(shipDeclareAddVo.getIssuing_swift());
            sd.setContract_days(shipDeclareAddVo.getContract_days());
            sd.setDeclaration_no(shipDeclareAddVo.getDeclaration_no());
            sd.setDeclare_type(shipDeclareAddVo.getDeclare_type());
            sd.setTransport_type(shipDeclareAddVo.getTransport_type());
            sd.setPayment_terms(shipDeclareAddVo.getPayment_terms());
            sd.setSt_top_buyers_id(Long.valueOf(Long.parseLong(shipDeclareAddVo.getIns_top_buyers_id())));
            sd.setStatus(Integer.valueOf(0));
            sd.setUpdate_time((Date)DateUtil.getTimestamp());
            boolean sdinsert = this.shipDeclareService.updateById((Object)sd);
            if (!sdinsert) {
                return new ResultDto("\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", "300", "", "", "");
            }
            si.setIns_ship_declare_id(sd.getIns_ship_declare_id());
            si.setInvoice_no(shipDeclareAddVo.getInvoice_no());
            si.setInvoice_amounts(new BigDecimal(shipDeclareAddVo.getInvoice_amount()));
            si.setStatus(Integer.valueOf(0));
            boolean siinsert = this.shipInvoicesService.updateById((Object)si);
            if (!siinsert) {
                return new ResultDto("\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", "300", "", "", "");
            }
            return new ResultDto("\u4fee\u6539\u51fa\u8fd0\u6210\u529f\uff01", "200", "", "", "");
        }
        if (result.compareTo(BigDecimal.ZERO) < 0) {
            BigDecimal downAmount = invoiceAmountBefore.subtract(invoiceAmountNow);
            if (!this.insTopBuyersService.updTopFreeAmount(String.valueOf(insTopBuyers.getSt_top_buyers_id()), Long.valueOf(Long.parseLong(userdetail.getOid())), Long.valueOf(2L), downAmount)) {
                return new ResultDto("\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", "300", "", "", "");
            }
            sd.setInsured(shipDeclareAddVo.getInsured());
            sd.setCoverage(new BigDecimal(shipDeclareAddVo.getCoverage()));
            try {
                sd.setDelivery_time(format.parse(shipDeclareAddVo.getDelivery_time()));
                sd.setPay_expire_time(format.parse(shipDeclareAddVo.getPay_expire_time()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            sd.setTrade_name(shipDeclareAddVo.getTrade_name());
            sd.setShip_trade_no(shipDeclareAddVo.getShip_trade_no());
            sd.setShip_trade_name(shipDeclareAddVo.getShip_trade_name());
            sd.setPack_num(shipDeclareAddVo.getPack_num());
            sd.setRatio(shipDeclareAddVo.getRatio());
            sd.setIssuing_swift(shipDeclareAddVo.getIssuing_swift());
            sd.setContract_days(shipDeclareAddVo.getContract_days());
            sd.setDeclaration_no(shipDeclareAddVo.getDeclaration_no());
            sd.setDeclare_type(shipDeclareAddVo.getDeclare_type());
            sd.setTransport_type(shipDeclareAddVo.getTransport_type());
            sd.setPayment_terms(shipDeclareAddVo.getPayment_terms());
            sd.setSt_top_buyers_id(Long.valueOf(Long.parseLong(shipDeclareAddVo.getIns_top_buyers_id())));
            sd.setStatus(Integer.valueOf(0));
            sd.setUpdate_time((Date)DateUtil.getTimestamp());
            boolean sdinsert = this.shipDeclareService.updateById((Object)sd);
            if (!sdinsert) {
                MessageUtils.returnFailMessage(map, (HttpServletResponse)this.response);
                return new ResultDto("\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", "300", "", "", "");
            }
            si.setIns_ship_declare_id(sd.getIns_ship_declare_id());
            si.setInvoice_no(shipDeclareAddVo.getInvoice_no());
            si.setInvoice_amounts(new BigDecimal(shipDeclareAddVo.getInvoice_amount()));
            si.setStatus(Integer.valueOf(0));
            boolean siinsert = this.shipInvoicesService.updateById((Object)si);
            if (!siinsert) {
                return new ResultDto("\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", "300", "", "", "");
            }
            return new ResultDto("\u4fee\u6539\u51fa\u8fd0\u6210\u529f\uff01", "200", "", "", "");
        }
        sd.setInsured(shipDeclareAddVo.getInsured());
        sd.setCoverage(new BigDecimal(shipDeclareAddVo.getCoverage()));
        try {
            sd.setDelivery_time(format.parse(shipDeclareAddVo.getDelivery_time()));
            sd.setPay_expire_time(format.parse(shipDeclareAddVo.getPay_expire_time()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        sd.setTrade_name(shipDeclareAddVo.getTrade_name());
        sd.setShip_trade_no(shipDeclareAddVo.getShip_trade_no());
        sd.setShip_trade_name(shipDeclareAddVo.getShip_trade_name());
        sd.setPack_num(shipDeclareAddVo.getPack_num());
        sd.setRatio(shipDeclareAddVo.getRatio());
        sd.setIssuing_swift(shipDeclareAddVo.getIssuing_swift());
        sd.setContract_days(shipDeclareAddVo.getContract_days());
        sd.setDeclaration_no(shipDeclareAddVo.getDeclaration_no());
        sd.setDeclare_type(shipDeclareAddVo.getDeclare_type());
        sd.setTransport_type(shipDeclareAddVo.getTransport_type());
        sd.setPayment_terms(shipDeclareAddVo.getPayment_terms());
        sd.setSt_top_buyers_id(Long.valueOf(Long.parseLong(shipDeclareAddVo.getIns_top_buyers_id())));
        sd.setStatus(Integer.valueOf(0));
        sd.setUpdate_time((Date)DateUtil.getTimestamp());
        boolean sdinsert = this.shipDeclareService.updateById((Object)sd);
        if (!sdinsert) {
            MessageUtils.returnFailMessage(map, (HttpServletResponse)this.response);
            return new ResultDto("\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", "300", "", "", "");
        }
        si.setIns_ship_declare_id(sd.getIns_ship_declare_id());
        si.setInvoice_no(shipDeclareAddVo.getInvoice_no());
        si.setInvoice_amounts(new BigDecimal(shipDeclareAddVo.getInvoice_amount()));
        si.setStatus(Integer.valueOf(0));
        boolean siinsert = this.shipInvoicesService.updateById((Object)si);
        if (!siinsert) {
            return new ResultDto("\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", "300", "", "", "");
        }
        return new ResultDto("\u4fee\u6539\u51fa\u8fd0\u6210\u529f\uff01", "200", "", "", "");
    }

    private boolean msgNotFull(ShipDeclareAddVo shipDeclareAddVo) {
        boolean flag = false;
        return flag;
    }
}

