/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.controller.api.gzzrx.taibao;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.entity.policy_core.InsPreservationRecord;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.preservation.InsPreservationRecordAPIService;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.third.gzzrx.taibao.GZZRX_TBRequestService;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.PolicyTransactionVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.SpecialHirelingVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class GZZRX_TB_API_Controller
extends BaseController {
    @Autowired
    private InsTransactionAPIService insTransactionAPIService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private GZZRX_TBRequestService gZZRX_TBRequestService;
    @Autowired
    private InsPreservationRecordAPIService insPreservationRecordAPIService;
    @Autowired
    private MyAsyncExecutor myAsyncExecutor;

    @RequestMapping(value={"/TB-API/GZZRX/callback-policy"})
    public void callbackPolicy(@RequestBody String json) throws UnsupportedEncodingException {
        String signMsgNow;
        if (json.contains("%3C%")) {
            json = URLDecoder.decode(json, "UTF-8");
        }
        this.logger.info("\u4fdd\u5355\u751f\u6548\u63a5\u53e3\u56de\u8c03-callback-policy-TB-GZZRX\uff1a\u8bf7\u6c42\u62a5\u6587-" + json);
        Map map = (Map)JSON.parseObject((String)json, Map.class);
        String efficientDate = (String)map.get("efficientDate");
        String terminationDate = (String)map.get("terminationDate");
        String policyApplyNo = (String)map.get("policyApplyNo");
        String paymentTime = (String)map.get("paymentTime");
        String policyNo = (String)map.get("policyNo");
        String signMsg = (String)map.get("signMsg");
        String epolicyUrl = (String)map.get("epolicyUrl");
        if (StringUtils.isNotEmpty((CharSequence)policyNo)) {
            String redisKey = "GZZRX_TB_CALLBACK_POLICY_" + policyNo;
            String redisValue = JedisUtils.get((String)redisKey);
            if (StringUtils.isNotEmpty((CharSequence)redisValue)) {
                this.logger.info("\u4fdd\u5355\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callback-policy-TB-GZZRX\uff1a\u91cd\u590d\u63d0\u4ea4\u8bf7\u6c42\uff0cpolicyNo={}", (Object)policyNo);
                this.renderString(this.response, this.returnRet("500", "\u8bf7\u6c42\u9891\u7e41\uff0c\u9a73\u56de\u672c\u6b21\u64cd\u4f5c"), "application/json");
                this.logger.info("\u4fdd\u5355\u751f\u6548\u63a5\u53e3\u56de\u8c03-callback-policy-TB-GZZRX\uff1a\u4e1a\u52a1\u7ed3\u675f\uff1aend");
                return;
            }
            JedisUtils.set((String)redisKey, (String)"1", (int)10);
        }
        if (!(signMsgNow = DigestUtils.md5Hex((String)(efficientDate + terminationDate + policyApplyNo + paymentTime + policyNo + "P_CPIC"))).equals(signMsg)) {
            this.renderString(this.response, this.returnRet("500", "\u62a5\u6587\u9a8c\u7b7e\u5931\u8d25"), "application/json");
            this.logger.info("\u4fdd\u5355\u751f\u6548\u63a5\u53e3\u56de\u8c03-callback-policy-TB-GZZRX\uff1a\u4e1a\u52a1\u7ed3\u675f\uff1aend");
            return;
        }
        OrderFormVo orderVo = this.policyService.getPolicyDtoByRcptNo(policyApplyNo);
        if (orderVo == null) {
            this.renderString(this.response, this.returnRet("500", "\u8ba2\u5355\u4e0d\u5b58\u5728"), "application/json");
            this.logger.info("\u4fdd\u5355\u751f\u6548\u63a5\u53e3\u56de\u8c03-callback-policy-TB-GZZRX\uff1a\u4e1a\u52a1\u7ed3\u675f\uff1aend");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)orderVo.getExternal_reference())) {
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(policyNo);
            vo.setPolicy_id(orderVo.getOid());
            this.insTransactionAPIService.savePolicyExternalReference(vo);
            if (StringUtils.isNotEmpty((CharSequence)epolicyUrl)) {
                vo.setInsure_path(epolicyUrl);
                this.insTransactionAPIService.savePolicyOther(vo);
            }
            this.myAsyncExecutor.execute(() -> {
                try {
                    this.policyService.returnsAnOrderToTheSpecifiedPlatform(orderVo.getOid());
                }
                catch (Exception e) {
                    this.logger.error("------------\u96c7\u4e3b\u8d23\u4efb\u9669\u63a8\u9001\u767e\u4fdd\u76fe\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            });
        }
        this.renderString(this.response, this.returnRet("200", "\u6210\u529f"), "application/json");
        this.logger.info("\u4fdd\u5355\u751f\u6548\u63a5\u53e3\u56de\u8c03-callback-policy-TB-GZZRX\uff1a\u4e1a\u52a1\u7ed3\u675f\uff1aend");
    }

    @RequestMapping(value={"/TB-API/GZZRX/callback-record"})
    public void callbackRecord(@RequestBody String json) throws UnsupportedEncodingException {
        if (json.contains("%3C%")) {
            json = URLDecoder.decode(json, "UTF-8");
        }
        this.logger.info("\u4fdd\u5355\u751f\u6548\u63a5\u53e3\u56de\u8c03-callback-record-TB-GZZRX\uff1a\u8bf7\u6c42\u62a5\u6587-" + json);
        Map map = (Map)JSON.parseObject((String)json, Map.class);
        String efficientDate = map.get("efficientDate") != null ? map.get("efficientDate").toString() : "";
        String resultCode = map.get("resultCode") != null ? map.get("resultCode").toString() : "";
        String terminationDate = map.get("terminationDate") != null ? map.get("terminationDate").toString() : "";
        String policyApplyNo = map.get("policyApplyNo") != null ? map.get("policyApplyNo").toString() : "";
        String endorsementRequestNo = map.get("endorsementRequestNo") != null ? map.get("endorsementRequestNo").toString() : "";
        String endorsementNo = map.get("endorsementNo") != null ? map.get("endorsementNo").toString() : "";
        String paymentTime = map.get("paymentTime") != null ? map.get("paymentTime").toString() : "";
        String policyNo = map.get("policyNo") != null ? map.get("policyNo").toString() : "";
        String signMsg = map.get("signMsg") != null ? map.get("signMsg").toString() : "";
        String epolicyUrl = map.get("epolicyUrl") != null ? map.get("epolicyUrl").toString() : "";
        String signMsgNow = DigestUtils.md5Hex((String)(efficientDate + terminationDate + policyApplyNo + paymentTime + policyNo + "P_CPIC"));
        if (StringUtils.isNotEmpty((CharSequence)endorsementNo)) {
            String redisKey = "GZZRX_TB_CALLBACK_RECORD_" + endorsementNo;
            String redisValue = JedisUtils.get((String)redisKey);
            if (StringUtils.isNotEmpty((CharSequence)redisValue)) {
                this.logger.info("\u4fdd\u5355\u589e\u5458\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callback-record-TB-GZZRX\uff1a\u91cd\u590d\u63d0\u4ea4\u8bf7\u6c42\uff0cendorsementNo={}", (Object)endorsementNo);
                this.renderString(this.response, this.returnRet("500", "\u8bf7\u6c42\u9891\u7e41\uff0c\u9a73\u56de\u672c\u6b21\u64cd\u4f5c"), "application/json");
                this.logger.info("\u4fdd\u5355\u751f\u6548\u63a5\u53e3\u56de\u8c03-callback-record-TB-GZZRX\uff1a\u4e1a\u52a1\u7ed3\u675f\uff1aend");
                return;
            }
            JedisUtils.set((String)redisKey, (String)"1", (int)10);
        }
        if (!signMsgNow.equals(signMsg)) {
            this.renderString(this.response, this.returnRet("500", "\u62a5\u6587\u9a8c\u7b7e\u5931\u8d25"), "application/json");
            this.logger.info("\u4fdd\u5355\u751f\u6548\u63a5\u53e3\u56de\u8c03-callback-record-TB-GZZRX\uff1a\u4e1a\u52a1\u7ed3\u675f\uff1aend");
            return;
        }
        String result = this.insPreservationRecordAPIService.updateHTRecordStatus(endorsementRequestNo, endorsementNo, epolicyUrl, resultCode.equals("1") ? "01" : "00", resultCode.equals("1") ? "\u627f\u4fdd\u6210\u529f" : "\u627f\u4fdd\u5931\u8d25");
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            this.renderString(this.response, this.returnRet("500", result), "application/json");
            this.logger.info("\u4fdd\u5355\u751f\u6548\u63a5\u53e3\u56de\u8c03-callback-record-TB-GZZRX\uff1a\u4e1a\u52a1\u7ed3\u675f\uff1aend");
            return;
        }
        this.renderString(this.response, this.returnRet("200", "\u6210\u529f"), "application/json");
        this.logger.info("\u4fdd\u5355\u751f\u6548\u63a5\u53e3\u56de\u8c03-callback-record-TB-GZZRX\uff1a\u4e1a\u52a1\u7ed3\u675f\uff1aend");
    }

    public static void main(String[] args) {
        String url = "http://www.bailianbao.cn/TB-API/GZZRX/callback-policy";
        TaipingyangNotifyForm form = new TaipingyangNotifyForm();
        String content = "{\"terminationDate\":\"2026-03-14 00:00:00\",\"payuserid\":\"AMSUSABLEMATCH\",\"payername\":\"\u5317\u4eac\u5bb9\u76db\u4fdd\u6d01\u670d\u52a1\u6709\u9650\u516c\u53f8\",\"payeraccount\":\"11122301040005691\",\"policyApplyNo\":\"ABEJ13037125FM00001E\",\"resultCode\":1,\"efficientDate\":\"2025-03-14 00:00:00\",\"policyNo\":\"ABEJ13037125FN00001A\",\"paymentTime\":\"20250313114000\",\"signMsg\":\"8008080dc79a4c360856bd1683a16ea7\",\"epolicyUrl\":\"https://jttp.cpic.com.cn/jttpitx/externalpartner/link?eluowKHu3nsGSb3QlYyKBr4/eYp8zobBmO3YjYgoPjpk1j6vZ2jBCE5VlBSGhxmd%7C91350200302969730N\"}  ";
        form.setPolicyApplyNo("111111");
        form.setPaymentTime(DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        form.setResultCode(1);
        form.setPolicyNo("2134566");
        StringBuilder builder = new StringBuilder().append(form.getPolicyApplyNo()).append(form.getPaymentTime()).append(form.getPolicyNo()).append("P_CPIC");
        form.setSignMsg(DigestUtils.md5Hex((String)builder.toString()));
        String result = GZZRX_TB_API_Controller.sendPostJsonRequest(url, content, "UTF-8");
        System.out.println(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPostJsonRequest(String urlStr, String jsonStr, String charSet) {
        DefaultHttpClient client = new DefaultHttpClient();
        client.getParams().setParameter("http.connection.timeout", (Object)12000);
        HttpPost post = new HttpPost(urlStr);
        post.getParams().setParameter("http.protocol.content-charset", (Object)charSet);
        post.addHeader("Content-Type", "application/json;charset=utf-8");
        post.addHeader("Accept", "application/json;charset=utf-8");
        StringEntity entity = new StringEntity(jsonStr, charSet);
        post.setEntity((HttpEntity)entity);
        try {
            CloseableHttpResponse resp = client.execute((HttpUriRequest)post);
            if (resp.getStatusLine().getStatusCode() == 200) {
                String result;
                String string = result = EntityUtils.toString((HttpEntity)resp.getEntity(), (String)charSet);
                return string;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            post.abort();
            post.releaseConnection();
            client.getConnectionManager().shutdown();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String postJsonString(String url, String json) {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost httppost = new HttpPost(url);
            httppost.addHeader("Content-Type", "application/json");
            if (StringUtils.isNotEmpty((CharSequence)json)) {
                StringEntity se = new StringEntity(json, StandardCharsets.UTF_8);
                se.setContentType("text/json");
                se.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json"));
                httppost.setEntity((HttpEntity)se);
            }
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);){
                HttpEntity entity = response.getEntity();
                if (entity == null) return "";
                String string = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                return string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    @RequestMapping(value={"/TB-API/GZZRX/PRINT_INVOICE/{oid}"})
    @ResponseBody
    public ResultDto printInvoice(@PathVariable long oid) throws Exception {
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(oid));
        if (dto == null || !"6".equals(dto.getPolicy_status())) {
            return new ResultDto("\u65e0\u6cd5\u83b7\u53d6\u53d1\u7968\uff01", "300", "", "", "");
        }
        SpecialHirelingVo vo = this.policyService.accordingToOrderIDToGetSpecialHirelingVo(Long.valueOf(oid));
        if (StringUtils.isNotEmpty((CharSequence)vo.getMailPolicyVo().getE_invoice_url())) {
            return new ResultDto(vo.getMailPolicyVo().getE_invoice_url(), "200", "", "", "");
        }
        String result = this.gZZRX_TBRequestService.request_tb_gzzrx(Long.valueOf(oid), TransTypeEnum.DZFP.getValue(), null);
        if (StringUtils.isEmpty((CharSequence)result)) {
            return new ResultDto("\u83b7\u53d6\u7535\u5b50\u53d1\u7968\u63a5\u53e3\u5f02\u5e38\uff01", "300", "", "", "");
        }
        String[] strs = result.split("#");
        if (!"200".equals(strs[0])) {
            return new ResultDto(strs[1], "300", "", "", "");
        }
        String e_invoice_url = strs[1];
        this.policyService.updateUrlByExternalreference(e_invoice_url, dto.getExternal_reference());
        return new ResultDto(e_invoice_url, "200", "", "", "");
    }

    @RequestMapping(value={"/TB-API/GZZRX/PRINT_RECORD_INVOICE/{oid}"})
    @ResponseBody
    public ResultDto printRecordInvoice(@PathVariable long oid) throws Exception {
        InsPreservationRecordVo iprVo = this.insPreservationRecordAPIService.findInsPreservationRecordVoById(Long.valueOf(oid));
        if (iprVo == null || !"1".equals(iprVo.getRevise_type()) || !"45".contains(iprVo.getRevise_status()) || StringUtils.isEmpty((CharSequence)iprVo.getRevise_pay())) {
            return new ResultDto("\u65e0\u6cd5\u83b7\u53d6\u53d1\u7968\uff01", "300", "", "", "");
        }
        if (StringUtils.isNotEmpty((CharSequence)iprVo.getE_invoice_url())) {
            return new ResultDto(iprVo.getE_invoice_url(), "200", "", "", "");
        }
        String result = this.gZZRX_TBRequestService.request_tb_gzzrx(Long.valueOf(Long.parseLong(iprVo.getIns_insurance_slip_id())), TransTypeEnum.DZFPXZ.getValue(), iprVo);
        if (StringUtils.isEmpty((CharSequence)result)) {
            return new ResultDto("\u83b7\u53d6\u7535\u5b50\u53d1\u7968\u63a5\u53e3\u5f02\u5e38\uff01", "300", "", "", "");
        }
        String[] strs = result.split("#");
        if (!"200".equals(strs[0])) {
            return new ResultDto(strs[1], "300", "", "", "");
        }
        String e_invoice_url = strs[1];
        InsPreservationRecord ipr = (InsPreservationRecord)this.insPreservationRecordAPIService.selectById((Serializable)Long.valueOf(oid));
        ipr.setE_invoice_url(e_invoice_url);
        this.insPreservationRecordAPIService.updateById((Object)ipr);
        return new ResultDto(e_invoice_url, "200", "", "", "");
    }

    private String returnRet(String code, String msg) {
        return "{\"code\":\"" + code + "\",\"message\":\"" + msg + "\"}";
    }

    static class TaipingyangNotifyForm {
        private String policyApplyNo;
        private String paymentTime;
        private Integer resultCode;
        private String policyNo;
        private String errorMsg;
        private String signMsg;

        TaipingyangNotifyForm() {
        }

        public String getPolicyApplyNo() {
            return this.policyApplyNo;
        }

        public void setPolicyApplyNo(String policyApplyNo) {
            this.policyApplyNo = policyApplyNo;
        }

        public String getPaymentTime() {
            return this.paymentTime;
        }

        public void setPaymentTime(String paymentTime) {
            this.paymentTime = paymentTime;
        }

        public String getPolicyNo() {
            return this.policyNo;
        }

        public void setPolicyNo(String policyNo) {
            this.policyNo = policyNo;
        }

        public Integer getResultCode() {
            return this.resultCode;
        }

        public void setResultCode(Integer resultCode) {
            this.resultCode = resultCode;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        public String getSignMsg() {
            return this.signMsg;
        }

        public void setSignMsg(String signMsg) {
            this.signMsg = signMsg;
        }
    }
}

