/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.controller.api.gzzrx;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.service.ComBankCodeService;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.third.gzzrx.changan.GZZRX_CARequestService;
import com.bcxin.ins.third.gzzrx.pingancai.GZZRX_PACRequestService;
import com.bcxin.ins.third.gzzrx.zhonghua.GZZRX_ZHRequestService;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.IdCardVerify;
import com.bcxin.ins.util.IdNumberValidator;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.ValidatorUtil;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.util.enums.NatureLinkage;
import com.bcxin.ins.vo.AdviceNoteVo;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.HirelingVo;
import com.bcxin.ins.vo.MailPolicyVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.SpecialHirelingVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/api/gzzrx"})
public class GZZRX_Policy_API_Controller
extends BaseController {
    @Autowired
    private PolicyService policyService;
    @Autowired
    private ProductService productService;
    @Autowired
    private GZZRX_ZHRequestService gZZRX_ZHRequestService;
    @Autowired
    private GZZRX_PACRequestService gZZRX_PACRequestService;
    @Autowired
    private GZZRX_CARequestService gZZRX_CARequestService;
    @Autowired
    private ComBankCodeService comBankCodeService;

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u4ea7\u54c1-\u8bbf\u95ee\u6295\u4fdd\u9875")
    @RequestMapping(value={"/policyInit/{product_id}"})
    public ModelAndView policyInit(HttpServletRequest request, @PathVariable Long product_id, ModelMap model) {
        String personNum = request.getParameter("personNum");
        int num = 0;
        if (StringUtils.isNotEmpty((CharSequence)personNum)) {
            num = Integer.parseInt(personNum);
        }
        SpecialHirelingVo vo = new SpecialHirelingVo();
        MailPolicyVo mVo = new MailPolicyVo();
        mVo.setIs_send_einvoice("1");
        vo.setMailPolicyVo(mVo);
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (StringUtils.isEmpty((CharSequence)userdetail.getWeb_type())) {
            return new ModelAndView("forward:/synopsis/loseView");
        }
        List doList = null;
        if (userdetail.getWeb_type().contains("ARS")) {
            doList = this.policyService.getComAndEmpByUserID_BBDAPI(userdetail.getWeb_id(), userdetail.getWeb_type());
        }
        if (userdetail.getWeb_type().contains("SAAS") || userdetail.getWeb_type().contains("PASP")) {
            String key = "ADDRESS-" + this.getToken();
            String cacheId = JedisUtils.get((String)key);
            if (StringUtils.isNotEmpty((CharSequence)cacheId)) {
                JedisUtils.del((String)key);
                doList = this.policyService.getComAndEmpByCacheId_API(cacheId, userdetail.getWeb_type());
            } else {
                doList = this.policyService.getComAndEmpByUserID_API(userdetail.getWeb_id(), userdetail.getWeb_type());
            }
        }
        if (doList != null) {
            ArrayList appList = Lists.newArrayList();
            List<RoleSubjectVo> voList = this.sortRoleList(doList, num, 0);
            appList.add(voList.get(0));
            vo.setRoleSubjectList((List)appList);
            vo.setHirelingVoList(this.setHVoByRole(voList));
        }
        ModelAndView view = new ModelAndView();
        view.addObject("vo", (Object)vo);
        view.addObject("userdetail", (Object)userdetail);
        view.addObject("recommend_code", (Object)UserSupportUtil.getRecommendCode());
        this.orderAllotInit(product_id, view);
        this.setTokenByApi(view);
        return view;
    }

    private List<HirelingVo> setHVoByRole(List<RoleSubjectVo> voList) {
        ArrayList hVoList = Lists.newArrayList();
        HirelingVo hVo = null;
        for (RoleSubjectVo rsVo : voList) {
            if ("1".equals(rsVo.getKind())) continue;
            hVo = new HirelingVo();
            hVo.setName(rsVo.getName_cn());
            hVo.setId_card(rsVo.getOrganization_code());
            hVo.setId_type(rsVo.getId_type());
            hVo.setMobile(rsVo.getMobile());
            hVo.setBirth_date(rsVo.getBirth_date());
            hVo.setCareer(rsVo.getMajor_group());
            hVo.setSex(rsVo.getSex());
            hVoList.add(hVo);
        }
        if (hVoList.size() < 3) {
            for (int i = 0; i <= 3 - hVoList.size(); ++i) {
                hVo = new HirelingVo();
                hVoList.add(hVo);
            }
        }
        return hVoList;
    }

    private List<RoleSubjectVo> sortRoleList(List<RoleSubjectVo> doList, int num, int type) {
        ArrayList<RoleSubjectVo> results = new ArrayList<RoleSubjectVo>();
        if (doList == null) {
            if (num <= 0) {
                return null;
            }
            RoleSubjectVo appRole = new RoleSubjectVo();
            appRole.setKind("1");
            results.add(appRole);
            RoleSubjectVo insRole = null;
            for (int i = 0; i < num; ++i) {
                insRole = new RoleSubjectVo();
                insRole.setKind("2");
                insRole.setMajor_group("1");
                results.add(insRole);
                insRole = null;
            }
            return results;
        }
        ArrayList<RoleSubjectVo> insurceRoleList = new ArrayList<RoleSubjectVo>();
        for (RoleSubjectVo vo : doList) {
            if ("1".equals(vo.getKind())) {
                results.add(vo);
                continue;
            }
            insurceRoleList.add(vo);
        }
        if (results.size() == 0) {
            RoleSubjectVo vo = new RoleSubjectVo();
            vo.setKind("1");
            results.add(vo);
        }
        if (type == 0) {
            this.type0Role(num, results, insurceRoleList);
        } else {
            results.addAll(insurceRoleList);
        }
        return results;
    }

    private void type0Role(int num, List<RoleSubjectVo> results, List<RoleSubjectVo> insurceRoleList) {
        if (insurceRoleList.size() <= 0) {
            return;
        }
        int insRoleNum = insurceRoleList.size();
        if (insRoleNum < num) {
            results.addAll(insurceRoleList);
            int lastNum = num - insRoleNum;
            for (int i = 0; i < lastNum; ++i) {
                RoleSubjectVo rvo = new RoleSubjectVo();
                rvo.setKind("2");
                rvo.setMajor_group("1");
                results.add(rvo);
            }
        } else if (insRoleNum == num) {
            results.addAll(insurceRoleList);
        } else if (num == 0) {
            results.addAll(insurceRoleList);
        } else {
            for (int i = 0; i < num; ++i) {
                results.add(insurceRoleList.get(i));
            }
        }
    }

    @RequestMapping(value={"/policy/{order_id}"})
    public ModelAndView enterInfo(HttpServletRequest request, @PathVariable Long order_id) {
        ModelAndView view = new ModelAndView();
        this.orderAllot(order_id, view);
        this.setTokenByApi(view);
        return view;
    }

    private void orderAllotInit(Long product_id, ModelAndView view) {
        ProductVo pd = this.productService.getProduct(product_id.longValue());
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setGross_premium(pd.getPremium_min());
        dto.setTrade_serial_number(String.valueOf(IdWorker.getId()));
        view.addObject("pd", (Object)pd);
        view.addObject("dto", (Object)dto);
        view.addObject("sigId", (Object)String.valueOf(IdWorker.getId()));
        view.addObject("comTypeList", (Object)IdType.comList());
        view.addObject("personTypeList", (Object)IdType.personList());
        view.addObject("natureList", (Object)NatureLinkage.getListByProvince((String)""));
        view.addObject("idOptionList", (Object)SysDictUtils.getDictList((String)"idOption"));
        view.addObject("businessAreaList", (Object)SysDictUtils.getDictList((String)"businessArea"));
        if (StringUtils.isEmpty((CharSequence)pd.getProduct_code())) {
            return;
        }
        if (pd.getProduct_code().contains("GZZRX")) {
            try {
                view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            view.setViewName("/coninsweb/api/gzzrx/policy/gzzrx_enter_basic_info");
        }
    }

    @RequestMapping(value={"/natureChange"})
    @ResponseBody
    public Map<String, String> natureChange(HttpServletRequest request) {
        String nID = request.getParameter("nID");
        if (StringUtils.isNotEmpty((CharSequence)nID)) {
            Map map = NatureLinkage.getMapByProvince((String)nID);
            return map;
        }
        return null;
    }

    private void orderAllot(Long order_id, ModelAndView view) {
        try {
            OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
            ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
            view.addObject("pd", (Object)pd);
            view.addObject("dto", (Object)dto);
            view.addObject("userdetail", (Object)UserSupportUtil.getSessionUser());
            view.addObject("comTypeList", (Object)IdType.comList());
            view.addObject("personTypeList", (Object)IdType.personList());
            view.addObject("natureList", (Object)NatureLinkage.getListByProvince((String)""));
            view.addObject("idOptionList", (Object)SysDictUtils.getDictList((String)"idOption"));
            view.addObject("businessAreaList", (Object)SysDictUtils.getDictList((String)"businessArea"));
            if (StringUtils.isEmpty((CharSequence)dto.getProduct_code()) || !dto.getProduct_code().contains("GZZRX")) {
                return;
            }
            SpecialHirelingVo vo = this.policyService.accordingToOrderIDToGetSpecialHirelingVo(order_id);
            view.addObject("vo", (Object)vo);
            view.setViewName("/coninsweb/api/gzzrx/policy/gzzrx_enter_basic_info");
            if (vo == null) {
                return;
            }
            view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
            if (vo.getRoleSubjectList() != null) {
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getNature_two()) && StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getCom_nature())) {
                    view.addObject("natureTwoList", (Object)NatureLinkage.getListByProvince((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getCom_nature()));
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_province())) {
                    view.addObject("bankCityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_province()));
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_city())) {
                    view.addObject("bankTypeList", (Object)this.comBankCodeService.getAllBankType(((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_city()));
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_type())) {
                    if (pd.getProduct_code().contains("GZZRX-TB")) {
                        view.addObject("bankAddrList", (Object)this.comBankCodeService.getTBAllBankAddr(((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_city(), ((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_type()));
                    } else {
                        view.addObject("bankAddrList", (Object)this.comBankCodeService.getAllBankAddr(((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_city(), ((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_type()));
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province())) {
                    view.addObject("cityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province()));
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city())) {
                    view.addObject("areaList", (Object)RegionUtils.findDistrictByParentCode((String)"3", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city()));
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getNature_two()) && StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getCom_nature())) {
                    view.addObject("natureTwoList1", (Object)NatureLinkage.getListByProvince((String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getCom_nature()));
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province())) {
                    view.addObject("reg_city_1_List", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province()));
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city())) {
                    view.addObject("reg_area_1_List", (Object)RegionUtils.findDistrictByParentCode((String)"3", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city()));
                }
            }
            if (vo.getMailPolicyVo() != null && StringUtils.isNotEmpty((CharSequence)vo.getMailPolicyVo().getBank_province())) {
                view.addObject("bankCityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)vo.getMailPolicyVo().getBank_province()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/policy/confirmPage/{order_id}"})
    public ModelAndView confirmPage(@PathVariable Long order_id, HttpServletRequest request) throws Exception {
        ModelAndView view = new ModelAndView();
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
        view.addObject("pd", (Object)pd);
        view.addObject("dto", (Object)dto);
        if (!StringUtils.isEmpty((CharSequence)dto.getProduct_code()) && dto.getProduct_code().contains("GZZRX")) {
            view.setViewName("/coninsweb/api/gzzrx/policy/policy_confirm");
            SpecialHirelingVo vo = this.policyService.accordingToOrderIDToGetSpecialHirelingVo(order_id);
            List natureList = NatureLinkage.doList();
            List typeList = IdType.doList();
            view.addObject("vo", (Object)vo);
            view.addObject("typeList", (Object)typeList);
            view.addObject("natureList", (Object)natureList);
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
            view.addObject("reg_role_1", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_district()));
        }
        this.setTokenByApi(view);
        return view;
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_ORDER, title="\u3010\u8bf7\u6c42\u3011\u4ea7\u54c1-\u8ba2\u5355\u6295\u4fdd")
    @RequestMapping(value={"/policy/pendingSpecialHirelingVoPolicy"})
    @ResponseBody
    public ResultDto pendingSpecialHirelingVoPolicy(SpecialHirelingVo vo, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String recommendCode = request.getParameter("recommendCode");
        return this.policyService.pendingSpecialHirelingVoPolicy(vo, recommendCode);
    }

    @LoginRequired
    @RequestMapping(value={"/policy/updateOrderFormStatus"})
    @ResponseBody
    public ResultDto updateOrderFormStatus(HttpServletRequest request) throws Exception {
        String order_id = request.getParameter("order_id");
        String status = request.getParameter("status");
        if (StringUtils.isEmpty((CharSequence)order_id) || StringUtils.isEmpty((CharSequence)status)) {
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        OrderFormVo vo = new OrderFormVo();
        vo.setOid(String.valueOf(order_id));
        vo.setPolicy_status(status);
        String orderID = this.policyService.updateOrderFormStatus(vo);
        if (StringUtils.isNotEmpty((CharSequence)orderID)) {
            return new ResultDto("\u8ba2\u5355\u5f55\u5165\u6210\u529f\u3002", "200", orderID, "300", "");
        }
        return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
    }

    @RequestMapping(value={"/policy/policyPayment/{order_id}"})
    public ModelAndView savePolicy(@PathVariable long order_id, HttpServletRequest request) {
        ModelAndView view = null;
        try {
            OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(order_id));
            ProductVo pd = this.productService.getProduct(Long.parseLong(vo.getProduct_oid()));
            if (vo.getPolicy_status().equals("4")) {
                if (vo.getProduct_code().contains("GZZRX-RB")) {
                    this.policyService.payUrlChange(Long.valueOf(order_id));
                    view = new ModelAndView("/coninsweb/api/gzzrx/transaction/policyPaymentRB");
                }
                if (vo.getProduct_code().contains("GZZRX-ZH") || vo.getProduct_code().contains("GZZRX-XZH")) {
                    view = new ModelAndView("/coninsweb/api/gzzrx/transaction/policyPaymentZH");
                    this.GZZRX_ZH_Payment(order_id, view, vo);
                }
                if (vo.getProduct_code().contains("GZZRX-CA")) {
                    view = new ModelAndView("/coninsweb/api/gzzrx/transaction/policyPaymentCA");
                    this.GZZRX_CA_Payment(order_id, view, vo);
                }
                if (vo.getProduct_code().contains("GZZRX-QH")) {
                    view = new ModelAndView("/coninsweb/api/gzzrx/transaction/policyPaymentQH");
                    view.addObject("payurl", (Object)vo.getShow_url());
                }
                if (vo.getProduct_code().contains("GZZRX-PAC")) {
                    view = new ModelAndView("/coninsweb/api/gzzrx/transaction/policyPaymentPAC");
                    this.GZZRX_PAC_Payment(order_id, view, vo);
                }
                if (vo.getProduct_code().contains("GZZRX-TB")) {
                    view = new ModelAndView("/coninsweb/api/gzzrx/transaction/policyPaymentTB");
                    view.addObject("payurl", (Object)vo.getShow_url());
                }
            } else if (vo.getPolicy_status().equals("3") || vo.getPolicy_status().equals("16")) {
                AdviceNoteVo anVo = null;
                if (vo.getProduct_code().contains("GZZRX-ZH")) {
                    view = new ModelAndView("/coninsweb/api/gzzrx/transaction/paymentNoticeZH");
                    anVo = this.policyService.accordingToOrderIDToGetAdviceNoteVo(Long.valueOf(order_id));
                } else if (vo.getProduct_code().contains("GZZRX-PAC")) {
                    view = new ModelAndView("/coninsweb/api/gzzrx/transaction/paymentNoticePAC");
                    anVo = this.policyService.accordingToOrderIDToGetAdviceNoteVo(Long.valueOf(order_id));
                } else if (vo.getProduct_code().contains("GZZRX-CA")) {
                    view = new ModelAndView("/coninsweb/api/gzzrx/transaction/paymentNoticeCA");
                } else if (vo.getProduct_code().contains("GZZRX-TB")) {
                    view = new ModelAndView("/coninsweb/api/gzzrx/transaction/policyPaymentTB");
                    view.addObject("payurl", (Object)vo.getShow_url());
                }
                view.addObject("anVo", (Object)anVo);
            } else if (vo.getPolicy_status().equals("5")) {
                view = new ModelAndView("/coninsweb/api/gzzrx/transaction/finishPay");
            }
            view.addObject("pd", (Object)pd);
            view.addObject("dto", (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setTokenByApi(view);
        view.addObject("nowTime", (Object)new Date());
        return view;
    }

    private void GZZRX_CA_Payment(@PathVariable long order_id, ModelAndView view, OrderFormVo vo) throws Exception {
        boolean boo;
        String yxDate = DateUtil.convertDateToString((Date)new Date(), (String)"yyyyMMdd");
        boolean bl = boo = StringUtils.isEmpty((CharSequence)vo.getPay_order_number()) ? false : vo.getPay_order_number().contains(yxDate);
        if (StringUtils.isNotEmpty((CharSequence)vo.getShow_url()) && boo) {
            view.addObject("payurl", (Object)vo.getShow_url());
        } else {
            String result = this.gZZRX_CARequestService.request_ca_gzzrx(Long.valueOf(Long.parseLong(vo.getOid())), TransTypeEnum.ZFDZ.getValue(), null);
            String[] strs = result.split("#");
            if ("200".equals(strs[0])) {
                this.policyService.payUrlChangeCA(Long.valueOf(order_id), strs[1], strs[2]);
                view.addObject("payurl", (Object)strs[2]);
            }
        }
    }

    private void GZZRX_PAC_Payment(@PathVariable long order_id, ModelAndView view, OrderFormVo vo) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)vo.getShow_url())) {
            view.addObject("payurl", (Object)vo.getShow_url());
        } else {
            String result = this.gZZRX_PACRequestService.requestPAC(Long.valueOf(Long.parseLong(vo.getOid())), "5", null);
            String[] strs = result.split("#");
            if ("200".equals(strs[0])) {
                this.policyService.payUrlChangePAC(Long.valueOf(order_id), strs[1], strs[2]);
                view.addObject("payurl", (Object)strs[2]);
            }
        }
    }

    private void GZZRX_ZH_Payment(@PathVariable long order_id, ModelAndView view, OrderFormVo vo) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)vo.getShow_url())) {
            view.addObject("payurl", (Object)vo.getShow_url());
        } else {
            String result = this.gZZRX_ZHRequestService.request_zh_gzzrx(Long.valueOf(Long.parseLong(vo.getOid())), "5", null);
            String[] strs = result.split("#");
            if ("200".equals(strs[0])) {
                this.policyService.payUrlChangeZHGZ(Long.valueOf(order_id), strs[1], strs[2]);
                view.addObject("payurl", (Object)strs[2]);
            }
        }
    }

    @RequestMapping(value={"/policy/requestEPolicy/{oid}"})
    @ResponseBody
    public ResultDto requestEPolicy(@PathVariable Long oid) throws Exception {
        OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(oid);
        if (this.productService.api_request_sign(vo.getProduct_code()) == ConstProp.INT_NUMBER_TWO.intValue()) {
            this.policyService.HTTP_PAS_TYX_DZBD(oid, null, vo);
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getProduct_code()) && vo.getProduct_code().contains("GZZRX-PAC")) {
            this.policyService.HTTP_PAC_GZZRX_DZBD(vo);
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getInsure_path())) {
            return new ResultDto("", "200", vo.getInsure_path(), "", "");
        }
        return new ResultDto("\u7535\u5b50\u4fdd\u5355\u751f\u6210\u4e2d(\u8fd9\u53ef\u80fd\u9700\u8981\u534a\u4e2a\u5c0f\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5)...", "300", "", "", "");
    }

    @RequestMapping(value={"/policy/computational-costs"})
    @ResponseBody
    public ResultDto computationalCosts(HttpServletRequest request) throws Exception {
        String product_code = request.getParameter("product_code");
        String is_contain_repo = request.getParameter("is_contain_repo");
        String inception_type = request.getParameter("inception_type");
        String inception_long = request.getParameter("inception_long");
        String person_num = request.getParameter("person_num");
        String premium = request.getParameter("premium");
        if (StringUtils.isEmpty((CharSequence)product_code) || StringUtils.isEmpty((CharSequence)is_contain_repo) || StringUtils.isEmpty((CharSequence)person_num) || StringUtils.isEmpty((CharSequence)premium)) {
            return new ResultDto("", "300", "", "", "");
        }
        BigDecimal prm = BigDecimal.ZERO;
        BigDecimal aom = BigDecimal.ZERO;
        BigDecimal pm = BigDecimal.valueOf(Double.parseDouble(premium));
        String epm = "0";
        String epm2 = "0";
        String eam = "0";
        if (product_code.contains("GZZRX-RB")) {
            String string = "GZZRX-RB-1".equals(product_code) ? "25" : ("GZZRX-RB-2".equals(product_code) ? "35" : ("GZZRX-RB-3".equals(product_code) ? "45" : (epm = "GZZRX-RB-4".equals(product_code) ? "55" : "0")));
            eam = "GZZRX-RB-1".equals(product_code) ? "3000000" : ("GZZRX-RB-2".equals(product_code) ? "4000000" : ("GZZRX-RB-3".equals(product_code) ? "5000000" : ("GZZRX-RB-4".equals(product_code) ? "6000000" : "0")));
        } else if (product_code.contains("GZZRX-ZH")) {
            String string = "GZZRX-ZH-1".equals(product_code) ? "15" : ("GZZRX-ZH-2".equals(product_code) ? "20" : ("GZZRX-ZH-3".equals(product_code) ? "25" : ("GZZRX-ZH-4".equals(product_code) ? "30" : ("GZZRX-ZH-5".equals(product_code) ? "35" : ("GZZRX-ZH-6".equals(product_code) ? "40" : ("GZZRX-ZH-7".equals(product_code) ? "40" : ("GZZRX-ZH-8".equals(product_code) ? "50" : (epm = "GZZRX-ZH-9".equals(product_code) ? "55" : "0"))))))));
            eam = "GZZRX-ZH-1".equals(product_code) ? "3000000" : ("GZZRX-ZH-2".equals(product_code) ? "4000000" : ("GZZRX-ZH-3".equals(product_code) ? "5000000" : ("GZZRX-ZH-4".equals(product_code) ? "6000000" : ("GZZRX-ZH-5".equals(product_code) ? "7000000" : ("GZZRX-ZH-6".equals(product_code) ? "8000000" : ("GZZRX-ZH-7".equals(product_code) ? "9000000" : ("GZZRX-ZH-8".equals(product_code) ? "10000000" : ("GZZRX-ZH-9".equals(product_code) ? "12000000" : "0"))))))));
        } else if (product_code.contains("GZZRX-QH")) {
            String string = "GZZRX-QH-1".equals(product_code) ? "36" : ("GZZRX-QH-2".equals(product_code) ? "36" : ("GZZRX-QH-3".equals(product_code) ? "48" : ("GZZRX-QH-4".equals(product_code) ? "48" : ("GZZRX-QH-5".equals(product_code) ? "60" : ("GZZRX-QH-6".equals(product_code) ? "72" : ("GZZRX-QH-7".equals(product_code) ? "84" : (epm = "GZZRX-QH-8".equals(product_code) ? "96" : "0")))))));
            eam = "GZZRX-QH-1".equals(product_code) ? "3000000" : ("GZZRX-QH-2".equals(product_code) ? "4000000" : ("GZZRX-QH-3".equals(product_code) ? "5000000" : ("GZZRX-QH-4".equals(product_code) ? "6000000" : ("GZZRX-QH-5".equals(product_code) ? "7000000" : ("GZZRX-QH-6".equals(product_code) ? "8000000" : ("GZZRX-QH-7".equals(product_code) ? "9000000" : ("GZZRX-QH-8".equals(product_code) ? "10000000" : "0")))))));
        } else if (product_code.contains("GZZRX-TB")) {
            String string = "GZZRX-TB-1".equals(product_code) ? "25" : ("GZZRX-TB-2".equals(product_code) ? "25" : ("GZZRX-TB-3".equals(product_code) ? "25" : ("GZZRX-TB-4".equals(product_code) ? "25" : (epm = "GZZRX-TB-5".equals(product_code) ? "25" : "0"))));
            eam = "GZZRX-TB-1".equals(product_code) ? "400000" : ("GZZRX-TB-2".equals(product_code) ? "500000" : ("GZZRX-TB-3".equals(product_code) ? "600000" : ("GZZRX-TB-4".equals(product_code) ? "700000" : ("GZZRX-TB-5".equals(product_code) ? "800000" : "0"))));
        } else if (product_code.contains("GZZRX-CA")) {
            epm = "45";
            epm2 = "90";
            eam = "GZZRX-CA-1".equals(product_code) ? "300000" : ("GZZRX-CA-2".equals(product_code) ? "400000" : ("GZZRX-CA-3".equals(product_code) ? "500000" : ("GZZRX-CA-4".equals(product_code) ? "600000" : ("GZZRX-CA-5".equals(product_code) ? "700000" : ("GZZRX-CA-6".equals(product_code) ? "800000" : ("GZZRX-CA-DQ-1".equals(product_code) ? "300000" : ("GZZRX-CA-DQ-2".equals(product_code) ? "400000" : ("GZZRX-CA-DQ-3".equals(product_code) ? "500000" : ("GZZRX-CA-DQ-4".equals(product_code) ? "600000" : ("GZZRX-CA-DQ-5".equals(product_code) ? "700000" : ("GZZRX-CA-DQ-6".equals(product_code) ? "800000" : "0")))))))))));
        } else if (product_code.contains("GZZRX-PAC")) {
            epm = "100";
            String string = "GZZRX-PAC-1".equals(product_code) ? "330000" : ("GZZRX-PAC-2".equals(product_code) ? "440000" : ("GZZRX-PAC-3".equals(product_code) ? "550000" : ("GZZRX-PAC-4".equals(product_code) ? "660000" : ("GZZRX-PAC-5".equals(product_code) ? "770000" : ("GZZRX-PAC-6".equals(product_code) ? "880000" : ("GZZRX-PAC-7".equals(product_code) ? "990000" : ("GZZRX-PAC-8".equals(product_code) ? "1100000" : (eam = "GZZRX-PAC-9".equals(product_code) ? "1320000" : "0"))))))));
            String string2 = "1".equals(is_contain_repo) ? String.valueOf(Integer.parseInt(eam) + 100000) : (eam = "2".equals(is_contain_repo) ? String.valueOf(Integer.parseInt(eam) + 200000) : eam);
        }
        if (!"0".equals(eam)) {
            aom = BigDecimal.valueOf(Double.parseDouble(eam)).multiply(BigDecimal.valueOf(Double.parseDouble(person_num)));
        }
        if ("1".equals(is_contain_repo)) {
            pm = pm.add(BigDecimal.valueOf(Double.parseDouble(epm)));
        }
        if ("2".equals(is_contain_repo)) {
            pm = pm.add(BigDecimal.valueOf(Double.parseDouble(epm2)));
        }
        prm = pm.multiply(BigDecimal.valueOf(Double.parseDouble(person_num))).setScale(2, 4);
        if ("2".equals(inception_type) && StringUtils.isNotEmpty((CharSequence)inception_long)) {
            prm = prm.multiply(BigDecimal.valueOf(Double.parseDouble(inception_long))).divide(BigDecimal.valueOf(Double.parseDouble("12"))).setScale(2, 4);
        }
        System.out.println(prm + "#" + aom);
        return new ResultDto(prm + "#" + aom, "200", "", "", "");
    }

    @RequestMapping(value={"/sessionInfo"})
    @ResponseBody
    public ResultDto sessionInfo(HttpServletRequest reqeust, ModelMap model) {
        String name = reqeust.getParameter("name");
        String base64 = reqeust.getParameter("base64");
        model.addAttribute(name, (Object)base64);
        return new ResultDto("", "200", "", "", "");
    }

    @RequestMapping(value={"/policy/deleteHirelingByOid"})
    @ResponseBody
    public ResultDto deleteHirelingByOid(HttpServletRequest request) {
        String hire_id = request.getParameter("hire_id");
        if (StringUtils.isEmpty((CharSequence)hire_id)) {
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u5220\u9664\u5931\u8d25\uff01", "300", "", "", "");
        }
        if (this.policyService.deleteHirelingByOid(hire_id)) {
            return new ResultDto("\u5220\u9664\u6210\u529f\uff01", "200", "", "", "");
        }
        return new ResultDto("\u8fd0\u884c\u65f6\u5f02\u5e38\uff0c\u5220\u9664\u5931\u8d25\uff01", "300", "", "", "");
    }

    @RequestMapping(value={"/policy/delectAllHireling"})
    @ResponseBody
    public ResultDto delectAllHireling(HttpServletRequest request) {
        String order_id = request.getParameter("order_id");
        if (StringUtils.isEmpty((CharSequence)order_id)) {
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        if (this.policyService.delectAllHireling(order_id)) {
            return new ResultDto("\u5220\u9664\u6210\u529f\uff01", "200", "", "", "");
        }
        return new ResultDto("\u8fd0\u884c\u65f6\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ResultDto uploadHirelingFile(MultipartFile mFile) throws Exception {
        ArrayList list = null;
        String[] arrStr = new String[]{"name", "id_type", "id_card", "birth_date", "sex", "mobile", "career"};
        list = Lists.newArrayList();
        String msg = "";
        boolean cum = false;
        String cds = "";
        try (InputStream is = mFile.getInputStream();){
            HSSFWorkbook hssfWorkbook = new HSSFWorkbook(is);
            block27: for (int numSheet = 0; numSheet < hssfWorkbook.getNumberOfSheets(); ++numSheet) {
                HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);
                if (hssfSheet == null) continue;
                HirelingVo rsVo = null;
                for (int rowNum = 6; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                    HSSFRow hssfRow = hssfSheet.getRow(rowNum);
                    int hh = rowNum + 1;
                    if (hssfRow == null) continue;
                    if (StringUtils.isEmpty((CharSequence)String.valueOf(hssfRow.getCell(1)).trim()) && StringUtils.isEmpty((CharSequence)String.valueOf(hssfRow.getCell(2)).trim()) && StringUtils.isEmpty((CharSequence)String.valueOf(hssfRow.getCell(3)).trim()) && StringUtils.isEmpty((CharSequence)String.valueOf(hssfRow.getCell(6)).trim()) && StringUtils.isEmpty((CharSequence)String.valueOf(hssfRow.getCell(7)).trim()) && StringUtils.isEmpty((CharSequence)String.valueOf(hssfRow.getCell(8)).trim())) continue block27;
                    HSSFCell cell = null;
                    rsVo = new HirelingVo();
                    HashMap map = Maps.newHashMap();
                    String cd = "";
                    for (int i = 1; i < 8; ++i) {
                        String _value;
                        block54: {
                            block59: {
                                block60: {
                                    block55: {
                                        block58: {
                                            block57: {
                                                block56: {
                                                    block53: {
                                                        cell = hssfRow.getCell(i);
                                                        _value = GZZRX_Policy_API_Controller.getValue(cell).trim();
                                                        if (StringUtils.isEmpty((CharSequence)_value)) {
                                                            String n = i == 1 ? "\u59d3\u540d" : (i == 2 ? "\u8bc1\u4ef6\u7c7b\u578b" : (i == 3 ? "\u8bc1\u4ef6\u53f7" : (i == 4 ? "\u51fa\u751f\u65e5\u671f" : (i == 5 ? "\u6027\u522b" : (i == 6 ? "\u624b\u673a" : "\u804c\u4e1a")))));
                                                            msg = msg + "\u7b2c " + hh + " \u884c\uff1a" + n + "\u4e0d\u80fd\u4e3a\u7a7a;";
                                                            cum = true;
                                                            continue;
                                                        }
                                                        if (!"name".equals(arrStr[i - 1])) break block53;
                                                        if (StringUtils.isNotEmpty((CharSequence)_value)) {
                                                            _value = _value.replace(" ", "");
                                                        }
                                                        break block54;
                                                    }
                                                    if (!"id_type".equals(arrStr[i - 1])) break block55;
                                                    if (!"\u5c45\u6c11\u8eab\u4efd\u8bc1".equals(_value)) break block56;
                                                    _value = "0";
                                                    break block54;
                                                }
                                                if (!"\u62a4\u7167".equals(_value)) break block57;
                                                _value = "3";
                                                break block54;
                                            }
                                            if (!"\u53f0\u80de\u8bc1".equals(_value)) break block58;
                                            _value = "4";
                                            break block54;
                                        }
                                        if (!"\u56de\u4e61\u8bc1".equals(_value)) break block54;
                                        _value = "5";
                                        break block54;
                                    }
                                    if (!"sex".equals(arrStr[i - 1])) break block59;
                                    if (!"\u7537".equals(_value)) break block60;
                                    _value = "1";
                                    break block54;
                                }
                                if (!"\u5973".equals(_value)) break block54;
                                _value = "2";
                                break block54;
                            }
                            if ("birth_date".equals(arrStr[i - 1])) {
                                block52: {
                                    try {
                                        if (_value.contains("-")) {
                                            DateUtil.parseDate((String)_value);
                                            break block52;
                                        }
                                        if (!HSSFDateUtil.isCellDateFormatted((Cell)cell)) break block52;
                                        Date d = cell.getDateCellValue();
                                        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
                                        _value = formater.format(d);
                                    }
                                    catch (Exception e) {
                                        msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u51fa\u751f\u65e5\u671f\u6709\u8bef;";
                                        cum = true;
                                        break;
                                    }
                                }
                                if (IdNumberValidator.getAgeFromBirthday((String)_value) > 65 || IdNumberValidator.getAgeFromBirthday((String)_value) < 16) {
                                    msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u4eba\u5458\u7684\u5e74\u9f84\u8d85\u51fa\u9650\u5236\uff08\u533a\u95f4\uff1a16-60\u5468\u5c81\uff09;";
                                    cum = true;
                                    break;
                                }
                            } else if ("id_card".equals(arrStr[i - 1])) {
                                if (!IdCardVerify.isValidatedAllIdcard((String)(_value = _value.toUpperCase()))) {
                                    msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u8bc1\u4ef6\u53f7\u7801\u4e0d\u662f\u6709\u6548\u8bc1\u4ef6\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d;";
                                    cum = true;
                                    break;
                                }
                                cd = _value;
                            } else if ("mobile".equals(arrStr[i - 1])) {
                                if (_value.contains("E")) {
                                    try {
                                        DecimalFormat df = new DecimalFormat("#");
                                        _value = df.format(cell.getNumericCellValue());
                                    }
                                    catch (Exception e) {
                                        msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u624b\u673a\u53f7\u7801\u683c\u5f0f\u6709\u8bef;";
                                        cum = true;
                                        break;
                                    }
                                }
                                if (!ValidatorUtil.validatePhone((String)_value)) {
                                    msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u624b\u673a\u53f7\u7801\u683c\u5f0f\u6709\u8bef;";
                                    cum = true;
                                    break;
                                }
                            } else if ("career".equals(arrStr[i - 1]) && !"1234".contains(_value = _value.replace(".0", ""))) {
                                msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u804c\u4e1a\u7f16\u7801\u65e0\u6548;";
                                cum = true;
                                break;
                            }
                        }
                        map.put(arrStr[i - 1], _value);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)cd) && cds.contains(cd)) {
                        msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u8be5\u8bc1\u4ef6\u53f7\u5df2\u5728\u672c\u6e05\u5355\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u5f55\u5165;";
                        cum = true;
                    }
                    cds = cds + cd + ";";
                    if (rsVo == null || map.size() <= 0) continue;
                    MyConverUtil.map2PO((Map)map, (Object)rsVo);
                    list.add(rsVo);
                    rsVo = null;
                }
            }
            if (cum) {
                ResultDto resultDto = new ResultDto(msg, "300", "", "", "");
                return resultDto;
            }
            if (list != null && !list.isEmpty()) {
                if (list.size() > 2001 || list.size() < 3) {
                    ResultDto resultDto = new ResultDto("\u8bf7\u63a7\u5236\u5bfc\u5165\u4eba\u6570\u57283~2001\u4eba\u4ee5\u5185\uff01", "300", "", "", "");
                    return resultDto;
                }
                if (this.setValueSession(list)) {
                    ResultDto resultDto = new ResultDto("\u6587\u4ef6\u89e3\u6790\u6210\u529f\uff01", "200", "", "", "");
                    return resultDto;
                }
                ResultDto resultDto = new ResultDto("\u6570\u636e\u7f13\u5b58\u5931\u8d25\uff01", "300", "", "", "");
                return resultDto;
            }
            ResultDto resultDto = new ResultDto("\u672a\u89e3\u6790\u5230\u53ef\u7528\u6570\u636e\uff01", "300", "", "", "");
            return resultDto;
        }
        catch (Exception e) {
            return new ResultDto("Excel\u6e05\u5355\u6a21\u677f\u6587\u4ef6\u6570\u636e\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u4f7f\u7528\u6807\u51c6\u7684Excel\u6e05\u5355\u6a21\u677f\u4e0a\u4f20\uff01\n\u53ef\u80fd\u539f\u56e0\uff1a\n1.\u6a21\u677f\u6587\u4ef6\u5934\u90e8\u5185\u5bb9\u88ab\u5220\u9664\u6216\u6574\u4f53\u6837\u5f0f\u88ab\u6539\u53d8\uff1b\n2.\u76f4\u63a5\u5b83\u5904\u590d\u5236\u7684\u4eba\u5458\u4fe1\u606f\u9644\u5e26\u683c\u5f0f\u3002", "300", "", "", "");
        }
    }

    private static String getValue(HSSFCell hssfRow) {
        if (hssfRow.getCellType() == 4) {
            return String.valueOf(hssfRow.getBooleanCellValue());
        }
        if (hssfRow.getCellType() == 0) {
            return String.valueOf(hssfRow.getNumericCellValue());
        }
        String value = "";
        try {
            value = String.valueOf(hssfRow.getStringCellValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    @RequestMapping(value={"/policy/gzxUploadHirelingFile"})
    @ResponseBody
    public ResultDto gzxUploadHirelingFile(MultipartHttpServletRequest request) throws Exception {
        MultipartFile hireFile = request.getFile("hire_emp");
        if (hireFile != null) {
            return this.uploadHirelingFile(hireFile);
        }
        return new ResultDto("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", "300", "", "", "");
    }

    @RequestMapping(value={"/policy/hire_upload_list/{product_code}"})
    public ModelAndView hire_upload_list(@PathVariable String product_code) {
        ModelAndView view = new ModelAndView("/coninsweb/api/gzzrx/policy/hire_upload_list");
        view.addObject("rsVoList", this.getValueSession());
        view.addObject("personTypeList", (Object)IdType.personList());
        view.addObject("product_code", (Object)product_code);
        this.setTokenByApi(view);
        return view;
    }

    private boolean setValueSession(List<HirelingVo> list) {
        JedisUtils.setObject((String)("rsVoList:" + this.getToken()), list, (int)180);
        return true;
    }

    private List<HirelingVo> getValueSession() {
        List list = (List)JedisUtils.getObject((String)("rsVoList:" + this.getToken()));
        JedisUtils.delObject((String)("rsVoList:" + this.getToken()));
        return list;
    }
}

