/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.controller.api.gzx;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.service.ComBankCodeService;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.third.gzx.huatai.GZX_HTRequestService;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.util.enums.NatureLinkage;
import com.bcxin.ins.vo.AdviceNoteVo;
import com.bcxin.ins.vo.BLBCommunicationDto;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.MailPolicyVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.SpecialPublicDutyVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/api/gzx"})
public class GZX_Policy_API_Controller
extends BaseController {
    @Autowired
    private PolicyService policyService;
    @Autowired
    private GZX_HTRequestService gZX_HTRequestService;
    @Autowired
    private ProductService productService;
    @Autowired
    private ComBankCodeService comBankCodeService;

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT, title="\u3010\u89c6\u56fe\u3011\u4ea7\u54c1-\u8bbf\u95ee\u6295\u4fdd\u9875")
    @LoginRequired(methodParamKey={"1#product_id"}, redirectUrl="insurance/policy_init_iframe/{product_id}")
    @RequestMapping(value={"/policyInit/{product_id}"})
    public ModelAndView policyInit(HttpServletRequest request, @PathVariable Long product_id, ModelMap model) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        SpecialPublicDutyVo vo = new SpecialPublicDutyVo();
        ProductVo pd = this.productService.getProduct(product_id.longValue());
        MailPolicyVo mVo = new MailPolicyVo();
        ModelAndView view = new ModelAndView();
        vo.setMailPolicyVo(mVo);
        view.addObject("vo", (Object)vo);
        view.addObject("recommend_code", (Object)UserSupportUtil.getRecommendCode());
        this.orderAllotInit(pd, view);
        this.setTokenByApi(view);
        return view;
    }

    private String createOrderAndGetOrderIDByProductID(Long product_id, Long user_id, String recommendCode, String trade_serial_number) {
        Map map = this.policyService.createOrderFormByProductOid(product_id, user_id, recommendCode, trade_serial_number);
        if (map.get("order_id") != null) {
            return (String)map.get("order_id");
        }
        return "";
    }

    @LoginRequired(methodParamKey={"1#order_id"}, redirectUrl="insurance/gzx/policy/policy_iframe/{order_id}")
    @RequestMapping(value={"/policy/{order_id}"})
    public ModelAndView enterInfo(HttpServletRequest request, @PathVariable Long order_id) {
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        ModelAndView view = new ModelAndView();
        this.orderAllot(order_id, userdetail, view);
        this.setTokenByApi(view);
        return view;
    }

    private void orderAllotInit(ProductVo pd, ModelAndView view) {
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setGross_premium(pd.getPremium_min());
        dto.setTrade_serial_number(String.valueOf(IdWorker.getId()));
        view.addObject("sigId", (Object)String.valueOf(IdWorker.getId()));
        view.addObject("pd", (Object)pd);
        view.addObject("dto", (Object)dto);
        view.addObject("comTypeList", (Object)IdType.comList());
        view.addObject("natureList", (Object)NatureLinkage.getListByProvince((String)""));
        if (StringUtils.isEmpty((CharSequence)pd.getProduct_code())) {
            return;
        }
        if ("GZX".equals(pd.getProduct_code().split("-")[0])) {
            try {
                view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            view.setViewName("/coninsweb/api/gzx/policy/gzx_enterBasicInfo");
        }
    }

    private void orderAllot(Long order_id, ClientUserVo userdetail, ModelAndView view) {
        try {
            OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
            ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
            view.addObject("pd", (Object)pd);
            view.addObject("comTypeList", (Object)IdType.comList());
            view.addObject("natureList", (Object)NatureLinkage.getListByProvince((String)""));
            view.addObject("dto", (Object)dto);
            if (StringUtils.isEmpty((CharSequence)dto.getProduct_code()) || !"GZX".equals(dto.getProduct_code().split("-")[0])) {
                return;
            }
            SpecialPublicDutyVo vo = this.policyService.accordingToOrderIDToGetSpecialPublicDutyVo(order_id);
            view.addObject("vo", (Object)vo);
            view.setViewName("/coninsweb/api/gzx/policy/gzx_enterBasicInfo");
            if (vo == null) {
                return;
            }
            view.addObject("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
            if (vo.getRoleSubjectList() != null) {
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getNature_two()) && StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getCom_nature())) {
                    view.addObject("natureTwoList", (Object)NatureLinkage.getListByProvince((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getCom_nature()));
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province())) {
                    view.addObject("cityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province()));
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_province())) {
                    view.addObject("bankCityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_province()));
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_city())) {
                    view.addObject("bankTypeList", (Object)this.comBankCodeService.getAllBankType(((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_city()));
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_type())) {
                    view.addObject("bankAddrList", (Object)this.comBankCodeService.getAllBankAddr(((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_city(), ((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getBank_type()));
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city())) {
                    view.addObject("areaList", (Object)RegionUtils.findDistrictByParentCode((String)"3", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city()));
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getNature_two()) && StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getCom_nature())) {
                    view.addObject("natureTwoList1", (Object)NatureLinkage.getListByProvince((String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getCom_nature()));
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province())) {
                    view.addObject("reg_city_1_List", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province()));
                }
                if (StringUtils.isNotEmpty((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city())) {
                    view.addObject("reg_area_1_List", (Object)RegionUtils.findDistrictByParentCode((String)"3", (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city()));
                }
            }
            if (vo.getMailPolicyVo() != null && StringUtils.isNotEmpty((CharSequence)vo.getMailPolicyVo().getBank_province())) {
                view.addObject("bankCityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)vo.getMailPolicyVo().getBank_province()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @LoginRequired(methodParamKey={"0#order_id"}, redirectUrl="insurance/gzx/policy/policy_iframe/{order_id}")
    @RequestMapping(value={"/policy/confirmPage/{order_id}"})
    public ModelAndView confirmPage(@PathVariable Long order_id, HttpServletRequest request) throws Exception {
        ModelAndView view = new ModelAndView();
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
        view.addObject("pd", (Object)pd);
        view.addObject("dto", (Object)dto);
        view.addObject("comTypeList", (Object)IdType.comList());
        if (!StringUtils.isEmpty((CharSequence)dto.getProduct_code()) && "GZX".equals(dto.getProduct_code().split("-")[0])) {
            view.setViewName("/coninsweb/api/gzx/policy/policyConfirm");
            List natureList = NatureLinkage.doList();
            SpecialPublicDutyVo vo = this.policyService.accordingToOrderIDToGetSpecialPublicDutyVo(order_id);
            view.addObject("vo", (Object)vo);
            view.addObject("natureList", (Object)natureList);
            view.addObject("reg_role", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getReg_district()));
            view.addObject("reg_role_1", (Object)RegionUtils.getRegionNameByALLCode((String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_province(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_city(), (String)((RoleSubjectVo)vo.getRoleSubjectList().get(1)).getReg_district()));
        }
        this.setTokenByApi(view);
        return view;
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_ORDER, title="\u3010\u8bf7\u6c42\u3011\u4ea7\u54c1-\u8ba2\u5355\u6295\u4fdd")
    @RequestMapping(value={"/policy/pendingSpecialPublicDutyVoPolicy"})
    @ResponseBody
    public ResultDto pendingSpecialPublicDutyVoPolicy(SpecialPublicDutyVo vo, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String recommendCode = request.getParameter("recommendCode");
        return this.policyService.pendingSpecialPublicDutyVoPolicy(vo, recommendCode);
    }

    @LoginRequired
    @RequestMapping(value={"/policy/updateOrderFormStatus"})
    @ResponseBody
    public ResultDto updateOrderFormStatus(HttpServletRequest request) throws Exception {
        String order_id = request.getParameter("order_id");
        String status = request.getParameter("status");
        if (StringUtils.isEmpty((CharSequence)order_id) || StringUtils.isEmpty((CharSequence)status)) {
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        OrderFormVo vo = new OrderFormVo();
        vo.setOid(String.valueOf(order_id));
        vo.setPolicy_status(status);
        String orderID = this.policyService.updateOrderFormStatus(vo);
        if (StringUtils.isNotEmpty((CharSequence)orderID)) {
            return new ResultDto("\u8ba2\u5355\u5f55\u5165\u6210\u529f\u3002", "200", orderID, "300", "");
        }
        return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
    }

    @LoginRequired(methodParamKey={"0#order_id"}, redirectUrl="insurance/gzx/policy/payment_iframe/{order_id}")
    @RequestMapping(value={"/policy/policyPayment/{order_id}"})
    public ModelAndView savePolicy(@PathVariable long order_id, HttpServletRequest request) {
        ModelAndView view = null;
        try {
            OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(order_id));
            ProductVo pd = this.productService.getProduct(Long.parseLong(vo.getProduct_oid()));
            if (StringUtils.isNotEmpty((CharSequence)vo.getPay_methods())) {
                AdviceNoteVo anVo = this.policyService.accordingToOrderIDToGetAdviceNoteVo(Long.valueOf(order_id));
                view = new ModelAndView("/coninsweb/api/gzx/transaction/paymentNotice");
                view.addObject("anVo", (Object)anVo);
            } else if (vo.getPolicy_status().equals("2")) {
                view = new ModelAndView("/coninsweb/api/gzx/transaction/waitOffer");
            } else if (vo.getPolicy_status().equals("6")) {
                view = new ModelAndView("/coninsweb/api/gzx/transaction/passUnderwriting");
            } else if (vo.getPolicy_status().equals("15")) {
                view = new ModelAndView("/coninsweb/api/gzx/transaction/declinature");
            } else if (vo.getPolicy_status().equals("4")) {
                if (this.productService.api_request_sign(vo.getProduct_code()) == 2) {
                    view = new ModelAndView("/coninsweb/api/gzx/transaction/policyPayment_PAC");
                } else if (this.productService.api_request_sign(vo.getProduct_code()) == 1) {
                    view = new ModelAndView("/coninsweb/api/gzx/transaction/policyPayment_HT");
                    this.GZX_HT_Payment(order_id, view, vo);
                }
            } else if (vo.getPolicy_status().equals("5")) {
                view = new ModelAndView("/coninsweb/api/gzx/transaction/finishPay");
            }
            view.addObject("pd", (Object)pd);
            view.addObject("dto", (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        view.addObject("nowTime", (Object)new Date());
        this.setTokenByApi(view);
        return view;
    }

    private void GZX_HT_Payment(@PathVariable long order_id, ModelAndView view, OrderFormVo vo) throws Exception {
        boolean boo;
        String yxDate = DateUtil.convertDateToString((Date)new Date(), (String)"yyyyMMdd");
        boolean bl = boo = StringUtils.isEmpty((CharSequence)vo.getPay_order_number()) ? false : vo.getPay_order_number().contains(yxDate);
        if (StringUtils.isNotEmpty((CharSequence)vo.getShow_url()) && boo) {
            view.addObject("payurl", (Object)vo.getShow_url());
        } else {
            String result = this.gZX_HTRequestService.request_ht_gzx(Long.valueOf(Long.parseLong(vo.getOid())), TransTypeEnum.ZFDZ.getValue(), null);
            String[] strs = result.split("#");
            if ("200".equals(strs[0])) {
                this.policyService.payUrlChangeCA(Long.valueOf(order_id), com.bcxin.mybatisplus.toolkit.IdWorker.getId() + "", strs[1]);
                view.addObject("payurl", (Object)strs[1]);
            }
        }
    }

    @RequestMapping(value={"/policy/requestEPolicy/{oid}"})
    @ResponseBody
    public ResultDto requestEPolicy(@PathVariable Long oid) throws Exception {
        OrderFormVo vo = this.policyService.accordingToOrderIDToGetPolicyDto(oid);
        if (vo.getProduct_code().indexOf("GZX-PAC") != -1 && StringUtils.isEmpty((CharSequence)vo.getInsure_path())) {
            this.policyService.HTTP_PAC_GZX_DZBD(oid, null, vo);
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getInsure_path())) {
            return new ResultDto("", "200", vo.getInsure_path(), "", "");
        }
        return new ResultDto("\u7535\u5b50\u4fdd\u5355\u751f\u6210\u4e2d(\u8fd9\u53ef\u80fd\u9700\u8981\u534a\u4e2a\u5c0f\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5)...", "300", "", "", "");
    }

    @RequestMapping(value={"/sessionInfo"})
    @ResponseBody
    public ResultDto sessionInfo(HttpServletRequest reqeust, ModelMap model) {
        String name = reqeust.getParameter("name");
        String base64 = reqeust.getParameter("base64");
        model.addAttribute(name, (Object)base64);
        return new ResultDto("", "200", "", "", "");
    }

    @RequestMapping(value={"/getActivityByPss/{thr_order_id}"})
    @ResponseBody
    public String getActivityByPss(@PathVariable String thr_order_id) {
        String result = "";
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return result;
        }
        try {
            BLBCommunicationDto dto = this.policyService.getBLBCommunicationDtoByOrderID_PSSAPI(thr_order_id, userdetail.getWeb_type());
            if (dto != null) {
                result = JSONObject.toJSONString((Object)dto);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

