/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.coninsweb.order.controller.api.afr;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/insurance/afr"})
public class PolicyProductAFR
extends BaseController {
    @Autowired
    private ProductService productService;
    @Autowired
    private PolicyService policyService;

    @RequestMapping(value={"/pro_afr_info/{product_id}"})
    public ModelAndView proAfrInfo(@PathVariable Long product_id) {
        ModelAndView view = new ModelAndView("/coninsweb/api/afr/pro_afr_info");
        view.addObject("product_id", (Object)String.valueOf(product_id));
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(methodParamKey={"0#oid"}, redirectUrl="insurance/afr/policy/policy_iframe/{oid}")
    @RequestMapping(value={"/policy/policy_iframe/{oid}"})
    public ModelAndView policy_iframe(@PathVariable long oid) {
        ModelAndView view = new ModelAndView("/coninsweb/api/afr/order_afr_info");
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.valueOf(oid));
        view.addObject("order_id", (Object)dto.getOid());
        view.addObject("product_id", (Object)dto.getProduct_oid());
        this.setTokenByApi(view);
        return view;
    }

    @LoginRequired(methodParamKey={"0#oid"}, redirectUrl="insurance/afr/policy/payment_iframe/{oid}")
    @RequestMapping(value={"/policy/payment_iframe/{oid}"})
    public ModelAndView payment_iframe(@PathVariable long oid) {
        ModelAndView view = new ModelAndView("/coninsweb/api/afr/order_afr_pay");
        view.addObject("order_id", (Object)String.valueOf(oid));
        this.setTokenByApi(view);
        return view;
    }

    @RequestMapping(value={"/productInit/{oid}"})
    public ModelAndView productInit(HttpServletRequest request, @PathVariable Long oid, ModelMap model) {
        ModelAndView view = new ModelAndView();
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        ProductVo pd = this.productService.getProduct(oid.longValue());
        if (!StringUtils.isNotEmpty((CharSequence)pd.getOid())) {
            return null;
        }
        view.addObject("sharePath", (Object)this.productService.setSharePath(oid, userdetail));
        if (!StringUtils.isEmpty((CharSequence)pd.getProduct_code()) && pd.getProduct_code().contains("GZX-HT")) {
            view.setViewName("/coninsweb/api/afr/product/gzx_ht_product_info");
        }
        view.addObject("productDto", (Object)pd);
        view.addObject("userdetail", (Object)userdetail);
        this.setTokenByApi(view);
        return view;
    }
}

