/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.aspect;

import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.Constant;
import com.bcxin.ins.util.DSUtil;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.ModelAndView;

@Aspect
@Component
public class LoginRequiredAspect {
    private static final Logger logger = LoggerFactory.getLogger(LoginRequiredAspect.class);

    public LoginRequiredAspect() {
        System.out.println("\u521d\u59cb\u5316\u767b\u5f55\u62e6\u622a\u5207\u9762 LoginRequiredAspect=======================");
    }

    @Pointcut(value="@annotation(com.bcxin.ins.spring.annotation.LoginRequired)")
    public void controllerAspect() {
    }

    @Around(value="controllerAspect()")
    public Object doAroundController(ProceedingJoinPoint point) {
        Object result = null;
        try {
            Method[] methods;
            ClientUserVo userDetail = UserSupportUtil.getSessionUser();
            if (userDetail != null) {
                return point.proceed();
            }
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, Object> map = new HashMap<String, Object>();
            HashMap<String, Object> kv = new HashMap<String, Object>();
            String targetName = point.getTarget().getClass().getName();
            String methodName = point.getSignature().getName();
            Object[] arguments = point.getArgs();
            Class<?> targetClass = Class.forName(targetName);
            for (Method method : methods = targetClass.getMethods()) {
                String[] requestParamKey;
                String[] methodParamKey;
                Class<?>[] clazz;
                if (!method.getName().equals(methodName) || (clazz = method.getParameterTypes()).length != arguments.length) continue;
                map.put("isRedirect", method.getAnnotation(LoginRequired.class).isRedirect());
                map.put("redirectUrl", method.getAnnotation(LoginRequired.class).redirectUrl());
                for (String k : methodParamKey = method.getAnnotation(LoginRequired.class).methodParamKey()) {
                    String keyIndex = k.split("#")[0];
                    String key = k.split("#")[1];
                    Object ats = arguments[Integer.parseInt(keyIndex)];
                    if (ats == null) continue;
                    String keyValue = arguments[Integer.parseInt(keyIndex)].toString();
                    kv.put(key, keyValue);
                }
                for (String k : requestParamKey = method.getAnnotation(LoginRequired.class).requestParamKey()) {
                    String keyValue = request.getParameter(k) != null ? request.getParameter(k).toString() : "";
                    kv.put(k, keyValue);
                }
                break;
            }
            String url = this.getRedirectUrl(map, kv);
            return new ModelAndView(url);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.toString());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            logger.error(throwable.toString());
        }
        return result;
    }

    private boolean checkWeiXin() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String userAgent = request.getHeader("user-agent").toLowerCase();
        return userAgent.indexOf("micromessenger") > -1;
    }

    private String getRedirectUrl(Map<String, Object> map, Map<String, Object> kv) {
        if (!map.containsKey("isRedirect") || !"true".equals(map.get("isRedirect").toString().toLowerCase())) {
            return "";
        }
        String url = map.containsKey("redirectUrl") ? map.get("redirectUrl").toString() : "";
        String token = LoginRequiredAspect.getToken();
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            String platformFlag = JedisUtils.get((String)("thirdPlatformFlagCache" + token));
            logger.info("\u7b2c\u4e09\u65b9\u5e73\u53f0\u6807\u8bc6{}", new Object[]{platformFlag});
            if (StringUtils.isNotEmpty((CharSequence)platformFlag) && !"BLB".equalsIgnoreCase(platformFlag)) {
                return "forward:/synopsis/loseView";
            }
        }
        if (StringUtils.isEmpty((CharSequence)url)) {
            return Constant.LOGIN_URL_COM;
        }
        if (!(url.contains("redirect:") || url.contains("forward:") || this.checkWeiXin())) {
            url = DSUtil.operation() + url;
        }
        for (String key : kv.keySet()) {
            url = url.replace("{" + key + "}", kv.get(key).toString());
        }
        return url;
    }

    public static Cookie getCookieByName(String name) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        Map<String, Cookie> cookieMap = LoginRequiredAspect.ReadCookieMap(request);
        if (cookieMap.containsKey(name)) {
            Cookie cookie = cookieMap.get(name);
            return cookie;
        }
        return null;
    }

    public static String getToken() {
        String referer_url;
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String access_token = request.getParameter("ACCESS_TOKEN");
        if (StringUtils.isEmpty((CharSequence)access_token) && StringUtils.isNotEmpty((CharSequence)(referer_url = request.getHeader("Referer"))) && referer_url.contains("ACCESS_TOKEN=") && !referer_url.endsWith("ACCESS_TOKEN=")) {
            String x_at = referer_url.split("ACCESS_TOKEN=")[1];
            if (x_at.length() == 32) {
                access_token = x_at;
            } else if (x_at.length() > 32) {
                access_token = x_at.substring(0, 32);
            }
        }
        return access_token;
    }

    private static Map<String, Cookie> ReadCookieMap(HttpServletRequest request) {
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie);
            }
        }
        return cookieMap;
    }
}

