<%@ page language="java" contentType="text/html; charset=utf-8"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="renderer" content="webkit">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <link rel="stylesheet" href="/static/weChat/css/public.css">
    <link rel="stylesheet" href="/static/weChat/css/bai_basic.css">
    <script src="/static/weChat/js/flexible.js"></script>
    <title>我的资料</title>
</head>
<body id="container">
<div class="ert-head">
    <div class="ert-left">
        <a href="/weixin/usercenter/index">
            <img src="/static/weChat/images/head-left.png" />
        </a>
    </div>
    <p>我的资料</p>
    <div class="ert-right">
      <%--  <a href="javascript:;" id="save">保存</a>--%>
    </div>
</div>
<div class="users-data">
    <ul class="data">
        <li>
            <p>姓名</p>
            <div class="dfg">
                <input type="text" value="${weixinVo.real_name}" id="name" placeholder="请填写姓名"/>
                <b></b>
            </div>
        </li>
        <li>
            <p>身份证号</p>
            <div class="dfg">
                <input type="text" value="${weixinVo.id_card}" id="identifica" placeholder="请填写身份证号"/>
                <b></b>
            </div>
        </li>
    </ul>
    <ul class="data">
        <li>
            <p>手机号</p>
            <div class="dfg">
                <input type="text" value="${weixinVo.telephone}" class="gray" id="phone" placeholder="请填写手机号码"/>
                <b></b>
            </div>
        </li>
        <li>
            <p>邮箱</p>
            <div class="dfg">
                <input type="text" value="${weixinVo.email}" id="email" placeholder="请填写邮箱"/>
                <b></b>
            </div>
        </li>
    </ul>
</div>

</body>
<script src="/static/weChat/js/jquery-1.8.3.min.js"></script>

<script src="/static/weChat/js/basic.js"></script>
<script>
    var phone_reg = /^1[2|3|4|5|6|7|8|9]\d{9}$/;
    var email_reg = /^[A-Za-z0-9\u4e00-\u9fa5]+@[a-zA-Z0-9_-]+(\.[a-zA-Z0-9_-]+)+$/;
    var identifica_reg = /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/;

    //    是否为空
    function checkEmpty(obj) {
        obj_ok = obj + '_ok';
        if ($('#'+obj).val() == "") {
            var sd = $('#'+obj).parents('.dfg').siblings('p').text();
            $('#'+obj).siblings('b').text(sd + '不能为空').css({"display": "block"});
            return obj_ok = false;
        }else{
            $('#'+obj).siblings('b').css({"display": "none"});
            return obj_ok = true;
        }
    }

    //   验证身份证号
    function checkIdentifica() {
        if ($('#identifica').val() == "") {
            $('#identifica').siblings('b').text('身份证号不能为空').css({"display": "block"});
            return identifica_ok = false;
        } else if(!$('#identifica').val().match(identifica_reg)){
            $('#identifica').siblings('b').text('身份证号格式错误').css({"display": "block"});
            return identifica_ok = false;
        }else{
            $('#identifica').siblings('b').css({"display": "none"});
            return identifica_ok = true;
        }
    }

    //    验证手机号码
    function checkPhone() {
        if ($('#phone').val() == "") {
            $('#phone').siblings('b').text('手机号码不能为空').css({"display": "block"});
            return phone_ok = false;
        } else if(!$('#phone').val().match(phone_reg)){
            $('#phone').siblings('b').text('手机号码格式错误').css({"display": "block"});
            return phone_ok = false;
        }else{
            $('#phone').siblings('b').css({"display": "none"});
            return phone_ok = true;
        }
    }
    //    验证邮箱
    function checkEmail() {
        if ($('#email').val() == "") {
            $('#email').siblings('b').text('邮箱不能为空').css({"display": "block"});
            return email_ok = false;
        }else if(!$('#email').val().match(email_reg)){
            $('#email').siblings('b').text('邮箱格式错误').css({"display": "block"});
            return email_ok = false;
        }else{
            $('#email').siblings('b').css({"display": "none"});
            return email_ok = true;
        }
    }

    $('#save').click(function () {
        name_ok = checkEmpty('name');
        identifica_ok = checkIdentifica();
        phone_ok = checkPhone();
        email_ok = checkEmail();
        if (name_ok && identifica_ok && phone_ok && email_ok) {
            window.location = "http://www.baidu.com";
        }
    });

</script>
</html>