<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="renderer" content="webkit">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <link rel="stylesheet" href="/static/weChat/css/public.css">
    <link rel="stylesheet" href="/static/weChat/css/bai_basic.css">
    <script src="/static/weChat/js/flexible.js"></script>
    <title>搜索</title>
</head>
<body id="container">
<div class="lian-search">
    <div class="search">
        <div class="search-back">
            <a href="/weixin/product/win/list">
                <img src="/static/weChat/images/yellow-back.png" />
            </a>
        </div>
        <input id="searchText" type="text" placeholder="请输入关键词搜索" value=""/>
        <div class="serach-error">
            <img src="/static/weChat/images/remove-error.png" />
        </div>
    </div>
    <div class="lian-cancel">
        <a id="searchButton" >搜索</a>
    </div>
    <div class="search-content">
        <ul id="promptList">
          <%--  <li>
                <a class="promptListItem" href="/weixin/product/win/search/result?keyword=xxx">这是搜索内容这是搜索内容</a>
            </li>
            <li>
                <a href="javascript:;">这是搜索内容这是搜索内容这是搜索内容这是搜索内容这是搜索内容这是搜索内容</a>
            </li>
            <li>
                <a href="javascript:;">这是搜索内容这是搜索内容</a>
            </li>--%>
        </ul>
        <%--<div class="search-more">--%>
            <%--<a id="searchMore">查看更多结果</a>--%>
        <%--</div>--%>
    </div>
</div>
<div class="serach-histroy" id="serach-histroy">
    <h2>
        <i>搜索历史</i>
        <span>
            <img id="clear" src="/static/weChat/images/trash.png" />
        </span>
    </h2>
    <ul id="searchHistoryList">
        <%--<li>
            <a href="javascript:;">财产保险</a>
        </li>
        <li>
            <a href="javascript:;">财产</a>
        </li>
        <li>
            <a href="javascript:;">财产撒大大</a>
        </li>
        <li>
            <a href="javascript:;">财</a>
        </li>
        <li>
            <a href="javascript:;">财产</a>
        </li>
        <li>
            <a href="javascript:;">财产</a>
        </li>
        <li>
            <a href="javascript:;">财产是的发生的</a>
        </li>--%>
    </ul>
</div>
<%--<div class="serach-histroy hot-search">
    <h2>
        <i>热门搜索</i>
    </h2>
    <ul>
        <li>
            <a href="javascript:;">财产保险</a>
        </li>
        <li>
            <a href="javascript:;">财产</a>
        </li>
        <li>
            <a href="javascript:;">财</a>
        </li>
        <li>
            <a href="javascript:;">财</a>
        </li>
        <li>
            <a href="javascript:;">财产</a>
        </li>
        <li>
            <a href="javascript:;">财产撒大大</a>
        </li>
        <li>
            <a href="javascript:;">财产</a>
        </li>
        <li>
            <a href="javascript:;">财产是的发生的</a>
        </li>
    </ul>
</div>--%>
</body>
<script src="/static/weChat/js/jquery-1.8.3.min.js"></script>
<script src="/static/weChat/common/layer_mobile/layer.js"></script>
<link rel="stylesheet" href="/static/weChat/common/layer_mobile/need/right.css">
<script src="/static/weChat/js/weixin_g.js"></script>
<script src="/static/weChat/js/basic.js"></script>
<script>
    l_length = $('.search input').val().length;
    if(l_length >= 1){
        $('.serach-error').show();
    }

    //搜索框的变化
    $(".lian-search").find('input').on('input propertychange',function(){
        var re_length = $(this).val().length;
        if(re_length >=1 ){
            $('.serach-error').show();
            $('.search-content').show();
        }else{
            $('.serach-error').hide();
            $('.search-content').hide();
        }
    });

    $('.serach-error').click(function () {
        $(".lian-search input").val('');
        $(this).hide();
        $('.search-content').hide();
    });

    $('#serach-histroy h2 span').click(function () {
        $('#serach-histroy ul').remove();
    });

    //提示列表分页查询
    function getData(){
        g_ajax("/weixin/product/query",p ,function(json){
            var el, li, i;
            var rows = json.rows;
            var total = json.total;
            el = document.getElementById('promptList');
            if( rows==undefined || rows.length==0 ) { //长度为空，或者小于limit条数，说明是已经到最后了
                return;
            }else{
                p.offset += p.limit;
            }
            for(var i in rows){
                li = document.createElement('li');
                li.innerHTML = '<a class="promptListItem">'+rows[i].insurance_name+'</a>'; //href="/weixin/product/win/search/result?keyword=xxx"
                el.appendChild(li, el.childNodes[0]);
            }
        },false);
    }

    var last;
    //输入框输入事件
    $("#searchText").keyup(function(event){
        $this=$(this);

        last=event.timeStamp;
        //利用event的timeStamp来标记时间，这样每次的keyup事件都会修改last的值，注意last必需为全局变量
        setTimeout(function(){
            if(last - event.timeStamp==0){
                //如果时间差为0（也就是你停止输入1s之内都没有其它的keyup事件发生）则做你想要做的事
                $("#promptList").html("");
                p = { limit: 5, offset: 0 };
                p.search = $("#searchText").val();
                getData(); //初始化加载
            }
        },500);
    });

//    //搜索更多
//    $("#searchMore").click(function(){
//        p.search = $("#searchText").val();
//        getData();
//    })

    //设置历史下拉列表
    function setHistory( search ){
        if(localStorage.getItem("searchProductHistory")==null){
            localStorage.setItem("searchProductHistory",JSON.stringify([search])); //如果为空，第一次放入缓存
        }else{
            //如果已经存在，取出来合并
            old = JSON.parse(localStorage.getItem("searchProductHistory"));
            old.unshift(search);
            localStorage.setItem("searchProductHistory",JSON.stringify(old));
        }
    }
    //清空搜索缓存
    $("#clear").click(function(){
        localStorage.removeItem("searchProductHistory");
    })

    //搜索点击时间和选中点击事件
    $("#promptList").on("click","li",function(){
        location.href = "/weixin/product/win/search/result?keyword="+$(this).text();
        setHistory( $(this).text() );
    });
    $("#searchButton").click(function(){
        location.href = "/weixin/product/win/search/result?keyword="+$("#searchText").val();
        setHistory( $("#searchText").val() );
    });

    //初始化搜索列表
    if(localStorage.getItem("searchProductHistory")!=null){
        var old = JSON.parse(localStorage.getItem("searchProductHistory"));
        var el, li ;
        el = document.getElementById('searchHistoryList');
        for(var i in old){
            if(old[i]!=""){
                li = document.createElement('li');
                li.innerHTML ='<a href="/weixin/product/win/search/result?keyword='+old[i]+'">'+old[i]+'</a>';
                el.appendChild(li, el.childNodes[0]);
            }
        }

    }

    $("#searchText").focus();


</script>
</html>