<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="renderer" content="webkit">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <link rel="stylesheet" href="/static/weChat/css/public.css">
    <link rel="stylesheet" href="/static/weChat/css/bai_basic.css">
    <link rel="stylesheet" href="/static/weChat/css/animate.min.css">
    <script src="/static/weChat/js/flexible.js"></script>
    <title>产品详情</title>
    <style>
        .productTitle2{
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            width: 80%;
            left: 80px;
            position: absolute;
        }

    </style>
</head>
<body id="container">
<div class="arment-head">
    <div class="arment-left">
        <a  id="back">
            <img src="/static/weChat/images/arment-left.png"/>
        </a>
    </div>
    <p class="productTitle productTitle2"><%--产品名称--%></p>
</div>
<div class="plan-details">
    <div class="plan-s1">
        <img id="productLogo" src="/static/weChat/images/default.png" />
        <div class="s1-cont">
            <h2 class="productTitle"><%--产品名称--%></h2>
            <div id="companyLogo" class="s1-logo"></div>
            <p class="money">
                <i>￥</i>
                <b class="fixed_premium">450.00</b>
            </p>
            <p  class="cont-text productIntro">
               <%--产品简介--%>
            </p>
            <div class="cont-regules">
                <div class="regules-left">
                    <p>适用范围：<span class="productScope">- </span> </p>
                    <p>保障期限：<span class="dl_rep_time">- </span></p>
                    <p>保险金额：<span class="dl_coverage">- </span></p>
                </div>
            </div>
        </div>
        <div class="s2-cont">
            <h2>保障内容</h2>
            <ul id="responseList">
                <%--<li><p><span>展会场馆方财产损失责任</span><i>150万</i></p></li>--%>
            </ul>
            <p class="more">
               <a id="clauses">《保险条款》</a>
            </p>
        </div>
        <div class="s3-cont bottom_tip_list">
            <ul>
                <li class="s1 bottom_tip_item  bottom_tip_information" title="投保须知" >
                    <img  src="/static/weChat/images/plan-s1.png" />
                    <p>投保须知</p>
                </li>
                <li class="s2  bottom_tip_item bottom_tip_sample" title="典型案例" >
                    <img src="/static/weChat/images/plan-s2.png" />
                    <p>典型案例</p>
                </li>
                <li class="s3 bottom_tip_item bottom_tip_claim_flow" title="理赔流程" >
                    <img src="/static/weChat/images/plan-s3.png" />
                    <p>理赔流程</p>
                </li>
                <li class="s4 bottom_tip_item bottom_tip_insurance_faq" title="常见问题">
                    <img src="/static/weChat/images/plan-s4.png" />
                    <p>常见问题</p>
                </li>
            </ul>
        </div>
    </div>
</div>
<div class="buy-product">
    <p>
        <i>￥</i><span class="fixed_premium">450.00</span>
    </p>
    <a id="insure">立即投保</a>
</div>

<!--弹窗-->
<div class="cont-popover animated">
    <div class="popover-head">
        <p class="tip_title"><%--保障责任标题--%></p>
        <%--<div class="popover-bi">--%>
            <%--<img src="/static/weChat/images/bi-gray.png" >--%>
        <%--</div>--%>
    </div>
    <div class="concent tip_content">
        <div class="popover-list tip_content_title">
            <p>
                <i>保险金额：</i>
                <span class="tip_insurance_amount_max">-</span>
            </p>
            <p>
                <i>免赔额：</i>
                <span>- -</span>
            </p>
            <p>
                <i>赔付比例：</i>
                <span class="tip_compensation_ratio">-</span>
            </p>
        </div>
        <div class="popover-bottom tip_content_body">
            <h2>保险责任说明：</h2>
            <p class="tip_explain_product">
                -
            </p>
        </div>
    </div>
</div>

<!--黑色蒙版-->
<div class="black-mask"></div>

</body>
<script src="/static/weChat/js/jquery-1.8.3.min.js"></script>
<script src="/static/weChat/common/layer_mobile/layer.js"></script>
<link rel="stylesheet" href="/static/weChat/common/layer_mobile/need/right.css">
<script src="/static/weChat/js/weixin_g.js"></script>
<script src="/static/weChat/js/basic.js"></script>
<script>
    $(function () {
        function  ani(){
            $('.cont-popover').show().addClass('bounceInUp').removeClass('fadeOutDownBig');
            $('.black-mask').show();
            $('.black-mask').click(function () {
                $('.cont-popover').addClass('fadeOutDownBig').removeClass('bounceInUp');
                $('.black-mask').hide();
            })
        }
        $('.s2-cont ul li').click(function () {
            ani()
        });
        $('.s3-cont ul li').click(function () {
            ani()
        });
        $('#clauses').click(function () {
            ani()
        });
        //关闭内容
        $('.cont-popover').on('click',".popover-bi",function () {
            $('.cont-popover').addClass('fadeOutDownBig').removeClass('bounceInUp');
            $('.black-mask').hide();
        });
    });

    //返回按钮
    $("#back").click(function(){
//        window.history.back();
        window.location.href='/weixin/product/win/list';
    });

    function chgMoney(money){
        if(money>=10000){
            return (money/10000)+"万";
        }else{
            return money;
        }
    }

    //获得产品ID
    var row = {};
    g_ajax("/weixin/product/detail",{pro_primary_id:'${p.pro_primary_id}'},function(json){ row = json; },false);

//    console.log(row);
    $(".productTitle").html(row.insurance_name); //设置产品标题
    document.title = row.insurance_name;
    $(".productIntro").html(row.intro); //产品简介
    $(".productScope").html(row.scope); //产品适用范围

    //保障责任范围
    var el = document.getElementById("responseList"), li, rl  =  row.responsesList;
    for(var i in rl){
        var insurance_amount_max = "- -";
        if(rl[i].insurance_amount_max!=undefined && rl[i].insurance_amount_max!=null && $.trim(rl[i].insurance_amount_max)!=""){
            insurance_amount_max = chgMoney(rl[i].insurance_amount_max)+"元"
        }

        li = document.createElement('li');
        li.setAttribute("class", "responseListItem");
        li.setAttribute("pro_responsibility_id", i);
        li.innerHTML ='<p><span>'+rl[i].show_name+'</span><i>'+insurance_amount_max+'</i></p>';
        el.appendChild(li, el.childNodes[0]);
    }

    //保障责任点击事件
    $("#responseList").on('click',".responseListItem",function(){
        var i = $(this).attr("pro_responsibility_id");
//        console.log(rl[i]);
        var cumulative_deductibles = "- -";
        if(rl[i].cumulative_deductibles!=undefined && rl[i].cumulative_deductibles!=null && $.trim(rl[i].cumulative_deductibles)!=""){
            cumulative_deductibles = chgMoney(rl[i].cumulative_deductibles)+"元"
        }
        var insurance_amount_max = "- -";
        if(rl[i].insurance_amount_max!=undefined && rl[i].insurance_amount_max!=null && $.trim(rl[i].insurance_amount_max)!=""){
            insurance_amount_max = chgMoney(rl[i].insurance_amount_max)+"元"
        }
        var deductible_days = "- -";
        if(rl[i].deductible_days!=undefined && rl[i].deductible_days!=null && $.trim(rl[i].deductible_days)!=""){
            deductible_days = rl[i].deductible_days+"天"
        }

        var str  =
            ' <div class="popover-head">'
            +'  <p class="tip_title">'+rl[i].show_name+'</p>'
            +'  <div class="popover-bi"> <img src="/static/weChat/images/bi-gray.png" > </div>'
            +'</div>'
            +'<div class="concent tip_content">'
            +'  <div class="popover-list tip_content_title">'
            +'      <p><i>赔偿限额：</i><span class="tip_insurance_amount_max">'+insurance_amount_max+'</span></p>'
            +'      <p><i>免赔额：</i><span>'+cumulative_deductibles+'</span></p>'
            +'      <p><i>免赔天数：</i><span>'+deductible_days+'</span></p>'
            +'      <p><i>赔付比例：</i><span class="tip_compensation_ratio">'+rl[i].compensation_ratio+'%</span></p>'
            +'  </div>'
            +'  <div class="popover-bottom tip_content_body">'
            +'      <h2>保险责任说明：</h2>'
            +'      <p class="tip_explain_product">'+rl[i].explain_product+'</p>'
            +'  </div>'
            +'</div>';
        $(".cont-popover").html(str);
    });

    function getText(title, msg){
        var str  =
            ' <div class="popover-head">'
            +'  <p class="tip_title">'+title+'</p>'
            +'  <div class="popover-bi"> <img src="/static/weChat/images/bi-gray.png" > </div>'
            +'</div>'
            +'<div class="concent tip_content">'
            +'  <div class="popover-bottom tip_content_body">'
            +'      <p class="tip_explain_product">'+msg+'</p>'
            +'  </div>'
            +'</div>';
        return str;
    }

    //投保须知
    $(".bottom_tip_information").click(function(){
        var msg = row.information;
        if(msg==undefined) msg="暂无";
        $(".cont-popover").html(getText("投保须知", msg));
    });
    //典型案例
    $(".bottom_tip_sample").click(function(){
        var msg = row.sample;
        if(msg==undefined) msg="暂无";
        $(".cont-popover").html(getText("典型案例", msg));
    });
    //理赔流程
    $(".bottom_tip_claim_flow").click(function(){
        var msg="";
        msg+="(1)拨打报案电话</br>根据保单信息拨打相应保险公司报案电话或拨打平台报案电话400-662-9696或根据平台要求在线填写信息</br></br>";
        msg+="(2)准备材料</br>根据服务人员告知的资料清单准备理赔资料</br></br>";
        msg+="(3)理赔办理</br>前往保险公司提交理赔资料</br></br>";
        msg+="(4)审核</br>保险公司审核理赔材料</br></br>"
        msg+="(5)结案</br>确属保险责任范围的事故，保险公司将在约定时效内赔付</br></br>";
        $(".cont-popover").html(getText("理赔流程", msg));
    });
    //常见问题
    $(".bottom_tip_insurance_faq").click(function(){
        var msg = row.insurance_faq;
        if(msg==undefined) msg="暂无"
        $(".cont-popover").html(getText("常见问题", msg));
    });
    //保险条款
    $("#clauses").click(function(){
        var cl = row.clausesList;
        var str =
             ' <div class="popover-head">'
            +'  <p class="tip_title">保险条款</p>'
            +'  <div class="popover-bi"> <img src="/static/weChat/images/bi-gray.png" > </div>'
            +'</div>'
            +'<div class="concent tip_content">'
            +'  <div class="popover-list clauses_list">';
        if(cl!=undefined && cl.length!=0 ){
            for(var i in cl){
                if(cl[i].file_name==undefined) cl[i].file_name="暂无文件名";
                str  +='<p class="clauses_item" ><a style="padding: 50px 20px 0px 20px; font-size: 28px;" target="_blank" href="/weixin/product/clause/'+cl[i].pro_clauses_id+'">'+cl[i].file_name+'</a></p>';
            }
        }
            str+= '  </div>'
             +'</div>';
        $(".cont-popover").html(str);
    });

    if(row.picture!=undefined && row.picture!="") $("#productLogo").attr("src",row.picture); //产品logo
    if(row.company_logo!=undefined && row.company_logo!="" ){
        $("#companyLogo").css("background","url("+row.company_logo+") no-repeat center center"); //公司logo
        $("#companyLogo").css("background-size","100% auto"); //公司logo
    }
    $(".fixed_premium").html(row.fixed_premium+(row.product_code.indexOf("ZZX-ZA")!=-1?"":"起")); //产品最低价格
    $(".dl_rep_time").html(row.dl_rep_time); //保障期限
    $(".dl_coverage").html(row.dl_coverage); //保险金额

    //投保按钮，不同的产品去不同的投保界面
    $("#insure").click(function () {
        if(row.product_code.indexOf("ZZX-ZA")!=-1 || row.product_code.indexOf("ZZX-PAC")!=-1 || row.product_code.indexOf("ZZX-YA")!=-1){ //包含
            location.href="/weixin/order/zzx/zzx_write_order1?pro_primary_id="+row.pro_primary_id;
        }
    })

</script>
</html>