<%@ page language="java" contentType="text/html; charset=UTF-8"
    pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>重置密码-2</title>
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/public.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/basic.css' />" />

</head>
<body id="login-regis">
<div class="head-more">
    <div class="more-content clearfix">
        <div class="logo fl">
            <a href="<c:url value='/'/>">
                <img src="<c:url value='/resources/version_new/images/bai-logo.png' />" alt="百联保logo">
                <span>重置密码</span>
            </a>
        </div>
    </div>
</div>
<div class="s-login">
    <form action="<c:url value='/user/pwd/rest/setUserPwd' />"  id="resetForm" method="post">
        <div class="login-content">
            <h2>重置密码</h2>
            <div class="login-step">
                <ul class="clearfix">
                    <li class="on">
                        <span>确认账户</span>
                        <div class="step-number">
                            <label>1</label>
                        </div>
                        <div class="line"></div>
                    </li>
                    <li class="on">
                        <span>验证身份</span>
                        <div class="step-number">
                            <label>2</label>
                        </div>
                        <div class="line"></div>
                    </li>
                    <li>
                        <span>重置密码</span>
                        <div class="step-number">
                            <label>3</label>
                        </div>
                        <div class="line"></div>
                    </li>
                    <li>
                        <span>重置成功</span>
                        <div class="step-number">
                            <label>4</label>
                        </div>
                        <div  class="line"></div>
                    </li>
                </ul>
            </div>
            <div class="select-content">
                <div class="content-describe describe-top">
                    <div class="dec-inp">
                        <input type="text" name="email" value="${resetPwdEmail}" id="email" readonly="readonly" class="s1" >
                        <p class="error password-error"></p>
                    </div>
                </div>
            </div>

            <c:if test="${not empty resetType && resetType eq '1'}">
                <div class="dec-pic clearfix">
                    <p class="fl"><input type="text" style="width: 200px" placeholder="请输入右侧验证码" value="" class="s3" id="right-code"></p>
                    <div class="fr" id="v_container"><img style="width: 140px;height: 46px" id="imageF" src="" onclick="changeImg()"/></div>
                    <p class="error error-code"></p>
                </div>
                <div class="dec-pic clearfix">
                    <p class="fl">
                        <input type="hidden" id="check_code">
                        <input type="text" placeholder="请输入手机验证码" class="s8" id="code">
                    </p>
                    <a href="javascript:;" class="fr phone-code" style="background:rgba(236,236,236,1);color:rgb(153,153,153);cursor:default;pointer-events:none">获取手机验证码</a>
                    <p class="error phone-code-error"></p>
                </div>
            </c:if>
            <c:if test="${not empty resetType && resetType eq '2'}">
                <div class="dec-pic clearfix">
                    <p class="fl"><input type="text" placeholder="请输入右侧验证码" class="s3" id="left-code"></p>
                    <div class="fr" id="e_v_container"></div>
                    <p class="error error-code"></p>
                </div>
                <div class="dec-pic clearfix">
                    <p class="fl">
                        <input type="text" placeholder="请输入邮箱验证码" class="s8" id="email-code">
                    </p>
                    <a href="javascript:;" class="fr email-code">获取邮箱验证码</a>
                    <p class="error email-code-error"></p>
                </div>
            </c:if>

            <div class="login-foot">
                <div class="login">
                    <a href="javascript:;" onclick="next()" class="ert">下一步</a>
                </div>
                <div class="sign-up">
                    <p>已经有账号？<a href="<c:url value='/user/login' />">立即登录>></a></p>
                </div>
            </div>
        </div>
    </form>
</div>
<script src="<c:url value='/resources/version_new/js/jquery-1.8.3.min.js' />"></script>
<script src="<c:url value='/resources/version_new/js/gVerify.js' />"></script>
<script src="<c:url value='/resources/version_new/js/login.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script type='text/javascript' src='https://webchat.7moor.com/javascripts/7moorInit.js?accessId=d7359b20-9dec-11ec-a564-cd73c4e7850a&autoShow=true&language=ZHCN' async='async'>
</script>
<script>
    var baseUrl = '${pageContext.request.contextPath }';
    var verifyCode;
    if($('#e_v_container').prev().length>0){
        verifyCode = new GVerify("e_v_container");
    }
    $('.email-code').click(function () {
        sendTrueEmail();
        sendemail();
    });
    changeImg();
    function changeImg() {
        console.log('/user/image.htm'+ '?'+ Math.floor(Math.random() * 100));
        $('#imageF').hide().attr('src','/user/image.htm'+ '?'+ Math.floor(Math.random() * 100)).fadeIn();
    }
    function checkTelCodes() {
        var right_code = $('#right-code').val();
        if (right_code == "") {
            $('.error-code').html("验证码不能为空").addClass('wed');
            $('#right-code').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
        } else {
            $('#check_code').val('');
            $.ajax({
                type: 'POST',
                url: baseUrl + "/synopsis/checkYzm.json",
                data:{'captcha': right_code},
                dataType:"json",
                success: function(json){
                    if(json.statusCode == "200") {
                        $("#right-code").attr("disabled","disabled").css("cursor", "not-allowed");
                        $("#imageF").attr("onclick", "");
                        $('#check_code').val(right_code);
                        $("#right-code").attr('TY-VAL','');
                        changeBtn(1);
                        $('.error-code').html("").removeClass('wed');
                        $('#right-code').css({"border":"1px solid #e6e6e6","box-shadow":"none"});
                    }else{
                        $('.error-code').html("验证码错误").addClass('wed');
                        $('#right-code').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
                        changeImg();
                    }
                }
            });
        }
    }

    $('#right-code').blur(function () {
        checkTelCodes();
    })

    var countdown=60;
    function sendemail() {
        if (countdown == 0) {
            $('.email-code').text("获取邮箱验证码").css({"background":"rgba(69,190,86,1)","color":"#ffffff","cursor":"pointer","pointer-events":"auto"});
            countdown = 60;
            return;
        } else {
            $('.email-code').text("再次发送(" + countdown + ")").css({"background":"rgba(236,236,236,1)","color":"rgb(153,153,153)","cursor":"default","pointer-events":"none"});
            countdown--;
        }
        setTimeout(function() {
                    sendemail()
                }
                ,1000)
    };

    $('.phone-code').click(function () {
        if($("#right-code").attr('TY-VAL') == '1'){
            changeImg();
            $("#right-code").removeAttr("disabled").css("cursor", "text");
            $("#imageF").attr("onclick", "changeImg()");
            layer.msg("图形验证码已刷新，请重新填写！");
            changeBtn(2);
            return;
        }
        sendTruePhone();
//        sendphone();
    });
    var count=60;
    function sendphone() {


        if (count == 0) {
            $('.phone-code').text("获取短信验证码").css({"background":"rgba(69,190,86,1)","color":"#ffffff","cursor":"pointer","pointer-events":"auto"});
            count = 60;
            return;
        } else {
            $('.phone-code').text("再次发送(" + count + ")").css({"background":"rgba(236,236,236,1)","color":"rgb(153,153,153)","cursor":"default","pointer-events":"none"});
            count--;
        }
        setTimeout(function() {
                    sendphone()
                }
                ,1000)
    };

    function   sendTrueEmail(){
        var index = layer.load(0, {shade: [0.3,'#808080']});
        var  email='${resetPwdEmail}';
        $.ajax({
            type : 'POST',
            url : baseUrl + "/user/sendEmailCode",
            async: false,
            data : {
                'email' : email
            },
            dataType : "json",
            cache : false,
            success : function(json) {
                layer.close(index);
                if (json.statusCode == '200') {
                    layer.msg("验证码获取成功,请查收邮件并进行验证！！");
                    layer.close(index);
                }
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                layer.msg("验证码获取失败！！");

            }
        });
    }
    function sendTruePhone(){
        var  email='${resetPwdEmail}';
        var check_code =$("#check_code").val();
        if(check_code == ''){
            layer.msg("请先输入正确的图形验证码！！");
            return;
        }
        sendphone();
        var index = layer.load(0, {shade: [0.3,'#808080']});
        $("#right-code").attr('TY-VAL','1');
        $.ajax({
            type : 'POST',
            url : baseUrl + "/user/register/sendAuthCode",
            async: false,
            data : {
                'tel' : email,
                'check_code' : check_code
            },
            dataType : "json",
            cache : false,
            success : function(json) {
                layer.close(index);
                if (json.statusCode == '200') {
                    layer.msg("验证码获取成功,请查收手机并进行验证！！");
                }else{
                    layer.msg(json.message);
                }
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                layer.msg("验证码获取失败！！");
            }
        });
    }
    function changeBtn(sign) {
        if(sign == 1){
            $('.phone-code').text("获取短信验证码").css({"background":"rgba(69,190,86,1)","color":"#ffffff","cursor":"pointer","pointer-events":"auto"});
        }else{
            $('.phone-code').text("获取短信验证码").css({"background":"rgba(236,236,236,1)","color":"rgb(153,153,153)","cursor":"default","pointer-events":"none"});
        }
    };


    $('.login-select ul li').click(function () {
        var s_index = $(this).index();
        $('.login-select ul li').removeClass('active');
        $(this).addClass('active');
        $('.select-content .content-describe').hide();
        $('.select-content .content-describe').eq(s_index).show();
    });
    $('.s-login .login-content input').focus(function(){
        $(this).css({"border-color":"#ff6600","box-shadow":" 0 0 5px #fdb381"});
    }).blur(function () {
        $(this).css({"border-color":"#e6e6e6","box-shadow":" none"});
    });
    $('.tooltip-more').mouseenter(function () {
        // $('.tooltip').show();\
        $(this).children('.tooltip').show();
    }).mouseleave(function () {
        $(this).children('.tooltip').hide();
    })



    function checkCode() {
        if ($('#code').val() == "") {
            $('.code-error').html("验证码不能为空").addClass('wed');
            $('#code').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
            return code_ok = false;
        } else {
            $('.code-error').html("").removeClass('wed');
            $('#code').css({"border":"1px solid #e6e6e6","box-shadow":"none"});
            return code_ok = true;
        };
    }

    function checkCodes() {
        if ( $('#email-code').val() == "") {
            $('.email-code-error').html("验证码不能为空").addClass('wed');
            $('#email-code').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
            return email_code_ok = false;
        } else {
            $('.email-code-error').html("").removeClass('wed');
            $('#email-code').css({"border":"1px solid #e6e6e6","box-shadow":"none"});
            email_code_ok = true;
        }
    }

    // 短信验证码
    $('#code').blur(function () {
        checkCode();
    });
    // 邮箱验证码
    $('#email-code').blur(function () {
        checkCodes();
    });


    function next(){
        var type="${resetType}";

        if(type!=""&&type=="1"){

            var  phoneCode=$("#code").val();
            if(phoneCode==""){
                layer.msg("请输入正确的短信验证码验证码！");
                return "";
            }
            $.ajax({
                type: 'POST',
                url: baseUrl + "/user/register/checkCode",
                data:{'sign': $('#phone').val(),'captcha': $('#code').val()},
                dataType:"json",
                async: false,
                success: function(json){
                    if(json.statusCode == "200") {
                        $('.code-error').html("").removeClass('wed');
                        $('#code').css({"border":"1px solid #e6e6e6","box-shadow":"none"});
                        $("#resetForm").submit();
                    }else{
                        layer.msg("请输入正确的短信验证码验证码！");
                    }
                }
            });

        }

        if(type!=""&&type=="2"){
            var code=$("#left-code").val();
            if(!verifyCode.validate(code)){
                layer.msg("请输入正确的验证码！");
                return ;
            }
            var  emailCode=$("#email-code").val();
            if(emailCode==""){
                layer.msg("请输入正确的短信验证码验证码！");
                return "";
            }
            $.ajax({
                type: 'POST',
                url: baseUrl + "/user/register/checkCode",
                data:{'sign': $('#email').val(),'captcha': $('#email-code').val()},
                dataType:"json",
                async: false,
                success: function(json){
                    if(json.statusCode == "200") {
                        $('.code-error').html("").removeClass('wed');
                        $('#code').css({"border":"1px solid #e6e6e6","box-shadow":"none"});
                        $("#resetForm").submit();
                    }else{
                        layer.msg("请输入正确的短信验证码验证码！");
                    }
                }
            });
        }

    }







</script>
</body>
</html>