<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
<meta name="keywords" content="百联保">
<meta name="description" content="">
<title>百联保—我的账户</title>
<link href="<c:url value='/resources/css/public.css' />" rel="stylesheet" type="text/css" />
<link href="<c:url value='/resources/css/personal_center.css' />" rel="stylesheet" type="text/css" />

</head>
<body>
<jsp:include page="../header.jsp"/>
<!-- 个人中心  我的账户 内容部分 开始 -->
<div class="per_centerwar"><!-- per_centerwar start -->
<div class="per_centersub"><!-- per_centersub star -->
	<div class="per_cenleftwar">
    	<div class="my_acount">
        	<p><img src="<c:url value='/resources/images/my_acount.jpg' />" width="32" height="32" title="我的账户"></p>
        	<p><a href="<c:url value='/user/index?ACCESS_TOKEN=${ACCESS_TOKEN}' />">我的账户</a></p>
        </div>
        <div class="clear"></div>
        <div class="acount_list">
        	<ul>
                <li>
                    <a href="<c:url value='/policy/index?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
                        <label><img src="<c:url value='/resources/images/my_order.png' />" width="17" height="19"></label>
                        <span>我的订单</span>
                    </a>
                </li>
                <div class="clear"></div>
                <li>
                    <a href="<c:url value='/report/index?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
                        <label><img src="<c:url value='/resources/images/refer.png' />" width="22" height="21"></label>
                        <span>理赔查询</span>
                    </a>
                </li>
                <div class="clear"></div>
                <li>
                    <a href="<c:url value='/user/personal/init?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
                        <label><img src="<c:url value='/resources/images/com_data.png' />" width="21" height="15"></label>
                        <span>企业资料</span>
                    </a>
                </li>
                <div class="clear"></div>
                <li>
                    <a href="<c:url value='/appMsg/index?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
                        <label><img src="<c:url value='/resources/images/insure_mes.png' />" width="19" height="20"></label>
                        <span>投保人资料</span>
                    </a>
                </li>
            </ul>
        </div>
    </div>
    <div class="per_cenrightwar"><!-- per_cenrightwar start -->
    	<div class="welcome_war"><!-- welcome_war start -->
        	<div class="welcome_sub1">
            	<div class="wel_smile1">
                	<p><img src="<c:url value='/resources/images/smile.jpg' />" width="34" height="34" title="欢迎您~"></p>
                    <p>欢迎您~<br>${user.userName }</p>
                </div>
                <div class="wel_smile2"><p><label>资料<c:if test="${ user.sign == 0 }">未完善</c:if><c:if test="${ user.sign == 1 }">已完善</c:if></label>
                					<c:if test="${ user.sign == 0 }"><a href="<c:url value='/user/personal/init?ACCESS_TOKEN=${ACCESS_TOKEN}' />">我要更新</a></c:if><c:if test="${ user.sign == 1 }"><a href="<c:url value='/user/personal/init?ACCESS_TOKEN=${ACCESS_TOKEN}' />">我要修改</a></c:if>
                					<a href="<c:url value='/user/changeBinding/pwd?ACCESS_TOKEN=${ACCESS_TOKEN}' />">密码修改</a>
                            		<a href="<c:url value='/user/changeBinding/email?ACCESS_TOKEN=${ACCESS_TOKEN}' />">邮箱变更</a>
                            		<a href="<c:url value='/user/changeBinding/tel?ACCESS_TOKEN=${ACCESS_TOKEN}' />">手机变更</a>
                            		</p></div>
            </div>
            <div class="clear"></div>
            <div class="welcome_sub2">
            	<p>
                	<span>保障中：<a href="<c:url value='/policy/index/IN_FORCE?ACCESS_TOKEN=${ACCESS_TOKEN}' />">${forcetotal }份</a></span>
                    <span>已过期：<a href="<c:url value='/policy/index/LAPSED?ACCESS_TOKEN=${ACCESS_TOKEN}' />">${lapsedtotal }份</a></span>
                </p>
            </div>
        </div><!-- welcome_war end -->
        <div class="bg_f3f4f5"></div><!-- bg_f3f4f5 -->
        <div class="insur_ance"><!-- insur_ance start -->
        	<p>进行中保单：投保中<a href="<c:url value='/policy/index/APPLIED?ACCESS_TOKEN=${ACCESS_TOKEN}' />">（${appliedtotal }）</a>　|　待支付<a href="<c:url value='/policy/index/PENDING?ACCESS_TOKEN=${ACCESS_TOKEN}' />">（${pendtotal }）</a></p>
			
			<c:forEach items="${appliedList }" var="list">
	            <div class="insur_list"><!-- insur_list start -->
	            	<div>
	                <c:if test="${list.agreementSpec.productType eq 'CONBID' && list.agreementSpec.productClass eq 'JGL' }">
			    		<img src="<c:url value='/resources/images/inqu_img1.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
			    	</c:if>
			    	<c:if test="${list.agreementSpec.productType eq 'CONBID' && list.agreementSpec.productClass eq 'ZCL' }">
			    		<img src="<c:url value='/resources/images/inqu_img6.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
			    	</c:if>
			    	<c:if test="${list.agreementSpec.productType eq 'PACT' }">
			    		<img src="<c:url value='/resources/images/pay_img.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
			    	</c:if>
			    	<c:if test="${list.agreementSpec.productType eq 'CONQUALITY' }">
			    		<img src="<c:url value='/resources/images/product_img1.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
			    	</c:if>
			    	<c:if test="${list.agreementSpec.productType eq 'PERFORMANCE' }">
			    		<img src="<c:url value='/resources/images/product_img2.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
			    	</c:if>
			    	<c:if test="${list.agreementSpec.productType eq 'WAGEPAY' }">
			    		<img src="<c:url value='/resources/images/product_img3.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
			    	</c:if>
	                </div>
	                <div class="inli_text">
	                	<a href="<c:url value='' />">
	                    	<h4>${list.agreementSpec.name  }<c:if test="${list.agreementSpec.productClass != 'RESTS' }">(${list.agreementSpec.productClass.name })</c:if></h4>
	                        <p>订单号：${list.policyTransaction.tradeSerialNumber }</p>
	                        <p>保费：${list.grossPremium }元</p>
	                        <p>订单日期：<fmt:formatDate pattern="yyyy-MM-dd" value="${list.policyTransaction.startTime}"/></p>
	                    </a>
	                </div>
	                <div class="skip">
	                	<p></p>
	                	<a href="<c:url value='/product/sale/continueFill/${list.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="aborder">继续投保</a>
	                </div>
	            </div><!-- insur_list end -->
            </c:forEach>
            
			<c:forEach items="${pendingList }" var="list">
	            <div class="insur_list"><!-- insur_list start -->
	            	<div>
	                <c:if test="${list.agreementSpec.productType eq 'CONBID' && list.agreementSpec.productClass eq 'JGL' }">
			    		<img src="<c:url value='/resources/images/inqu_img1.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
			    	</c:if>
			    	<c:if test="${list.agreementSpec.productType eq 'CONBID' && list.agreementSpec.productClass eq 'ZCL' }">
			    		<img src="<c:url value='/resources/images/inqu_img6.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
			    	</c:if>
			    	<c:if test="${list.agreementSpec.productType eq 'PACT' }">
			    		<img src="<c:url value='/resources/images/pay_img.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
			    	</c:if>
			    	<c:if test="${list.agreementSpec.productType eq 'CONQUALITY' }">
			    		<img src="<c:url value='/resources/images/product_img1.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
			    	</c:if>
			    	<c:if test="${list.agreementSpec.productType eq 'PERFORMANCE' }">
			    		<img src="<c:url value='/resources/images/product_img2.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
			    	</c:if>
			    	<c:if test="${list.agreementSpec.productType eq 'WAGEPAY' }">
			    		<img src="<c:url value='/resources/images/product_img3.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
			    	</c:if>
	                </div>
	                <div class="inli_text">
	                	<a href="<c:url value='' />">
	                    	<h4>${list.agreementSpec.name  }<c:if test="${list.agreementSpec.productClass != 'RESTS' }">(${list.agreementSpec.productClass.name })</c:if></h4>
	                        <p>订单号：${list.policyTransaction.tradeSerialNumber }</p>
	                        <c:if test="${list.agreementSpec.productType eq 'CONBID' }"><p>保费：${list.grossPremium }元</p></c:if>
	                        <p>订单日期：<fmt:formatDate pattern="yyyy-MM-dd" value="${list.policyTransaction.startTime}"/></p>
	                    </a>
	                </div>
	                <div class="skip">
	                	<p></p>
	                	<c:choose>
				        	<c:when test="${list.agreementSpec.productType eq 'CONBID' }">
				        		<c:if test="${not empty list.policySerialNumber && empty list.external_reference }">
				        		<a href="${list.policyTransaction.showUrl }" target="_blank" class="aborder mar_left35">立即支付</a>
				        		</c:if>
				        		<c:if test="${empty list.policySerialNumber }">
						        <a href="<c:url value='/product/sale/policyPay/${list.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="aborder mar_left35">立即支付</a>
				        		</c:if>
						        <%-- <a href="<c:url value='/product/sale/policyPay/${list.policySerialNumber }' />" class="aborder">立即支付</a> --%>
				        	</c:when>
				        	<c:otherwise>
				        		<a href="<c:url value='/?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="aborder">继续购买</a>
				        	</c:otherwise>
				        </c:choose>
	                </div>
	            </div><!-- insur_list end -->
            </c:forEach>
        </div><!-- insur_ance end -->
        <div class="bg_f3f4f5"></div><!-- bg_f3f4f5 -->
        <div class="pro_ductimg"><!-- pro_ductimg start -->
        	<p>您可能需要的保险产品>></p>
            <ul>
            <c:forEach items="${productTypeList }" var="productType">
            	<li>
            		<c:if test="${productType.ename eq 'conquality' }">
			    		<a href="<c:url value='/product/productInfo/${productType.ename }?ACCESS_TOKEN=${ACCESS_TOKEN}' />"><img src="<c:url value='/resources/images/product_img3.jpg' />" width="199" height="103" title="${productType.name  }"></a>
			    	</c:if>
			    	<c:if test="${productType.ename eq 'performance' }">
			    		<a href="<c:url value='/product/productInfo/${productType.ename }?ACCESS_TOKEN=${ACCESS_TOKEN}' />"><img src="<c:url value='/resources/images/product_img2.jpg' />" width="199" height="103" title="${productType.name  }"></a>
			    	</c:if>
			    	<c:if test="${productType.ename eq 'pact' }">
			    		<a href="<c:url value='/product/productInfo/${productType.ename }?ACCESS_TOKEN=${ACCESS_TOKEN}' />"><img src="<c:url value='/resources/images/product_img1.jpg' />" width="199" height="103" title="${productType.name  }"></a>
			    	</c:if>
                </li>
            </c:forEach>
            </ul>
        </div><!-- pro_ductimg end -->
    </div><!-- per_cenrightwar end -->
</div><!-- per_centersub end -->
    <div class="clear"></div>
</div><!-- per_centerwar end -->
<!-- 个人中心  我的账户 内容部分 结束 -->

<!-- 内容部分  注册  结束 -->
<jsp:include page="../index/multi_f.jsp" />
<script src="<c:url value='/resources/script/jquery-1.8.3.min.js' />" type="text/javascript"></script>
<script src="<c:url value='/resources/js/insurance.js' />" type="text/javascript"></script>

<script type="text/javascript">
var baseUrl = '${pageContext.request.contextPath }';

</script>
</html>