<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>


<input type="hidden" name="oid" id="oid" value="${user.oid }"/>
<input type="hidden" name="mains" id="mains" value="email"/>
<p>
	<label>邮箱地址</label>
	<input type="text" value="${fn:substring(fn:split(user.email, '@')[0], 0, 3) }...@${fn:split(user.email, '@')[1] }" class="form-control" readonly="readonly" />
</p>
<div  class="mt-20">
	<label>验证码</label>
	<div class="row">
		<div class="col-sm-9 col-xs-9"><input type="text" class="form-control" placeholder="请输入验证码" onblur="checkYzm(this)" id="ryzm_reset" name='j_captcha'/></div>
		<div class="col-sm-3 col-xs-3 pl-0 br-img ryzm_width"><img id="imageF_3" src="<c:url value='/user/image.htm'/>" onclick="changeImg_init(this)"/></div>
	</div>
</div>
<div  class="mt-20">
	<label>邮件验证码</label>
	<div class="row">
		<div class="col-sm-7 col-xs-7">
			<input type="text" class="form-control" id="v-code-captcha" placeholder="请输入验证码" />
			<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
		</div>
		<div class="col-sm-5 col-xs-5 pl-0"> 
			<input type="button" class="v-code" id="v-code" send-tp="0" value="获取验证码"/>
		</div>
	</div>
</div>
<p><a href="javascript:void(0);" onclick="resetFrom('resetPwdFrom','3');" class="nstep-btn">下一步</a></p>



<!-- script -->
<script src="<c:url value='/resources/script/jquery-1.8.3.min.js' />" type="text/javascript"></script>
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';
    var wait=60;
	function time(o) {
	        if (wait == 0) {
	        	$("#v-code").val("重新获取"); 
	        	$("#v-code").attr("send-tp","0");
	        	$("#v-code").css("background-color","#ff6d37");
	            wait = 60;
				/*$("#btn").css("background-color","#229fff");*/
	        } else { // www.jbxue.com
	            $("#v-code").val("重新发送(" + wait + ")");
	            wait--;
				$("#v-code").css("background-color","#bbb6b6");
	            setTimeout(function() {
	                time(o)
	            },
	            1000)
	        }
	    }
	document.getElementById("v-code").onclick=function(){
		if($(this).attr("send-tp") == "0"){
			var oid = $("#oid").val();
			var mains = $("#mains").val();
			$.ajax({
	   			type: 'POST',
	   			url: baseUrl + "/user/sendCaptcha",
	   			data:{
	   				'oid': oid,
	   				'mains': mains
	   			},
	   			dataType:"json",
	   			cache: false,
	   			success: function(json){
	   					$("#v-code").attr("send-tp","1");
	   					time(this);
	   			}
	   		}); 
		}
			
	}
	
</script>