<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
<meta name="keywords" content="百联保">
<meta name="description" content="百联保是百川信（厦门）网络技术有限公司基于金融创新并响应互联网＋计划搭建的第三方金融服务平台。秉承开拓金融创新，减轻企业负担的服务理念，百联保利用互联网平台优势并结合保险的市场作用，将与保证金、银行保函、担保公司保函具备同等效力的保证保险保函纳入经贸合作的担保形式之一，旨在减轻企业资金负担，简化申办流程，缩短办理周期，为企业客户提供低成本、高效率、安全专业的新型互联网金融服务。">

<title>百联保—密码修改</title>
<link href="<c:url value='/resources/css/public.css' />" rel="stylesheet" type="text/css" />
<link href="<c:url value='/resources/css/personal_center.css' />" rel="stylesheet" type="text/css" />

</head>
<body>
<jsp:include page="../header.jsp"/>
<!-- 个人中心  企业资料 内容部分 开始 -->
<div class="per_centerwar"><!-- per_centerwar start -->
	<div class="per_centersub"><!-- per_centersub star -->
    	<div class="per_cenleftwar"><!-- per_cenleftwar star -->
        	<div class="my_acount">
            	<p><img src="<c:url value='/resources/images/my_acount.jpg' />" width="32" height="32" title="我的账户"></p>
            	<p><a href="<c:url value='/user/index?ACCESS_TOKEN=${ACCESS_TOKEN}' />">我的账户</a></p>
            </div>
            <div class="clear"></div>
            <div class="acount_list">
            	<ul>
                    <li>
                        <a href="<c:url value='/policy/index?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
                            <label><img src="<c:url value='/resources/images/my_order.png' />" width="17" height="19"></label>
                            <span>我的订单</span>
                        </a>
                    </li>
                    <div class="clear"></div>
                    <li>
                        <a href="<c:url value='/report/index?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
                            <label><img src="<c:url value='/resources/images/refer.png' />" width="22" height="21"></label>
                            <span>理赔查询</span>
                        </a>
                    </li>
                    <div class="clear"></div>
                    <li>
                        <a href="<c:url value='/user/personal/init?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
                            <label><img src="<c:url value='/resources/images/com_data.png' />" width="21" height="15"></label>
                            <span>企业资料</span>
                        </a>
                    </li>
                    <div class="clear"></div>
                    <li>
                        <a href="<c:url value='/appMsg/index?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
                            <label><img src="<c:url value='/resources/images/insure_mes.png' />" width="19" height="20"></label>
                            <span>投保人资料</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div><!-- per_cenleftwar end -->
        <div class="per_cenrightwar"><!-- per_cenrightwar start -->
           	<!-- 密码修改 开始  -->
           	 <div class="company_title"><p>密码修改</p></div>
           	<form action="<c:url value='/user/changePasswords?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" id="changePasswordForm" name="forgotpwdForm" method="post">
           	<div class="center_pasrev">
       			<p>
       				<span class="first_s">请输入旧的密码</span>
       				<span><input type="password" placeholder="6位以上的字母,数字,下划线" id="oldPwd" name="oldPwd"></span>
       				<span class="error_block"><img src="<c:url value='/resources/images/reg_error.png' />">不能为空</span>
       			</p>
       			<div class="clear"></div>
       			<p>
       				<span class="first_s">请输入新的密码</span>
       				<span><input type="password" placeholder="6位以上的字母,数字,下划线" id="newPwd" name="newPwd" onchange="pwdverify(this,'newPwd_1','0');"></span>
       				<span class="error_block"><img src="<c:url value='/resources/images/reg_error.png' />">不能为空</span>
       			</p>
       			<div class="clear"></div>
       			<p>
       				<span class="first_s">请再次输入新的密码</span>
       				<span><input type="password" placeholder="与新密码保持一致" id="newPwd_1" name="newPwd_1" onchange="pwdverify(this,'newPwd','1');"></span>
       				<span class="error_block"><img src="<c:url value='/resources/images/reg_error.png' />">不能为空</span>
       			</p>
       			<div class="clear"></div>
       			<p class="c_verifi">
       				<span class="first_s">验证码</span>
       				<span><input type="text" id="ryzm" name='j_captcha' onblur="checkYzm(this)" placeholder="输入验证码"></span>
                    <label class="auth_code"><img id="imageF" src="<c:url value='/user/image.htm'/>" onclick="changeImg()" width="100%" /></label>
                    <span class="error_block"><img src="<c:url value='/resources/images/reg_error.png'/>">不能为空</span>
       			</p>
       			<div class="clear"></div>
       			<p class="sub_mit"><a href="javascript:void(0);" onclick="changePasswordSubmit()">确定</a></p>
           	</div>
           	<!-- 密码修改 结束  -->
           	</form>
           	<!-- 密码修改成功 开始  -->
           	<div class="center_passuc">
           		<p><img src="<c:url value='/resources/images/finish_img.jpg' />"></p>
           		<p>密码修改成功</p>
           	</div>
           	<!-- 密码修改成功 结束  -->
           	
         </div><!-- per_cenrightwar end -->
    </div><!-- per_centersub end -->
    <div class="clear"></div>
</div><!-- per_centerwar end -->
<!-- 个人中心  企业资料 内容部分 结束 -->
<!-- 内容部分  注册  结束 -->
<jsp:include page="../index/multi_f.jsp" />
<script src="<c:url value='/resources/script/jquery-1.8.3.min.js' />" type="text/javascript"></script>
<script src="<c:url value='/resources/js/insurance.js' />" type="text/javascript"></script>
<script type="text/javascript">
var baseUrl = '${pageContext.request.contextPath }';
function checkYzm(obj) {
	var flag = checkExistTel("tel");
	if($("#ryzm").val() == ""){
		$("#ryzm").parent().next().html("<lable><img src='<c:url value="/resources/images/reg_error.png"/>'></lable><lable>验证码不能为空</lable>");
		$("#ryzm").parent().next().attr("style","display:block;");
	}else{
		
   		$.ajax({
   			type: 'POST',
   			url: baseUrl + "/user/register/checkYzm.json",
   			data:{'captcha': $('#'+obj.id).val()},
   			dataType:"json",
   			success: function(json){
   				if(json.statusCode == "200") {
   					$("#ryzm").parent().next().next().attr("style","display:none;");
   				}else{
   					$("#ryzm").parent().next().next().html("<lable><img src='<c:url value="/resources/images/reg_error.png"/>'></lable><lable>验证码不正确</lable>");
   		    		$("#ryzm").parent().next().next().attr("style","display:block;");
   				}
   			}
   		}); 
	}
}
function pwdverify(this_,id_,sign_){
	var this_val = this_.value;
	var id_val = $("#"+id_).val();
	if(sign_ == "0"){
		if( this_val.length < 6){
			$("#"+this_.id).parent().next().html("<lable><img src='<c:url value="/resources/images/reg_error.png"/>'></lable><lable>密码长度不符合</lable>");
    		$("#"+this_.id).parent().next().attr("style","display:block;");
    		$("#"+this_.id).val('');
    		return;
    	}else{
    		$("#"+id_).parent().next().attr("style","display:none;");
    	}
	}
	if( this_val == "" || this_val == $("#"+this_.id).attr("defaultValue")){
		
	}else{
		if( id_val == "" || id_val == $("#"+id_).attr("defaultValue")){
			
    	}else{
    		if(this_val != id_val){
        		$("#"+this_.id).parent().next().html("<lable><img src='<c:url value="/resources/images/reg_error.png"/>'></lable><lable>密码不一致</lable>");
        		$("#"+this_.id).parent().next().attr("style","display:block;");
        		$("#"+id_).parent().next().attr("style","display:none;");
        		$("#"+this_.id).focus();
        	}else{
        		$("#"+this_.id).parent().next().attr("style","display:none;");
        		$("#"+id_).parent().next().attr("style","display:none;");
        	}
    	}
	}
	
}

function changePasswordSubmit(){
	var oldPwd = $("#oldPwd").val();
	var newPwd = $("#newPwd").val();
	var newPwd_1 = $("#newPwd_1").val();
	if(oldPwd == ""){
		$("#oldPwd").parent().next().html("<lable><img src='<c:url value="/resources/images/reg_error.png"/>'></lable><lable>原密码不能为空</lable>");
		$("#oldPwd").parent().next().attr("style","display:block;");
		return false;
	}else{
		$("#oldPwd").parent().next().attr("style","display:none;");
	}
	if(oldPwd.length < 6){
		$("#oldPwd").parent().next().html("<lable><img src='<c:url value="/resources/images/reg_error.png"/>'></lable><lable>密码长度不符合</lable>");
		$("#oldPwd").parent().next().attr("style","display:block;");
		return false;
	}else{
		$("#oldPwd").parent().next().attr("style","display:none;");
	}
	if(newPwd == ""){
		$("#newPwd").parent().next().html("<lable><img src='<c:url value="/resources/images/reg_error.png"/>'></lable><lable>新密码不能为空</lable>");
		$("#newPwd").parent().next().attr("style","display:block;");
		return false;
	}else{
		$("#newPwd").parent().next().attr("style","display:none;");
	}
	if(newPwd.length < 6){
		$("#newPwd").parent().next().html("<lable><img src='<c:url value="/resources/images/reg_error.png"/>'></lable><lable>密码长度不符合</lable>");
		$("#newPwd").parent().next().attr("style","display:block;");
		return false;
	}else{
		$("#newPwd").parent().next().attr("style","display:none;");
	}
	
	if(newPwd_1 == ""){
		$("#newPwd_1").parent().next().html("<lable><img src='<c:url value="/resources/images/reg_error.png"/>'></lable><lable>密码不能为空</lable>");
		$("#newPwd_1").parent().next().attr("style","display:block;");
		return false;
	}else{
		$("#newPwd_1").parent().next().attr("style","display:none;");
	}
	if(newPwd_1 != newPwd){
		$("#newPwd_1").parent().next().html("<lable><img src='<c:url value="/resources/images/reg_error.png"/>'></lable><lable>密码不一致</lable>");
		$("#newPwd_1").parent().next().attr("style","display:block;");
		return false;
	}else{
		$("#newPwd_1").parent().next().attr("style","display:none;");
	}
	
	$.ajax({
			type: 'POST',
			url: baseUrl + "/user/register/checkYzm.json",
			data:{'captcha': $('#ryzm').val()},
			dataType:"json",
			success: function(json){
				if(json.statusCode == "200") {
					$("#ryzm").parent().next().next().attr("style","display:none;");
					$.ajax({
						type: 'POST',
						url: baseUrl + "/user/changePasswords.json",
						data:$("#changePasswordForm").serialize(),
						dataType:"json",
						success: function(json){
							if(json.statusCode == "200") {
								$("#changePasswordForm").hide();
								$(".center_passuc").show();
							}else if(json.statusCode == "301") {
								$("#oldPwd").parent().next().next().html("<lable><img src='<c:url value="/resources/images/reg_error.png"/>'></lable><lable>"+json.resultDto.message+"</lable>");
					    		$("#oldPwd").parent().next().next().attr("style","display:block;");
							}else {
								alert(json.resultDto.message);
							}
						}
					});
				}else{
					$("#ryzm").parent().next().next().html("<lable><img src='<c:url value="/resources/images/reg_error.png"/>'></lable><lable>验证码不正确</lable>");
		    		$("#ryzm").parent().next().next().attr("style","display:block;");
				}
			}
		});
	
}
</script>
</html>