<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<div class="query-result w-99-auto" id="searchMsg">
	<table class="table" id="list">
		<thead>
			<tr> 
			  <th>产品</th>
			  <th>保单号</th>
			  <th>订单日期</th>
			  <th>保费</th>
			  <th>状态</th>
			  <th>操作</th> 
			</tr>
		</thead>
		<tbody>
			<c:if test="${ policy == null }">
			<td colspan="6" class="text-center">未检索到相关数据！</td>
			</c:if>
			<c:if test="${ policy != null }">
			<tr> 
			  <td title="${ policy.product_name }"><a target="_blank" href="<c:url value='/insurance/product/productInfo/${policy.product_oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">${ policy.product_name }</a></td>
			  <td title="${ policy.external_reference }">${ policy.external_reference }</td>
			  <td>${policy.start_time}</td>
			  <td>${policy.gross_premium } 元</td>
			  <td>
				  <label class="guarantee-bg" style="margin-top: 15px;">${fns:getDictLabel (policy.policy_status,"order_status","")}</label>
			  </td>
			  <td><a target="_blank" href="<c:url value='/pc/order/exportDetailByOrderID/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">查看保单</a></td>
			</tr>
			</c:if>
		  </tbody>
	</table>
</div>