<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<div class="modal-header bg-1f96ef">
	<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
	<h4 class="modal-title">${nameCode }</h4>
</div>
<form id="aeResellerForm">
	<input name="oid" value="${resellerVo.oid }" type="hidden">
	<input name="parentID" value="${resellerVo.parentID }" type="hidden">
	<div class="modal-body">
	 	<p><!-- -has-success has-feedback -->
	 		<label>登录名</label>
			${empty resellerVo.userName ? loginName : resellerVo.userName }
	 		<input type="hidden" class="form-control" name="userName" id="userName" value="${empty resellerVo.userName ? loginName : resellerVo.userName }"/>
	 	</p>
	 	<p><!-- has-loser has-feedback -->
	 		<label>状态</label>
	 		<select Data-Val="Required" name="resellerStatus" id="resellerStatus" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg'/>) 97% no-repeat  #fafafc;">
				<option value="1"<c:if test="${resellerVo.resellerStatus eq '1' }"> selected="selected"</c:if>>启用</option>
				<option value="2"<c:if test="${resellerVo.resellerStatus eq '2' }"> selected="selected"</c:if>>停用</option>
			</select>
	 	</p>
		<p style="margin-top: 60px;"><!-- has-loser has-feedback -->
			<label>区域</label>
            <div class="clearfix">
            <select Data-Val="Required" name="province" id="province" class="form-control" style="margin-right: 10px;width:100px;background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('city', 'district', '2', this);">
                <option value="">省</option>
                <c:forEach items="${provinceList }" var="list">
                    <option value="${list.oid }" <c:if test="${list.oid eq resellerVo.province }"> selected="selected"</c:if>>${list.province }</option>
                </c:forEach>
            </select>&nbsp;&nbsp;
            <select Data-Val="Required" name="city" id="city" class="form-control" style="margin-right: 10px;width:100px;background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('district', '', '3', this);">
                <option value="">市</option>
                <c:forEach items="${cityList }" var="list">
                    <option value="${list.oid }" <c:if test="${list.oid eq resellerVo.city}"> selected="selected"</c:if>>${list.citytype }</option>
                </c:forEach>
            </select>&nbsp;&nbsp;
            <select Data-Val="Required" name="district" id="district" class="form-control" style="width:100px;background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                <option value="">区/县</option>
                <c:forEach items="${areaList }" var="list">
                    <option value="${list.oid }" <c:if test="${resellerVo.district eq list.oid }"> selected="selected"</c:if>>${list.city }</option>
                </c:forEach>
            </select>
            </div>

		</p>
	 	<p>
	 		<label>名称</label>
	 		<input Data-Val="Required" type="text" class="form-control" placeholder="请输入分销商名称" name="resellerName" id="resellerName" value="${resellerVo.resellerName }" />
	 	</p>
	 	<p>
	 		<label>联系人</label>
	 		<input Data-Val="Required" type="text" class="form-control" placeholder="请输入联系人姓名" name="name" id="name" value="${resellerVo.name }" />
	 	</p>
	 	<p>
	 		<label>电子邮箱</label>
	 		<input Data-Val="Required" type="text" class="form-control" placeholder="请输入邮箱" name="email" id="email" value="${resellerVo.email }" />
	 	</p>
	 	<p>
	 		<label>联系方式</label>
	 		<input Data-Val="Required" type="text" class="form-control" placeholder="请输入联系方式" name="contactsWay" id="contactsWay" value="${resellerVo.contactsWay }" />
	 	</p>
	</div>
	<div class="modal-footer">
		<div class="mofo-sub">
			<button type="button" class="btn pull-left cancel-btn" data-dismiss="modal">取消</button>
			<button type="button" class="btn notarize-btn pull-right" onclick="submitFormChange();">提交</button>
		</div>
	</div> 
</form> 
<script>

</script>