<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
	<table class="table">
		<thead>
			<tr>
				<th>ID</th>
				<th>分销商名称</th>
				<th>联系人</th>
				<th>联系方式</th>
				<th>已分配产品数</th>
				<th>状态</th>
				<th>开通时间</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:choose>
			<c:when test="${empty resellerList }">
				<tr><td colspan="8" style="text-align: center;">无查询结果</td></tr>
			</c:when>
			<c:otherwise>
				<c:forEach items="${resellerList }" var="reseller">
					<tr>
						<td title="双击以上ID可全选哦">${reseller.oid }</td>
						<td title="${reseller.resellerName }">${reseller.resellerName }</td>
						<td>${reseller.name }</td>
						<td>${reseller.contactsWay }</td>
						<td>${reseller.allotNum }</td>
						<td>${reseller.resellerStatus eq '1' ? '启用' : '停用'}</td>
						<td>
								${reseller.create_time }
						</td>
						<td>
							<a href="javascript:void(0);" onclick="addResellerModal('view','${reseller.oid }');">查看</a>
							<a href="javascript:void(0);" onclick="openAssignedInitModel('${reseller.oid }');">分配产品</a>
						</td>
					</tr>
				</c:forEach>
			</c:otherwise>
		</c:choose>
		</tbody>
	</table>
