<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
<h4 class="mt-60">查询结果</h4>
<div class="query-result" id="resellerListResultPage">
	<table class="table">
		<thead>
			<tr>
				<th>ID</th>
				<th>分销商名称</th>
				<th>联系人</th>
				<th>联系方式</th>
				<th>已分配产品数</th>
				<th>状态</th>
				<th>开通时间</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:choose>
			<c:when test="${empty resellerList }">
				<tr><td colspan="8" style="text-align: center;">无查询结果</td></tr>
			</c:when>
			<c:otherwise>
				<c:forEach items="${resellerList }" var="reseller">
					<tr>
						<td title="双击以上ID可全选哦">${reseller.oid }</td>
						<td title="${reseller.resellerName }">${reseller.resellerName }</td>
						<td>${reseller.name }</td>
						<td>${reseller.contactsWay }</td>
						<td>${reseller.allotNum }</td>
						<td>${reseller.resellerStatus eq '1' ? '启用' : '停用'}</td>
						<td>
								${reseller.create_time }
						</td>
						<td>
							<a href="javascript:void(0);" onclick="addResellerModal('view','${reseller.oid }');">查看</a>
							<a href="javascript:void(0);" onclick="openAssignedInitModel('${reseller.oid }');">分配产品</a>
						</td>
					</tr>
				</c:forEach>
			</c:otherwise>
		</c:choose>
		</tbody>
	</table>
</div>
<div class="btn-bottom pull-right"> 
	<p>
		<a href="javascript:void(0);" onclick="addResellerModal('add','');" class="clearing pull-left">新增分销商</a>
		<a href="javascript:void(0);" onclick="openBatchInitModel();" class="clearing pull-left">批量分配产品</a>
	</p>
</div>
<!-- 分页 start -->
<nav class="text-center">
	<div id="r_callBackPager" style="margin: 0 auto;text-align: center;"></div>
</nav>
<!-- 分页 end -->
<script type="text/javascript" src="<c:url value='/resources/js/reseller.js'/>"></script>
<script>


	var totalCount = Number($('#totalCount').val()) || 0;
	var showCount = $('#showCount').val() || 5;
	var limit = Number($('#numPerPage').val()) || 5;
	
	$('#r_callBackPager').extendPagination({
		totalCount: totalCount,
		showCount: showCount,
		limit: limit,
		callback: function (curr, limit, totalCount) {
            getResellerListForPage();
		}
	});

	function getResellerListForPage(){
		var index = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : baseUrl + "/pc/reseller/resellerList",
			data : $("#resellerForm").serialize(),
			dataType : "text",
			success : function(data) {
				layer.close(index);
				$("#resellerListResultPage").html(data);
			},
			error: function(){
				layer.close(index);
			}
		});
	}
	

</script>