<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<table class="table">
	<thead>
	<tr>
		<th class="choice check-box"><input type="checkbox" value="反选" id="acball" onclick="choiseAll_x('acball','aoids');">
			<label for="acball"></label>
		</th>
		<th>订单编号</th>
		<th>产品名称</th>
		<th>犹豫期/结算日期</th>
		<th>状态</th>
		<th>下单时间</th>
		<th>可得佣金</th>
		<th>下级分销佣金</th>
	</tr>
	</thead>
	<tbody>
	<c:choose>
		<c:when test="${empty advanceList }">
			<tr><td colspan="8" style="text-align: center;">无查询结果</td></tr>
		</c:when>
		<c:otherwise>
			<c:forEach items="${advanceList }" var="advance">
				<tr>
					<td class="choice check-box">
						<c:if test="${advance.advanceStatus == '1'}">
							<input type="checkbox" id="checkbox${advance.oid }" dataStatus="${advance.advanceStatus }" value="${advance.oid }" name="aoids" <c:if test="${advance.advanceStatus eq '1'}">onclick="choiseOid_x('acball','aoids');"</c:if>>
							<label for="checkbox${advance.oid }"></label>
						</c:if>
					</td>
					<td title="${advance.tradeSerialNumber }">${advance.tradeSerialNumber }</td>
					<td title="${advance.insuranceName }">${advance.insuranceName }</td>
					<td>${advance.clearingTime }</td>
					<td>${fns:getDictLabel (advance.advanceStatus,"advance_status","")}</td>
					<td>${advance.startTime }</td>
					<td>${advance.brokerage}</td>
					<td>${advance.brokerageChild}</td>
				</tr>
			</c:forEach>
		</c:otherwise>
	</c:choose>
	</tbody>
</table>
