<%@ page language="java" contentType="text/html;charset=UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1"/>
    <meta http-equiv="X-UA-Compatible" content="IE=9"/>
    <meta name="keywords"
          content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
    <meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
    <meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
    <title>理赔申请</title>
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" />
</head>

<body>
<jsp:include page="../../index/multi_h.jsp"/>
<style>
    .rightLabel {
        margin-left: 15px;
        position: relative;
        top: -16px;
    }
    .input-group .btn{
        width:auto;
    }
    .container .contacts {
        height: auto;
    }
    .laydate_body .laydate_box {
        width: auto !important;
    }
    .laydate_body .laydate_bottom{
        width: auto !important;
        height: 30px !important;
    }
    .popo-tbody p{
        margin-bottom: 0;
    }
    .user-detail{
        height: auto !important;
    }
    .user-detail .detail-left{
        width: 100px !important;
    }
</style>
<div class="container">
    <jsp:include page="../../index/multi_pc_l.jsp"/>
    <!--右边编辑开始  -->
    <div style="height: auto;width: 980px;float: left;">
        <div class="nav-list">
            <div class="row w-80-auto">
                <div class="col-sm-3 col-sm-4 active">
                    <p><i class="pull-left" id="i_1">1</i><span class=" pull-left">报案申请</span></p>
                </div>
                <div class="col-sm-3 col-sm-4">
                    <p><i class="pull-left" id="i_2">2</i><span class="pull-left">审核中</span></p>
                </div>
                <div class="col-sm-3 col-sm-3">
                    <p><i class="pull-left" id="i_3">3</i><span class="pull-left">赔款支付</span></p>
                </div>
                <div class="col-sm-3 col-sm-3 pull-right">
                    <p><i class="pull-left" id="i_4">4</i><span class="pull-left">已结案</span></p>
                </div>
            </div>
        </div>
        <div class="user-detail">
            <div class="title">
                <span class="tit-name">
                    基础信息
                </span>
            </div>
            <ul class="detail-list">
                <li>
                    <span class="detail-left">保单号</span>
                    <span class="no-name" id="policy_no"></span>
                </li>
                <li>
                    <span class="detail-left"></span>
                    <span class="no-name"></span>
                </li>
                <li>
                    <span class="detail-left">报案号</span>
                    <span class="no-name" id="report_no"></span>
                </li>
                <li>
                    <span class="detail-left">报案人姓名</span>
                    <span class="no-name" id="reporter_name"></span>
                </li>
                <li>
                    <span class="detail-left">报案时间</span>
                    <span class="no-name" id="report_date"></span>
                </li>
                <li>
                    <span class="detail-left">报案人手机</span>
                    <span class="no-name" id="reporter_tel"></span>
                </li>

            </ul>
        </div>
        <div class="user-detail">
            <div class="title">
                <span class="tit-name">
                    事故情况
                </span>
            </div>
            <ul class="detail-list">
                <li>
                    <span class="detail-left">事故时间</span>
                    <span class="no-name" id="accident_date"></span>
                </li>
                <li>
                    <span class="detail-left"></span>
                    <span class="no-name"></span>
                </li>
                <li style="width: 100%;min-height: 30px;height: auto;">
                    <span class="detail-left">人伤类型</span>
                    <span class="no-name" id="injured_detail_content"></span>
                </li>
                <li style="width: 100%;">
                    <span class="detail-left">事故原因</span>
                    <span class="no-name" id="accident_cause_level"></span>
                </li>
                <li style="width: 100%">
                    <span class="detail-left">事故地点</span>
                    <span class="no-name" id="accident_address"></span>
                </li>
                <li style="width: 100%;height: auto">
                    <span class="detail-left" style="float: left;">事故经过</span>
                    <div class="no-name" id="accident_process" style="float: left;width: 80%;"></div>
                </li>

            </ul>
        </div>
        <div class="user-detail">
            <div class="title">
                <span class="tit-name">
                    领款信息
                </span>
            </div>
            <ul class="detail-list">
                <li>
                    <span class="detail-left">账户类型</span>
                    <span class="no-name" id="bank_account_attribute_name"></span>
                </li>
                <li>
                    <span class="detail-left"></span>
                    <span class="no-name"></span>
                </li>
                <li>
                    <span class="detail-left">开户银行</span>
                    <span class="no-name" id="client_bank_name"></span>
                </li>
                <li>
                    <span class="detail-left">开户地点</span>
                    <span class="no-name" id="bank_address"></span>
                </li>
                <li>
                    <span class="detail-left">银行账户</span>
                    <span class="no-name" id="client_bank_account"></span>
                </li>
                <li>
                    <span class="detail-left">开户名</span>
                    <span class="no-name" id="client_name"></span>
                </li>
                <li>
                    <span class="detail-left">证件类型</span>
                    <span class="no-name" id="client_certificate_type_name"></span>
                </li>
                <li>
                    <span class="detail-left">证件号码</span>
                    <span class="no-name" id="client_certificate_no"></span>
                </li>
            </ul>
            <c:if test="${!fn:contains(product_code, 'GZZRX-PAC') && !fn:contains(product_code, 'GZZRX-CA') }">
                <ul class="form-list">
                    <li>
                        <div class="list-name" style="width: 400px;"></div>
                        <div class="list-input">
                            <button class="btn an_back back" type="button">返回</button>
                        </div>
                    </li>
                </ul>
            </c:if>
        </div>
        <c:if test="${fn:contains(product_code, 'GZZRX-PAC') || fn:contains(product_code, 'GZZRX-CA') }">
        <div class="user-detail">
            <div class="title">
                <span class="tit-name">
                    附件信息
                </span>
            </div>
            <ul class="detail-list" id="uploads">

            </ul>
            <ul class="form-list" id="last-show" style="display: none;">
                <li>
                    <div class="list-name" style="width: 395px;"></div>
                    <div class="list-input">
                        <button class="btn an_back back" type="button">返回</button>
                    </div>
                </li>
            </ul>
        </div>
        <form id="defaultForm">
            <input type="hidden" id="ins_common_report_id" name="ins_common_report_id">
            <input type="hidden" id="register_user_id" name="register_user_id">
        <div class="account-safe" id="upload-model" style="display: none;">
            <div class="title">
                <span class="tit-name">
                理赔资料上传（点击此处查看<a href="javascript:void(0);" class="po-details">理赔所需材料说明及模板下载</a>）
                <div class="btn-group">
                    <button type="button" class="btn btn-success dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="width: auto;height: auto">
                        <span>+</span>
                    </button>
                    <ul class="dropdown-menu">
                        <li><a href="javascript:void(0);" onclick="addUploadInput('001000','索赔申请书（加盖公章）','10')">索赔申请书（加盖公章）</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('007003','赔付协议及权益转让书（加盖公章）','11')">赔付协议及权益转让书（加盖公章）</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('003019','事故经过说明','12')">事故经过说明</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('003007','劳动合同（复印件）','13')">劳动合同（复印件）</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('004005','首诊病历、住院病历、医疗费发票、用药清单、诊断证明等医院病历材料','14')">首诊病历、住院病历、医疗费发票、用药清单、诊断证明等医院病历材料</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('004006','医生提供的病假条','15')">医生提供的病假条</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('004006','单位休假记录，需公司由人事部门盖章','16')">单位提供的休假记录，需公司由人事部门盖章</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('003012','事故认定书','17')">涉及交通及安监等事故：需提供相关部门出据的事故认定书</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('006004','公司营业执照、法人身份证复印件。经办人身份证复印件','18')">公司营业执照、法人身份证复印件。经办人身份证复印件</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('003001','被保险人员工有无工伤保险证明（加盖公章）','19')">被保险人员工有无工伤保险证明（加盖公章）</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('003007','工伤认定书','20')">如员工上有工伤保险，需提供工伤认定书（非必备，有工伤的提供）</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('005000','判决书原件及提交法院材料的复印件','21')">涉及诉讼案件：需提供判决书原件及提交法院材料的复印件</a></li>
                    </ul>
                </div>
            </span>
            </div>
            <ul class="form-list">
                <input type="hidden" id="uploadInputNum">
                <input type="hidden" id="fileNum">
                <li>
                    <div class="list-input" id="some_upload_bl">

                    </div>
                </li>
            </ul>
            <ul class="form-list" style="padding-top: 0;height: 120px;">
                <li>
                    <div class="list-input">
                        <div class="col-sm-12 col-xs-12 reminder" style="margin: 16px;width: 97%;line-height: 20px;">
                            <label style="margin-top: 10px;width: 500px">温馨提示：                                                        </label>
                            <label style="text-indent: 18px;">1.支持材料补充上传，若材料未准备齐全也可先行提交，后续可到【我的理赔】-【理赔记录】补充上传；</label>
                            <label style="text-indent: 18px;">2.点击“+”按钮会出现可选资料类型的下拉列表，点击条目可生成该类型的上传组件，双击组件框可删除该组件；</label>
                            <label style="margin-bottom: 10px;text-indent: 18px;">3.支持8M以内扩展名jpg、gif、png、jpeg、bmp图片格式，为了更快完成申请，请确保材料清晰、完整。</label>
                        </div>
                    </div>
                </li>
            </ul>
            <ul class="form-list">
                <li>
                    <div class="list-name" style="width: 300px;"></div>
                    <div class="list-input">
                        <button class="btn an_save save" type="button">材料补传</button>
                        <button class="btn an_back back" type="button">返回</button>
                    </div>
                </li>
            </ul>
        </div>
        </form>
        </c:if>
    </div>
    <!--右边编辑结束-->

</div>
<!--附件信息弹窗-->
<div class="details-popover animated" style="position: absolute!important;width: 770px;margin-left:-350px;top:550px">
    <div class="popover-cont">
        <div class="popo-head">
            <span>理赔所需材料说明（点击下载模板）</span>
            <a href="javascript:;" id="popo-bi">
                <img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
            </a>
        </div>
        <div id="loadRecordDetail">
            <c:if test="${!fn:contains(product_code, 'GZZRX-CA') }">
                <div class="popo-content" style="height: auto">
                    <ul class="popo-header clearfix">
                        <li style="width: 100%;text-align: inherit;">
                            <span style="padding: 5px">一、单证类资料（填写后盖章拍照上传）</span>
                        </li>
                    </ul>
                    <ul class="popo-tbody">
                        <li style="float: none;padding-left: 35px;height:auto;border-bottom:none">
                            <p style="line-height: 25px;margin-top: 10px;">1、<a href="<c:url value='/resources/files/平安索赔申请书0602.doc' />">索赔申请书</a>（加盖公章）；</p>
                            <p style="line-height: 35px;">2、<a href="<c:url value='/resources/files/赔付意向及权益转让书.doc' />">赔付协议及权益转让书</a>（加盖公章）；</p>
                        </li>
                    </ul>
                    <ul class="popo-header clearfix">
                        <li style="width: 100%;text-align: inherit;">
                            <span style="padding: 5px">二、常规必备材料类（准备完毕后拍照上传）</span>
                        </li>
                    </ul>
                    <ul class="popo-tbody">
                        <li style="float: none;padding-left: 35px;height:auto;border-bottom:none">
                            <p style="line-height: 25px;margin-top: 10px;">1、手写一份<a href="<c:url value='/resources/files/事故经过说明.doc' />">事故经过说明</a>，写明事故发生时间、地点、就医等情况；</p>
                            <p style="line-height: 35px;">2、事故员工身份证复印件；</p>
                            <p style="line-height: 35px;">3、劳动合同（复印件）；</p>
                            <p style="line-height: 35px;">4、医院就诊材料：首诊病历、住院病历（如有住院）、医疗费发票、用药清单、诊断证明等医院病历材料；</p>
                        </li>
                    </ul>
                    <ul class="popo-header clearfix">
                        <li style="width: 100%;text-align: inherit;">
                            <span style="padding: 5px">三、误工费资料（需准备完毕后拍照上传，误工时间不足5天的，无需准备）</span>
                        </li>
                    </ul>
                    <ul class="popo-tbody">
                        <li style="float: none;padding-left: 35px;height:auto;border-bottom:none">
                            <p style="line-height: 25px;margin-top: 10px;">1、医生提供的病假条；</p>
                            <p style="line-height: 35px;">2、单位提供的休假记录，需公司由人事部门盖章；</p>
                        </li>
                    </ul>
                    <ul class="popo-header clearfix">
                        <li style="width: 100%;text-align: inherit;">
                            <span style="padding: 5px">四、其他特定情形案件材料，根据需要提供</span>
                        </li>
                    </ul>
                    <ul class="popo-tbody">
                        <li style="float: none;padding-left: 35px;height:auto;border-bottom:none">
                            <p style="line-height: 25px;margin-top: 10px;">1、如涉及交通及安监等事故：需提供相关部门出据的事故认定书；</p>
                            <p style="line-height: 35px;">2、如赔款超过1万元，需提供：</p>
                            <p style="line-height: 35px;">（1）公司营业执照、法人身份证复印件。经办人身份证复印件；</p>
                            <p style="line-height: 35px;">（2）被保险人员工有无工伤保险证明（加盖公章）；</p>
                            <p style="line-height: 35px;">（3）如员工上有工伤保险，需提供工伤认定书（非必备，有工伤的提供）；</p>
                            <p style="line-height: 35px;">3、涉及诉讼案件：需提供判决书原件及提交法院材料的复印件；</p>
                        </li>
                    </ul>
                </div>
            </c:if>
            <c:if test="${fn:contains(product_code, 'GZZRX-CA') }">
                <div class="popo-content" style="height: auto">
                    <ul class="popo-header clearfix">
                        <li style="width: 100%;text-align: inherit;">
                            <span style="padding: 5px">一、单证类资料（填写后盖章拍照上传）</span>
                        </li>
                    </ul>
                    <ul class="popo-tbody">
                        <li style="float: none;padding-left: 35px;height:auto;border-bottom:none">
                            <p style="line-height: 25px;margin-top: 10px;">1、<a href="<c:url value='/resources/files/CA-责任险索赔申请书.docx' />">索赔申请书</a>（加盖公章）；</p>
                            <p style="line-height: 35px;">2、<a href="<c:url value='/resources/files/CA-赔款确认书及授权委托.docx' />">赔付协议、赔付员工的银行支付凭证或授权支付员工的权益转让书</a>（加盖公章）；</p>
                        </li>
                    </ul>
                    <ul class="popo-header clearfix">
                        <li style="width: 100%;text-align: inherit;">
                            <span style="padding: 5px">二、常规必备材料类（准备完毕后拍照上传）</span>
                        </li>
                    </ul>
                    <ul class="popo-tbody">
                        <li style="float: none;padding-left: 35px;height:auto;border-bottom:none">
                            <p style="line-height: 25px;margin-top: 10px;">1、<a href="<c:url value='/resources/files/事故经过说明.doc' />">事故经过说明</a>，写明事故发生时间、地点、就医等情况伤者签字、单位盖章；</p>
                            <p style="line-height: 35px;">2、事故员工身份证复印件；</p>
                            <p style="line-height: 35px;">3、劳动合同（复印件）、伤前3月工资银行流水；</p>
                            <p style="line-height: 35px;">4、医院就诊材料：首诊病历、住院病历（如有住院）、医疗费发票、用药清单、诊断证明等医院病历材料；</p>
                        </li>
                    </ul>
                    <ul class="popo-header clearfix">
                        <li style="width: 100%;text-align: inherit;">
                            <span style="padding: 5px">三、误工费资料（需准备完毕后拍照上传，误工时间不足5天的，无需准备）</span>
                        </li>
                    </ul>
                    <ul class="popo-tbody">
                        <li style="float: none;padding-left: 35px;height:auto;border-bottom:none">
                            <p style="line-height: 25px;margin-top: 10px;">1、医生提供的病假条需医院盖章；</p>
                            <p style="line-height: 35px;">2、单位提供的休假记录由人事部门盖章；</p>
                        </li>
                    </ul>
                    <ul class="popo-header clearfix">
                        <li style="width: 100%;text-align: inherit;">
                            <span style="padding: 5px">四、其他特定情形案件材料，根据需要提供</span>
                        </li>
                    </ul>
                    <ul class="popo-tbody">
                        <li style="float: none;padding-left: 35px;height:auto;border-bottom:none">
                            <p style="line-height: 25px;margin-top: 10px;">1、如涉及交通及安监等事故需提供相关部门出据的事故认定书；</p>
                            <p style="line-height: 35px;">2、如赔款超过1万元，需提供：</p>
                            <p style="line-height: 35px;">（1）公司营业执照、法人身份证复印件、经办人身份证复印件、被保险人身份信息登记表；</p>
                            <p style="line-height: 35px;">（2）被保险人员工有无工伤保险证明（加盖公章）；</p>
                            <p style="line-height: 35px;">（3）原则上需提供工伤认定书；</p>
                            <p style="line-height: 35px;">3、涉及诉讼案件：需提供判决书原件及提交法院材料的复印件；</p>
                        </li>
                    </ul>
                </div>
            </c:if>
        </div>
    </div>
</div>
<!--黑色蒙版-->
<div class="black-mask"></div>
<!--黑色蒙版2-->
<div class="black-mask-more"></div>
<jsp:include page="../../index/multi_f.jsp"/>
<%--<script src="<c:url value='/resources/version_new/js/jquery-1.8.3.min.js' />"></script>--%>
<script src="<c:url value='/resources/version_new/js/jquery.form.js' />"></script>
<script src="<c:url value='/resources/version_new/js/jquery.formHelper.js' />"></script>
<%--<script src="<c:url value='/resources/version_new/js/laydate/laydate.js' />"></script>--%>
<%--<script src="<c:url value='/resources/version_new/js/layer/layer.js' />"></script>--%>
<script src="<c:url value='/resources/public/g.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>
</body>
<script type="text/javascript">
    var allright = true;

    function isWrong(el, obj, msg) {
        if (el) {
            $(obj).nextAll("span").remove();
            if (msg != "") $(obj).after("<span class='list-msg'>" + msg + "</span>");
            $(obj).addClass("err");
            allright = false;
            return false;
        } else {
            $(obj).nextAll("span").remove();
            $(obj).removeClass("err");
            return true;
        }
    }

    //只做标记不提示
    function isWrong2(el, obj) {
        if (el) {
            $(obj).addClass("err");
            allright = false;
            return false;
        } else {
            $(obj).removeClass("err");
            return true;
        }
    }

    function clearErr(obj) {
        $(obj).nextAll("span").remove();
        $(obj).removeClass("err");
    }

    // 详情弹窗的出现与消失
    $('.po-details').click(function () {
        $('.details-popover').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
        $('.black-mask').show();
        var s = $('.popo-tbody').height();
        if(s <= 400){
            $('.details-popover .popo-content').css({"overflow":"hidden"})
        }
    });
    $('#popo-bi').click(function () {
        $('.details-popover').addClass('fadeOutUpBig').removeClass('fadeInDownBig');
        $('.black-mask').hide();
    });
    function setCode(type){
        var data = [];
        if(type==1){
            data = [
                {id:'1',text:"组织机构代码证"},
                {id:'6',text:"税务登记证"},
                {id:'7',text:"营业执照"},
                {id:'2',text:"三证合一统一信用代码"}
            ];
        }else{
            data = [
                {id:'0',text:"身份证"},
                {id:'3',text:"护照"},
                {id:'4',text:"台胞证"},
                {id:'5',text:"回乡证"}
            ];
        }
        var str = "<option value=''>请选择证件类型</option>";
        for(var i in data){
            if (data[i].id != undefined) str += "<option value='"+data[i].id+"'>"+data[i].text+"</option>";
        }
        $('#client_certificate_type').html(str);
    }

    function codeToName(_sign,_code){
        var _name = '';
        if(_sign!=''){
            if('10' == _sign){
                _name = '索赔申请书（加盖公章）';
            }else if('11' == _sign){
                _name = '赔付协议及权益转让书（加盖公章）';
            }else if('12' == _sign){
                _name = '事故经过说明';
            }else if('13' == _sign){
                _name = '劳动合同（复印件）';
            }else if('14' == _sign){
                _name = '首诊病历、住院病历、医疗费发票、用药清单、诊断证明等医院病历材料';
            }else if('15' == _sign){
                _name = '医生提供的病假条';
            }else if('16' == _sign){
                _name = '单位休假记录，需公司由人事部门盖章';
            }else if('17' == _sign){
                _name = '事故认定书';
            }else if('18' == _sign){
                _name = '公司营业执照、法人身份证复印件。经办人身份证复印件';
            }else if('19' == _sign){
                _name = '被保险人员工有无工伤保险证明（加盖公章）';
            }else if('20' == _sign){
                _name = '工伤认定书';
            }else if('21' == _sign){
                _name = '判决书原件及提交法院材料的复印件';
            }else if('22' == _sign){
                _name = '事故员工身份证复印件';
            }else if('01' == _sign){
                _name = '身份证';
            }else if('02' == _sign){
                _name = '劳动合同';
            }else if('03' == _sign){
                _name = '事故经过';
            }else if('04' == _sign){
                _name = '门诊病历';
            }else if('05' == _sign){
                _name = '医疗费发票';
            }else if('06' == _sign){
                _name = '用药清单';
            }else if('07' == _sign){
                _name = '误工费资';
            }else if('08' == _sign){
                _name = '其他证明资料';
            }
        }else{
            if('001000' == _code){
                _name = '索赔申请书（加盖公章）';
            }else if('007003' == _code){
                _name = '赔付协议及权益转让书（加盖公章）';
            }else if('003019' == _code){
                _name = '事故经过说明';
            }else if('003007' == _code){
                _name = '劳动合同（复印件）';
            }else if('004005' == _code){
                _name = '首诊病历、住院病历、医疗费发票、用药清单、诊断证明等医院病历材料';
            }else if('004006' == _code){
                _name = '医生提供的病假条';
            }else if('004006' == _code){
                _name = '单位休假记录，需公司由人事部门盖章';
            }else if('003012' == _code){
                _name = '事故认定书';
            }else if('006004' == _code){
                _name = '公司营业执照、法人身份证复印件。经办人身份证复印件';
            }else if('003001' == _code){
                _name = '被保险人员工有无工伤保险证明（加盖公章）';
            }else if('003007' == _code){
                _name = '工伤认定书';
            }else if('005000' == _code){
                _name = '判决书原件及提交法院材料的复印件';
            }else if('006005' == _code){
                _name = '事故员工身份证复印件';
            }
        }
        return _name;
    }

    $("input[name=bank_account_attribute]").on("change", function () {
        var val = $(this).val();
        console.log(val);
        if (val == '0') {
            setCode(1);
        } else {
            setCode(0);
        }
    });

    $(document).ready(function () {

        //点击下拉选择
        $(".list-input").on("change", '.sel-list', function () {
            var val = $(this).val();
            if (val === 0) {
                $(this).addClass('default');
            } else {
                $(this).removeClass('default');
            }
        });
        setCode(0);
        if('${report_id}' != ''){
            //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
            setParamDatas({},'/pc/report/queryByID/${report_id}',false,true,function(json){
                var _pay = json.insPaymentInfoVo;
                var _k = Object.keys(json);
                var _p = Object.keys(_pay);
                var _sta = json.status;
                if(_sta != undefined && _sta != ''){
                    var _pdate = _pay.pay_date;
                    if(_sta == '1'){//审核中
                        $('#i_1').addClass('glyphicon glyphicon-ok').html('');
                        if(_pdate != undefined && _pdate != ''){
                            $('#last-show').show();//显示返回按钮
                            $('#i_2').addClass('glyphicon glyphicon-ok').html('');
                            $('#i_2').parent().parent().addClass('active');
                            $('#i_3').addClass('glyphicon glyphicon-ok').html('');
                            $('#i_3').parent().parent().addClass('active');
                            $('#i_4').parent().parent().addClass('active');
                        }else{
                            $('#upload-model').show();//显示上传组件模块
                            $('#i_2').parent().parent().addClass('active');
                        }
                    }else if(_sta == '2'){//结案
                        $('#last-show').show();//显示返回按钮
                        $('#i_1').addClass('glyphicon glyphicon-ok').html('');
                        $('#i_2').addClass('glyphicon glyphicon-ok').html('');
                        $('#i_2').parent().parent().addClass('active');
                        if(_pdate != undefined && _pdate != ''){
                            $('#i_3').addClass('glyphicon glyphicon-ok').html('');
                            $('#i_3').parent().parent().addClass('active');
                        }else{
                            $('#i_3').addClass('glyphicon glyphicon-remove').html('');
                            $('#i_3').parent().parent().addClass('active-fail');
                        }
                        $('#i_4').addClass('glyphicon glyphicon-ok').html('');
                        $('#i_4').parent().parent().addClass('active');
                    }
                }
                $.each(_k, function (i, key) {
                    if($('#'+key)){
                        if(key == 'ins_common_report_id'||key == 'register_user_id'){
                            $('#'+key).val(json[key]);
                        }else{
                            $('#'+key).html(json[key]);
                        }
                    }
                });
                $.each(_p, function (i, key) {
                    if($('#'+key)){
                        $('#'+key).html(_pay[key]);
                    }
                });
                if(json.claimInformationVoList && json.claimInformationVoList.length>0) {
                    var _div = '';
                    $.each(json.claimInformationVoList, function (i, obj) {
                        var _sign = obj.file_key.substring(2,3)=='-'?obj.file_key.substring(0,2):'';
                        var file_path = obj.file_path;
                        if(obj.short_group_code == '001000'){
                            file_path = file_path.replace('doc','png')
                        }
                        _div += setUploads(codeToName(_sign,obj.short_group_code),file_path);
                    });
                    $('#uploads').html(_div);
                }
            });
        }
        contacts();
    });

    function setUploads(_title,_url){
        var _t = _title.length>7?(_title.substring(0,7)+'...'):_title;
        return _div = '<div class="col-sm-2 col-xs-2">'+
        '<img src="'+_url+'" width="100%" height="50px">'+
        '<span class="mt-db-7f" title="'+_title+'">'+_t+'</span>'+
        '</div>';
    }
    function contacts() {

        // 报案保存
        $('.an_save').click(function () {
            allright = true;
            var _file_html = $('#some_upload_bl').html();
            if(_file_html.trim() == ''){
                layer.alert('请点击“+”号添加理赔资料附件信息', {
                    icon: 3, closeBtn: 0, yes: function () {
                        layer.closeAll();
                    }
                });
                return;
            }
            $(".myValid").each(function () {
                $(this).trigger("blur");
                if ($(this).hasClass("err")) $(this).focus();
            }); //校验表单
            if (allright) {
                var data = $("#defaultForm").serializeJson();
                //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
                setParamDatas(data,'/pc/report/saveUploadFile',false,true,function(json){
                    if(json.statusCode == '200') {
                        layer.alert(json.message, {
                            icon: 1, closeBtn: 0, yes: function () {
                                layer.closeAll();
                                window.location.reload();
                            }
                        });
                    }else{
                        layer.alert(json.message, {
                            icon: 2, closeBtn: 0, yes: function () {
                                layer.closeAll();
                            }
                        });
                    }
                });
            }
        });
    }

    //点击返回按钮
    $(".list-input").on("click", '.an_back', function () {
        window.location.href = '/pc/report/reportList?ACCESS_TOKEN=${ACCESS_TOKEN}';
    });

    function clearBase64Byinput(_el){
        var _file_id = _el.id;
        _file_id = _file_id.substring(0,_file_id.length-7);
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        $("#"+_file_id).val('');
    }
    function base64convert(_el,_file){
        var flag = false;
        var fileName = _file.name;
        var type = fileName.split(".")[fileName.split(".").length-1];

        var fileKeyName = "/report/"+fileName;
        var _file_id = _el.attr("name").replace("_file","").trim();
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        ajaxFormDataLoad(_file,_file_id,"report/",type);
        flag = true;
        return flag;
    }
    function random4() {
        return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
    };
    function createUUID() {
        return (random4() + random4() + "-" + random4() + "-" + random4() + "-" + random4() + random4());
    };

    function ajaxFormDataLoad(file,_id,directoryName,fileType){
        var index = laySomenType(0,null,'',0);
        var _times = (new Date()).getTime();
        var fileName = _times+"."+fileType;
        var _sign = $('#'+_id+'_file-5').attr('data-sign');
        var fileId = _sign + '-' + createUUID();
        var formData = new FormData();
        formData.append('file', file);
        formData.append('fileName', fileName);
        formData.append('fileId', fileId);
        formData.append('directoryName', directoryName);
        var boo = ${fn:contains(product_code, 'GZZRX-PAC')};
        console.log('boo:',boo);
        var uul = baseUrl + '/file/ajaxFormDataLoadOther';
        if(boo){
            uul = baseUrl + '/file/ajaxFormDataLoadPA';
        }
        $.ajax({
            type: 'POST',
            url: uul,
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(result){
                laySomenType(2,index,'',0);
                if(result.statusCode == '200'){
                    $("#"+_id).val(result.message);
                    $("#"+_id.replace('file_path','file_name')).val(fileName);
                    $("#"+_id.replace('file_path','file_key')).val(fileId);
                }else{
                    laySomenType(1,null,result.message,0);
                }
            }
        });
    }

    function ajaxFormDataDelete(_id){
        var formData = new FormData();
        formData.append('url', $("#"+_id).val());
        var uul = baseUrl + '/file/ajaxFormDataDelete';
        $.ajax({
            url: uul,
            type: 'POST',
            cache: false,
            data: formData,
            processData: false,
            contentType: false
        }).done(function(res) {
            $("#"+_id).val('');
        }).fail(function(res) {

        });
    }

    function setOneUploadInput(_short_code,_cl_title,_sign,_key,_name,_url){
        var _t = _cl_title.length>21?(_cl_title.substring(0,20)+'...'):_cl_title;
        var _input = '<input type="hidden" name="claimInformationVoList[0].short_group_code" id="short_group_code_0" value="'+_short_code+'">'+
            '<input type="hidden" name="claimInformationVoList[0].file_key" id="file_key_0" value="'+_key+'">'+
            '<input type="hidden" name="claimInformationVoList[0].file_name" id="file_name_0" value="'+_name+'">'+
            '<input class="myValid" type="hidden" name="claimInformationVoList[0].file_path" id="file_path_0" value="'+_url+'">'+
            '<div>'+
            '<input name="file_path_0_file" id="file_path_0_file-5" data-sign="'+_sign+'" data-drawview="'+_url+'" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon=""/>'+
            '</div>'+
            '<span class="mt-db-7f" title="'+_cl_title+'">'+_t+'</span>';
        $('#one_upload_input').html(_input);
        initDoFile();
    }

    function addUploadInput(_short_code,_cl_title,_sign,_key,_name,_url){
        _key = _key==undefined?'':_key;
        _name = _name==undefined?'':_name;
        _url = _url==undefined?'':_url;
        var _num = 0,_fileNum = 1;
        if($('#uploadInputNum').val() != ''){
            _num = Number($('#uploadInputNum').val())+1;
        }
        if($('#fileNum').val() != ''){
            _fileNum = Number($('#fileNum').val())+1;
        }
        if(_fileNum>9){
            return;
        }else if(_fileNum<4){
            $('#uploadInputNum').parent().attr('style','height:320px;');
        }else if(_fileNum>3&&_fileNum<7){
            $('#uploadInputNum').parent().attr('style','height:613px;');
        }else if(_fileNum>6&&_fileNum<10){
            $('#uploadInputNum').parent().attr('style','height:860px;');
        }
        var _t = _cl_title.length>21?(_cl_title.substring(0,20)+'...'):_cl_title;
        var _input = '<div class="col-sm-4 col-xs-4">'+
            '<input type="hidden" name="claimInformationVoList['+_num+'].short_group_code" id="short_group_code_'+_num+'" value="'+_short_code+'">'+
            '<input type="hidden" name="claimInformationVoList['+_num+'].file_key" id="file_key_'+_num+'" value="'+_key+'">'+
            '<input type="hidden" name="claimInformationVoList['+_num+'].file_name" id="file_name_'+_num+'" value="'+_name+'">'+
            '<input class="myValid" type="hidden" name="claimInformationVoList['+_num+'].file_path" id="file_path_'+_num+'" value="'+_url+'">'+
            '<div>'+
            '<input name="file_path_'+_num+'_file" id="file_path_'+_num+'_file-5" data-sign="'+_sign+'" data-drawview="'+_url+'" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon=""/>'+
            '</div>'+
            '<span class="mt-db-7f" title="'+_cl_title+'">'+_t+'</span>'+
            '</div>';
        $('#some_upload_bl').append(_input);
        $('#uploadInputNum').val(_num);
        $('#fileNum').val(_fileNum);
        //激活组件
        initDoFile();
        //绑定必填校验
        zjjy();
    }

    function initDoFile(){
        var $input = $('input.file[type=file]'), count = $input.attr('type') ? $input.length : 0;
        if (count > 0) {
            $input.each(function(a,b){
                var type_img = ['.jpg','.jpeg','.gif','.png','.psd','.tiff','bmp'];
                var type_wj = ['.txt','.pdf','.doc','.docx','.ppt','.rar','.zip','.tar'];

                var maxFileSize = 20480;//文件限制20M(20480KB)
                var paths = $(b).attr('data-drawview');
                var name = paths;
                var allowedFiles = $(b).attr('data-allowedFileExtensions');
                var fileType = $(b).attr("data-preview-file-type");
                var allowedFileArr = new Array();//创建一个数组
                if(allowedFiles == undefined || allowedFiles == ""){
                    if(fileType == undefined || fileType == ""){
                        allowedFileArr = ["jpg","png","gif","jpeg","bmp","BMP","JPG","PNG","GIF","JPEG","doc","docx","xml","txt","pdf","ppt","xls","xlsx","rar","zip"];
                    }else if(fileType == "image"){
                        allowedFileArr =["jpg","png","gif","jpeg","bmp","BMP","JPG","PNG","GIF","JPEG"];
                        maxFileSize = 8192; //图片限制2M(2048KB)
                    }else{
//        				allowedFileArr =["doc","docx","xml","txt","pdf","ppt","xls","xlsx","rar","zip"];
                        allowedFileArr = ["jpg","png","gif","jpeg","bmp","BMP","JPG","PNG","GIF","JPEG","doc","docx","xml","txt","pdf","ppt","xls","xlsx","rar","zip"];
                    }
                }else{
                    allowedFileArr = allowedFiles.replace("[","").replace("]","").split(",");
                }
                if(paths != undefined && paths != '' && paths.length>1){
                    var code = "";
                    for(var i=0;i<type_img.length;i++){
                        if(code != "1"){
                            if(paths.replace(type_img[i])){
                                code = "1";
                                paths = '<img src="'+paths+'" class="file-preview-image" title="'+name+'" alt="'+name+'" style="width:200px;height:154px;">';
                            }
                        }
                    }
                    if(code == ""){
                        for(var i=0;i<type_wj.length;i++){
                            if(code != "2"){
                                if(paths.replace(type_wj[i])){
                                    code = "2";
                                }
                            }
                        }
                    }
                    if(code == "1"){
                        name = name.split("/")[name.split("/").length-1];
                        $(b).fileinput({
                            allowedFileExtensions: allowedFileArr,//接收的文件后缀
                            maxFileSize:maxFileSize,
                            initialPreview: [
                                paths
                            ],
                            initialPreviewAsData: true,
                            initialPreviewFileType: 'image',
                            deleteUrl: "/site/file-delete",
                            overwriteInitial: true,
                            initialPreviewConfig: [
                                {caption: name, size: 576237, width: "210px", url: "/site/file-delete", key: 1},
                            ]
                        });
                    }else if(code == "2"){
                        $(b).fileinput({
                            allowedFileExtensions: allowedFileArr,//接收的文件后缀
                            maxFileSize:maxFileSize,
                            initialPreview: [
                                paths
                            ]
                        });
                    }
                }else
                    $(b).fileinput({
                        allowedFileExtensions: allowedFileArr,//接收的文件后缀
                        maxFileSize:maxFileSize
                    });


            });
            //绑定双击删除
            deleteUploadDiv();
        }
    }
    function deleteUploadDiv(){
        //先清除已绑定的双击事件，避免之前已绑定第二遍重复绑定
        $('.file-drop-zone').unbind('dblclick');
        //重新绑定双击事件
        $('.file-drop-zone').dblclick(function(){
            var _div = $(this).parent().parent().parent().parent();
            _div.remove();
            var _fileNum = Number($('#fileNum').val())-1;
            if(_fileNum == 0){
                $('#fileNum').val('');
                $('#uploadInputNum').val('');
                $('#uploadInputNum').parent().attr('style','');
            }else{
                $('#fileNum').val(_fileNum);
                if(_fileNum>9){
                    return;
                }else if(_fileNum<4){
                    $('#uploadInputNum').parent().attr('style','height:320px;');
                }else if(_fileNum>3&&_fileNum<7){
                    $('#uploadInputNum').parent().attr('style','height:613px;');
                }else if(_fileNum>6&&_fileNum<10){
                    $('#uploadInputNum').parent().attr('style','height:860px;');
                }
            }
        });
    }

    //组件校验
    function zjjy() {
        //解绑
        $("input[name*='].file_path']").unbind('blur keyup.pev');
        //绑定
        $("input[name*='].file_path']").bind("blur keyup.pev", function () {
            var r1 = isWrong2($(this).val().trim() == "", this);
            if(!r1){
                layer.alert('存在已添加的上传组件未上传附件信息', {
                    icon: 2, closeBtn: 0, yes: function () {
                        layer.closeAll();
                    }
                });
            }
        });
    }
</script>

</html>
<script>
    $('ul.aside-list li').removeClass('on');
    $("#myReport").addClass('on');
</script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js' />"></script>