<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
	<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
	<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
	<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
	<title>百联保-我的账户</title>
</head>

<body style="position: relative">
<jsp:include page="../../../index/multi_h.jsp"/>
<div class="container">
	<jsp:include page="../../../index/multi_pc_l.jsp"/>
	<!--右边内容块-->
	<div class="pp-content">

		<ul class="order-list wed-list" id="wed-list">
			<li onclick="openRecordModel()">批改申请记录</li>
			<li onclick="openBillModel();">保全账单</li>
			<li onclick="openSettlementModel()">保全结算单</li>
			<li class="active">批量减员</li>
			<li onclick="openPerChangeModel();">人员变更</li>
		</ul>
<%--		<p class="pp-wert">人员变更</p>--%>
	</div>
	<div class="tab-query tab-order my-order">
		<div class="increased-time clearfix" style="padding-left: 30%;padding-top: 10%">
			<div class="time">
				<span>模板下载：</span>
				<a href="<c:url value='/resources/files/雇主批量导入范本.xls'/>">批量导入范本.xls</a>
			</div>
			<div class="upload">
				<a href="javascript:$('#batch_record').click();" class="batch-text">导入减员人员</a>
				<input name="batch_record" id="batch_record" type="file" onchange="uploadBatchInsure();">
			</div>
			<div class="time" id="errTime" hidden>
				<span>上传异常：</span>
				有人员数据无法识别，请<a href="">下载失败文件</a>查看，调整人员后重新导入
			</div>
		</div>
	</div>

</div>
<!--减少人员弹窗-->
<div class="increased-styles redues-increased animated" style="position: absolute!important;">
	<div class="payment-head">
		<span>选择保单减员</span>
		<a href="javascript:;" id="redues-bi">
			<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
		</a>
	</div>
	<div id="minus-increased">

	</div>
</div>
<!--人员变更提示弹窗-->
<div class="personnel-changes animated" style="position: absolute!important;top:30%">
	<div class="payment-head">
		<span>提示</span>
		<a href="javascript:;" id="personnel-bi">
			<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
		</a>
	</div>
	<div class="personnel-cont">
		<p>
			如有企业人员变动（如，员工离职、新员工入职等）<br/>
			可在“我的订单”中查询对应的保险，<br/>
			点击“保全”进入保单中的人员增减操作！
		</p>
	</div>
	<div class="personnel-butt">
		<span class="personnel-bibi">关闭</span>
		<span class="personnel-wed" onclick="openPolicy()">进入“我的订单”</span><%--<c:url value='/pc/order/myOrder'/>--%>
	</div>
</div>
<!--黑色蒙版-->
<div class="black-mask"></div>
<!--黑色蒙版2-->
<div class="black-mask-more"></div>
<jsp:include page="../../../index/multi_f.jsp"/>
<script src="<c:url value='/resources/versions-2.0.2/js/jquery.zoom.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0.2/js/laydate.js' />"></script>
<script src="<c:url value='/resources/versions-2.0.2/js/corrections.js' />"></script>
<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
<script type="text/javascript">
    var baseUrl = '${pageContext.request.contextPath }';
    $(function () {
        function mouse(even, stat, iconA, iconB) {
            $('.order-detail').on(even, '.guar', function () {
                $(this).siblings('.guar-list').css('display',stat);
                $(this).find('.' + iconA).removeClass(iconA).addClass(iconB);
            });
        }
        //鼠标移动到元素上显示
        mouse('mouseenter', 'block', 'down-icon', 'up-icon');
        //鼠标移出元素
        mouse('mouseleave', 'none', 'up-icon', 'down-icon');
    })
    var totalCount = Number($('#totalCount').val()) || 0;
    var showCount = $('#showCount').val() || 5;
    var limit = Number($('#numPerPage').val()) || 5;

    $('#callBackPager').extendPagination({
        totalCount: totalCount,
        showCount: showCount,
        limit: limit,
        callback: function (curr, limit, totalCount) {
            getListForPage("preservationPayForm","preservationPaysArea");
        }
    });
	function openRecordModel(){
		location.href=baseUrl+'/pc/preservation/recordList?ACCESS_TOKEN=${ACCESS_TOKEN}';
	}
	function openBillModel(){
		location.href=baseUrl+'/pc/preservation/pay/payList?ACCESS_TOKEN=${ACCESS_TOKEN}';
	}
	function openSettlementModel(){
		location.href=baseUrl+'/pc/preservation/pay/settlementList?ACCESS_TOKEN=${ACCESS_TOKEN}';
	}
	function openBatchModel(){
		location.href=baseUrl+'/pc/preservation/batchMinus?ACCESS_TOKEN=${ACCESS_TOKEN}';
	}
	function openPerChangeModel(){
		$('.personnel-changes').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
		$('.black-mask').show();
	}

    function openPolicy(){
        location.href=baseUrl+'/pc/order/myOrder?policyStatus=21&ACCESS_TOKEN=${ACCESS_TOKEN}';
    }
    function uploadPay(_id){
        $("#payId").val(_id);
    }

    function loadCanvas(_img){
        clearCanvas();
        var c=document.getElementById("cvs");
        var cxt=c.getContext("2d");
        var img=new Image()
        img.src=baseUrl + _img;
        img.onload = function () //确保图片已经加载完毕
        {
            cxt.drawImage(img, 0, 0, 440, 260);
        }
        payUploadShow();
    }
    function payUploadShow () {
        $('.payment-voucher').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
        $('.black-mask').show();
    }

    function clearCanvas(){
        var c=document.getElementById("cvs");
        var cxt=c.getContext("2d");
        cxt.clearRect(0,0,c.width,c.height);
    }

    function uploadFilePay(_form){
        if($("#upload").val() == ''){
            return false;
        }
        var index = layer.load(0, {shade: [0.3,'#808080']});
        var formData = new FormData(document.forms.namedItem(_form));
        $.ajax({
            type: 'POST',
            url:baseUrl + '/pc/preservation/pay/uploadFilePay',
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(json){
                layer.msg(json.message);
                $('.payment-voucher').addClass('fadeOutUpBig').removeClass('fadeInDownBig');
                $('.black-mask').hide();
                clearCanvas();
                getListForPage("preservationPayForm","preservationPaysArea");
                layer.close(index);
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                layer.close(index);
                layer.msg(textStatus);
            }
        });
    }

	function uploadBatchInsure(){
		var formData = new FormData();
		var files = document.getElementById("batch_record").files[0];
		if(files == undefined){
			return;
		}
		if(files.name.split('.')[1].indexOf('xls')==-1&&files.name.split('.')[1].indexOf('xlsx')==-1){
			layer.msg('请下载模板文件，填充人员信息后上传！',{time:3000});
			return;
		}
		var index = layer.load(0, {shade: [0.3,'#808080']});
		formData.append('batch_minus_record', files);
		$('#batch_record').val('');
		$.ajax({
			type: 'POST',
			url:baseUrl + '/pc/preservation/uploadBatchMinusFile',
			dataType:"json",
			data: formData,
			processData: false,
			contentType: false,
			success: function(json){
				if(json.retType == '0') {
					if(json.data.errCount>0){
						$('#errTime').children('a').attr('href',baseUrl + '/pc/preservation/exportErrInsPer');
						$('#errTime').show();
						layer.close(index);
					}else{
						$('#errTime').hide();
						$('.redues-increased').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
						$('.black-mask').show();
						$("#operate").val('minus');
						$.ajax({
							type : 'POST',
							url : baseUrl + "/pc/preservation/minus_policy_list_view",
							data : $("#preservationForm").serialize(),
							dataType : "html",
							success : function(data) {
								$("#minus-increased").html(data);
								layer.close(index);
							},
							error: function(){
								layer.close(index);
							}
						});
					}
				}else{
					layer.msg(json.msg);
					layer.close(index);
				}
			},
			error : function(XMLHttpRequest, textStatus, errorThrown) {
				layer.msg(textStatus);
				layer.close(index);
			}
		});
	}

	function batch_minus_save_preservation(_this,orderId,importBatchId){
		var index = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : baseUrl + "/pc/preservation/resultSet/batch_minus_preservation_service",
			data : {
				'orderId':orderId,
				'importBatchId':importBatchId
			},
			dataType : "json",
			success : function(data) {
				layer.msg(data.message,{time:3000});
				if(data.statusCode == "200"){
					$(_this).parent().parent().hide();
				}
				layer.close(index);
			},
			error: function(){
				layer.close(index);
			}
		});
	}

    function openPayDetail(_id){
        $.ajax({
            type : 'POST',
            url : baseUrl + "/pc/preservation/pay/getInsPreservationPayByPayId/"+_id,
            dataType : "html",
            success : function(data) {
                $("#loadRecordDetail").html(data);
            },
            error: function(){
            }
        });
    }

    function searchList(){
        $("#start_time").val($("#start-s2").val());
        $("#end_time").val($("#end-s2").val());
        $("#keyword").val($("#keyword_it").val());
        $("#pageNum").val(1);
        $("#numPerPage").val(5);
        $("#totalCount").val(0);
        $("#pay_status").val($('.con-s2 #status-xuan-s2').attr('data-status'));
        $("#preservationPayForm").submit();
    }

    function loadDataAndPage(){
        totalCount = Number($('#totalCount').val()) || 0;
        $('#callBackPager').extendPagination({
            totalCount: totalCount,
            showCount: showCount,
            limit: limit,
            callback: function (curr, limit, totalCount) {
                getListForPage("preservationPayForm","preservationPaysArea");
            }
        });
    };


    function getListForPage(formId,contentId){
        var index = layer.load(0, {shade: [0.3,'#808080']});
        $.ajax({
            type : 'POST',
            url : baseUrl + "/pc/preservation/pay/getPayListForPage",
            data : $("#"+formId).serialize(),
            dataType : "text",
            success : function(data) {
                layer.close(index);
                $("#"+contentId).html(data);
            },
            error: function(){
                layer.close(index);
            }
        });
    }

    function choisePolicyStatus(policyStatus,totalCount,obj){
        $(".order-list li").removeClass("active");
        $(obj).addClass("active");
        $("#policyStatus").val(policyStatus);
        $('#totalCount').val(totalCount);
        $('#pageNum').val("1");
        loadDataAndPage();
        getListForPage("preservationPayForm","preservationPaysArea");
    }

    function deletePreservationRecord(preservationId){
        layer.confirm('确定删除此订单？', {
            btn: ['确定','取消'] //按钮
        }, function(){
            layer.closeAll();
            var index = layer.load(0, {shade: [0.3,'#808080']});
            $.ajax({
                type : 'POST',
                url : baseUrl + "/pc/preservation/deleteInsPreservationRecord",
                data : {
                    "oid":preservationId,
                },
                dataType : "json",
                success : function(data) {
                    layer.close(index);
                    layer.msg(data.message);
                    if(data.status =="200"){
                        getListForPage("preservationPayForm","preservationPaysArea");
                    }
                },
                error: function(){
                    layer.close(index);
                }
            });
        });
    }

    function refreshTotal(){
        var total = Number($("#"+id).html());
        var totalCount = total -1;
        var numPerPage = Number($('#numPerPage').val());
        var pageNum = Number($("#pageNum").val());
        if(totalCount%numPerPage ==0)
            pageNum = pageNum -1;

        $("#"+id).html(totalCount);
        $('#totalCount').val(totalCount);
        $('#pageNum').val(pageNum);
        loadDataAndPage();

        $("#callBackPager li").each(function(){
            $(this).removeClass('active');
            if ($(this).find('a').html() == pageNum) {
                $(this).addClass('active');
            }
        });

        getListForPage("preservationPayForm","preservationPaysArea");
    }
</script>
</body>
</html>

<script>
    $('ul.aside-list li').removeClass('on');
    $("#myPreservation").addClass('on');
</script>