<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>

<div class="query-criteria">
	<div class="paging-war mt-60 clearfix">
		<span>分页项</span>
		<a href="#page-add" data-toggle="modal">添加</a>
		<a href="#page-amend" data-toggle="modal">修改</a>
	</div> 
	<div class="query-result">
		<table class="table product-table">
			<thead>
				<tr>
					<th></th>
					<th>顺序</th>
					<th>页名</th>
					<th>产品名</th>
					<th>操作</th> 
				</tr>
			</thead>
			<tbody>
				<c:choose>
					<c:when test="${empty pageSetupList }">
					<tr><td colspan="11" style="text-align: center;">无查询结果</td></tr>
					</c:when>
					<c:otherwise>
						<c:forEach items="${pageSetupList }" var="pageSetup">
							<tr typs="pag" rel="${pageSetup.oid}" onclick="selectRadio(this)">
								<td class="rad-io">
									<input type="radio" name="radio_pag" id="id_${pageSetup.oid}" />
									<label for="id_${pageSetup.oid}"></label>
								</td> 
								<td>${pageSetup.pageView}</td>
								<td>${pageSetup.pageName}</td>
								<td title="${pageSetup.insuranceProduct.name}">${pageSetup.insuranceProduct.name}</td>
								<td class="cr-7f">
									<a href="javascript:void(0);" data-vals="${pageSetup.oid}" onclick="getLoadModularity(this,'modularity_modal')" >查看</a>
									<span>|</span>
									<a href="javascript:void(0);" onclick="deleteRow('${pageSetup.oid}','deletePageSetup');" ><i class="glyphicon glyphicon-trash cr-7f"></i></a>
								</td>
							</tr>
						</c:forEach>
					</c:otherwise>
				</c:choose>
			  </tbody>
		</table>
	</div>
</div>
