<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>

<table class="table">
	<thead>
		<tr>
		  <th>子公司名称</th>
		  <th>账号</th>
		  <th>添加时间</th>
		  <th>地区</th>
		  <th>账户类型</th>
		  <th>操作</th> 
		</tr>
	</thead>
	<tbody>
		<c:choose>
			<c:when test="${empty userList || userList.size() < 1 }">
				<tr><td colspan="6" style="text-align: center;">无相关数据</td></tr>
			</c:when>
			<c:otherwise>
				<c:forEach items="${userList }" var="user">
				<tr>
					<td>${user.company.fullName }</td>
					<td>${user.userName }</td>
					<td><fmt:formatDate value='${user.registerDate }' pattern='yyyy-MM-dd HH:mm:ss' /></td>
					<td>${user.company.provinceName }${user.company.cityName }${user.company.countyName }</td>
					<td>${user.company.accountType.name }</td>
					<td><a href="javascript:void(0);"onclick="showEidtUser('${user.oid}');">编辑</a></td>
				</tr>
				</c:forEach>
			</c:otherwise>
		</c:choose>
	  </tbody>
</table>
							
