<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
	<table class="table">
		<thead>
			<tr>
				<th>订单号</th>
				<th>投保人名称</th>
				<th>被保险人名称</th>
				<th>项目名称</th>
				<th>信息状态</th>
				<th>承保状态</th>
				<th>订单生成时间</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:choose>
			<c:when test="${empty orderFirmList }">
				<tr><td colspan="8" style="text-align: center;">无查询结果</td></tr>
			</c:when>
			<c:otherwise>
				<c:forEach items="${orderFirmList }" var="orderFirm">
					<tr>
						<td>${orderFirm.orderNo }</td>
						<td>${orderFirm.applicant }</td>
						<td>${orderFirm.recognizee }</td>
						<td title="${orderFirm.policy.buildProject.projectName }">${orderFirm.policy.buildProject.projectName }</td>
						<td>${orderFirm.status.name }</td>
						<td>${orderFirm.underwriteStatus.name }</td>
						<td><fmt:formatDate pattern='yyyy-MM-dd HH:mm' value='${orderFirm.createOn }'/></td>
						<td><a target="_blank" href="<c:url value='/insuranceFirm/getOrderFirmDetail/${orderFirm.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">查看详情</a></td>
					</tr>
				</c:forEach>
			</c:otherwise>
		</c:choose>
		</tbody>
	</table>
