<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
	<table class="table">
		<thead>
			<tr>
				<th>订单号</th>
				<th>投保人名称</th>
				<th>被保险人名称</th>
				<th>项目名称</th>
				<th>费率详情</th>
				<th>保费</th>
				<th>出单机构</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:choose>
			<c:when test="${empty orderFirmList }">
				<tr><td colspan="6" style="text-align: center;">无查询结果</td></tr>
			</c:when>
			<c:otherwise>
				<c:forEach items="${orderFirmList }" var="orderFirm">
					<tr>
						<td>${orderFirm.orderNo }</td>
						<td>${orderFirm.applicant }</td>
						<td>${orderFirm.recognizee }</td>
						<td title="${orderFirm.policy.buildProject.projectName }">${orderFirm.policy.buildProject.projectName }</td>
						<td>${orderFirm.enteringStatus.name }</td>
						<td>${orderFirm.policy.grossPremium == 0 ? "未录入":orderFirm.policy.grossPremium }</td>
						<td>${ empty orderFirm.policy.insurerUser?"未指派":orderFirm.policy.insurerUser.company.fullName }</td>
						<td>
							<a target="_blank" href="<c:url value='/insuranceFirm/getOrderFirmDetail/${orderFirm.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">查看详情</a>
							<c:if test="${( orderFirm.policy.policyStatus eq 'WAITOFFER' || orderFirm.policy.policyStatus eq 'PENDING') && orderFirm.underwriteStatus eq 'ACCEPT' && orderFirm.backletterStatus eq 'UNUPLOADING' }">
								<a id="rateBtn" href="javascript:void(0);" onclick="showInputRateModal('${orderFirm.enteringStatus }','${orderFirm.oid }');" class="ns-btn">${orderFirm.enteringStatus eq 'UNENTERING' ?'录入保费':'修改保费'}</a>
							</c:if>
						</td>
					</tr>
				</c:forEach>
			</c:otherwise>
		</c:choose>
		</tbody>
	</table>
