<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-信用险业务管理-信用限额管理</title>

		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css'/>" />
		<!--[if lt IE 9]>
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
	<body>
		<div class="container-fluid">
			<jsp:include page="../../pcHeader.jsp"/>
			<div class="mar-content mt-80">
					<div class="container w100-mt20"><!-- container start -->
				<div class="nav-list" >
					<div class="row">
						<div class="col-sm-4 col-sm-4 active">
							<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">选择保单</span></p>
						</div>
						<div class="col-sm-4 col-sm-4">
							<p><i class="pull-left">2</i><span class="pull-left">限额查询</span></p>
						</div>
						<div class="col-sm-4 col-sm-4">
							<p><i class="pull-left">3</i><span class="pull-left">申请/修改</span></p>
						</div>
					</div>
				</div>
				<div class="message-war"><!-- message-war start -->
					<div class="w-95-auto"><!-- w-95-auto start -->
						<div class="mess-title"><h3>请选择一张保单</h3></div>
						<div class="affirm-warr"  id="policysArea">
							<table class="table ">
								<tbody>
									<tr>
										<td class="col-sm-1 col-xs-1">选择</td>
										<td class="col-sm-2 col-xs-2">保单号</td>
										<td class="col-sm-3 col-xs-3">投保人名称</td>
										<td class="col-sm-1 col-xs-1">投保金额</td>
										<td class="col-sm-2 col-xs-2">保费</td>
										<td class="col-sm-3 col-xs-3">起止日期</td>
									</tr>

									<c:choose>
										<c:when test="${empty policyList }">
											<tr>
												<td class="col-sm-12" colspan="6" style="text-align: center;">暂无相关数据</td>
											</tr>
										</c:when>
										<c:otherwise>
											<c:forEach items="${policyList }" var="policy"
												varStatus="status">
												<tr>
													<td class="col-sm-1 col-xs-1">
														<p class="col-sm-2 col-xs-2 rad-io">
															<span><input type="radio" name="oid"
																value="${policy.oid}"
																<c:if test="${ status.index  eq 0}"> checked="checked"</c:if>
																id="radio_${policy.oid}"> <label
																for="radio_${policy.oid}" class="pull-left m-0-13"></label></span>
														</p>
													</td>
													<td class="col-sm-2 col-xs-2">${policy.external_reference}</td>
													<td class="col-sm-3 col-xs-3">${policy.applicant_name}</td>
													<td class="col-sm-1 col-xs-1"><%--${policy.insured_amount}--%></td>
													<td class="col-sm-2 col-xs-2">${policy.gross_premium}</td>
													<td class="col-sm-3 col-xs-3">${policy.inception_date}
														至${policy.planned_end_date}</td>
												</tr>
											</c:forEach>
										</c:otherwise>
									</c:choose>
								</tbody>
							</table>
						</div>
					</div><!-- w-95-auto end -->
				</div><!-- message-war end -->
				<div class="row next-step">
					<div class="col-sm-6 col-sm-6">
							<!-- 分页 start -->
						<nav class="text-center">
							 <form id="policyForm">
				            	<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
				            	<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
				            	<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
				            	<div id="callBackPager" style="margin: 0 auto;text-align: center;"></div>
				            </form>
						</nav>

					</div>

					<c:if  test="${not empty policyList }">
					<div class="col-sm-6 col-xs-6 text-right pull-right">
						<p>
							<a onclick="getNext()" class="ns-btn">下一步</a>
						</p>
					</div>
					</c:if>
				</div>
			</div><!-- container end -->
			</div><!-- mar-content 右边内容块 end -->
		</div>
	</body>

</html>
<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
<script type="text/javascript">
		choiseMenu("shipping01");
		var baseUrl = '${pageContext.request.contextPath }';
		var totalCount = Number($('#totalCount').val()) || 0;
		var showCount = $('#showCount').val() || 5;
		var limit = Number($('#numPerPage').val()) || 10;
		$('#callBackPager').extendPagination({
		totalCount: totalCount,
		showCount: showCount,
		limit: limit,
		callback: function (curr, limit, totalCount) {
			getListForPage("policyForm","policysArea");
		}
		});
		function getListForPage(formId,contentId){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/exports/credit/getPolicyListForPage",
				data : $("#"+formId).serialize(),
				dataType : "text",
				success : function(data) {
					layer.close(index);
					$("#"+contentId).html(data);
				},
				error: function(){
					layer.close(index);
				}
			});
		}
		function  getNext(){
			var oid = $('input[name="oid"]:checked').val();
			//alert(baseUrl+"/exports/credit/limitQuery/"+oid);
			window.location=baseUrl+"/exports/credit/limitQuery/"+oid+"?ACCESS_TOKEN=${ACCESS_TOKEN}";

		}
</script>
