<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>

<p><!-- -has-success has-feedback -->
	<label>保单号</label>
	${claim.policy.external_reference }
</p>
<p><!-- has-loser has-feedback -->
	<label>申请时间</label>
	<c:if test="${claim.reportTime != null }">
	<fmt:formatDate pattern="yyyy-MM-dd HH:mm" value="${claim.reportTime }" />
	</c:if>
</p>
<p>
	<label>联系人</label>
	${claim.contactName }
</p>
<p>
	<label>联系人电话</label>
	${claim.contactTel }
</p>
<p>
	<label>出险时间</label>
	<c:if test="${claim.caseTime != null }">
	<fmt:formatDate pattern="yyyy-MM-dd HH:mm" value="${claim.caseTime }" />
	</c:if>
</p>
<p>
	<label>出险地点</label>
	${claim.caseScene }
</p>
<p>
	<label>出险经过</label>
	${claim.caseDescption }
</p>
<p>
	<label>处理状态</label>
	${claim.status.name }
</p>
<p>
	<label>理赔资料</label>
	<c:if test="${not empty claim.downPath }"><a href="javascript:void(0);" onclick="sodownload('${ claim.downPath }','理赔资料')">下载</a></c:if>
</p>
