<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
<form id="settlementForm">
<h4 class="mt-60">查询结果</h4>
<div class="query-result" id="pageResult">
	<table class="table">
		<thead>
			<tr>
				<th class="choice check-box"><input type="checkbox" value="反选" id="cball" onclick="choiseAll();"> 
					<label for="cball"></label>
				</th>
				<th>订单号</th>
				<th>项目名称</th>
				<th>保单号</th>
				<th>保费</th>
				<th>保额</th>
				<th>保险起保日期</th>
				<th>保险出单日期</th>
				<th>投保人</th>
				<th>状态</th>
				<th>服务费</th>
			</tr>
		</thead>
		<tbody>
		<c:choose>
			<c:when test="${empty orderRecordList }">
				<tr><td colspan="11" style="text-align: center;">无查询结果</td></tr>
			</c:when>
			<c:otherwise>
				<c:forEach items="${orderRecordList }" var="orderRecord">
					<tr>
						<td class="choice check-box">
							<c:if test="${orderRecord.status eq 'UNACCOUNTING' }">
								<input type="checkbox" id="checkbox${orderRecord.oid }" value="${orderRecord.oid }" name="oids" onclick="choiseOid()">
								<label for="checkbox${orderRecord.oid }"></label>
							</c:if>
						</td>
						<td>${orderRecord.orderNo }</td>
						<td title="${orderRecord.policy.buildProject.projectName }">${orderRecord.policy.buildProject.projectName }</td>
						<td>${orderRecord.policy.external_reference }</td>
						<td>${orderRecord.policy.premium }</td>
						<td>${orderRecord.policy.insuredAmount }</td>
						<td><fmt:formatDate pattern='yyyy-MM-dd' value='${orderRecord.policy.signedDate }'/></td>
						<td><fmt:formatDate pattern='yyyy-MM-dd' value='${orderRecord.policy.inceptionDate }'/></td>
						<td><fmt:formatDate pattern='yyyy-MM-dd' value='${orderRecord.policy.buildProject.bidtime }'/></td>
						<td>${orderRecord.status.name }</td>
						<td>${orderRecord.commission.brokerage }${orderRecord.commission.brokerageType.name }</td>
					</tr>
				</c:forEach>
			</c:otherwise>
		</c:choose>
		</tbody>
	</table>
</div>
<div class="btn-bottom pull-right"> 
	<p><a href="javascript:void(0);" onclick="settlement();" class="clearing pull-left">结算所选</a></p>
</div>
<!-- 分页 start -->
<nav class="text-center">
	<div id="callBackPager" style="margin: 0 auto;text-align: center;"></div>
</nav>
<!-- 分页 end -->
</form>
<script>


	var totalCount = Number($('#totalCount').val()) || 0;
	var showCount = $('#showCount').val() || 5;
	var limit = Number($('#numPerPage').val()) || 5;
	
	$('#callBackPager').extendPagination({
		totalCount: totalCount,
		showCount: showCount,
		limit: limit,
		callback: function (curr, limit, totalCount) {
			getListForPage();
		}
	});

	function getListForPage(){
		var index = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : baseUrl + "/bid/settlementList",
			data : $("#orderForm").serialize(),
			dataType : "text",
			success : function(data) {
				layer.close(index);
				$("#pageResult").html(data);			
			},
			error: function(){
				layer.close(index);
			}
		});
	}
	
	
	function settlement(){
		layer.confirm('确定结算所选？', {
			  skin: 'confirmTip',
			  btn: ['确定','取消'] //按钮
			}, function(){
				layer.closeAll();
				var index = layer.load(0, {shade: [0.3,'#808080']});
				if($("input[name=oids]:checked").length >0){
					$.ajax({
						type : 'POST',
						url : baseUrl + "/bid/settlement.json",
						data : $("#settlementForm").serialize(),
						dataType : "json",
						success : function(data) {
							layer.close(index);
							layer.msg(data.message);
							if(data.status=="200")
								submitOrderForm();
						},
						error: function(){
							layer.close(index);
						}
					});
				}else{
					layer.msg("请选择需要结算的订单");
				}
			}, function(){			  
			});
	}
</script>