<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
<h4 class="mt-60">查询结果</h4>
<div class="query-result" id="pageResult">
	<table class="table">
		<thead>
			<tr>
				<th>订单号</th>
				<th>项目名称</th>
				<th>保单号</th>
				<th>保费</th>
				<th>保额</th>
				<th>保险起保日期</th>
				<th>保险出单日期</th>
				<th>投保人</th>
				<th>状态</th>
				<th>服务费</th>
			</tr>
		</thead>
		<tbody>
		<c:choose>
			<c:when test="${empty orderRecordList }">
				<tr><td colspan="10" style="text-align: center;">无查询结果</td></tr>
			</c:when>
			<c:otherwise>
				<c:forEach items="${orderRecordList }" var="orderRecord">
					<tr>
						<td>${orderRecord.orderNo }</td>
						<td title="${orderRecord.policy.buildProject.projectName }">${orderRecord.policy.buildProject.projectName }</td>
						<td>${orderRecord.policy.external_reference }</td>
						<td>${orderRecord.policy.premium }</td>
						<td>${orderRecord.policy.insuredAmount }</td>
						<td><fmt:formatDate pattern='yyyy-MM-dd' value='${orderRecord.policy.inceptionDate }'/></td>
						<td><fmt:formatDate pattern='yyyy-MM-dd' value='${orderRecord.policy.signedDate }'/></td>
						<td>${orderRecord.applicant }</td>
						<td>${orderRecord.status.name }</td>
						<td>${orderRecord.coverCharge }</td>
					</tr>
				</c:forEach>
			</c:otherwise>
		</c:choose>
		</tbody>
	</table>
</div>
<!-- 分页 start -->
<nav class="text-center">
	<div id="callBackPager" style="margin: 0 auto;text-align: center;"></div>
</nav>
<!-- 分页 end -->
<script>


	var totalCount = Number($('#totalCount').val()) || 0;
	var showCount = $('#showCount').val() || 5;
	var limit = Number($('#numPerPage').val()) || 5;
	
	$('#callBackPager').extendPagination({
		totalCount: totalCount,
		showCount: showCount,
		limit: limit,
		callback: function (curr, limit, totalCount) {
			getListForPage();
		}
	});

	function getListForPage(){
		var index = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : baseUrl + "/bid/orderRecordList",
			data : $("#orderForm").serialize(),
			dataType : "text",
			success : function(data) {
				layer.close(index);
				$("#pageResult").html(data);			
			},
			error: function(){
				layer.close(index);
			}
		});
	}
</script>