<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-我的账户</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
	<body>
		<div class="container-fluid">
			<jsp:include page="../pcHeader.jsp"/>
			<div class="mar-content mt-80">
				<!-- 我的账户-评标结果 start -->
				<div class="container-fluid">
					<div class="tender-war">
						<div class="query-criteria">
							<h4>评标结果</h4>
							<form id="evaluationForm">
								<div class="qucr-sub clearfix">
									<div class="w-98-auto">
										<div class="col-sm-3 col-xs-3">
											<p>*项目名称及标段</p>
											<input onblur="baseCheckInput(this,'');" name="projectName" id="projectName" type="text" class="form-control" placeholder="" />
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div> 
										<div class="col-sm-3 col-xs-3">
											<p>*招标文件编号</p>
											<input onblur="baseCheckInput(this,'');" name="invitationCode" id="invitationCode" type="text" class="form-control" placeholder="" />
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span> 
										</div> 
										<div class="col-sm-3 col-xs-3">
											<p>*评标结果公示日期</p> 
											<input name="bidTime" readonly="readonly" id="bidTime" class="laydate-icon form-control" placeholder="">
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div>
										<div class="col-sm-3 col-xs-3">
											<p>预计开工日期</p> 
											<input name="workingTime" readonly="readonly" id="workingTime" class="laydate-icon form-control" placeholder="">
										</div> 
										<div class="clear"></div>
										<div class="bb-mt-e7"></div>
										<div class="col-sm-6 col-xs-6">
											<p>*第一中标候选人</p>
											<input onblur="baseCheckInput(this,'');" name="companyName_1" id="companyName_1" type="text" class="form-control" placeholder="" />
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div> 
										<div class="col-sm-3 col-xs-3">
											<p>*联系人</p>
											<input onblur="baseCheckInput(this,'');" name="linkman_1" id="linkman_1" type="text" class="form-control" placeholder="" /> 
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div>
										<div class="col-sm-3 col-xs-3">
											<p>*联系人电话</p>
											<input onblur="baseCheckInput(this,'');" name="linkphone_1" id="linkphone_1" type="text" class="form-control" placeholder="" /> 
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div>
										<div class="col-sm-6 col-xs-6">
											<p>第二中标候选人</p>
											<input name="companyName_2" id="companyName_2" type="text" class="form-control" placeholder="" /> 
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div> 
										<div class="col-sm-3 col-xs-3">
											<p>联系人</p>
											<input name="linkman_2" id="linkman_2" type="text" class="form-control" placeholder="" /> 
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div>
										<div class="col-sm-3 col-xs-3">
											<p>联系人电话</p>
											<input name="linkphone_2" id="linkphone_2" type="text" class="form-control" placeholder="" /> 
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div>
										<div class="col-sm-6 col-xs-6">
											<p>第三中标候选人</p>
											<input name="companyName_3" id="companyName_3" type="text" class="form-control" placeholder="" /> 
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div> 
										<div class="col-sm-3 col-xs-3">
											<p>联系人</p>
											<input name="linkman_3" id="linkman_3" type="text" class="form-control" placeholder="" /> 
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div>
										<div class="col-sm-3 col-xs-3">
											<p>联系人电话</p>
											<input name="linkphone_3" id="linkphone_3" type="text" class="form-control" placeholder="" /> 
											<span class="glyphicon form-control-feedback t-icon-l" aria-hidden="true"></span>
										</div>
									</div>
								</div> 
								<div class="btn-bottom pull-right"> 
									<p><a href="javascript:void(0);" onclick="submitEvaluationForm();" class="conserve pull-left">提交</a></p>
								</div>
							</form>
						</div>
					</div>
					<div class="tender-war">
						<div class="query-criteria" id="pageResult">
							<h4 class="mt-60">历史信息</h4>
							<div class="query-result" id='queryResult'>
								<table class="table">
									<thead>
										<tr>
										  <th>项目名称及标段</th>
										  <th>招标文件编号</th>
										  <th>评标结果公示日期</th>
										  <th>预计开工日期</th>
										  <th>添加时间</th>
										  <th>操作</th> 
										</tr>
									</thead>
									<tbody>
										<c:choose>
											<c:when test="${empty bidMsgList }">
												<tr><td colspan="6" style="text-align: center;">无查询结果</td></tr>
											</c:when>
											<c:otherwise>
												<c:forEach items="${bidMsgList }" var="bidMsg">
													<tr>
														<td title="${bidMsg.projectName }">${bidMsg.projectName }</td>
														<td>${bidMsg.invitationCode }</td>
														<td><fmt:formatDate value='${bidMsg.bidTime }' pattern='yyyy-MM-dd' /></td>
														<td><fmt:formatDate value='${bidMsg.workingTime }' pattern='yyyy-MM-dd' /></td>
														<td><fmt:formatDate value='${bidMsg.createOn }' pattern='yyyy-MM-dd' /></td>
														<td class="look-over">
															<a href="javascript:void(0);" onclick="lookDetail('${bidMsg.oid}');"><i class="glyphicon glyphicon-eye-open"></i>查看</a>
														</td>
													</tr>
											</c:forEach>
											</c:otherwise>
										</c:choose>
									  </tbody>
								</table>
							</div>
							<!-- 分页 start -->
							<nav class="text-center">
								<div id="callBackPager" style="margin: 0 auto;text-align: center;"></div>
							</nav>
							 <form id="queryForm">
				            	<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
				            	<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
				            	<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
				            </form>
							<!-- 分页 end --> 
						</div>
					</div>
				</div>
				<!-- 我的账户-评标结果 end -->
				
			</div><!-- mar-content 右边内容块 end -->
		</div>
		
		
		<!-- 查看 start -->
			<div class="modal fade" id="look-1" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
			   <div class="modal-dialog" role="document">
					<div class="modal-content">
					  <div class="modal-header bg-1f96ef">
						<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						<h4 class="modal-title">详情</h4>
					  </div> 
					  <div class="modal-body"> 
					  	<div class="parti-culars" id="lookDetailDiv"></div> 
					  </div>
					  <div class="modal-footer">
						<div class="mofo-sub"> 
							<button type="button" class="btn notarize-btn pull-right cancel-btn" data-dismiss="modal">关闭</button>
						</div>
					  </div> 
					</div> 
			  </div> 
			</div> 
			<!-- 查看 end -->
		
	</body>
	<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js'/>"></script>
	<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
	<script type="text/javascript" src="<c:url value='/resources/js/checkInputChangeStyle.js'/>"></script>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/normalCheck.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/validateIdent.js' />"></script>
	<script type="text/javascript">
		var baseUrl = '${pageContext.request.contextPath }';
		choiseMenu("evaluation");
		
		var totalCount = Number($('#totalCount').val()) || 0;
		var showCount = $('#showCount').val() || 5;
		var limit = Number($('#numPerPage').val()) || 5;
		
		$('#callBackPager').extendPagination({
		totalCount: totalCount,
		showCount: showCount,
		limit: limit,
		callback: function (curr, limit, totalCount) {
			getListForPage();
		}
		});

		function refreshListForPage(){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/bid/refreshListForPage",
				dataType : "text",
				cache : false,
				success : function(data) {
					layer.close(index);
					$("#pageResult").html(data);
				},
				error : function(XMLHttpRequest, textStatus, errorThrown) {
					layer.close(index);
					layer.msg(textStatus);
				}
			});
		}
		
		function getListForPage(){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/bid/getBidMsgList",
				data : $("#queryForm").serialize(),
				dataType : "text",
				cache : false,
				success : function(data) {
					layer.close(index);
					$("#queryResult").html(data);
				},
				error : function(XMLHttpRequest, textStatus, errorThrown) {
					layer.close(index);
					layer.msg(textStatus);
				}
			});
		}
		
		//日期范围限制
		var bidTime = {
		    elem: '#bidTime',
		    format: 'YYYY-MM-DD',
		    max: '2099-06-16', //最大日期
		    istoday: false,
		    choose: function(datas){
		    }
		};
		
		var workingTime = {
			    elem: '#workingTime',
			    format: 'YYYY-MM-DD',
			    max: '2099-06-16',
			    istoday: false,
			    choose: function(datas){
			    }
			};
	
		Date.prototype.Format = function (fmt) { //author: meizz 
		    var o = {
		        "M+": this.getMonth() + 1, //月份 
		        "d+": this.getDate(), //日 
		        "h+": this.getHours(), //小时 
		        "m+": this.getMinutes(), //分 
		        "s+": this.getSeconds(), //秒 
		        "q+": Math.floor((this.getMonth() + 3) / 3), //季度 
		        "S": this.getMilliseconds() //毫秒 
		    };
		    if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
		    for (var k in o)
		    if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
		    return fmt;
		}
		laydate(bidTime);
		laydate(workingTime);
		
		function checkEvaluationFormInput(){
			var flag = true;
			var filedNames = new Array("projectName","invitationCode","bidTime","companyName_1","linkman_1","linkphone_1");
			var tips = new Array("项目名称及标段","招标文件编号","评标结果公示日期","第一中标候选人","第一中标联系人","第一中标联系人电话");
			var falseCount = 0;
			for(var j=0;j<filedNames.length;j++){
// 				flag = checkInput(filedNames[j],tips[j]);
				flag = baseCheckInput(filedNames[j],'');
				if(!flag)
					falseCount++;
			}
			if(falseCount>0)
				flag = false;
			return flag;
		}
		
		function submitEvaluationForm(){
			if(checkEvaluationFormInput()){
				var index = layer.load(0, {shade: [0.3,'#808080']});
				$.ajax({
					type : 'POST',
					url : baseUrl + "/bid/addEvaluation.json",
					data : $("#evaluationForm").serialize(),
					dataType : "json",
					cache : false,
					success : function(json) {
						layer.close(index);
						layer.msg(json.message);
						if(json.status='200')
							refreshListForPage();
					},
					error : function(XMLHttpRequest, textStatus, errorThrown) {
						layer.close(index);
						layer.msg(textStatus);
					}
				});
			}
		}
		
		function lookDetail(oid){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/bid/getEvaluationDetail",
				data : {"oid":oid},
				dataType : "text",
				cache : false,
				success : function(data) {
					layer.close(index);
					$("#lookDetailDiv").html(data);
					$("#look-1").modal('show');
				},
				error : function(XMLHttpRequest, textStatus, errorThrown) {
					layer.close(index);
					layer.msg(textStatus);
				}
			});
		}
		
	</script>
</html>

