<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags"%>
<%@ page import="org.springframework.security.core.AuthenticationException"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<h4 class="mt-60">历史信息</h4>
<div class="query-result" id='queryResult'>
	<table class="table">
		<thead>
			<tr>
				<th>项目名称及标段</th>
				<th>招标文件编号</th>
				<th>评标结果公示日期</th>
				<th>预计开工日期</th>
				<th>添加时间</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
			<c:choose>
				<c:when test="${empty bidMsgList }">
					<tr>
						<td colspan="6" style="text-align: center;">无查询结果</td>
					</tr>
				</c:when>
				<c:otherwise>
					<c:forEach items="${bidMsgList }" var="bidMsg">
						<tr>
							<td title="${bidMsg.projectName }">${bidMsg.projectName }</td>
							<td>${bidMsg.invitationCode }</td>
							<td><fmt:formatDate value='${bidMsg.bidTime }' pattern='yyyy-MM-dd' /></td>
							<td><fmt:formatDate value='${bidMsg.workingTime }' pattern='yyyy-MM-dd' /></td>
							<td><fmt:formatDate value='${bidMsg.createOn }' pattern='yyyy-MM-dd' /></td>
							<td class="look-over"><a href="javascript:void(0);" onclick="lookDetail('${bidMsg.oid}');"><i class="glyphicon glyphicon-eye-open"></i>查看</a>
							</td>
						</tr>
					</c:forEach>
				</c:otherwise>
			</c:choose>
		</tbody>
	</table>
</div>
<!-- 分页 start -->
<nav class="text-center">
	<div id="callBackPager" style="margin: 0 auto; text-align: center;"></div>
</nav>
<form id="queryForm">
	<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
	<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
	<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
</form>
<!-- 分页 end -->
<script>

	var totalCount = Number($('#totalCount').val()) || 0;
	var showCount = $('#showCount').val() || 5;
	var limit = Number($('#numPerPage').val()) || 5;
	
	$('#callBackPager').extendPagination({
	totalCount: totalCount,
	showCount: showCount,
	limit: limit,
	callback: function (curr, limit, totalCount) {
		getListForPage();
	}
	});
	

	function getListForPage(){
		var index = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : baseUrl + "/bid/getBidMsgList",
			data : $("#queryForm").serialize(),
			dataType : "text",
			cache : false,
			success : function(data) {
				layer.close(index);
				$("#queryResult").html(data);
			},
			error : function(XMLHttpRequest, textStatus, errorThrown) {
				layer.close(index);
				layer.msg(textStatus);
			}
		});
	}
</script>