<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-非约束行报价</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" /> 
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
<body style="background: rgba(244,245,246,1);">

<jsp:include page="../../../index/multi_h.jsp"/>
<div class="container" style="padding-bottom: 50px; padding-top: 20px;"><!-- container start -->
	<ol class="breadcrumb">
	  <li><a href="<c:url value='/?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">首页</a></li>
	  <li><a href="<c:url value='/synopsis/product/productAllView?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">产品列表</a></li>
	  <li><a href="<c:url value='/insurance/product/productInfo/${dto.product_oid}?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">产品详情</a></li>
	  <li class="active">投保确认</li>
	</ol>
	<div class="nav-list">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 active">
				<p><i class="pull-left">3</i><span class="pull-left">投保信息审核</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 pull-right">
				<p><i class="pull-left">4</i><span class="pull-left">完成投保</span></p>
			</div>
		</div>
	</div>
	<div class="message-war"><!-- message-war start -->
		<h2>${ dto.product_name}</h2>
		<div class="w-95-auto"><!-- w-95-auto start -->
			<h5>订单号码：${ dto.trade_serial_number}</h5>
			<div class="mess-title"><h3>被保险人信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">被保险人名称</td>
							<td colspan="3" class="col-sm-6 col-xs-6">${dto.insured_role}</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">经营范围</td>
							<td colspan="3" class="col-sm-6 col-xs-6">${dto.business_scope}</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">共同被保险人</td>
							<td colspan="3" class="col-sm-6 col-xs-6"></td>
						</tr> 
                   	</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>投保信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">报价单日期</td>
							<td colspan="3" class="col-sm-6 col-xs-6">${underwriteVo.underwrite_time }</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">保单币种</td>
							<td colspan="3" class="col-sm-6 col-xs-6">${fns:getDictLabel (dto.policy_currency,"currencyRequired","") }</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">保险期限</td>
							<td colspan="3" class="col-sm-6 col-xs-6">一年<%--${underwriteVo.deadline }--%></td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">保险公司</td>
							<td colspan="3" class="col-sm-6 col-xs-6">${ dto.insurance_name}</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">承保范围</td>
							<td colspan="3" class="col-sm-6 col-xs-6">${underwriteVo.coverage }</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">可保营业额</td>
							<td colspan="3" class="col-sm-6 col-xs-6">${underwriteVo.business_volume }</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">一般付款条件</td>
							<td colspan="3" class="col-sm-6 col-xs-6">-</td>
						</tr>
                   	</tbody>
				</table>
			</div>
			<c:if test="${underwriteVo.riskDutyVoList.size()>0 }">
			<div class="mess-title"><h3>国家分组条款</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
					<tr>
						<td rowspan="2" class="tablebg_f5f8fa col-sm-1 col-xs-1">国家分组</td>
						<td rowspan="2" class="tablebg_f5f8fa  	col-sm-1 col-xs-1">保险费率</td>
						<td rowspan="2" class="tablebg_f5f8fa  col-sm-1 col-xs-1">最长付款期限</td>
						<td rowspan="2" class="tablebg_f5f8fa col-sm-1 col-xs-1">最长延长期限</td>
						<td rowspan="2" class="tablebg_f5f8fa  col-sm-1 col-xs-1">不可撤销合同的承保责任</td>
						<td rowspan="2" class="tablebg_f5f8fa col-sm-1 col-xs-1">自定信用限额</td>
						<td colspan="2" class="tablebg_f5f8fa  col-sm-1 col-xs-1">承保比例</td>
						<td colspan="2" class="tablebg_f5f8fa col-sm-1 col-xs-1">等待期</td>
						<td colspan="2" rowspan="2" class="tablebg_f5f8fa col-sm-1 col-xs-1">自负额起赔额</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa  col-sm-1 col-xs-1">核准的信用限额</td>
						<td class="tablebg_f5f8fa  col-sm-1 col-xs-1">自定信用限额</td>
						<td class="tablebg_f5f8fa col-sm-1 col-xs-1">商业风险</td>
						<td class="tablebg_f5f8fa col-sm-1 col-xs-1">政治风险</td>
					</tr>
					<c:forEach items="${underwriteVo.riskDutyVoList }" var="list">
						<tr>
							<td class="col-sm-1 col-xs-1">${list.country_area_risk_type }</td>
							<td class="col-sm-1 col-xs-1">${list.rate }</td>
							<td class="col-sm-1 col-xs-1">${list.long_credit }</td>
							<td class="col-sm-1 col-xs-1">${list.grace_period }</td>
							<td class="col-sm-1 col-xs-1">${list.un_repeal_period }</td>
							<td class="col-sm-1 col-xs-1">${list.credit_quota }</td>
							<td class="col-sm-1 col-xs-1">${list.credit_quota_rate }</td>
							<td class="col-sm-2 col-xs-2">${list.claim_period }</td>
							<td class="col-sm-1 col-xs-1">${list.deductible }</td>
						</tr>
					</c:forEach>
					</tbody>
				</table>
			</div>
			</c:if>
       		<div class="mess-title"><h3>承保条件</h3></div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">最高责任限额</td>
							<td colspan="3" class="col-sm-6 col-xs-6">${underwriteVo.insurance_amount_max }</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">就逾期欠款通知的最后期限</td>
							<td colspan="3" class="col-sm-6 col-xs-6">${underwriteVo.balance_overdue_deadline }</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">开具发票期限</td>
							<td colspan="3" class="col-sm-6 col-xs-6">${underwriteVo.make_invoice_deadline }</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">营业额申报期限</td>
							<td colspan="3" class="col-sm-6 col-xs-6">${underwriteVo.declare_time }</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">承保国家</td>
							<td colspan="3" class="col-sm-6 col-xs-6">-</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">特殊条件（如有）</td>
							<td colspan="3" class="col-sm-6 col-xs-6">${underwriteVo.special_if }</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">备注</td>
							<td colspan="3" class="col-sm-6 col-xs-6">${underwriteVo.underwrite_remark }</td>
						</tr>
                   	</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>保险费和信用限额费</h3></div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">保险费率(%)</td>
							<td colspan="3" class="col-sm-6 col-xs-6">${underwriteVo.total_rate }</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">预计年度保险费(元)</td>
							<td colspan="3" class="col-sm-6 col-xs-6">${underwriteVo.year_premium }</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">最低保险费(元)</td>
							<td colspan="3" class="col-sm-6 col-xs-6">${underwriteVo.initial_premium }</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">保费缴纳方式</td>
							<td colspan="3" class="col-sm-6 col-xs-6">${fns:getDictLabel (underwriteVo.payment_way,"pay_methods","") }</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-6 col-xs-6">信用限额调查费(元)</td>
							<td colspan="3" class="col-sm-6 col-xs-6">${underwriteVo.credit_credit_fee }</td>
						</tr> 
                   	</tbody>
				</table>
			</div>
			<div class="affirm-warr">
				<p class="mt30 mb30">本报价仅基于目前贵司所提供的相关信息，以上报价不具任何约束性，并取决于所有完整的投保信息，包括但不限于：对于信用管理问卷的评估结果，买方信用限额的评估审批结果，经签字及确认的完整投保单，以及截至起保日的最新逾期账款账龄分析的评估结果等。
					在没有实质性风险及相关因素变化的前提下，本报价自发出日起的两个月内有效，但中国太平洋财产保险有限公司保留修改和撤回以上条件的权利。</p>
			</div>
			<div class="mess-title"><h3>保单申请</h3></div>
			<div class="affirm-warr">
				<p class="mt30 mb30">请在此确认贵司已了解并接受上述承保条件并同意本公司根据上述条件出具保单。且贵司已仔细阅读中国太平洋财产保险股份有限公司的“国内贸易信用保险”(报备编号：（太保财险）（备-责任）[2011]（主）7号)， 包括除外责任及被保险人义务等条款内 容，并对保险公司就保险条款内容的说明和提示完全理解。</p>
			</div>
		</div><!-- w-95-auto end -->
	</div><!-- message-war end -->
	<div class="row next-step">
		<div class="col-sm-6 col-sm-6">
			<div class="insure-check">
				<span class="check-box pull-left">
					<input type="checkbox" id="checkbox1_ss" />
					<label for="checkbox1_ss"></label>
				</span>
				<span class="pull-left">我已仔细阅读并确认以上信息</span><br /> 
			</div> 
		</div>
		<div class="col-sm-3 col-xs-3 text-right pull-right">
			<p>
				<a href="javascript:void(0);" onclick="validateChecked('${ dto.oid}');" id="validatePost" class="ns-btn">确认报价</a>
			</p>
		</div>
	</div>
</div><!-- container end --> 

<!-- 内容部分  注册  结束 -->
<jsp:include page="../../../index/multi_f.jsp" />
<!-- script -->
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';
	function validateChecked(_id){
		if($("#checkbox1_ss").is(':checked')){
			var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
			var feesFor = '${ dto.feesFor}';
			var status = '5';
			if(feesFor == '1'){
				status = '4';
			}else if(feesFor == '2'){
				status = '5';
			}
			$.ajax({
				type: 'POST',
				url:baseUrl + '/insurance/customs/policy/updateOrderFormStatus',
				data:{
					'order_id':_id,
					'status':status
				},
				dataType:"json",
				success: function(json){
					layer.close(index);
					if(json.statusCode == '200') {
						window.location.href = baseUrl + '/insurance/customs/policy/policyPayment/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
					}else{
						layer.msg(json.message);
					}
				},
				error : function(XMLHttpRequest, textStatus, errorThrown) {
					layer.close(index);
					layer.msg(textStatus);
				}
			});
		}else{
			layer.msg("请勾选“我已仔细阅读并确认以上信息”！");
		}
			
	}
	
</script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/jquery.form.js'/>"></script>
</body>
</html>