<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-支付保费</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" /> 
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	   	
	   	<style type="text/css" media=print>
			.noprint{display : none}
			.container,.payment-order,.paor-sub{
				width: 100%;margin: 0px;padding: 0px;
			}
			.paor-content,.paor-conlist{
				border: 1px solid #000000;
			}
			#kf5-support-123456789{
				display : none;
			}
		</style>
	</head>
	<OBJECT classid="CLSID:8856F961-340A-11D0-A96B-00C04FD705A2" height="0" id="printWB" name="printWB" width="0"></OBJECT>
<body style="background: rgba(244,245,246,1);">
<div id="header" class="noprint">
<jsp:include page="../../index/multi_h.jsp"/>
</div>
<div class="container" style="padding-bottom: 50px; padding-top: 20px;"><!-- container start -->
	<ol class="breadcrumb noprint">
	  <%--<li><a href="<c:url value='/'/>">首页</a></li>
	  <li><a href="<c:url value='/synopsis/product/productAllView'/>">产品列表</a></li>
	  <li><a href="<c:url value='/insurance/${policy.agreementSpec.groupType.name }/product/productInfo/${dto.product_oid}'/>">产品详情</a></li>
	  <li class="active">支付保费</li>--%>
	</ol>
	<div class="nav-list noprint">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 active">
				<p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 pull-right">
				<p><i class="pull-left">4</i><span class="pull-left">完成投保</span></p>
			</div>
		</div>
	</div>
	<div class="payment-order">
		<div class="paor-sub">
			<div class="paor-content">
				<%--<h3>${policy.insuranceCompany.name }</h3>
				<h4>${policy.insuranceCompany.name_en }</h4>--%>
					<h3>中国太平洋财产保险股份有限公司</h3>
					<h4>China Pacific Property Insurance Co.,Ltd</h4>
				<h5>保费通知书</h5>
				<div class="row paor-context">
					<div class="col-lg-7 col-sm-7"><strong>致尊敬的客户</strong></div>
					<div class="col-lg-5 col-sm-5">
						<p class="clearfix"><span>日期：</span><label><fmt:formatDate value='${nowTime }' pattern='yyyy年MM月dd日' /></label></p>
						<%--<p class="clearfix"><span>帐户名:  </span><label>${policy.insuranceCompany.bankAccountName }</label></p>
						<p class="clearfix"><span>地址：</span><label>${policy.insuranceCompany.registeredAddress }</label></p>
						<p class="clearfix"><span>开户行: </span><label>${policy.insuranceCompany.bankName }</label></p>
						<p class="clearfix"><span>帐号：</span><label>${policy.insuranceCompany.bankAccount }</label></p>--%>
						<p class="clearfix"><span>帐户名:  </span><label>中国太平洋财产保险股份有限公司厦门分公司</label></p>
						<p class="clearfix"><span>地址：</span><label>厦门湖滨西路9号大西洋中心25楼</label></p>
						<p class="clearfix"><span>开户行: </span><label>厦门市建设银行营业部</label></p>
						<p class="clearfix"><span>帐号：</span><label>35101535001050006433</label></p>
					</div>
				</div>
				<div class="row paor-conlist">
					<div class="paor-lsub">
						<div class="col-lg-5 col-sm-5">
						<p><span>险种</span></p>
						<p>${dto.product_name }</p>
						</div>
						<div class="col-lg-3 col-sm-3">
							<p><span>保险金额（元）</span></p>
							<p>${dto.insured_amount}</p>
						</div>
						<div class="col-lg-2 col-sm-2 col-lg-offset-2 col-sm-offset-2">
							<p><span>保险费（元）</span></p>
							<p>${dto.gross_premium}</p>
						</div>
					</div>
					<div class="col-lg-3 col-sm-3 col-lg-offset-9 col-sm-offset-9"><strong>合计：${dto.gross_premium}元</strong></div>
				</div>
				<div class="paor-cofoot"><h6 class="pull-right">中国太平洋财产保险股份有限公司厦门分公司<%--${policy.insuranceCompany.bankAccountName }--%></h6></div>
			</div>
			<div class="row next-step noprint">
				<div class="col-lg-6 col-sm-6">
				<p>请打印付款通知书，缴费完需到此上传付款凭证。</p>
				<p>同时您还需要打印投保单将其盖上贵公司公章并到此上传。</p>
				</div>
				<div class="col-sm-6 col-xs-6 text-right pull-right">
					<p>
						<a href="javascript:void(0);" onclick="showPaymentModal();" class="ns-btn" style="margin-left: 10px;">上传付款凭证</a>
						<%--<a href="javascript:void(0);" onclick="showInsureModal();" class="ns-btn" style="margin-left: 10px;">上传投保单</a>--%>
						<a href="javascript:void(0);" onclick="printPaymentNotice();" class="gray-btn" style="margin-left: 10px;">打印付款通知书</a>
						<%--<a href="javascript:void(0);" onclick="showPrintPolicyModal('${policy.oid}');" class="gray-btn" style="margin-left: 10px;">打印投保单</a>--%>
<%-- 						<a target="_blank" href="<c:url value='/insurance/transaction/printPolicy/${policy.oid}'/>" class="gray-btn" style="margin-left: 10px;">打印投保单</a> --%>
					</p>
				</div>
			</div>
		</div>
	</div> 
</div><!-- container end --> 


<div class="modal fade" id="insureModal" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
   <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header bg-1f96ef">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">上传投保单</h4>
		  </div>
		  <form id="insureForm" method="post" enctype="multipart/form-data" action='<c:url value="/insurance/transaction/uploadInsureFile.json?ACCESS_TOKEN=${ACCESS_TOKEN}"/>' >
		  	<input name="oid" value="${dto.oid}" type="hidden"/>
			  <div class="modal-body">
			  	<div class="col-sm-12 col-xs-12" style="margin-top: 8px;">
					<div class="col-sm-12 col-xs-12" id="insurePath_isHidden">
						<div class="basic-file">
							<input data-drawview="${dto.insure_path }" name="insurePath_file" id="insurePath_file-5" class="file" type="file" data-drawview="" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
						</div> 
					</div> 
			  	</div> 
			  </div>
			  <div class="modal-footer">
				<div class="mofo-sub">
					<button type="button" class="btn pull-left cancel-btn" data-dismiss="modal">取消</button>
					<button type="button" class="btn notarize-btn pull-right" onclick="uploadInsure();">确认</button>
				</div>
			  </div> 
		  </form> 
		</div> 
  </div> 
</div>

<div class="modal fade" id="paymentModal" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
   <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header bg-1f96ef">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">上传付款凭证</h4>
		  </div>
		  <form id="paymentForm" method="post" enctype="multipart/form-data" action='<c:url value="/insurance/transaction/uploadPayMentFile.json?ACCESS_TOKEN=${ACCESS_TOKEN}"/>' >
		  	<input name="oid" value="${dto.oid}" type="hidden"/>
			  <input type="hidden" name="gross_premium" id="grossPremium" value="${dto.gross_premium }">
			  <input type="hidden" name="payment_path" id="paymentPath" value="${dto.pay_order_url }">
			  <div class="modal-body">
			  	<div class="col-sm-12 col-xs-12" style="margin-top: 8px;">
					<div class="col-sm-12 col-xs-12" id="paymentPath_isHidden">
						<div class="basic-file">
							<input data-drawview="${dto.pay_order_url }" name="paymentPath_file" id="paymentPath_file-5" class="file" type="file" data-drawview="" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
						</div> 
					</div> 
			  	</div> 
			  </div>
			  <div class="modal-footer">
				<div class="mofo-sub">
					<button type="button" class="btn pull-left cancel-btn" data-dismiss="modal">取消</button>
					<button type="button" class="btn notarize-btn pull-right" onclick="uploadPayment();">确认</button>
				</div>
			  </div> 
		  </form> 
		</div> 
  </div> 
</div>
<div id="footer" class="noprint">
<jsp:include page="../../index/multi_f.jsp" />
</div>
<!-- script -->
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';
    function clearBase64Byinput(_el){
        var _file_id = _el.id;
        _file_id = _file_id.substring(0,_file_id.length-7);
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        $("#"+_file_id).val('');
    }
    function base64convert(_el,_file){
        var flag = false;
        var fileName = _file.name;
        var type = fileName.split(".")[fileName.split(".").length-1];

        var fileKeyName = "/policy/"+fileName;
        var _file_id = _el.attr("name").replace("_file","").trim();
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        ajaxFormDataLoad(_file,_file_id,"policy/",type);
        flag = true;
        return flag;
    }

    function ajaxFormDataLoad(file,_id,directoryName,fileType){
        var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
        var _myData = new Date();
        var _times = _myData.getTime();
        var name = "/"+directoryName+_times+"."+fileType;
        var formData = new FormData();
        formData.append('file', file);
        formData.append('fileName', _times+"."+fileType);
        formData.append('directoryName', directoryName);
        var uul = baseUrl + '/file/ajaxFormDataLoad';
        $.ajax({
            type: 'POST',
            url: uul,
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(result){
                layer.close(index);
                if(result.statusCode == '200'){
                    $("#"+_id).val(result.message);
                }else{
                    layer.msg(result.message);
                }
            }
        });
    }

    function ajaxFormDataDelete(_id){
        var formData = new FormData();
        formData.append('url', $("#"+_id).val());
        var uul = baseUrl + '/file/ajaxFormDataDelete';
        $.ajax({
            url: uul,
            type: 'POST',
            cache: false,
            data: formData,
            processData: false,
            contentType: false
        }).done(function(res) {
            $("#"+_id).val('');
        }).fail(function(res) {

        });
    }
	function showPaymentModal(){
		$("#paymentModal").modal("show");
	}
	
	function showInsureModal(){
		$("#insureModal").modal("show");
	}
	
	function showPrintPolicyModal(policyId){
		layer.open({
			  type: 2,
			  title:'投保单预览',
			  scrollbar: false,
			  area : [ '70%', '90%' ],
			  shade : 0.8,
			  skin: 'agreementModal',
			  btn: ['打印','取消'],
			  content: baseUrl +'/insurance/transaction/printPolicy/'+policyId+'?ACCESS_TOKEN=${ACCESS_TOKEN}', //iframe的url
			  yes:function(indexIframe, layero){
			    var iframeWin = window[layero.find('iframe')[0]['name']]; //得到iframe页的窗口对象，执行iframe页的方法：iframeWin.method();
			    iframeWin.printPage();
			  }
		});
	}
	
	function printPaymentNotice(){
		$(".payment-order").removeClass("noprint");
		try{
			document.all.printWB.ExecWB(7,1);
		}catch (e) 
		{ 
// 			alert("浏览器不支持打印预览或者IE设置不允许ActiveX控件(设置IE允许ActiveX控件方能打印预览)\n"+e);
			window.print();
		}
	}
	
	function uploadPayment(){
		var policyId = $("#policyId").val();
		var paymentPath = $("#paymentPath_file-5").val();
		 if(paymentPath ==""){
			layer.msg("请选择缴费凭证");
		}
		else{
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$("#paymentForm").ajaxSubmit({
				success : function(data) {
					layer.close(index);
					layer.msg(data.message);
					if(data.statusCode == "200"){
						$("#paymentModal").modal("hide");
						if(data.navTabId=='true')
							setTimeout(function() {
								location.href=baseUrl + '/insurance/transaction/finishPay/${dto.oid}?ACCESS_TOKEN=${ACCESS_TOKEN}';
					        },2000);
						else
							window.location.reload();//刷新当前页面.
					}
				},
				error : function() {
					layer.close(index);
					alert('error');
				}
			});
		}
	}
	
	function uploadInsure(){
		var insurePath = $("#insurePath_file-5").val();
		 if(insurePath ==""){
			layer.msg("请选择投保单");
		}
		else{
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$("#insureForm").ajaxSubmit({
				success : function(data) {
					layer.close(index);
					layer.msg(data.message);
					if(data.statusCode == "200"){
						$("#insureModal").modal("hide");
						if(data.endUpload)
							setTimeout(function() {
								location.href=baseUrl + '/insurance/transaction/finishPay/${dto.oid}?ACCESS_TOKEN=${ACCESS_TOKEN}';
					        },2000);
						else
							window.location.reload();//刷新当前页面.
					}
				},
				error : function() {
					layer.close(index);
					alert('error');
				}
			});
		}
	}
</script>

<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/jquery.form.js'/>"></script>
</body>
</html>