<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-支付保费</title>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" />
		<!--[if lt IE 9]>
	   	<![endif]-->
		<style>
			.img_s img{ margin-left: 75px;}
			.modal-content .bg-1f96ef {
				background: #ff8b00;
			}
		</style>
	</head>

<body style="background: rgba(244,245,246,1);">
<jsp:include page="../../../index/multi_h.jsp"/>
<div class="container" style="padding-bottom: 50px; padding-top: 20px;"><!-- container start -->
	<ol class="breadcrumb" id="bread_crumbs">
	</ol>
	<div class="nav-list">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 active">
				<p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 pull-right">
				<p><i class="pull-left">4</i><span class="pull-left">完成投保</span></p>
			</div>
		</div>
	</div>
	<form class="form-horizontal form-create-item" method="post" id="policyPaymentForm">
		<input name="policyId" value="${dto.oid}" type="hidden"/>
		<div class="message-war"><!-- message-war start -->
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="p-table">
						<table class="table">
							<thead>
								<tr>
								  <th>产品名称</th>
								  <th>保障期限</th>
								  <th>保费</th>
								</tr>
							</thead>
							<tbody>
								<tr>
								  <td>${dto.product_name}</td>
								  <td>${dto.inception_date} 至 ${dto.planned_end_date}</td>
								  <td>${dto.gross_premium}元</td>
								</tr>
							  </tbody>
						</table>
					</div>
				<p class="fs16">所需支付金额￥${dto.gross_premium}</p>
				<div class="bg-f5f8fa">选择支付方式&nbsp;&nbsp;&nbsp;&nbsp;<span style="color: #ff0000;">注：当前产品采用微信支付，建议使用IE内核浏览器，支持IE8以上版本，若使用其他浏览器可能出现支付失败。</span></div>
				<div class="row"><!-- 当个人支付生产测试通过后开启 -->
					<div class="col-sm-2 col-xs-2 rad-io mt-20">
						<span><input type="radio" name="policyPaymentType" value="1" id="radio1" checked="checked"><label for="radio1" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('radio1','radio');">微信支付</strong></span>
					</div>
				</div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
	</form>
	<div class="row next-step">
		<div class="col-sm-3 col-xs-3 text-right pull-right">
			<p><a href="javascript:void(0);" onclick="submitPayment();" class="ns-btn">立即支付</a></p>
		</div>
	</div>
</div><!-- container end -->
<!-- 立即支付 start -->
<div class="modal fade" id="pay-now" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
   <div class="modal-dialog" style="width: 800px;" role="document">
		<div class="modal-content" style="width: 800px;">
		  <div class="modal-header bg-1f96ef">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">微信支付</h4>
		  </div>
		  <div class="modal-body">
			  <div class="row w-80-auto">
				  <div class="col-sm-6 col-xs-6" style="border-right: 1px solid #eee;">
					  <%--<p class="text-center" style="color: #00B83F"><i class="glyphicon glyphicon-ok-circle pull-left" style="top: 3px;padding-left: 75px;padding-right: 5px;"></i><span class=" pull-left">支付成功!</span><div class="clear"></div></p>--%>
					  <p class="text-center" id="pay_success_msg">支付倒计时<strong id="pay_time">06:00</strong>，请及时付款</p>
					  <p class="text-center" id="img_s" style="position: relative;"><%--<img id="base64-img" width="200px" height="200px" src=""><span id="wed_pay" class="span_wed">-已失效-</span>--%></p>
					  <p class="text-center">请使用微信扫一扫完成支付</p>
				  </div>
				  <div class="col-sm-6 col-xs-6">
					  <div class="row w-80-auto">
						  <div class="col-sm-2 col-xs-2">
							  &nbsp;
						  </div>
						  <div class="col-sm-10 col-xs-10" style="margin-top: 10px;">
							  <h4>${dto.product_name}</h4>
							  <h3>￥<strong>${dto.gross_premium}</strong></h3>
							  <p ><span style="float: left;">订单号</span><span style="float: right;">${dto.trade_serial_number}</span></p>
							  <div class="clear"></div>
							  <p ><span style="float: left;">下单时间</span><span style="float: right;">${dto.start_time}</span></p>
							  <div class="clear"></div>
							  <%--<p ><a href="javascript:time_pay()">定时</a></p>--%>
						  </div>
					  </div>
				  </div>
			  </div>

		  </div>
		  <div class="modal-footer">
			<div class="mofo-sub">
			</div>
		  </div>
		</div>
  </div>
</div>
<!-- 立即支付 end -->
<a href="" id="gotoNewUrl" target="_blank"></a>
<jsp:include page="../../../index/multi_f.jsp" />
<!-- script -->
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/bootstrap.min.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/qrcode.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';
    var qrcode;
    $(function(){
        qrcode = new QRCode(document.getElementById("img_s"), {
            width : 200,
            height : 200
        });
        changeFrameSet(0,'');
	});
	function submitPayment() {

		var payType = $("input[name='policyPaymentType']:checked").val();
		if(payType == ''){
            layer.msg("请选择支付方式");
		}else{
		    var url = '${dto.show_url}';
		    if(url!=''){
                qrcode.makeCode(url);
                $("img[alt='Scan me!']").attr('style','display: block;margin-left: 75px;');
                $('#img_s').append('<span id="wed_pay" class="span_wed">-已失效-</span>');
                $('#pay-now').modal({backdrop: 'static', keyboard: false});
                time_pay();
            }else{
                layer.msg("二维码生成失败");
			}
		}
	}

	function checkToradio(_id, type){
		var o = $("#"+_id);
		if(type=="radio"){
			o.prop('checked',true);
		}
	}
    var wait_pay=360;
     function time_pay() {
     	if (wait_pay == 0) {
            $("#pay_time").html(qys(wait_pay));
            $("#wed_pay").css({'display':'block'});
            wait_pay = 360;
     	} else {
            $("#wed_pay").css({'display':'none'});
     		$("#pay_time").html(qys(wait_pay));
            dingshi();
            wait_pay--;
     		setTimeout(function() {
            	time_pay();
     		},1000);
     	}
     }
     function qys(i){
         var m = Math.floor((i / 60 % 60));
         var s = Math.floor((i % 60));
         if(s<10){
             s = '0' + s;
         }
         return '0' + m + ":" + s;
	 }
	 var isDo = 0;
    function dingshi(){
        if(wait_pay != 0 && wait_pay != 180){
            if(isDo == 0){
                isDo = 1;
                setTimeout(function() {
                    isDo = 0;
                    setTimeOutByPayMsg();
                },5000);
            }
        }

    }
    function setTimeOutByPayMsg(){
        $.ajax({
            type: 'POST',
            url:baseUrl + '/transaction/isPaySuccess/${dto.oid}',
            dataType:"json",
            async:false,
            success: function(json){
                if(json.status == '200') {//支付成功
                    wait_pay = 0;
                    $("#pay_success_msg").attr("style","color: #00B83F;");
                    $("#pay_success_msg").html('<i class="glyphicon glyphicon-ok-circle pull-left" style="top: 3px;padding-left: 75px;padding-right: 5px;"></i><span class=" pull-left">支付成功!</span><div class="clear"></div>');
                    var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
                    layer.msg("正在处理数据（1~2分钟），请耐心等待...", {time:5000});
                    getPM();//定时180秒查询是否承保，如果承保就跳转完成页面
                }
                if(json.status == '300') {
                    dingshi();
                }
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                layer.msg(textStatus);
            }
        });
    }

    var pm=360;
    function getPM() {
        if (pm == 0) {
            pm = 360;
        } else {
            pm = pm-5;
            setTimeout(function() {
                locationPolicyMsg();
            },5000);
        }
    }
    function locationPolicyMsg(){
        $.ajax({
            type: 'POST',
            url:baseUrl + '/transaction/isPolicyUnderwrite/${dto.oid}',
            dataType:"json",
            async:false,
            success: function(json){
                if(json.status == '200') {//支付成功
                    location.href=baseUrl + '/transaction/common-syntony/${dto.oid}?ACCESS_TOKEN=${ACCESS_TOKEN}';
                }
                if(json.status == '300') {
                    getPM();
                }
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                layer.msg(textStatus);
            }
        });
    }
</script>
</body>
</html>