<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
<head>
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" />
	<!--[if lt IE 9]>
	<script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	<script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	<![endif]-->
</head>
<body>
<jsp:include page="../../../index/multi_h.jsp"/>
<div class="container"><!-- container start -->
	<ol class="breadcrumb" id="bread_crumbs">
	</ol>
	<div class="nav-list">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 active">
				<p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 pull-right">
				<p><i class="pull-left">4</i><span class="pull-left">完成投保</span></p>
			</div>
		</div>
	</div>
	<div class="message-war"><!-- message-war start -->
		<h2>${ dto.product_name}</h2>
		<div class="w-95-auto"><!-- w-95-auto start -->
			<h5>订单号码：${ dto.trade_serial_number}</h5>
			<div class="mess-title"><h3>推荐人信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">推荐人的手机号或编号</td>
						<td class="col-sm-4 col-xs-4">${empty vo.recommend_code ? '无' : vo.recommend_code}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
						<td class="col-sm-4 col-xs-4"></td>
					</tr>
					</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>投/被保人信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
						<tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">姓名</td>
							<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].name_cn}</td>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">性别</td>
							<td class="col-sm-4 col-xs-4">${empty vo.roleSubjectList[0].sex ? '':vo.roleSubjectList[0].sex eq '1'?'男':'女'}</td>
						</tr>
						<tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件类型</td>
							<td class="col-sm-4 col-xs-4">
								<c:forEach items="${typeList }" var="list">
									<c:if test="${list.value eq vo.roleSubjectList[0].id_type}">
										${list.name}
									</c:if>
								</c:forEach>
							</td>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件号码</td>
							<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].organization_code}</td>
						</tr>
						<tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">出生日期</td>
							<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].birth_date}</td>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">手机号码</td>
							<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].mobile}</td>
						</tr>
						<tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">健康状况</td>
							<td class="col-sm-4 col-xs-4">${empty vo.roleSubjectList[0].health ? '':
									vo.roleSubjectList[0].health eq '01'?'健康或良好':
											vo.roleSubjectList[0].health eq '02'?'一般或较弱':
													vo.roleSubjectList[0].health eq '03'?'有慢性病':
															vo.roleSubjectList[0].health eq '04'?'心血管病':
																	vo.roleSubjectList[0].health eq '05'?'脑血管病':
																			vo.roleSubjectList[0].health eq '06'?'慢性呼吸系统病':
																					vo.roleSubjectList[0].health eq '07'?'慢性消化系统病':
																							vo.roleSubjectList[0].health eq '08'?'慢性肾炎':
																									vo.roleSubjectList[0].health eq '09'?'结核病':
																											vo.roleSubjectList[0].health eq '10'?'糖尿病':
																													vo.roleSubjectList[0].health eq '11'?'神经或精神疾病':
																															vo.roleSubjectList[0].health eq '12'?'癌症':
																																	vo.roleSubjectList[0].health eq '13'?'其他慢性病':
																																			vo.roleSubjectList[0].health eq '14'?'残疾':
																																					vo.roleSubjectList[0].health eq '15'?'视力残疾':
																																							vo.roleSubjectList[0].health eq '16'?'听力残疾':
																																									vo.roleSubjectList[0].health eq '17'?'语言残疾':
																																											vo.roleSubjectList[0].health eq '18'?'肢体残疾':
																																													vo.roleSubjectList[0].health eq '19'?'智力残疾':
																																															vo.roleSubjectList[0].health eq '20'?'精神残疾':
																																																	vo.roleSubjectList[0].health eq '21'?'多重残疾':
																																																			vo.roleSubjectList[0].health eq '22'?'其他残疾':
																																																					'其他'}</td>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">是否参加医疗</td>
							<td class="col-sm-4 col-xs-4">${empty vo.roleSubjectList[0].health_flag ? '':vo.roleSubjectList[0].health_flag eq '1'?'是':'否'}</td>
						</tr>
						<tr>
							<td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系地址</td>
							<td class="col-sm-10 col-xs-10" colspan="3">
								${reg_role}
								${vo.roleSubjectList[0].reg_address}
							</td>
						</tr>
					</tbody>
				</table>
			</div>

			<div class="mess-title"><h3>投保计划信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">保险期间</td>
						<td class="col-sm-4 col-xs-4">自 ${ vo.inception_date } 零时起，至 ${ vo.planned_end_date } 二十四时止</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">保障天数</td>
						<td class="col-sm-4 col-xs-4" id="days"></td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">司法管辖</td>
						<td class="col-sm-10 col-xs-10" colspan="3">中华人民共和国司法管辖（港澳台除外）</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">争议处理</td>
						<td class="col-sm-10 col-xs-10" colspan="3">若投保人/被保险人与保险人发生争执，不能达成协议，被保险人自愿采取的解决方式：${ vo.dispute eq '0' ? '诉讼' : '仲裁，仲裁机构' }&nbsp;&nbsp;${vo.dispute eq '0' ? '': vo.arbitral_institution}</td>
					</tr>
					</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>投保计划信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
					<%--<tr>
						<td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">保障方案</td>
						<td colspan="3" class="col-sm-10 col-xs-10" style="padding: 0">
							<table class="table">
								<tbody>
								<tr style="border-bottom: 1px solid #e6eaee;">
									<td class="col-sm-6 col-xs-6">保障责任</td>
									<td class="col-sm-6 col-xs-6">保障金额</td>
								</tr>
								<c:forEach items="${ dto.responsibilityVoList }" var="irp" varStatus="index">
									<tr ${(index.index+1) != dto.responsibilityVoList.size()? 'style="border-bottom: 1px solid #e6eaee;"' : ''} >
										<td class="col-sm-6 col-xs-6" >${irp.name}</td>
										<td class="col-sm-6 col-xs-6" >
											<c:choose>
												<c:when test="${empty irp.insurance_amount_max && not empty irp.fcy}">
											<span>
												<c:if test="${ empty irp.fcy}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元/天
													</c:if>
												</c:if>
											</span>
												</c:when>
												<c:when test="${empty irp.fcy && not empty irp.insurance_amount_max}">
											<span>
												<c:if test="${ empty irp.insurance_amount_max}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元/天
													</c:if>
												</c:if>
											</span>
												</c:when>
												<c:otherwise>
													<span>-</span>
												</c:otherwise>
											</c:choose>
										</td>
									</tr>
								</c:forEach>
								</tbody>
							</table>
						</td>
					</tr>--%>
					<tr>
						<td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">保障方案</td>
						<td colspan="3" class="col-sm-10 col-xs-10">
							<table class="table ">
								<tbody>
								<tr>
									<td class="col-sm-4 col-xs-4">保障责任</td>
									<td class="col-sm-2 col-xs-2">
										<c:set var="irp_1" value="${ vo.responsibilityVoList[0] }"></c:set>
										<c:choose>
											<c:when test="${empty irp_1.insurance_amount_max && not empty irp_1.fcy}">
												保险金额
											</c:when>
											<c:when test="${empty irp_1.fcy && not empty irp_1.insurance_amount_max}">
												赔偿限额
											</c:when>
											<c:otherwise>
												保险金额
											</c:otherwise>
										</c:choose>
									</td>
									<td class="col-sm-2 col-xs-2">免赔额</td>
									<td class="col-sm-2 col-xs-2">赔付比例</td>
									<td class="col-sm-2 col-xs-2">免赔天数</td>
								</tr>
								<c:forEach items="${ vo.responsibilityVoList }" var="irp">
									<tr <c:choose>
										<c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '0' && irp.is_optional eq '2'}">
											hidden
										</c:when>
										<c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '1' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障一')}">
											hidden
										</c:when>
										<c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '2' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障二')}">
											hidden
										</c:when>
										<c:when test="${empty vo.is_contain_repo && irp.is_optional eq '2'}">
											hidden
										</c:when>
										<c:otherwise>

										</c:otherwise>
									</c:choose>>
										<td class="col-sm-4 col-xs-4" style="text-align:left; <c:if test="${irp.name eq '烈士褒扬金'}">color: red;</c:if>">${irp.name}<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="${irp.explain_product}"/></td>
										<td class="col-sm-2 col-xs-2" <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>
											<c:choose>
												<c:when test="${empty irp.insurance_amount_max && not empty irp.fcy}">
											<span>
												<c:if test="${ empty irp.fcy}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元/天
													</c:if>
												</c:if>
											</span>
												</c:when>
												<c:when test="${empty irp.fcy && not empty irp.insurance_amount_max}">
											<span>
												<c:if test="${ empty irp.insurance_amount_max}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元/天
													</c:if>
												</c:if>
											</span>
												</c:when>
												<c:otherwise>
													<span>-</span>
												</c:otherwise>
											</c:choose>
										</td>
										<td class="col-sm-2 col-xs-2" >${empty irp.cumulative_deductibles ? '-' : irp.cumulative_deductibles}</td>
										<td class="col-sm-2 col-xs-2" >${empty irp.compensation_ratio ? '-' : irp.compensation_ratio}${not empty irp.compensation_ratio ? '%' : ''}</td>
										<td class="col-sm-2 col-xs-2" >${empty irp.deductible_days ? '-' : irp.deductible_days}</td>
									</tr>
								</c:forEach>
								</tbody>
							</table>
						</td>
					</tr>
					</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>投保声明</h3></div>
			<div class="affirm-warr">
				<p class="mt30" style="font-weight: bold">1、投保人通过合法途径获得团体授权，向保险人投保本险种，所有投保操作和内容已获得认可，所有被保险人均为与投保单位有劳动关系的劳动者，该产品的保障内容以及保险金额已向被保险人进行了明确说明，并征得其同意。</p>
				<p style="font-weight: bold">2、投保人已就保险事宜与全部被保险人进行了宣导和沟通，凡参与该保险的全部被保险人均符合险种条款所约定（包括但不限于责任免除、投保人被保险人义务、保险金申请与给付等）的投保条件，并了解保障内容且同意由投保人统一办理投保事项，投保人已认真阅读并正确理解条款和投保须知的所有内容，并接受上述内容，同意以此作为订立保险合同的依据。</p>
				<p class="mb30" style="font-weight: bold">3、本产品投保填写以及所附的被保险人清单中的各项事实均属实，并作为本保险合同的组成部分，如有隐瞒或不实告知，投保人愿承担由此带来的法律后果，保险人有权解除保险合同，对于合同解除前发生的任何事故，保险人可不承担任何责任。</p>
			</div>
		</div><!-- w-95-auto end -->
	</div><!-- message-war end -->
	<div class="row next-step">
		<div class="col-sm-6 col-sm-6">
			<div class="insure-check">
				<span class="check-box pull-left">
					<input type="checkbox" id="checkbox1_ss" />
					<label for="checkbox1_ss"></label>
				</span>
				<span class="pull-left">本企业接受以上投保声明</span><br />
			</div>
			<p class="fs-20-cl">保费<strong class="fs-26"> ￥${ dto.gross_premium}</strong></p>
		</div>
		<div class="col-sm-3 col-xs-3 text-right pull-right">
			<p>
				<a href="<c:url value='/insurance/gyx/policy/policy/${vo.oid}?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="save">返回修改</a>
				<a href="javascript:void(0);" onclick="validateChecked('${vo.oid}');" id="validatePost" class="ns-btn">确认申请</a>
			</p>
			<!--确认投保单详情<p>
				<a href="javascript:;" class="save">下载保单</a>
				<a href="javascript:;" class="save ml-35">下载保函</a>
			</p>-->
		</div>
	</div>
</div><!-- container end -->
<jsp:include page="../../../index/multi_f.jsp" />
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/script/html2canvas.min.js' />"></script>
<%--<script type="text/javascript" src="<c:url value='/resources/commonJS/canvasFileUpload.js' />"></script>--%>
<!-- script -->
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb.min.js?1003' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb-save.js?1003' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/watermark.js?7' />"></script>
<script>
	window.onload = function () {
		//以后优化 频繁变更水印
		watermark.load({ watermark_txt: "${fns:getWatermark(dto.trade_serial_number)}" });
	}
    var baseUrl = '${pageContext.request.contextPath }';
    $(function(){
        <%--changeFrameSet(1,"<li>当前位置: 保障服务 </li><li> <a href='<c:url value="/api/gyx/product/productAllView" />'>产品列表</a> </li><li> <a href='<c:url value="/api/gmr/product/productInfo/${dto.product_oid}" />'>产品详情</a> </li><li> <span id='place'>填写投保单</span></li>");--%>
        changeFrameSet(0,'');//加载当前内容高度并重置iframe
        $("td").each(function(){
            var _class = $(this).attr("class");
            if(_class != undefined){
                if(_class.indexOf("tablebg_f5f8fa") == -1 && _class.indexOf("col-sm") != -1){
                    if($(this).prev().length==1){
                        var preClass = $(this).prev().attr("class");
                        if(preClass.indexOf("tablebg_f5f8fa") != -1){
                            var preVal = $(this).prev().html();
                            if(preVal != ''){
                                var _val = $(this).html();
                                if(_val == ''){
                                    $(this).html('-');
                                }
                            }
                        }else{
                            var _val = $(this).html();
                            if(_val == ''){
                                $(this).html('-');
                            }
                        }
                    }else{
                        var _val = $(this).html();
                        if(_val == ''){
                            $(this).html('-');
                        }
                    }


                }
            }
        });
        btnCount_Click();
		document.onmousedown = function(ev){
			ev = ev || window.event;
			var x=ev.clientX;
			var y=ev.clientY;
			insOperation('${dto.oid}','${dto.trade_serial_number}','投保信息确认');
			<%--insOperation2('${vo.oid}','','投保信息确认',x,y);--%>
		}
    });
    function validateChecked(_id){
        if($("#checkbox1_ss").is(':checked')){
            //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
            setParamDatas({'policyId':_id},baseUrl+'/insurance/gyx/transaction/API_Underwriting',false,true,function(data){
                if(data.statusCode == '200') {
                    //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
                    setParamDatas({'order_id':_id,'status':'4'},baseUrl+'/insurance/gyx/policy/updateOrderFormStatus',false,false,function(json){
                        if(json.statusCode == '200') {
                            //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
                            setParamDatas({'policyId':_id,'policyPaymentType':'7'},baseUrl+'/insurance/gyx/transaction/getPayUrlByTB',false,false,function(result){
                                if(result.statusCode == '200') {

									insOperation('${vo.oid}','','投保信息确认');
									window.open(result.forwardurl,'_parent');
									/*var _t = setInterval(function () {
										if(_tong==1){
											clearInterval(_t);
											window.open(result.forwardurl,'_parent');
										}
									},300);*/
                                }
                                if(result.statusCode == '300') {
                                    laySomenType(1,null,result.message,0);
                                }
                                if(result.statusCode == '301') {
                                    laySomenType(1,null,result.message,0);
                                }
                                dialogClose(true);
                            });
                        }else{
                            laySomenType(1,null,json.message,0);
                            dialogClose(true);
                        }
                    });
                }
                if(data.statusCode == '300') {
                    dialogClose(true);
                    laySomenType(1,null,data.message,0);
                }
            });

            /*var index = laySomenType(0,null,'',0);
            laySomenType(1,null,"核保过程可能需要1-2分钟，请勿关闭浏览！",5000);
            $.ajax({
                type: 'POST',
                timeout:120000,
                url:baseUrl + '/api/gyx/transaction/API_Underwriting',
                data:{
                    'policyId':_id
                },
                dataType:"json",
                async:false,
                success: function(json){
                    if(json.statusCode == '200') {
                        $.ajax({
                            type: 'POST',
                            url:baseUrl + '/api/gyx/policy/updateOrderFormStatus',
                            data:{
                                'order_id':_id,
                                'status':'4'
                            },
                            dataType:"json",
                            success: function(json){
                                if(json.statusCode == '200') {
                                    $.ajax({
                                        type: 'POST',
                                        url:baseUrl + '/api/gyx/transaction/getPayUrlByTB',
                                        data:{
                                            'policyId':_id,
											'policyPaymentType':'3'
										},
                                        dataType:"json",
                                        async:false,
                                        success: function(json){
                                            if(json.statusCode == '200') {
//                                                changeFrameHeight(700);
//                                                window.location.href = json.forwardurl;
                                                window.open(json.forwardurl,'_parent');
                                            }
                                            if(json.statusCode == '300') {
                                                laySomenType(1,null,json.message,0);
                                            }
                                            if(json.statusCode == '301') {
                                                laySomenType(1,null,json.message,0);
                                            }
                                            laySomenType(2,index,'',0);
                                        }
                                    });
                                }else{
                                    laySomenType(1,null,json.resultDto.message,0);
                                }
                            },
                            error : function(XMLHttpRequest, textStatus, errorThrown) {
                                laySomenType(2,index,'',0);
                                laySomenType(1,null,"（APP-GYX-051）订单数据丢失，请联系管理员！",0);
                            }
                        });
                    }
                    if(json.statusCode == '300') {
                        laySomenType(2,index,'',0);
                        laySomenType(1,null,json.message,0);
                    }
                },
                error:function(jqXHR, textStatus, errorThrown){
                    laySomenType(2,index,'',0);
                    if(textStatus=="timeout"){
                        laySomenType(1,null,"（APP-GYX-052）加载超时，请重试",0);
                    }else{
                        laySomenType(1,null,"（APP-GYX-053）订单信息处理过程出现异常，请联系管理员！",0);
                    }
                }
            });*/

        }else{
            laySomenType(1,null,"请勾选“本企业接受以上投保声明”！",0);
        }

    }
    function  btnCount_Click(){//d1失效日期，d2生效日期
        var d1 = '${dto.planned_end_date}';
        var d2 = '${dto.inception_date}';
        var days = '';
        if(d1 != '' && d2 != ''){
            days = DateDiff(d1,d2)+'天';
        }
        $("#days").html(days);
    }

    //计算天数差的函数，通用
    function  DateDiff(sDate1,  sDate2){    //sDate1和sDate2是2006-12-18格式
        var  aDate,  oDate1,  oDate2,  iDays
        aDate  =  sDate1.split("-")
        oDate1  =  new  Date(aDate[1]  +  '-'  +  aDate[2]  +  '-'  +  aDate[0])    //转换为12-18-2006格式
        aDate  =  sDate2.split("-")
        oDate2  =  new  Date(aDate[1]  +  '-'  +  aDate[2]  +  '-'  +  aDate[0])
        iDays  =  parseInt(Math.abs(oDate1  -  oDate2)  /  1000  /  60  /  60  /24) + 1    //把相差的毫秒数转换为天数
        return  iDays
    }
    function laySomenType(ty,idx,msg,times){//ty:layer类型，如0打开遮盖，1消息提示，2关闭遮盖层；win_sign:当前0内嵌或1外嵌
        if(win_sign == 0){//本站内嵌
            if(ty==0){//打开遮盖
                return parent.layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
            }else if(ty==1){//消息提示
                if(times == 0){
                    parent.layer.msg(msg);
                }else{
                    parent.layer.msg(msg, {time:times});
                }
            }else if(ty == 2){
                parent.layer.close(idx);
            }
        }else{//它站内嵌
            if(ty==0){//打开遮盖
                return layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
            }else if(ty==1){//消息提示
                if(times == 0){
                    layer.msg(msg);
                }else{
                    layer.msg(msg, {time:times});
                }
            }else if(ty == 2){
                layer.close(idx);
            }
        }
        return null;
    }
</script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/bootstrap.min.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
</body>
</html>