<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-产品详情</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   <![endif]-->
	</head>

<body style="background: rgba(244,245,246,1);">
	<jsp:include page="../../../index/multi_h.jsp"/>
	<div class="container" style="background: #FFFFFF;margin-bottom: 20px;margin-top: 20px;"><!-- container start -->
		<h3 class="text-center">小微企业身份校验</h3>
		<p class="w-700">您将要进行申请购买的产品为小微企业短期出口信用综合保险，为此需对贵公司的身份进行校验。
	请完整准确地填写以下基本信息以通过身份验证。其中，企业名称以《营业执照》为准，海关代码以《海关进出口货物收发货人报关注册登记证书》上10位或12为编码为准。</p>
		<form id="verifyForm">	
		<div class="enterprise-verify">
			<div class="clearfix">
				<div class="mt-20"><label>企业名称</label> <input type="text" name="name" id="name" class="form-control" /> </div>
				<div class="mt-20"><label>海关代码</label><input type="text" name="customs_code" id="customsCode" class="form-control" onblur="verifyInput(this)"/> </div>
				<div class="mt-20">
					<label>投保公司</label>
					<select class="form-control" name="insuranceType" id="insuranceType" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
						<option value="">--请选择--</option>
						<option value="1">太平洋保险</option>
						<option value="2">平安保险</option>
						<option value="3">阳光保险</option>
					</select>
				</div>
				<div>
					<label class="mt-20">验证码</label>
			  		<div class="row">
			  			<div class="col-sm-9 col-xs-9">
							<input type="text" class="form-control" id="ryzm_jy" name='j_captcha' onblur="checkYzm(this)" placeholder="请输入验证码">
							<span class="glyphicon form-control-feedback t-icon-m" aria-hidden="true"></span>
						</div>
						<div class="col-sm-3 col-xs-3 pl-0 br-img ryzm_width" style="padding-right: 0;"><img id="imageF_lp" src="<c:url value='/user/image.htm'/>" onclick="changeImg('imageF_lp')" width="100%" /></div>
			  		</div>
				</div>
			</div>
			<div class="enve-submit mt-20"><a href="javascript:void(0);" onclick="verifyOF()" class="register-btn">提交认证</a></div>
		</div>
		</form>
	</div><!-- container end --> 


	<!-- check-succeed start -->
	<div class="modal fade" id="check-succeed" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
	   <div class="modal-dialog" role="document">
			<div class="modal-content">
			  <div class="modal-header bg-1f96ef"> 
				<h4 class="modal-title text-center">检验成功！</h4>
			  </div>
			  <form>
				  <div class="modal-body">
				  	<p class="succeed-bg text-center"><i class="glyphicon glyphicon-ok text-center"></i></p>
				  	<p class="text-center mb-20">经系统校验，贵公司为小微企业，具有申请资格！</p>
				  </div>
				  <div class="modal-footer">
					<div class="mofo-sub"><!-- <c:url value='/insurance/customs/policy/${productDto.oid }'/> -->
						<button type="button" class="btn pull-left cancel-btn" data-dismiss="modal">取消</button>
						<button type="button" class="btn notarize-btn pull-right" onclick="xwAndmy('${productDto.oid }','S');" data-dismiss="modal">确认</button>
					</div>
				  </div> 
			  </form> 
			</div> 
	  </div>  
	</div> 
	<!-- check-succeed end -->
	
	<!-- lose-succeed start -->
	<div class="modal fade" id="lose-succeed" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
	   <div class="modal-dialog" role="document">
			<div class="modal-content">
			  <div class="modal-header bg-1f96ef"> 
				<h4 class="modal-title text-center">检验失败！</h4>
			  </div>
			  <form>
				  <div class="modal-body">
				  	<p class="loser-bg text-center"><i class="glyphicon glyphicon-remove"></i></p>
				  	<p class="text-center mb-20">经系统校验，贵公司非小微企业，不具申请资格，推荐您购买<a id="xwAndmyF_1" href="javascript:;">企业短期出口信用保险</a></p>
				  </div>
				  <div class="modal-footer">
					<div class="mofo-sub">
						<button type="button" class="btn pull-left cancel-btn" data-dismiss="modal">取消</button>
						<button type="button" class="btn notarize-btn pull-right" id="xwAndmyF_2" data-dismiss="modal">确认</button>
					</div>
				  </div> 
			  </form> 
			</div> 
	  </div>  
	</div> 
	<!-- lose-succeed end -->
	
	<jsp:include page="../../../index/multi_f.jsp" />
</body>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>

<script type="text/javascript">
var baseUrl = '${pageContext.request.contextPath }';
function verifyInput(_this){
	var cusCode = $(_this).val();
	if(cusCode.length != 12 && cusCode.length != 10){
		$(_this).val('');
		layer.msg("海关代码错误！");
	}
}
function xwAndmy(id,sg){
	if(sg == "S"){
		var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
        window.location.href = baseUrl + "/insurance/customs/policyInit/"+id+"?recommendCode=${recommendCode}&ACCESS_TOKEN=${ACCESS_TOKEN}";
		/*$.ajax({
			type: 'POST',
			url:baseUrl + "/insurance/customs/policy/createOrder/"+id+"?recommendCode=${recommendCode}",
			dataType:"json",
			success: function(json){
				layer.close(index);
				if(json.statusCode == '200') {
					window.location.href = baseUrl + '/insurance/customs/policy/'+json.resultDto.navTabId;
				}else{
					layer.msg(json.resultDto.message);
				}
			},
			error : function(XMLHttpRequest, textStatus, errorThrown) {
				layer.close(index);
				layer.msg(textStatus);
			}
		});*/
	}else if(sg == "F"){
		location.href= baseUrl + "/insurance/product/productInfo/"+id+"?ACCESS_TOKEN=${ACCESS_TOKEN}";
	}
}
function verifyOF(){
	var name = $("#name").val();
	var customsCode = $("#customsCode").val();
	var insuranceType = $("#insuranceType").val();
	if(name == ''||customsCode == ''||insuranceType == ''){
		layer.msg("请填写完整信息！");
	}else{
		$.ajax({
			type : 'POST',
			url : baseUrl + "/user/register/checkYzm.json",
			data : {
				'captcha' : $("#ryzm_jy").val()
			},
			dataType : "json",
			success : function(json) {
				if (json.statusCode == '300') {
		    		layer.msg("验证码错误！");
		    		changeImg('imageF_lp');
		    		$("#ryzm_jy").val($("#ryzm_jy").attr("defaultValue"));
		    		$("#ryzm_jy").focus();
				}else{
					changeImg('imageF_lp');
					$.ajax({
						type: 'POST',
						url: baseUrl + "/insurance/product/identityCheck.json",
						data:$("#verifyForm").serialize(),
						dataType:"json",
						async: false,
						success: function(json){
							if(json.statusCode == '301') {
								layer.msg(json.message);
							}else if(json.statusCode == '300') {
								$("#xwAndmyF_1").attr("onclick","xwAndmy('"+json.forwardUrl+"','F');");
								$("#xwAndmyF_2").attr("onclick","xwAndmy('"+json.forwardUrl+"','F');");
								$("#xwAndmyF_1").text(json.callbackType);
								$("#lose-succeed").modal('show');
							}else{
								$("#check-succeed").modal('show');
							}
						}
					}); 
				}
			}
		});
	}
}
/*** 修改验证码图*/
function changeImg(objId) {  
    $("#"+objId).hide().attr('src','<c:url value='/user/image.htm'/>'+ '?'+ Math.floor(Math.random() * 100)).fadeIn();  
}
</script>
</html>
