<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-填写投保单</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" /> 
	</head>
<body style="background: rgba(244,245,246,1);">
<jsp:include page="../../../index/multi_h.jsp"/>

<div class="container" style="padding-bottom: 50px; padding-top: 20px;"><!-- container start -->
	<%--<ol class="breadcrumb">
	  <li><a href="<c:url value='/'/>">首页</a></li>
	  <li><a href="<c:url value='/synopsis/product/productAllView'/>">产品列表</a></li>
	  <li><a href="<c:url value='/insurance/product/productInfo/${dto.product_oid}'/>">产品详情</a></li>
	  <li class="active">投保</li>
	</ol>   --%>
	<div class="nav-list">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4 active">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-3">
				<p><i class="pull-left">3</i><span class="pull-left">投保信息审核</span></p>
			</div>
			<div class="col-sm-3 col-sm-3 pull-right">
				<p><i class="pull-left">4</i><span class="pull-left"> 缴费通知</span></p>
			</div>
		</div>
	</div>
	<form class="form-horizontal form-create-item"  action="<c:url value='/insurance/customs/policy/confirmPage?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" method="post" id="policyInfoForm">
        <input type="hidden" name="oid" id="policyOid" value="${dto.oid}"/>
		<input type="hidden" name="product_id" id="product_oid" value="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}"/>
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>7.公司信用管理 In-house Credit Management</h3></div> 
			<div class="row w-95-auto"><!-- w-95-auto start --> 
				<div class="col-sm-12 col-xs-12">
					<p>何时开具发票?  When are invoices issued?</p> 
				</div> 
				<div class="col-sm-4 col-xs-4">
					<p>*货物发送日后Day after despatch/delivery</p>
					<input Data-Val="Required" placeholder="请输入天数" name="delivery" id="delivery" value="${vo.delivery}" class="form-control">
				</div> 
				<div class="col-sm-4 col-xs-4 col-sm-offset-4 col-xs-offset-4">
					<p>*其它 – 请注明何时  Other – please state when</p>
					<input Data-Val="Required" placeholder="" name="other_date" id="otherDate" value="${vo.other_date}" onclick="laydate({elem: '#otherDate', format: 'YYYY-MM-DD'})" class="laydate-icon form-control">
						</div>
						<div class="col-sm-12 col-xs-12">
							<p>负责信用风险控制和管理人员的详细资料<br/>Details of all staff with responsibility for credit risk management and control:</p>
						</div> 
						<div class="col-sm-4 col-xs-4">
							<p class="text-center">职务 Job Title</p>
						</div>
						<div class="col-sm-4 col-xs-4">
							<p class="text-center">职责范围 Responsibility</p>
						</div>
						<div class="col-sm-4 col-xs-4">
							<p class="text-center">授权等级 Level of Authority</p>
						</div>
						
						<div class="clearfix">
						<input type="hidden" name="managerDetailList[0].oid" id="management_oid_0" value="${vo.managerDetailList[0].oid}">
							<div class="col-sm-4 col-xs-4 mt-20"> 
							<input type="text" name="managerDetailList[0].job_title" id="management_jobTitle_0" value="${vo.managerDetailList[0].job_title}" class="form-control" placeholder="" />
							</div>
							<div class="col-sm-4 col-xs-4 mt-20"> 
								<input type="text" name="managerDetailList[0].responsibility" id="management_responsibility_0" value="${vo.managerDetailList[0].responsibility}" class="form-control" placeholder="" />
							</div>
							<div class="col-sm-4 col-xs-4 mt-20"> 
								<input type="text" name="managerDetailList[0].level" id="management_level_0" value="${vo.managerDetailList[0].level}" class="form-control" placeholder="" />
							</div>
						</div>
						<div class="clearfix">
						<input type="hidden" name="managerDetailList[1].oid" id="management_oid_1" value="${vo.managerDetailList[1].oid}">
							<div class="col-sm-4 col-xs-4 mt-20"> 
							<input type="text" name="managerDetailList[1].job_title" id="management_jobTitle_1" value="${vo.managerDetailList[1].job_title}" class="form-control" placeholder="" />
							</div>
							<div class="col-sm-4 col-xs-4 mt-20"> 
								<input type="text" name="managerDetailList[1].responsibility" id="management_responsibility_1" value="${vo.managerDetailList[1].responsibility}" class="form-control" placeholder="" />
							</div>
							<div class="col-sm-4 col-xs-4 mt-20"> 
								<input type="text" name="managerDetailList[1].level" id="management_level_1" value="${vo.managerDetailList[1].level}" class="form-control" placeholder="" />
							</div>
						</div>
						<div class="clearfix">
						<input type="hidden" name="managerDetailList[2].oid" id="management_oid_2" value="${vo.managerDetailList[2].oid}">
							<div class="col-sm-4 col-xs-4 mt-20"> 
							<input type="text" name="managerDetailList[2].job_title" id="management_jobTitle_2" value="${vo.managerDetailList[2].job_title}" class="form-control" placeholder="" />
							</div>
							<div class="col-sm-4 col-xs-4 mt-20"> 
								<input type="text" name="managerDetailList[2].responsibility" id="management_responsibility_2" value="${vo.managerDetailList[2].responsibility}" class="form-control" placeholder="" />
							</div>
							<div class="col-sm-4 col-xs-4 mt-20"> 
								<input type="text" name="managerDetailList[2].level" id="management_level_2" value="${vo.managerDetailList[2].level}" class="form-control" placeholder="" />
							</div>
						</div>
						
						<div class="col-sm-12 col-xs-12">
							<p>是否每个客户都被授予内部信用额度?<br/>Is each customer allocated an internal credit limit?</p>
						</div>
						<div class="col-sm-2 col-xs-2 rad-io">
							<span><input type="radio" name="is_creditlimit" id="isCreditlimit_1" value="1" <c:if test="${not empty vo.is_creditlimit && vo.is_creditlimit eq '1' }"> checked="checked"</c:if>><label for="isCreditlimit_1" class="pull-left"></label><strong class="pull-left">是 Yes</strong></span>
						</div>
						<div class="col-sm-2 col-xs-2 rad-io">
							<span><input type="radio" name="is_creditlimit" id="isCreditlimit_2" value="0" <c:if test="${empty vo.is_creditlimit}"> checked="checked"</c:if> <c:if test="${not empty vo.is_creditlimit && vo.is_creditlimit eq '0' }"> checked="checked"</c:if>><label for="isCreditlimit_2" class="pull-left"></label><strong class="pull-left">否 No</strong></span>
						</div>
						<div id="isCreditlimit1" <c:if test="${empty vo.is_creditlimit}"> style="display: none;"</c:if> <c:if test="${not empty vo.is_creditlimit && vo.is_creditlimit eq '0' }"> style="display: none;"</c:if>>
						<div class="col-sm-12 col-xs-12">
							<p>*如果以上回答为“是”，请提供内部信用额度审批所依据信息的主要获取渠道（如付款表现，企业年报，实地拜访等），并陈述针对新买方/已有买方如何应用。
<br/>* Please provide details on a separate sheet of all information sources (payment performance, annual accounts, visits, etc.) used in setting internal credit limits. Please advice from what level they are used for new / existing customers.</p>
						</div>
						<div class="col-sm-12 col-xs-12"> 
							<textarea Data-Val="Required" class="text-w form-control" name="provide_details" id="provideDetails" <c:if test="${empty vo.is_creditlimit}"> data-status="hidden"</c:if> <c:if test="${not empty vo.is_creditlimit && vo.is_creditlimit eq '0' }"> data-status="hidden"</c:if>>${ vo.provide_details}</textarea>
						</div>
						<div class="col-sm-6 col-xs-6 file-none">
							<p>上诉补充材料请在此处上传提交（限20M以内）</p> 
							<input type="hidden" name="material_path" id="materialPath" value="${vo.material_path}">
							<div>
								<input name="materialPath_file" id="materialPath_file-5" class="file" data-drawview="${vo.material_path}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
							</div> 
						</div>
						</div>
						<div class="clear"></div>
						<div>
							<div class="col-sm-4 col-xs-4 text-center"> 
								<p>应收帐款如何催收?<br/>How are debts collected?</p>
							</div>
							<div class="col-sm-3 col-xs-3 text-center"> 
								<p>是Yes  / 否No</p>
							</div>
							<div class="col-sm-5 col-xs-5 text-center"> 
								<p>*自到期日至采取行动日的天数<br/>By what day from due date?</p>
							</div>
						</div>
						<div class="clearfix">
							<div class="col-sm-4 col-xs-4 text-center"> 
								<p>*到期日前致电客户<br/>Telephone calls BEFORE due date</p>
							</div>
							<div class="col-sm-3 col-xs-3 text-center mt-15"> 
								<div class="col-sm-6 col-xs-6 rad-io">
									<span><input type="radio" name="is_expire_before" id="isExpireBefore_1" value="1" <c:if test="${not empty vo.is_expire_before && vo.is_expire_before eq '1' }"> checked="checked"</c:if>><label for="isExpireBefore_1" class="pull-left"></label><strong class="pull-left">是 Yes</strong></span>
								</div>
								<div class="col-sm-6 col-xs-6 rad-io">
									<span><input type="radio" name="is_expire_before" id="isExpireBefore_2" value="0" <c:if test="${empty vo.is_expire_before}"> checked="checked"</c:if> <c:if test="${not empty vo.is_expire_before && vo.is_expire_before eq '0' }"> checked="checked"</c:if>><label for="isExpireBefore_2" class="pull-left"></label><strong class="pull-left">否 No</strong></span>
								</div>
							</div>
							<div class="col-sm-5 col-xs-5 text-center mt-15"> 
								<input Data-Val="Num" type="text" name="expire_before_now" id="expireBeforeNow" value="${vo.expire_before_now}" class="form-control" placeholder="" />
							</div>
						</div>
						<div class="clearfix">
							<div class="col-sm-4 col-xs-4 text-center"> 
								<p>*到期日后致电客户<br/>Telephone calls AFTER due date</p>
							</div>
							<div class="col-sm-3 col-xs-3 text-center mt-15"> 
								<div class="col-sm-6 col-xs-6 rad-io">
									<span><input type="radio" name="is_expire_after" id="isExpireAfter_1" value="1" <c:if test="${not empty vo.is_expire_after && vo.is_expire_after eq '1' }"> checked="checked"</c:if>><label for="isExpireAfter_1" class="pull-left"></label><strong class="pull-left">是 Yes</strong></span>
								</div>
								<div class="col-sm-6 col-xs-6 rad-io">
									<span><input type="radio" name="is_expire_after" id="isExpireAfter_2" value="0" <c:if test="${empty vo.is_expire_after}"> checked="checked"</c:if> <c:if test="${not empty vo.is_expire_after && vo.is_expire_after eq '0' }"> checked="checked"</c:if>><label for="isExpireAfter_2" class="pull-left"></label><strong class="pull-left">否 No</strong></span>
								</div>
							</div>
							<div class="col-sm-5 col-xs-5 text-center mt-15"> 
								<input Data-Val="Num" type="text" name="now_expire_after" id="nowExpireAfter" value="${vo.now_expire_after}" class="form-control" placeholder="" />
							</div>
						</div>
						<div class="clearfix">
							<div class="col-sm-4 col-xs-4 text-center"> 
								<p>*催收信函<br/>Chasing letters</p>
							</div>
							<div class="col-sm-3 col-xs-3 text-center mt-15"> 
								<div class="col-sm-6 col-xs-6 rad-io">
									<span><input type="radio" name="is_chasing_letters" id="isChasingLetters_1" value="1" <c:if test="${not empty vo.is_chasing_letters && vo.is_chasing_letters eq '1' }"> checked="checked"</c:if>><label for="isChasingLetters_1" class="pull-left"></label><strong class="pull-left">是 Yes</strong></span>
								</div>
								<div class="col-sm-6 col-xs-6 rad-io">
									<span><input type="radio" name="is_chasing_letters" id="isChasingLetters_2" value="0" <c:if test="${empty vo.is_chasing_letters}"> checked="checked"</c:if> <c:if test="${not empty vo.is_chasing_letters && vo.is_chasing_letters eq '0' }"> checked="checked"</c:if>><label for="isChasingLetters_2" class="pull-left"></label><strong class="pull-left">否 No</strong></span>
								</div>
							</div>
							<div class="col-sm-5 col-xs-5 text-center mt-15"> 
								<input Data-Val="Num" type="text" name="chasing_letters" id="chasingLetters" value="${vo.chasing_letters}" class="form-control" placeholder="" />
							</div>
						</div>
						<div class="clearfix">
							<div class="col-sm-4 col-xs-4 text-center"> 
								<p>*暂停发货<br/>Deliveries suspended</p>
							</div>
							<div class="col-sm-3 col-xs-3 text-center mt-15"> 
								<div class="col-sm-6 col-xs-6 rad-io">
									<span><input type="radio" name="is_deliveries_suspended" id="is_deliveries_suspended_1" value="1" <c:if test="${not empty vo.is_deliveries_suspended && vo.is_deliveries_suspended eq '1' }"> checked="checked"</c:if>><label for="is_deliveries_suspended_1" class="pull-left"></label><strong class="pull-left">是 Yes</strong></span>
								</div>
								<div class="col-sm-6 col-xs-6 rad-io">
									<span><input type="radio" name="is_deliveries_suspended" id="is_deliveries_suspended_2" value="0" <c:if test="${empty vo.is_deliveries_suspended}"> checked="checked"</c:if> <c:if test="${not empty vo.is_deliveries_suspended && vo.is_deliveries_suspended eq '0' }"> checked="checked"</c:if>><label for="is_deliveries_suspended_2" class="pull-left"></label><strong class="pull-left">否 No</strong></span>
								</div>
							</div>
							<div class="col-sm-5 col-xs-5 text-center mt-15"> 
								<input Data-Val="Num" type="text" name="deliveries_suspended_day" id="deliveries_suspended_day" value="${vo.deliveries_suspended_day}" class="form-control" placeholder="" />
							</div>
						</div>
						<div class="clearfix">
							<div class="col-sm-4 col-xs-4 text-center"> 
								<p>*实地拜访<br/>Visits</p>
							</div>
							<div class="col-sm-3 col-xs-3 text-center mt-15"> 
								<div class="col-sm-6 col-xs-6 rad-io">
									<span><input type="radio" name="is_visits" id="is_visits_1" value="1" <c:if test="${not empty vo.is_visits && vo.is_visits eq '1' }"> checked="checked"</c:if>><label for="is_visits_1" class="pull-left"></label><strong class="pull-left">是 Yes</strong></span>
								</div>
								<div class="col-sm-6 col-xs-6 rad-io">
									<span><input type="radio" name="is_visits" id="is_visits_2" value="0" <c:if test="${empty vo.is_visits}"> checked="checked"</c:if> <c:if test="${not empty vo.is_visits && vo.is_visits eq '0' }"> checked="checked"</c:if>><label for="is_visits_2" class="pull-left"></label><strong class="pull-left">否 No</strong></span>
								</div>
							</div>
							<div class="col-sm-5 col-xs-5 text-center mt-15"> 
								<input Data-Val="Num" type="text" name="visits_day" id="visits_day" value="${vo.visits_day}" class="form-control" placeholder="" />
							</div>
						</div>
						<div class="clearfix">
							<div class="col-sm-4 col-xs-4 text-center"> 
								<p>*委托追帐公司<br/>Debt collectors</p>
							</div>
							<div class="col-sm-3 col-xs-3 text-center mt-15"> 
								<div class="col-sm-6 col-xs-6 rad-io">
									<span><input type="radio" name="is_debt_collectors" id="is_debt_collectors_1" value="1" <c:if test="${not empty vo.is_debt_collectors && vo.is_debt_collectors eq '1' }"> checked="checked"</c:if>><label for="is_debt_collectors_1" class="pull-left"></label><strong class="pull-left">是 Yes</strong></span>
								</div>
								<div class="col-sm-6 col-xs-6 rad-io">
									<span><input type="radio" name="is_debt_collectors" id="is_debt_collectors_2" value="0" <c:if test="${empty vo.is_debt_collectors}"> checked="checked"</c:if> <c:if test="${not empty vo.is_debt_collectors && vo.is_debt_collectors eq '0' }"> checked="checked"</c:if>><label for="is_debt_collectors_2" class="pull-left"></label><strong class="pull-left">否 No</strong></span>
								</div>
							</div>
							<div class="col-sm-5 col-xs-5 text-center mt-15"> 
								<input Data-Val="Num" type="text" name="debt_collectors_day" id="debt_collectors_day" value="${vo.debt_collectors_day}" class="form-control" placeholder="" />
							</div>
						</div>
						<div class="clearfix">
							<div class="col-sm-4 col-xs-4 text-center"> 
								<p>*诉诸法律手段<br/>Legal action</p>
							</div>
							<div class="col-sm-3 col-xs-3 text-center mt-15"> 
								<div class="col-sm-6 col-xs-6 rad-io">
									<span><input type="radio" name="is_legal_action" id="is_legal_action_1" value="1" <c:if test="${not empty vo.is_legal_action && vo.is_legal_action eq '1' }"> checked="checked"</c:if>><label for="is_legal_action_1" class="pull-left"></label><strong class="pull-left">是 Yes</strong></span> 
								</div>
								<div class="col-sm-6 col-xs-6 rad-io">
									<span><input type="radio" name="is_legal_action" id="is_legal_action_2" value="0" <c:if test="${empty vo.is_legal_action}"> checked="checked"</c:if> <c:if test="${not empty vo.is_legal_action && vo.is_legal_action eq '0' }"> checked="checked"</c:if>><label for="is_legal_action_2" class="pull-left"></label><strong class="pull-left">否 No</strong></span> 
								</div>
							</div>
							<div class="col-sm-5 col-xs-5 text-center mt-15"> 
								<input Data-Val="Num" type="text" name="legal_action_day" id="legal_action_day" value="${vo.legal_action_day}" class="form-control" placeholder="" />
							</div>
						</div>
						<div class="clearfix">
							<div class="col-sm-4 col-xs-4 text-center"> 
								<p>*其它 – 请详述<br/>Others – please specify</p>
							</div>
							<div class="col-sm-3 col-xs-3 text-center mt-15"> 
								<div class="col-sm-6 col-xs-6 rad-io">
									<span><input type="radio" name="is_others" id="is_others_1" value="1" <c:if test="${not empty vo.is_others && vo.is_others eq '1' }"> checked="checked"</c:if>><label for="is_others_1" class="pull-left"></label><strong class="pull-left">是 Yes</strong></span>
								</div>
								<div class="col-sm-6 col-xs-6 rad-io">
									<span><input type="radio" name="is_others" id="is_others_2" value="0" <c:if test="${empty vo.is_others}"> checked="checked"</c:if> <c:if test="${not empty vo.is_others && vo.is_others eq '0' }"> checked="checked"</c:if>><label for="is_others_2" class="pull-left"></label><strong class="pull-left">否 No</strong></span>
								</div>
							</div>
							<div class="col-sm-5 col-xs-5 text-center mt-15"> 
								<input Data-Val="Num" type="text" name="others_day" id="others_day" value="${vo.others_day}" class="form-control" placeholder="" />
							</div>
						</div>
					</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>8. 争议处理 Settlement of Disputes</h3></div> 
			<div class="row w-95-auto"><!-- w-95-auto start --> 
				<div class="text-mt0">
					<p>本保险合同项下的争议解决方式：</p>
					<p class="mt-0">According to Policy Article 5.08,  the Insured and CPIC need to choose either of the following dispute resolution mechanism for settlement of disputes under this insurance:</p>
					<p class="mt-0 clearfix"><span class="left">5.08 因履行本保险合同发生的争议，由被保险人和保险人友好协商解决，协商不成的，提交</span><span class="left"><input Data-Val="Required" type="text" name="arbitral_institution" id="arbitral_institution" value="${vo.arbitral_institution}" class="form-control w-120" placeholder=""  /></span><span class="left">仲裁委员会仲裁；</span></p>
					<p class="mt-0">All disputes arising from the performance of this insurance shall be resolved by the Insured and CPIC through friendly negotiation. If a dispute cannot be settled through friendly negotiation, it shall be submitted to Arbitration Commission for arbitration. </p>
				</div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>单证信息</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start --> 
				<div class="col-sm-3 col-xs-3 mt-20">
					<span class="pull-left check-box"> 
						<input type="checkbox" name="mailPolicyVo.need_insur_bill" value="1" id="need_insur_bill" <c:if test="${not empty vo.mailPolicyVo.need_insur_bill && vo.mailPolicyVo.need_insur_bill eq '1'}"> checked="checked"</c:if>/>
						<label for="need_insur_bill"></label>
					</span>
					<span class="pull-left lhml5">需要纸质保单</span>
				</div>
				<div class="clear"></div>
				<div id="mod_1" <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> style="display: none;"</c:if>>
				<div class="col-sm-3 col-xs-3">
					<p>*收件人名称</p>
					<input Data-Val="Required" type="text" name="mailPolicyVo.receiver_name" id="receiver_name" value="${ vo.mailPolicyVo.receiver_name}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*收件人手机</p>
					<input Data-Val="Required" type="text" name="mailPolicyVo.receiver_mobile" id="receiverMobile" value="${ vo.mailPolicyVo.receiver_mobile}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
				</div>
				<div class="col-sm-6 col-xs-6">
					<p>*收件人地址</p>
					<input Data-Val="Required" type="text" name="mailPolicyVo.receiver_address_detail" id="receiver_address_detail" value="${ vo.mailPolicyVo.receiver_address_detail}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				</div>
				<div class="col-sm-3 col-xs-3 mt-20">
					<span class="pull-left check-box"> 
						<input type="checkbox" name="mailPolicyVo.need_receipt" value="1" id="need_receipt" <c:if test="${not empty vo.mailPolicyVo.need_receipt && vo.mailPolicyVo.need_receipt eq '1'}"> checked="checked"</c:if> />
						<label for="need_receipt"></label>
					</span>
					<span class="pull-left lhml5">需要纸质发票</span>
				</div>
				<div class="clear"></div>
				<div id="mod_2" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> style="display: none;"</c:if>>
				<div class="col-sm-12 col-xs-12">
					<p>发票种类</p> 
					<div class="row">
						<div class="col-sm-12 col-xs-12">
							<div class="row">
								<div class="col-sm-2 col-xs-2 rad-io">
									<span><input type="radio" name="mailPolicyVo.invoice_type" id="invoice_type_1" value="0" <c:if test="${empty vo.mailPolicyVo.invoice_type}"> checked="checked"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> checked="checked"</c:if>><label for="invoice_type_1" class="pull-left"></label><strong  class="pull-left">增值税普通发票</strong></span>
								</div>
								<div class="col-sm-2 col-xs-2 rad-io">
									<span><input type="radio" name="mailPolicyVo.invoice_type" id="invoice_type_2" value="1" <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '1' }"> checked="checked"</c:if>><label for="invoice_type_2" class="pull-left"></label><strong  class="pull-left">增值税专用发票</strong></span>
								</div> 
							</div>
						</div>
					</div>
				</div> 
				</div>
				<div class="col-sm-12 col-xs-12 reminder" id="mod_2_1" <c:if test="${empty vo.mailPolicyVo.invoice_type}"> style="display: none;"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> style="display: none;"</c:if>>
					<label>温馨提示：请认真填写下述信息，确保信息真实准确，以免因开票信息错误给贵司带来损失。提交信息后，我司将在1-2个工作日完成审核，请及时关注审核结果。</label>
				</div>
				<div id="mod_2_2" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> style="display: none;"</c:if>>
				<div class="col-sm-3 col-xs-3">
					<p>*单位名称</p> 
					<input Data-Val="Required" type="text" name="mailPolicyVo.receipt_head" id="receipt_head" value="${ vo.mailPolicyVo.receipt_head}" class="form-control" placeholder="" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*收票人姓名</p> 
					<input Data-Val="Required" type="text" name="mailPolicyVo.taker_name" id="taker_name" value="${ vo.mailPolicyVo.taker_name}" class="form-control" placeholder="" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*收票人手机</p>
					<input Data-Val="Required" type="text" name="mailPolicyVo.taker_mobile" id="takerMobile" value="${ vo.mailPolicyVo.taker_mobile}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>/>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*收票人地址</p>
					<input Data-Val="Required" type="text" name="mailPolicyVo.taker_address_detail" id="taker_address_detail" value="${ vo.mailPolicyVo.taker_address_detail}" class="form-control" placeholder="企业营业执照上的全称"  <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>/>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*纳税人识别号</p>
					<input Data-Val="Required" type="text" name="mailPolicyVo.taxpayer_number_invoice" id="taxpayer_number_invoice_1" value="${ vo.mailPolicyVo.taxpayer_number_invoice}" class="form-control" placeholder="企业《税务登记证》编号"  <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				</div>
				<div id="mod_2_3" <c:if test="${empty mailPolicyVo.invoice_type}"> style="display: none;"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> style="display: none;"</c:if>>
				<div class="col-sm-3 col-xs-3">
					<p>*纳税人识别号</p> 
					<input Data-Val="Required" type="text" name="mailPolicyVo.taxpayer_number_invoice" id="taxpayer_number_invoice" value="${ vo.mailPolicyVo.taxpayer_number_invoice}" class="form-control" placeholder="企业《税务登记证》编号" <c:if test="${empty vo.mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*注册地址</p>
					<input Data-Val="Required" type="text" name="mailPolicyVo.register_address_invoice" id="register_address_invoice" value="${ vo.mailPolicyVo.register_address_invoice}" class="form-control" placeholder="企业营业执照上的注册地址"  <c:if test="${empty mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*电话</p>
					<input Data-Val="Required" type="text" name="mailPolicyVo.receipt_phone" id="receiptPhone" value="${ vo.mailPolicyVo.receipt_phone}" class="form-control" placeholder="企业联系电话"  <c:if test="${empty vo.mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*开户银行</p>
					<input Data-Val="Required" type="text" name="mailPolicyVo.bank_invoice" id="bank_invoice" value="${ vo.mailPolicyVo.bank_invoice}" class="form-control" placeholder="企业银行开户许可证上的开户银行"  <c:if test="${empty vo.mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>*银行账号</p>
					<input Data-Val="Required" type="text" name="mailPolicyVo.bank_account_invoice" id="bank_account_invoice" value="${ vo.mailPolicyVo.bank_account_invoice}" class="form-control" placeholder="企业开户许可证上的银行账号"  <c:if test="${empty vo.mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				<div class="col-sm-4 col-xs-4">
					<p>税务登记证<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/tax.jpg')">（样例）</a></p>
					<input type="hidden" title="" name="mailPolicyVo.tax_cert" id="tax_cert" value="${vo.mailPolicyVo.tax_cert }">
					<div>
						<input title="" value="${vo.mailPolicyVo.tax_cert }" name="tax_cert_file" id="tax_cert_file-5" data-drawview="${vo.mailPolicyVo.tax_cert }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
					</div>
					<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
				</div>
				<div class="col-sm-4 col-xs-4">
					<p>一般纳税人证明</p> 
					<input type="hidden" title="" name="mailPolicyVo.tax_prove" id="tax_prove" value="${vo.mailPolicyVo.tax_prove }">
					<div>
						<input title="" value="${vo.mailPolicyVo.tax_prove }" name="tax_prove_file" id="tax_prove_file-5" data-drawview="${vo.mailPolicyVo.tax_prove }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
					</div>
					<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
				</div> 
				<div class="col-sm-4 col-xs-4">
					<p>银行开户许可证</p> 
					<input type="hidden" title="" name="mailPolicyVo.bank_licence" id="bank_licence" value="${vo.mailPolicyVo.bank_licence }">
					<div>
						<input title="" value="${vo.mailPolicyVo.bank_licence }" name="bank_licence_file" id="bank_licence_file-5" data-drawview="${vo.mailPolicyVo.bank_licence}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
					</div>
					<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
				</div>
				<div class="col-sm-4 col-xs-4">
					<p>营业执照副本<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/open.jpg')">（样例）</a></p>
					<input type="hidden" title="" name="mailPolicyVo.business_license" id="business_license" value="${vo.mailPolicyVo.business_license }">
					<div>
						<input title="" value="${vo.mailPolicyVo.business_license }" name="business_license_file" id="business_license_file-5" data-drawview="${vo.mailPolicyVo.business_license}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
					</div>
					<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
				</div>
				<div class="col-sm-4 col-xs-4">
					<p>增票授权委托书（个人支付时需提供此委托书<a href="<c:url value='/resources/files/增票授权委托书.doc' />" target="_blank">下载</a>）</p> 
					<input type="hidden" title="" name="mailPolicyVo.auth_cert" id="auth_cert" value="${vo.mailPolicyVo.auth_cert}">
					<div>
						<input title="" value="${vo.mailPolicyVo.auth_cert }" name="auth_cert_file" id="auth_cert_file-5" data-drawview="${vo.mailPolicyVo.auth_cert }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
					</div>
					<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
				</div> 
				</div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
		</form>
		<div class="row next-step">
			<div class="col-sm-12 col-xs-12 text-right pull-right">
				<p>
					<a href="javascript:void(0);" onclick="saveCommonExportInfo('3');" id="pendingInfo" class="save">暂存本页</a>
					<a href="javascript:void(0);" onclick="save_policy_my();" class="ns-btn">下一步</a>
					<a href="<c:url value='/insurance/customs/policy/qy_policy/${vo.oid}/2'/>" class="ns-btn">上一步</a>
				</p>
			</div>
		</div>
	</div><!-- container end -->
<input id="tolP" type="hidden" value="${pageSetupList.size()}">
<input id="fileKeyName" type="hidden" value=""><!-- 上传文件的key，重要！ -->
<!-- 营业执照 start -->
<div class="modal fade" id="open" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
   <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header bg-1f96ef">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">营业执照</h4>
		  </div> 
		  <div class="modal-body">
		  	<img src="<c:url value='/resources/versions-2.0/images/product/open.jpg' />" class="img-responsive ml-14">
		  </div> 
		</div> 
  </div> 
</div> 
<!-- 营业执照 end -->
<!-- 组织机构代码证 start -->
<div class="modal fade" id="org" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
   <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header bg-1f96ef">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">组织机构代码证</h4>
		  </div> 
		  <div class="modal-body">
		  	<img src="<c:url value='/resources/versions-2.0/images/product/org.jpg' />" class="img-responsive">
		  </div> 
		</div> 
  </div> 
</div> 
<!-- 组织机构代码证 end -->
<!-- 税务登记证 start -->
<div class="modal fade" id="tax" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
   <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header bg-1f96ef">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">税务登记证</h4>
		  </div> 
		  <div class="modal-body">
		  	<img src="<c:url value='/resources/versions-2.0/images/product/tax.jpg' />" class="img-responsive">
		  </div> 
		</div> 
  </div> 
</div> 
<!-- 税务登记证 end --> 
<jsp:include page="../../../index/multi_f.jsp" />
</body>
<script src="<c:url value='/resources/commonJS/con-common.js'/>" type="text/javascript"></script>

<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/normalCheck.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/validateIdent.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/customs_enterBasicInfo.js' />"></script>

<script>
	$(function () {
        //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
        setParamDatas('','/pc/tb-mail-address/${userdetail.oid}',false,false,function(json){
            if(json != undefined && json != null){
                if('${dto.oid}' == ''){
                    $('#need_insur_bill').on('click',function(){//纸质发票
                        if($(this).is(":checked")){
                            $("#receiver_name").val(json.user_name);
                            $("#receiverMobile").val(json.telephone);
                            $("#receiver_address_detail").val(json.address);
                        }
                    });
                    $('#need_receipt').on('click',function(){//电子发票
                        if($(this).is(":checked")){
                            $("#taker_name").val(json.user_name);
                            $("#takerMobile").val(json.telephone);
                            $("#taker_address_detail").val(json.address);
                        }
                    });
                }
            }

        });
	})

</script>
<script type="text/javascript">
    function openImgView(img_url){
        top.layer.open({
            type: 1,
            skin: 'layui-layer-rim', //加上边框
            area: ['420px', '350px'], //宽高
            content: '<div><img src='+baseUrl+img_url+' width="100%" /></div>'
        });
    }
    //日期范围限制
    /*var delivery = {
        elem: '#delivery',
        format: 'YYYY-MM-DD',
        max: '2099-06-16', //最大日期
        istoday: false,
        choose: function(datas){

        }
    };*/

    Date.prototype.Format = function (fmt) { //author: meizz
        var o = {
            "M+": this.getMonth() + 1, //月份
            "d+": this.getDate(), //日
            "h+": this.getHours(), //小时
            "m+": this.getMinutes(), //分
            "s+": this.getSeconds(), //秒
            "q+": Math.floor((this.getMonth() + 3) / 3), //季度
            "S": this.getMilliseconds() //毫秒
        };
        if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
        for (var k in o)
            if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
        return fmt;
    }
//    laydate(delivery);

    var baseUrl = '${pageContext.request.contextPath }';
    var count = 2;
    $(function(){
	if($("#need_insur_bill").is(':checked')){
		$("#mod_1").fadeIn(1000);
	}else{
		$("#mod_1").fadeOut(1000);
	}
	if($("#need_receipt").is(':checked')){
		var _invoice_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
		$("#mod_2").fadeIn(1000);
		if(_invoice_val == "0"){//普通发票
			$("#mod_2_1").fadeIn(1000);
		}else{//专用发票,VATINVOICE
			$("#mod_2_1").fadeIn(1000);
			$("#mod_2_2").fadeIn(1000);
			$("#mod_2_3").fadeIn(1000);
		}
	}else{
		$("#mod_2").fadeOut(1000);
		$("#mod_2_1").fadeOut(1000);
		$("#mod_2_2").fadeOut(1000);
		$("#mod_2_3").fadeOut(1000);
	}

});
    function save_policy_my(){
	if(customsVerify()){
		var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
		$.ajax({
			type: 'POST',
			url:baseUrl + '/insurance/customs/policy/pendingCommonExportVo_3Policy',
			data:$("#policyInfoForm").serialize(),
			dataType:"json",
			success: function(json){
				layer.close(index);
				if(json.statusCode == '200') {
					window.location.href = baseUrl + '/insurance/customs/policy/confirmPage/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
				}else{
					layer.msg(json.message);
				}
			},
			error : function(XMLHttpRequest, textStatus, errorThrown) {
				layer.close(index);
				layer.msg(textStatus);
			}
		});
	}
}
function customsVerify(){
	var flag = true;
	$("input[Data-Val]").each(function(){
		var dataVal = $(this).attr("Data-Val");
		if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
			if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
				if($(this).val() == ''){
					document.getElementById(this.id).scrollIntoView();
					layer.msg("必填项不能为空！");
					$(this).focus();
					flag = false;
					return true;
				}else{
                    if($(this).val().length>40){
                        document.getElementById(this.id).scrollIntoView();
                        layer.msg("长度超出限制！");
                        $(this).focus();
                        flag = false;
                        return true;
                    }
                }
				
			}
		}
	});
	if(flag){
		$("select[Data-Val]").each(function(){
			var dataVal = $(this).attr("Data-Val");
			if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
				if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
					if($(this).val() == ''){
						document.getElementById(this.id).scrollIntoView();
						layer.msg("必填项不能为空！");
						$(this).focus();
						flag = false;
						return true;
					}
					
				}
			}
		});
		if(flag){
			$("textarea[Data-Val]").each(function(){
				var dataVal = $(this).attr("Data-Val");
				if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
					if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
						if($(this).val() == ''){
							document.getElementById(this.id).scrollIntoView();
							layer.msg("必填项不能为空！");
							$(this).focus();
							flag = false;
							return true;
						}else{
                            if($(this).val().length>100){
                                document.getElementById(this.id).scrollIntoView();
                                layer.msg("长度超出限制(100字符)！");
                                $(this).focus();
                                flag = false;
                                return true;
                            }
                        }
						
					}
				}
			});
			
		}
	}
	return flag;
}
</script>
</html>