<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-支付保费</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" /> 
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>

<body style="background: rgba(244,245,246,1);">
<jsp:include page="../../../index/multi_h.jsp"/>

<div class="container" style="padding-bottom: 50px; padding-top: 20px;"><!-- container start -->
	<ol class="breadcrumb">
	  <li><a href="<c:url value='/'/>">首页</a></li>
		<li><a href="<c:url value='/synopsis/product/productAllView'/>">产品列表</a></li>
		<li><a href="<c:url value='/insurance/product/productInfo/${dto.product_oid}'/>">产品详情</a></li>
	  <li class="active">支付保费</li>
	</ol>
	<div class="nav-list">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 active">
				<p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 pull-right">
				<p><i class="pull-left">4</i><span class="pull-left">完成投保</span></p>
			</div>
		</div>
	</div>
	<form class="form-horizontal form-create-item" action="<c:url value='/insurance/build/transaction/policyPayment' />" method="post" id="policyPaymentForm">
		<input name="policyId" value="${mapPolicy['policyOid']}" type="hidden"/>
		<div class="message-war"><!-- message-war start --> 
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="p-table">
						<table class="table">
							<thead>
								<tr>
								  <th>产品名称</th>
								  <th>保障期限</th>
								  <th>保费</th> 
								</tr>
							</thead>
							<tbody>
								<tr>
								  <td>${mapPolicy["productName"]}</td>
								  <td>${mapPolicy["inceptionDate"]} 至 ${mapPolicy["plannedEndDate"]}</td>
								  <td>${mapPolicy["grossPremium"]}元</td> 
								</tr> 
							  </tbody>
						</table>
					</div>
				<p class="fs16">所需支付金额￥${mapPolicy["grossPremium"]}</p>
				<div class="bg-f5f8fa">选择支付方式</div> 
				<div class="row">
					<div class="col-sm-2 col-xs-2 rad-io mt-20">
						<span><input type="radio" name="policyPaymentType" value="CHINAPAYPI" id="radio1" checked="checked"><label for="radio1" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('radio1','radio');">个人账户支付</strong></span> 
					</div>
					<div class="col-sm-2 col-xs-2 rad-io mt-20">
						<span><input type="radio" name="policyPaymentType" value="CHINAPAYPU" id="radio2"><label for="radio2" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('radio2','radio');">企业账户支付</strong></span> 
					</div> 
				</div> 
			</div><!-- w-95-auto end -->
		</div><!-- message-war end --> 
	</form>
	<div class="row next-step">
		<div class="col-sm-3 col-xs-3 text-right pull-right">
			<p><a href="javascript:void(0);" onclick="submitPayment();" class="ns-btn">立即支付</a></p>
		</div>
	</div>
</div><!-- container end --> 
<!-- 立即支付 start -->
<div class="modal fade" id="pay-now" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
   <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header bg-1f96ef">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close" onclick="closeWinD();"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">支付中</h4><%-- <c:url value='/insurance/build/transaction/policyVerify' /> --%>
		  </div> 
		  <div class="modal-body">
		  	<p class="text-center"><span>支付中......</span></p>
		  </div>
		  <div class="modal-footer">
			<div class="mofo-sub">
				<!-- <button type="button" class="btn pull-left cancel-btn" onclick="closeWinD();">未完成支付</button> -->
				<button type="button" class="btn notarize-btn pull-right" onclick="closeWinD();">查看</button>
			</div>
		  </div> 
		</div> 
  </div> 
</div> 
<!-- 立即支付 end -->
<jsp:include page="../../../index/multi_f.jsp" />

<!-- script -->
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';
	function submitPayment() {
		
		var payType = $("input[name='policyPaymentType']:checked").val();
		if(payType == ''){
			alert("请选择支付方式");	
		}else{
			var w = window.open();
			$.ajax({
				type: 'POST',
				url:baseUrl + '/insurance/build/transaction/policyPayment',
				data:$("#policyPaymentForm").serialize(),
				dataType:"json",
				async:false,
				success: function(json){
					if(json.statusCode == '200') {
						$('#pay-now').modal({backdrop: 'static', keyboard: false});
						w.location = json.forwardurl;
					}
					if(json.statusCode == '300') {
						w.close();
						layer.msg(json.message);
					}
					if(json.statusCode == '301') {
						w.close();
						layer.msg(json.message);
					}
				}
			});
		}
	}
	function closeWinD(){
		location.href=baseUrl + '/insurance/build/transaction/policyVerify/'+${mapPolicy['policyOid']};
	}
	function checkToradio(_id, type){
		var o = $("#"+_id);
		if(type=="radio"){
			o.prop('checked',true);
		}
	}
</script>
</body>
</html>