<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<ul class="scheme-thead clearfix">
	<li class="e1">
		<span>保障责任</span>
	</li>
	<li class="e2">
		<span>保障说明</span>
	</li>
	<li class="e3">
		<span>保障金额</span>
	</li>
	<li class="e4">
		<span>免赔额</span>
	</li>
	<li class="e5">
		<span>赔付比例</span>
	</li>
	<li class="e6">
		<span>免赔天数</span>
	</li>
</ul>
<ul class="scheme-tbody">
	<c:forEach items="${orderVo.responsibilityVoList }" var="irp">
		<li class="clearfix">
			<div class="e1">
				<p>${irp.name}</p>
			</div>
			<div class="e2">
				<i>
					${irp.explain_product}
				</i>
			</div>
			<div class="e3">
				<span>
					<c:if test="${ empty irp.fcy}">
						-
					</c:if>
					<c:if test="${empty irp.compensation_days && not empty irp.fcy}">
						<c:if test="${irp.fcy/10000 >= 1}">
							${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
							万元
						</c:if>
						<c:if test="${irp.fcy/10000 < 1}">
							${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
							元
						</c:if>
					</c:if>
					<c:if test="${not empty irp.compensation_days && not empty irp.fcy}">
						<c:if test="${irp.fcy/10000 >= 1}">
							${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
							万元/天
						</c:if>
						<c:if test="${irp.fcy/10000 < 1}">
							${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
							元/天
						</c:if>
					</c:if>
				</span>
			</div>
			<div class="e4">
				<span>${empty irp.compensation_ratio ? '-' : irp.compensation_ratio}${not empty irp.compensation_ratio ? '%' : ''}</span>
			</div>
			<div class="e5">
				<span>${empty irp.cumulative_deductibles ? '-' : irp.cumulative_deductibles}</span>
			</div>
			<div class="e6">
				<span>${empty irp.deductible_days ? '-' : irp.deductible_days}</span>
			</div>
		</li>
	</c:forEach>
</ul>
