<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
	<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
	<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
	<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
	<title>百联保-我的保全</title>
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/public.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/idangerous.swiper2.7.6.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/basic.css' />" />
	<link rel="stylesheet" href="<c:url value='/resources/versions-2.0.2/css/reset.css' />">
	<link rel="stylesheet" href="<c:url value='/resources/versions-2.0.2/css/applicant.css' />">
	<link rel="stylesheet" href="<c:url value='/resources/versions-2.0.2/css/laydate.css' />">
	<link rel="stylesheet" href="<c:url value='/resources/versions-2.0.2/css/animate.min.css' />">
	<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery-1.8.3.min.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/version_new/js/layer/layer.js' />"></script>
</head>

<body style="position: relative">
<div class="container">
	<!--右边内容块-->
	<div class="pp-content">
		<ul class="order-list wed-list" id="wed-list">
			<li onclick="openRecordModel()">批改申请记录</li>
			<li class="active">保全账单</li>
			<li onclick="openSettlementModel()">保全结算单</li>
		</ul>
		<%--SAAS需求不展示该入口--%>
		<%--<p class="pp-wert">人员变更</p>--%>
	</div>
	<div class="tab-query tab-order my-order">
		<div class="tab-con" id="tab-con">
			<div class="sdf">
				<div class="con-srt con-s2" style="display: block;">
					<div class="s-head clearfix">
						<div class="head-input fl">
							<span>关键字</span>
							<input type="text" id="keyword_it" value="${keyword}" placeholder="请填写账单号/投保人/保单号/保全单数">
						</div>
						<div class="head-time fl">
							<span>账单时间</span>
							<input type="text" value="${start_time}" id="start-s2">
							<span class="sdf">至</span>
							<input type="text" value="${end_time}" id="end-s2">
						</div>
						<div class="head-status fl">
							<span>状态</span>
							<div class="status fr">
								<p id="status-xuan-s2" data-status="${pay_status }">
									<c:if test="${empty pay_status}">请选择</c:if>
									<c:if test="${pay_status eq '1'}">待缴费</c:if>
									<c:if test="${pay_status eq '2'}">待审核</c:if>
									<c:if test="${pay_status eq '5'}">部分缴费</c:if>
									<c:if test="${pay_status eq '3'}">已缴费</c:if>
								</p>
								<ul class="status-select" id="drag-s2">
									<li<c:if test="${empty pay_status}"> class="active"</c:if> data-status="">请选择</li>
									<li<c:if test="${pay_status eq '1'}"> class="active"</c:if> data-status="1">待缴费</li>
									<li<c:if test="${pay_status eq '2'}"> class="active"</c:if> data-status="2">待审核</li>
									<li<c:if test="${pay_status eq '5'}"> class="active"</c:if> data-status="5">部分缴费</li>
									<li<c:if test="${pay_status eq '3'}"> class="active"</c:if> data-status="3">已缴费</li>
								</ul>
							</div>
						</div>
						<div class="head-button fr" onclick="searchList()">
							<p>搜索</p>
						</div>
					</div>
					<div class="s-head clearfix" style="margin-top: 10px;">
						<button type="button" class="btn btn-warning" onclick="exportExcel()" style="width: 70px;height: 30px;">
							<i class="glyphicon glyphicon-upload"></i><span> 导出</span>
						</button>
						<button type="button" class="btn btn-warning" onclick="uploadSubmit()" style="width: 70px;height: 30px;">
							<i class="glyphicon glyphicon-download"></i><span> 导入</span>
						</button>
						<button type="button" class="btn btn-warning" onclick="createPartBill()" style="height: 30px;">
							<span>生成部分账单</span>
						</button>
					</div>
					<div class="tab-content" id="preservationPaysArea">
						<ul class="order-num wed-num">
							<li class="width-s3" style="width: 24px">
								<span>&nbsp;</span>
							</li>
							<li class="width-s3">
								<span>账单编号</span>
							</li>
							<li class="width-s3">
								<span>保险公司</span>
							</li>
							<li class="width-s3">
								<span>投保人</span>
							</li>
							<li class="width-s3" style="width: 80px">
								<span>保全单数</span>
							</li>
							<li class="width-s3">
								<span>保全金额</span>
							</li>
							<li class="width-s3">
								<span>起止日期</span>
							</li>
							<li class="width-s3">
								<span>生成日期</span>
							</li>
							<li class="width-s3">
								<span>缴费状态</span>
							</li>
							<li class="width-s3">
								<span>操作</span>
							</li>
						</ul>
						<ul class="tab-body">
							<c:choose>
								<c:when test="${empty payList }">
									<li class="clearfix" style="text-align: center;line-height: -moz-block-height;">
										暂无记录！！
									</li>
								</c:when>
								<c:otherwise>
									<c:forEach items="${payList }" var="pay">
										<li class="clearfix">
											<div class="no-cont" style="display: flex;align-items: center;justify-content: center;width: 24px">
												<span style="line-height: 24px;">
													<c:if test="${(pay.pay_status eq '1'||pay.pay_status eq '2') && pay.is_part == 0 && row.predict_total_amount != 0 && pay.predict_total_amount ne '0.00'}"><input type="checkbox" name="billId" value="${pay.oid }"></c:if>
												</span>
											</div>
											<div class="no-cont">
												<span>${pay.external_reference }</span>
											</div>
											<div class="no-cont">
												<span>${pay.company_name }</span>
											</div>
											<div class="no-cont">
												<span>${pay.app_role_name }</span>
											</div>
											<div class="no-cont" style="width: 80px">
												<span>${pay.record_count}</span>
											</div>
											<div class="no-cont">
												<span>${empty pay.predict_total_amount ? '' : '￥'}${empty pay.predict_total_amount ? '-' : pay.predict_total_amount}</span>
											</div>
											<div class="no-cont">
												<p>${pay.star_pay_time }</p>
												<i>至</i>
												<p>${pay.end_pay_time }</p>
											</div>
											<div class="no-cont">
												<span>${pay.build_data}</span>
											</div>
											<div class="no-cont">
												<span id="status_${pay.oid }">
													<c:if test="${pay.is_part_status == 0}">
														${fns:getDictLabel(pay.pay_status,"billPayStatus","")}
													</c:if>
													<c:if test="${pay.is_part_status > 0 && pay.pay_status ne '3'}">
														${fns:getDictLabel("5","billPayStatus","")}
													</c:if>
													<c:if test="${pay.is_part_status > 0 && pay.pay_status eq '3'}">
														${fns:getDictLabel(pay.pay_status,"billPayStatus","")}
													</c:if>
												</span>
											</div>
											<div class="no-cont">
												<a href="javascript:;" onclick="openPayDetail('${pay.oid }','${pay.is_part}');"<%-- class="po-details"--%>>详情</a>
												<c:if test="${(pay.pay_status eq '1'||pay.pay_status eq '2') && pay.predict_total_amount ne '0.00' }">
													<a href="javascript:;" onclick="uploadPay('${pay.oid }','${pay.record_count }','${pay.predict_total_amount }','${pay.pay_order_path }');" class="a-progress">支付</a>
												</c:if>
												<c:if test="${pay.pay_status eq '3' && pay.is_fp eq '1' && not empty pay.fp_url}">
													<a href="${pay.fp_url}" target="_blank" class="a-progress">发票下载</a>
												</c:if>
												<c:if test="${pay.pay_status eq '3' && pay.is_fp ne '1'}">
													<a href="javascript:;" onclick="getFP('${pay.oid }');" class="a-progress">申请发票</a>
												</c:if>
											</div>
										</li>
									</c:forEach>
								</c:otherwise>
							</c:choose>
						</ul>
					</div>
					<!--分页-->
					<ul class="paper-num" style="padding: 0;padding-top: 20px;">
						<div class="filter-pagination">
							<div id="callBackPager"></div>
						</div>
					</ul>
				</div>
			</div>
		</div>
	</div>

	<div class="clearfix"></div>
	<form id="preservationPayForm" action="<c:url value='/api/preservation/pay/payList?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" method="post">
		<input type="hidden" id="start_time" name="start_time" value="${start_time }"/>
		<input type="hidden" id="end_time" name="end_time" value="${end_time }"/>
		<input type="hidden" id="keyword" name="keyword" value="${keyword }"/>
		<input type="hidden" id="pay_status" name="pay_status" value="${pay_status }"/>
		<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
		<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
		<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
	</form>
</div>

<!--缴费凭证弹窗-->
<div class="payment-voucher animated" style="position: absolute!important;top:30%">
	<div class="payment-head">
		<span>缴费处理</span>
		<a href="javascript:;" id="payment-bi">
			<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
		</a>
	</div>
	<form id="uploadPayForm">
		<div class="popo-title">
			<div class="title-img clearfix">
				<div class="title-wed" style="padding: 20px">
					<p style="text-align: right;"><span>总笔数: <i id="rcount"></i></span>&nbsp;&nbsp;&nbsp;&nbsp;<span>总金额: <i id="pamount"></i></span></p>
					<div class="row">
						<div class="col-sm-4 col-xs-4" style="margin: 10px 0;">
							缴费状态：
						</div>
						<div class="col-sm-8 col-xs-8" style="margin: 10px 0;">
							<span id="pay_status_j"></span>
						</div>
						<div class="clearfix"></div>
						<div class="col-sm-4 col-xs-4" style="margin: 10px 0;">
							保全结算费用：
						</div>
						<div class="col-sm-8 col-xs-8" style="margin: 10px 0;">
							<span id="pay_amount_j"></span>
						</div>
						<div class="clearfix"></div>
						<div class="col-sm-12 col-xs-12" id="imgs">
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="payment-cont" style="position: fixed;bottom: 0;width: 100%;">
			<input type="hidden" name="payId" id="payId" />
			<div class="payment-span">
				<span class="payment-ert">关闭</span>
				<span class="p-upload">再次上传<input type="file" class="upload_pic" name="pay_file" id="upload" onchange="uploadFilePay('uploadPayForm')"/></span>
			</div>
		</div>
	</form>
</div>

<!--人员变更提示弹窗-->
<div class="personnel-changes animated" style="position: absolute!important;">
	<div class="payment-head">
		<span>提示</span>
		<a href="javascript:;" id="personnel-bi">
			<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
		</a>
	</div>
	<div class="personnel-cont">
		<p>
			如有企业人员变动（如，员工离职、新员工入职等）<br/>
			可在“我的订单”中查询对应的保险，<br/>
			点击“保全”进入保单中的人员增减操作！
		</p>
	</div>
	<div class="personnel-butt">
		<span class="personnel-bibi">关闭</span>
		<span class="personnel-wed" onclick="openPolicy()">进入“我的订单”</span><%--<c:url value='/pc/order/myOrder'/>--%>
	</div>
</div>

<!--详情弹窗-->
<%--<div class="details-popover animated" style="top: 100px!important;position: absolute!important;">
	<div class="popover-cont">
		<div class="popo-head">
			<span>缴费详情</span>
			<a href="javascript:;" id="popo-bi">
				<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
			</a>
		</div>
		<div id="loadRecordDetail">

		</div>
	</div>
</div>--%>

<!--黑色蒙版-->
<div class="black-mask"></div>
<!--黑色蒙版2-->
<div class="black-mask-more"></div>
<script src="<c:url value='/resources/versions-2.0.2/js/jquery.zoom.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0.2/js/laydate.js' />"></script>
<script src="<c:url value='/resources/versions-2.0.2/js/corrections.js' />"></script>
<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>
<jsp:include page="../../../index/multi_init_param.jsp"/>
<script type="text/javascript">
    var baseUrl = '${pageContext.request.contextPath }';
    $(function () {
        function mouse(even, stat, iconA, iconB) {
            $('.order-detail').on(even, '.guar', function () {
                $(this).siblings('.guar-list').css('display',stat);
                $(this).find('.' + iconA).removeClass(iconA).addClass(iconB);
            });
        }
        //鼠标移动到元素上显示
        mouse('mouseenter', 'block', 'down-icon', 'up-icon');
        //鼠标移出元素
        mouse('mouseleave', 'none', 'up-icon', 'down-icon');
    })
    var totalCount = Number($('#totalCount').val()) || 0;
    var showCount = $('#showCount').val() || 5;
    var limit = Number($('#numPerPage').val()) || 5;

    $('#callBackPager').extendPagination({
        totalCount: totalCount,
        showCount: showCount,
        limit: limit,
        callback: function (curr, limit, totalCount) {
            getListForPage("preservationPayForm","preservationPaysArea");
        }
    });

	function openRecordModel(){
		location.href=baseUrl+'/api/preservation/recordList?ACCESS_TOKEN=${ACCESS_TOKEN}';
	}
	function openBillModel(){
		location.href=baseUrl+'/api/preservation/pay/payList?ACCESS_TOKEN=${ACCESS_TOKEN}';
	}
	function openSettlementModel(){
		location.href=baseUrl+'/api/preservation/pay/settlementList?ACCESS_TOKEN=${ACCESS_TOKEN}';
	}



    function openPolicy(){
        location.href=baseUrl+'/api/order/myOrder?policyStatus=21&ACCESS_TOKEN=${ACCESS_TOKEN}';
    }
    function uploadPay(_id){
        $("#payId").val(_id);
    }
	function getFP(_id){
		$.ajax({
			type: 'POST',
			url:baseUrl + '/api/preservation/pay/getFP/'+_id,
			dataType:"json",
			async:false,
			success: function(json){
				layer.msg(json.msg);
				/*if(json.retType == '0') {//支付成功
					window.open(json.data);
				}else{
					layer.msg(json.msg);
				}*/
			},
			error : function(XMLHttpRequest, textStatus, errorThrown) {
				layer.msg(textStatus);
			}
		});
	}

	function uploadPay(_id,_rcount,_amount,_path){
		$("#payId").val(_id);
		$("#pay_amount_j").html(_amount+'元');
		$("#pamount").html(_amount+'元');
		$("#rcount").html(_rcount);
		var status = $("#status_"+_id).html();
		$("#pay_status_j").html(status);
		loadCanvas(_path);
	}

	function loadCanvas(_img){
		var content = document.getElementById('imgs');
		content.innerHTML = '';
		if(_img != ''){
			var imgs = _img.split("||");
			for(var i=0;i<imgs.length;i++){
				content.innerHTML += '<a href="'+imgs[i]+'" target="_blank"><img src="'+imgs[i]+'" width="100px" style="margin-right: 10px;"></a>';
			}
		}
		payUploadShow();
	}
	function payUploadShow () {
		$('.payment-voucher').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
		$('.black-mask').show();
	}

    function clearCanvas(){
        var c=document.getElementById("cvs");
        var cxt=c.getContext("2d");
        cxt.clearRect(0,0,c.width,c.height);
    }

    function uploadFilePay(_form){
        if($("#upload").val() == ''){
            return false;
        }
        var index = laySomenType(0,null,'',0);
        var formData = new FormData(document.forms.namedItem(_form));
        $.ajax({
            type: 'POST',
            url:baseUrl + '/api/preservation/pay/uploadFilePay?ACCESS_TOKEN=${ACCESS_TOKEN}',
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(json){
                laySomenType(1,null,json.message,0);
                $('.payment-voucher').addClass('fadeOutUpBig').removeClass('fadeInDownBig');
                $('.black-mask').hide();
                getListForPage("preservationPayForm","preservationPaysArea");
                laySomenType(2,index,'',0);
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                laySomenType(2,index,'',0);
                laySomenType(1,null,textStatus,0);
            }
        });
    }

    function openPayDetail(_id,_isPart){
		layer.open({
			type: 2,
			area: ['1000px', '600px'],
			title: "账单列表",
			skin:'lay-bak',
			closeBtn: 1,
			shadeClose: false,
			scrollbar: false,
			shade:0.4,
			fix: false,
			content: baseUrl + '/api/preservation/pay/billList?parentPayId='+_id+'&isPart='+_isPart+'&ACCESS_TOKEN=${ACCESS_TOKEN}'
		});
        /*$.ajax({
            type : 'POST',
            url : baseUrl + "/api/preservation/pay/getInsPreservationPayByPayId/"+_id+"?ACCESS_TOKEN=${ACCESS_TOKEN}",
            dataType : "html",
            success : function(data) {
                $("#loadRecordDetail").html(data);
            },
            error: function(){
            }
        });*/
    }

    function searchList(){
        $("#start_time").val($("#start-s2").val());
        $("#end_time").val($("#end-s2").val());
        $("#keyword").val($("#keyword_it").val());
        $("#pageNum").val(1);
        $("#numPerPage").val(5);
        $("#totalCount").val(0);
        $("#pay_status").val($('.con-s2 #status-xuan-s2').attr('data-status'));
        $("#preservationPayForm").submit();
    }

	function exportExcel(){
		var start_time = $("#start-s2").val();
		var end_time = $("#end-s2").val();
		var keyword = $("#keyword_it").val();
		var pay_status = $('.con-s2 #status-xuan-s2').attr('data-status');
		// $("#preservationPayForm").submit();

		var index = layer.confirm('该操作将根据搜索条件导出数据，是否继续？',{btn: ['导出','取消']}, function(){
			location.href=baseUrl + '/api/preservation/pay/downBillPay?keyword='+keyword+'&pay_status='+pay_status+'&start_time='+start_time+'&end_time='+end_time;
			layer.close(layer.index);
		});
	}
	function createPartBill(){
		var checkboxes = document.querySelectorAll('input[name="billId"]:checked'),
				values = [];

		checkboxes.forEach((checkbox) => {
			values.push(checkbox.value);
		});
		if(values.length == 0){
			layer.msg('请勾选账单');
			return false;
		}
		var index = layer.confirm('是否根据已勾选记录生成部分账单汇总？',{btn: ['生成','取消']}, function(){
			$.ajax({
				type:'POST',
				dataType:'json',
				url:baseUrl + '/api/preservation/pay/createPartBill',
				data:{'isSummaryBill':'1','payIds':values.join(',')},
				success:function(result){
					layer.close(index);
					if(result.status=='200'){
						layer.msg(result.msg,{icon:1,time:1000});
					}else{
						layer.alert(result.msg, {icon: 2});
					}
				}
			})
		});
	}

	function uploadSubmit(){
		var str = "<div style='width: 300px;'>" +
				"<p style='padding-bottom: 5px;'><textarea class=\"form-control\" rows=6 id=\"pdNo\" placeholder=\"请输入账单编号（多个“,”隔开）\" style=\"width: 100%\"></textarea></p>" +
				"</div>";
		var index = layer.confirm(str,{btn: ['提交','取消'], title: "生成部分账单"}, function(){
			var pdNo = $('#pdNo').val();
			if(pdNo == undefined){
				layer.msg("请输入账单编号！", {icon: 2, time: 2000});
				return;
			}
			pdNo = pdNo.replace('，',',').replace(' ','');
			$.ajax({
				type:'POST',
				dataType:'json',
				url:baseUrl + '/api/preservation/pay/createPartBillByNo',
				data:{'isSummaryBill':'1','payNos':pdNo},
				success:function(result){
					if(result.status=='200'){
						layer.msg(result.msg,{icon:1,time:1000});
						layer.close(index);
					}else{
						layer.alert(result.msg, {icon: 2});
					}
				}
			})
		});
	}

    function loadDataAndPage(){
        totalCount = Number($('#totalCount').val()) || 0;
        $('#callBackPager').extendPagination({
            totalCount: totalCount,
            showCount: showCount,
            limit: limit,
            callback: function (curr, limit, totalCount) {
                getListForPage("preservationPayForm","preservationPaysArea");
            }
        });
    };


    function getListForPage(formId,contentId){
        var index = laySomenType(0,null,'',0);
        $.ajax({
            type : 'POST',
            url : baseUrl + "/api/preservation/pay/getPayListForPage?ACCESS_TOKEN=${ACCESS_TOKEN}",
            data : $("#"+formId).serialize(),
            dataType : "text",
            success : function(data) {
                laySomenType(2,index,'',0);
                $("#"+contentId).html(data);
            },
            error: function(){
                laySomenType(2,index,'',0);
            }
        });
    }

    function choisePolicyStatus(policyStatus,totalCount,obj){
        $(".order-list li").removeClass("active");
        $(obj).addClass("active");
        $("#policyStatus").val(policyStatus);
        $('#totalCount').val(totalCount);
        $('#pageNum').val("1");
        loadDataAndPage();
        getListForPage("preservationPayForm","preservationPaysArea");
    }

    function deletePreservationRecord(preservationId){
        layer.confirm('确定删除此订单？', {
            btn: ['确定','取消'] //按钮
        }, function(){
            layer.closeAll();
            var index = laySomenType(0,null,'',0);
            $.ajax({
                type : 'POST',
                url : baseUrl + "/api/preservation/deleteInsPreservationRecord?ACCESS_TOKEN=${ACCESS_TOKEN}",
                data : {
                    "oid":preservationId,
                },
                dataType : "json",
                success : function(data) {
                    laySomenType(2,index,'',0);
                    laySomenType(1,null,data.message,0);
                    if(data.status =="200"){
                        getListForPage("preservationPayForm","preservationPaysArea");
                    }
                },
                error: function(){
                    laySomenType(2,index,'',0);
                }
            });
        });
    }

    function refreshTotal(){
        var total = Number($("#"+id).html());
        var totalCount = total -1;
        var numPerPage = Number($('#numPerPage').val());
        var pageNum = Number($("#pageNum").val());
        if(totalCount%numPerPage ==0)
            pageNum = pageNum -1;

        $("#"+id).html(totalCount);
        $('#totalCount').val(totalCount);
        $('#pageNum').val(pageNum);
        loadDataAndPage();

        $("#callBackPager li").each(function(){
            $(this).removeClass('active');
            if ($(this).find('a').html() == pageNum) {
                $(this).addClass('active');
            }
        });

        getListForPage("preservationPayForm","preservationPaysArea");
    }
</script>
</body>
</html>

<script>
    $('ul.aside-list li').removeClass('on');
    $("#myPreservation").addClass('on');
</script>