<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<ul class="tab-title">
	<li class="wid-220">基本信息</li>
	<li>被保险人</li>
	<li>保障时间</li>
	<li>份数</li>
	<li>保费（元）</li>
	<li>状态</li>
	<li>操作</li>
</ul>
<div class="tab-content">
	<c:choose>
		<c:when test="${empty orderList }">
			<div class="order-detail">
				<ul class="order-num">
					<li style="float: none">
						<p style="text-align: center">暂无订单！！</p>
					</li>
				</ul>
			</div>
		</c:when>
		<c:otherwise>
			<c:forEach items="${orderList }" var="policy">
				<div class="order-detail">
					<ul class="order-num">
						<li>
							<span  class="num-name">订单号：</span>
							<span>${policy.trade_serial_number}</span>
						</li>
						<li>
							<c:choose>
								<c:when test="${empty policy.external_reference && not empty policy.policy_serial_number}">
									<span  class="num-name">投保单号：</span>
									<span>${policy.policy_serial_number}</span>
								</c:when>
								<c:otherwise>
									<span  class="num-name">保单号：</span>
									<span>${policy.external_reference}</span>
								</c:otherwise>
							</c:choose>
						</li>
						<li class="order-time">
							创建时间：${policy.start_time}
						</li>
					</ul>
					<ul class="tab-body">
						<li class="wid-220 two">
							<c:if test="${fn:contains(policy.product_code, 'TYX')}">
								<a href="<c:url value='/api/gmr/product/productInfo/${policy.product_oid }?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="insu">${policy.product_name }</a>
							</c:if>
							<c:if test="${fn:contains(policy.product_code, 'GZZRX')}">
								<a href="<c:url value='/insurance/gzzrx/product/productInfo/${policy.product_oid }?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="insu">${policy.product_name }</a>
							</c:if>
							<c:if test="${fn:contains(policy.product_code, 'GZX-HT')}">
								<a href="<c:url value='/api/afr/productInit/${policy.product_oid }?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="insu">${policy.product_name }</a>
							</c:if>
							<c:if test="${fn:contains(policy.product_code, 'GZX-PAC')}">
								<a href="<c:url value='/insurance/gzx/product/productInfo/${policy.product_oid }?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="insu">${policy.product_name }</a>
							</c:if>
						</li>
						<li class="wed">
							<span>
								<c:choose>
									<c:when test="${fn:contains(policy.product_code, 'TYX')||fn:contains(policy.product_code, 'GZZRX') }">
										团体
									</c:when>
									<c:otherwise>
										${policy.insured_role}
									</c:otherwise>
								</c:choose>
							</span>
						</li>
						<li class="three">
							<div class="qoi">${policy.inception_date}</div>
							<div>至</div>
							<div>
								${policy.planned_end_date}
							</div>
						</li>
						<li>
							<span>
								1份
							</span>
						</li>
						<li>
							<span>
								￥${policy.gross_premium}
							</span>
						</li>
						<li class="pay">
							<span>
									${fns:getDictLabel (policy.policy_status,"order_status","")}
							</span>
						</li>
						<li class="pay-delete">
							<c:if test="${policy.policy_status != '1' }">
								<a href="<c:url value='/api/order/orderDetailByOrderID/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">查看${ empty policy.external_reference ? '投保单':'保单'}</a>
							</c:if>
							<c:if test="${policy.policy_status eq '1' }">
								<c:if test="${fn:contains(policy.product_code, 'TYX') }">
									<a href="<c:url value='/api/gmr/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">继续投保</a>
								</c:if>
								<c:if test="${fn:contains(policy.product_code, 'GZX-HT') }"><a href="<c:url value='/api/gzx/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">继续投保</a></c:if>
								<c:if test="${fn:contains(policy.product_code, 'ZZX-HT') }"><a href="<c:url value='/api/lote/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">继续投保</a></c:if>
								<c:if test="${fn:contains(policy.product_code, 'GZX-PAC') }"><a href="<c:url value='/api/gzx/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">继续投保</a></c:if>
								<c:if test="${fn:contains(policy.product_code, 'GZZRX') }"><a href="<c:url value='/api/gzzrx/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">继续投保</a></c:if>
							</c:if>
							<c:if test="${policy.policy_status eq '3'}">
								<c:choose>
									<c:when test="${fn:contains(policy.product_code, 'TYX-PAC') }">
										<a href="<c:url value='/api/gmr/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">缴费单</a>
									</c:when>
									<c:when test="${fn:contains(policy.product_code, 'GZZRX-ZH') }">
										<a href="<c:url value='/api/gzzrx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">缴费单</a>
									</c:when>
									<c:when test="${fn:contains(policy.product_code, 'TYX-CA') }">
										<a href="<c:url value='/api/gmr/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">缴费单</a>
									</c:when>
									<c:when test="${fn:contains(policy.product_code, 'GZZRX-CA') }">
										<a href="<c:url value='/insurance/gzzrx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">缴费单</a>
									</c:when>
									<c:otherwise>
										<a target="_blank" href="<c:url value='/insurance/customs/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">确认报价</a>
									</c:otherwise>
								</c:choose>
							</c:if>
							<c:if test="${policy.policy_status eq '4'}">
								<c:if test="${fn:contains(policy.product_code, 'TYX') }">
									<a href="<c:url value='/api/gmr/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">立即支付</a>
								</c:if>
								<c:if test="${fn:contains(policy.product_code, 'GZX-HT') }"><a href="<c:url value='/api/gzx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">立即支付</a></c:if>
								<c:if test="${fn:contains(policy.product_code, 'ZZX-HT') }"><a href="<c:url value='/api/lote/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">立即支付</a></c:if>
								<c:if test="${fn:contains(policy.product_code, 'GZX-PAC') }"><a href="<c:url value='/api/gzx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">立即支付</a></c:if>
								<c:if test="${fn:contains(policy.product_code, 'GZZRX') }"><a href="<c:url value='/api/gzzrx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">立即支付</a></c:if>
							</c:if>
							<c:if test="${policy.policy_status eq '6' && (fn:contains(policy.product_code, 'TYX') || fn:contains(policy.product_code, 'GZZRX')) }">
								<a href="<c:url value='/api/preservation/resultSet/resultSetList?policyId=${policy.oid }&ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">保全</a>
							</c:if>
							<c:if test="${policy.policy_status eq '6' && fn:contains(policy.product_code, 'TYX-PAC') }">
								<a href="https://icore-cmss.pingan.com.cn/html/visitor/AHI/index.html#/applyTips?systemPageSource=thirdParty" class="again-pay">理赔申请</a>
							</c:if>
							<c:if test="${policy.policy_status eq '6' && (fn:contains(policy.product_code, 'GZZRX-PAC')||fn:contains(policy.product_code, 'GZZRX-ZH')||fn:contains(policy.product_code, 'GZZRX-CA')||fn:contains(policy.product_code, 'TYX-CA')) }">
								<a href="<c:url value='/api/report/reportInit/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">理赔申请</a>
							</c:if>
							<c:if test="${ policy.policy_status eq '16' && fn:contains(policy.product_code, 'GZZRX-PAC')}">
								<a href="<c:url value='/api/gzzrx/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">缴费单</a>
							</c:if>
							<c:if test="${policy.policy_status eq '3' || policy.policy_status eq '4' }">
								<div class="again-pay" onclick="copyOrder('${policy.oid }');">复制</div>
							</c:if>
							<c:if test="${policy.policy_status eq '1' || policy.policy_status eq '4' }">
								<div class="delete" onclick="deleteOrder('${policy.oid }','${policy.policy_status }');">删除</div>
							</c:if>
						</li>
					</ul>
				</div>
			</c:forEach>
		</c:otherwise>
	</c:choose>
</div>
<script>
	$('.order-detail ul.tab-body li.wed').each(function () {
		var s = $(this).find('p').height();
		if(s > 95 && s < 210){
			$('.order-detail ul.tab-body li.wed').css({"line-height":'28px',"padding-top":"18px"});
		}else if(s > 210){
			$('.order-detail ul.tab-body li.wed').css({"line-height":'28px',"padding-top":"5px"});
		}
	})
    $('.order-detail ul.tab-body li.pay-delete').each(function () {
        var s = $(this).children().length;
        if(s <= 2){
            $(this).css({"line-height":'28px',"padding-top":"18px"});
        }else if(s > 2){
            $(this).css({"line-height":'28px',"padding-top":"2px"});
        }
    })
</script>
