<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
<head>

    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" />
</head>
<body>

<div class="container"><!-- container start -->

    <ol class="breadcrumb" id="bread_crumbs">
        <%--<li>当前位置： </li>
        <li><a href="<c:url value='/api/order/myOrder' />">我的订单</a></li>
        <li><a href="<c:url value='/api/gmr/product/productInfo/${dto.product_oid}'/>">产品详情</a></li>
        <li class="active">投保</li>--%>
    </ol>
    <div class="nav-list">
        <div class="row w-80-auto">
            <div class="col-sm-3 col-sm-4 active">
                <p><i class="pull-left">1</i><span class=" pull-left">填写保险信息</span></p>
            </div>
            <div class="col-sm-3 col-sm-4">
                <p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
            </div>
            <div class="col-sm-3 col-sm-3">
                <p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
            </div>
            <div class="col-sm-3 col-sm-3 pull-right">
                <p><i class="pull-left">4</i><span class="pull-left"> 完成投保</span></p>
            </div>
        </div>
    </div>
    <form class="form-horizontal form-create-item" method="post" id="policyInfoForm">
        <input type="hidden" name="oid" id="policyOid" value="${dto.oid}"/>
        <input type="hidden" name="product_id" id="productOid" value="${not empty dto.product_oid ? dto.product_oid : ''}"/>
        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>推荐人信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-4 col-xs-4">
                    <p>推荐人的手机号或编号</p>
                    <input type="text" name="recommend_code" id="recommend_code" data-relate="${not empty dto.product_oid ? dto.product_oid : ''}" value="${empty vo.recommend_code ? recommend_code : vo.recommend_code}" class="form-control" placeholder="请输入推荐人的手机号或编号" maxlength="20"/>
                    <input type="hidden" name="sigId" value="${dto.trade_serial_number}"/>
                </div>
                <div class="col-sm-4 col-xs-4">
                </div>
                <div class="col-sm-4 col-xs-4">
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
        <div class="message-war"><!-- message-war start -->
            <input type="hidden" name="roleSubjectList[0].oid" id="role_appRoleID_0" value="${vo.roleSubjectList[0].oid}"/>
            <input type="hidden" name="roleSubjectList[0].kind" id="role_kind_0" value="1"/>
            <div class="title-war"><h3 id="cy_lxr">投保单位信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-3 col-xs-3">
                    <p>*投保人类型</p>
                    <select Data-Val="Required" class="form-control" name="roleSubjectList[0].role_type" id="role_roleType_0" value="${vo.roleSubjectList[0].role_type}" onchange="roleTypeChange(this)" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="1"<c:if test="${vo.roleSubjectList[0].role_type eq '1' }"> selected="selected"</c:if>>参展商</option>
                        <option value="2"<c:if test="${vo.roleSubjectList[0].role_type eq '2' }"> selected="selected"</c:if>>搭建商</option>
                    </select>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
                <div class="col-sm-6 col-xs-6">
                    <p>*企业名称<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="请填写与营业执照相一致的单位名称，个人不能作为投保单位"></i></p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].name_cn" id="role_namecn_0" value="${vo.roleSubjectList[0].name_cn}" class="form-control"<%-- data-toggle="tooltip" data-placement="top" title="请填写与营业执照相一致的单位名称"--%> />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-6 col-xs-6">
                    <p>*营业性质</p>
                    <div class="row">
                        <div class="col-sm-6 col-xs-6">
                            <select data-val="Required" name="roleSubjectList[0].com_nature" id="role_comNature_0" class="form-control" onchange="natureChange(this,'role_natureTwo_0');" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">-请选择-</option>
                                <c:forEach items="${natureList }" var="list">
                                    <option value="${list.value }" <c:if test="${vo.roleSubjectList[0].com_nature eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-6 col-xs-6" <c:if test="${empty vo.roleSubjectList[0].nature_two }"> hidden</c:if>>
                            <select name="roleSubjectList[0].nature_two" id="role_natureTwo_0" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">-请选择-</option>
                                <c:forEach items="${natureTwoList }" var="list">
                                    <option value="${list.value }" <c:if test="${vo.roleSubjectList[0].nature_two eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                                </c:forEach>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*证件类型</p>
                    <select Data-Val="Required" class="form-control" name="roleSubjectList[0].id_type" id="role_idType_0" value="${vo.roleSubjectList[0].id_type}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="">-请选择-</option>
                        <c:forEach items="${comTypeList }" var="list">
                            <option value="${list.value }" <c:if test="${vo.roleSubjectList[0].id_type eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*证件号码<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="组织机构代码：只能包含数字或英文大写字母，必须用连字符“-”隔开；营业执照：只能为15位数字；税务登记证：只能为15位数字，或20位数字，或19位数字与字母X组合；三证合一统一信用代码：由数字或大写英文字母组成，共18位"></i></p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].organization_code" id="role_organizationCode_0" GIST-ID="role_idType_0" value="${vo.roleSubjectList[0].organization_code}" class="form-control"/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
                <div class="col-sm-9 col-xs-9">
                    <p>*注册地址</p>
                    <div class="row">
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="省" name="roleSubjectList[0].reg_province" id="regProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regCity', '', '2', this);">
                                <option value="">请选择省</option>
                                <c:forEach items="${provinceList }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_province }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="市" name="roleSubjectList[0].reg_city" id="regCity" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regDistrict', '', '3', this);">
                                <option value="">请选择市</option>
                                <c:forEach items="${cityList }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_city}"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="县" name="roleSubjectList[0].reg_district" id="regDistrict" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">请选择县</option>
                                <c:forEach items="${areaList }" var="list">
                                    <option value="${list.codes }" <c:if test="${vo.roleSubjectList[0].reg_district eq list.codes }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <input Data-Val="Required" type="text" name="roleSubjectList[0].reg_address" id="regAddress" value="${vo.roleSubjectList[0].reg_address}" class="form-control" placeholder="请填写具体地址（包含：镇、乡或街道）" />
                            <span class="glyphicon form-control-feedback t-icon-l" style="top:0;" aria-hidden="true" ></span>
                        </div>
                    </div>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人姓名</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].link_name" id="role_linkName_0" value="${vo.roleSubjectList[0].link_name}" class="form-control" placeholder="请填写联系人名称" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人手机</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].link_tel" id="role_linkTel_0" value="${vo.roleSubjectList[0].link_tel}" class="form-control" placeholder="请填写联系人手机号" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人email</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].link_email" id="role_linkEmail_0" value="${vo.roleSubjectList[0].link_email}" class="form-control" placeholder="请填写联系人邮箱" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->

        <div class="message-war"><!-- message-war start -->
            <input type="hidden" name="roleSubjectList[1].oid" id="role_oid_1" value="${vo.roleSubjectList[1].oid}"/>
            <input type="hidden" name="roleSubjectList[1].kind" id="role_kind_1" value="2"/>
            <div class="title-war"><h3 <%--id="cy_lxr_bb"--%>>被保险人信息</h3> </div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-3 col-xs-3 mt-20" id="zd_tc">
                    <span class="pull-left check-box">
                        <input type="checkbox" id="zd_tc_cb" onclick="msgClone()"/>
                        <label for="zd_tc_cb"></label>
                    </span>
                    <span class="pull-left lhml5">同步投保人信息<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="选中该项，投保人信息将同步到被保险人，取消选中，将清空被保险人已输入信息"></i></span>
                </div>
                <div class="clear"></div>
                <div class="col-sm-6 col-xs-6">
                    <p id="p_p_1">*被保险人名称</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].name_cn" id="role_namecn_1" value="${vo.roleSubjectList[1].name_cn}" class="form-control" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-6 col-xs-6">
                    <p>*营业性质</p>
                    <div class="row">
                        <div class="col-sm-6 col-xs-6">
                            <select data-val="Required" name="roleSubjectList[1].com_nature" id="role_comNature_1" class="form-control" onchange="natureChange(this,'role_natureTwo_1');" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">-请选择-</option>
                                <c:forEach items="${natureList }" var="list">
                                    <option value="${list.value }" <c:if test="${vo.roleSubjectList[1].com_nature eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-6 col-xs-6" <c:if test="${empty vo.roleSubjectList[1].nature_two }"> hidden</c:if>>
                            <select name="roleSubjectList[1].nature_two" id="role_natureTwo_1" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">-请选择-</option>
                                <c:forEach items="${natureTwoList1 }" var="list">
                                    <option value="${list.value }" <c:if test="${vo.roleSubjectList[1].nature_two eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                                </c:forEach>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p id="p_p_2">*证件类型</p>
                    <select Data-Val="Required" class="form-control" name="roleSubjectList[1].id_type" id="role_idType_1" value="${vo.roleSubjectList[1].id_type}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="">-请选择-</option>
                        <c:forEach items="${comTypeList }" var="list">
                            <option value="${list.value }" <c:if test="${vo.roleSubjectList[1].id_type eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p id="p_p_3">*证件号码</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].organization_code" id="role_organizationCode_1" GIST-ID="role_idType_1" value="${vo.roleSubjectList[1].organization_code}" class="form-control"/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
                <div class="col-sm-9 col-xs-9">
                    <p>*详细地址</p>
                    <div class="row">
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="省" name="roleSubjectList[1].reg_province" id="regProvince_1" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regCity_1', '', '2', this);">
                                <option value="">请选择省</option>
                                <c:forEach items="${provinceList }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[1].reg_province }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="市" name="roleSubjectList[1].reg_city" id="regCity_1" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regDistrict_1', '', '3', this);">
                                <option value="">请选择市</option>
                                <c:forEach items="${reg_city_1_List }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[1].reg_city}"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="县" name="roleSubjectList[1].reg_district" id="regDistrict_1" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">请选择县</option>
                                <c:forEach items="${reg_area_1_List }" var="list">
                                    <option value="${list.codes }" <c:if test="${vo.roleSubjectList[1].reg_district eq list.codes }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <input Data-Val="Required" title="联系地址" type="text" name="roleSubjectList[1].reg_address" id="regAddress_1" value="${vo.roleSubjectList[1].reg_address}" class="form-control" placeholder="请填写具体地址（包含：镇、乡或街道）" onblur="validateForms(this)" />
                            <span class="glyphicon form-control-feedback t-icon-l" style="top:0;" aria-hidden="true" ></span>
                        </div>
                    </div>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人姓名</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].link_name" id="role_linkName_1" value="${vo.roleSubjectList[1].link_name}" class="form-control" placeholder="请填写联系人名称" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人手机</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].link_tel" id="role_linkTel_1" value="${vo.roleSubjectList[1].link_tel}" class="form-control" placeholder="请填写联系人手机号" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人email</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].link_email" id="role_linkEmail_1" value="${vo.roleSubjectList[1].link_email}" class="form-control" placeholder="请填写联系人邮箱" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
            </div>
        </div><!-- message-war end -->

        <div class="message-war"><!-- message-war start -->
            <input type="hidden" name="specialExhibitionVo.oid" id="special_oid_0" value="${vo.specialExhibitionVo.oid}"/>
            <div class="title-war"><h3>投保基本信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-3 col-xs-3">
                    <p>*展会名称</p>
                    <input Data-Val="Required" type="text" name="specialExhibitionVo.name" id="special_name" value="${vo.specialExhibitionVo.name}" class="form-control" placeholder="请填写展会活动的具体名称" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>

                <div class="col-sm-9 col-xs-9">
                    <p>*展会举办地址</p>
                    <div class="row">
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="省" name="specialExhibitionVo.ex_province" id="special_ex_province" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('special_ex_city', '', '2', this);">
                                <option value="">请选择省</option>
                                <c:forEach items="${provinceList }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.specialExhibitionVo.ex_province }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="市" name="specialExhibitionVo.ex_city" id="special_ex_city" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('special_ex_county', '', '3', this);">
                                <option value="">请选择市</option>
                                <c:forEach items="${exCityList }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.specialExhibitionVo.ex_city}"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="县" name="specialExhibitionVo.ex_county" id="special_ex_county" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">请选择县</option>
                                <c:forEach items="${exAreaList }" var="list">
                                    <option value="${list.codes }" <c:if test="${vo.specialExhibitionVo.ex_county eq list.codes }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <input Data-Val="Required" type="text" name="specialExhibitionVo.ex_address" id="special_ex_address" value="${vo.specialExhibitionVo.ex_address}" class="form-control" placeholder="请填写详细地址" />
                            <span class="glyphicon form-control-feedback t-icon-l" style="top:0;" aria-hidden="true" ></span>
                        </div>
                    </div>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*是否包含拆搭建</p>
                    <select Data-Val="Required" name="specialExhibitionVo.contains" id="special_contains" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="">请选择</option>
                        <option value="0" <c:if test="${ vo.specialExhibitionVo.contains eq '0' }"> selected="selected"</c:if>>否</option>
                        <option value="1" <c:if test="${vo.specialExhibitionVo.contains eq '1' }"> selected="selected"</c:if>>是</option>
                    </select>
                </div>

                <div class="col-sm-8 col-xs-8">
                    <p>*保障时间<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="${fn:contains(dto.product_code, 'ZZX-YA')?'保障时间可为展会活动期间或搭建商搭拆建期间，请选择展会活动开始时间或展位搭建时间作为起保日期。':'保障时间为展会活动期间，也可为展位搭建拆除时间，请根据展位实际情况选择保障时间。'}"></i></p>
                    <div class="row">
                        <div class="col-sm-4 col-xs-4">
                            <input Data-Val="Date Required" type="text" name="specialExhibitionVo.star_time" id="special_star_time" value="${ vo.specialExhibitionVo.star_time}" class="laydate-icon form-control" autocomplete="off">
                            <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                        </div>
                        <div class="col-sm-4 col-xs-4">
                            <input Data-Val="Date Required" type="text" name="specialExhibitionVo.end_time" id="special_end_time" value="${ vo.specialExhibitionVo.end_time}" class="laydate-icon form-control" ${fn:contains(dto.product_code, 'ZZX-YA') ? 'readonly':''}  autocomplete="off">
                            <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                        </div>
                    </div>
                </div>
                <div class="clear"></div>
                <div class="col-sm-3 col-xs-3">
                    <p>*展位号<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="多展位用字母小写“,”隔开，或通过检索展位再添加。如：A001,A002"></i></p>
                    <input Data-Val="Required" type="text" name="specialExhibitionVo.ex_no" id="special_ex_no" value="${vo.specialExhibitionVo.ex_no}" class="form-control" placeholder="" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <%--<div class="clear"></div>--%>
                <div class="col-sm-3 col-xs-3">
                    <p>*展位总面积（平米）</p>
                    <c:set var="acreage_placeholder" value="${fn:contains(dto.product_code, 'PAC-1')?'展位总面积在1~36平米之间':fn:contains(dto.product_code, 'PAC-2')?'展位总面积在1~100平米之间':fn:contains(dto.product_code, 'PAC-3')?'展位总面积必须在1平米以上':fn:contains(dto.product_code, 'ZZX-YA')?'展位总面积必须在1平米以上':'展位总面积在1~108平米之间'}"/>
                    <input Data-Val="Num Required" type="text" name="specialExhibitionVo.ex_acreage" id="special_ex_acreage" value="${vo.specialExhibitionVo.ex_acreage}" class="form-control" placeholder="${acreage_placeholder}" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*雇员总人数</p>
                    <input Data-Val="Num Required" type="text" name="specialExhibitionVo.ex_emp_num" id="special_ex_emp_num" value="${vo.specialExhibitionVo.ex_emp_num}" class="form-control" placeholder="请填写雇员人数" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3" style="${vo.specialExhibitionVo.contains != '1' ? 'display: none;' : '' }">
                    <p>搭建公司名称</p>
                    <input type="text" name="specialExhibitionVo.build_com_name" id="special_ex_build_com_name" value="${vo.specialExhibitionVo.build_com_name.trim()}" class="form-control" placeholder="主要搭建公司名称，如无可不填" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3" style="${vo.specialExhibitionVo.contains != '1' ? 'display: none;' : '' }">
                    <p>转包单位</p>
                    <input type="text" name="specialExhibitionVo.subcontracting_units" id="special_ex_subcontracting_units" value="${vo.specialExhibitionVo.subcontracting_units.trim()}" class="form-control" placeholder="转包单位名称，如无可不填" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
                <div class="col-sm-3 col-xs-3" style="display: none;">
                    <p>参展商名称</p>
                    <input Data-Val="" type="text" name="specialExhibitionVo.exhibitor_name" id="special_exhibitor_name" value="${vo.specialExhibitionVo.exhibitor_name.trim()}" class="form-control" placeholder="请填写参展商名称" onblur="verifyForm(this)" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3" style="display: none;">
                    <p>*证件类型</p>
                    <select Data-Val="" class="form-control" name="specialExhibitionVo.exhibitor_type" id="special_exhibitor_type" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="verifyForm(this)">
                        <option value="">-请选择-</option>
                        <c:forEach items="${comTypeList }" var="list">
                            <option value="${list.value }" <c:if test="${vo.specialExhibitionVo.exhibitor_type.trim() eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3" style="display: none;">
                    <p>*证件号码</p>
                    <input Data-Val="" type="text" name="specialExhibitionVo.exhibitor_code" id="special_exhibitor_code" GIST-ID="special_exhibitor_type" value="${vo.specialExhibitionVo.exhibitor_code.trim()}" class="form-control" onblur="verifyForm(this)"/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7" style="display: none;"></div>
                <div class="col-sm-12 col-xs-12">
                    <p>保障方案确认</p>
                    <div class="affirm-warr">
                        <table class="table ">
                            <tbody>
                            <tr>
                                <td class="col-sm-6 col-xs-6">保障责任</td>
                                <td class="col-sm-6 col-xs-6">保障金额</td>
                            </tr>
                            <c:forEach items="${ pd.responsibilityVoList }" var="irp">
                                <tr <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>
                                    <td class="col-sm-6 col-xs-6">${irp.name}</td>
                                    <td class="col-sm-6 col-xs-6">
                                        <c:choose>
                                            <c:when test="${empty irp.insurance_amount_max && not empty irp.fcy}">
											<span>
												<c:if test="${ empty irp.fcy}">
                                                    -
                                                </c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.fcy}">
                                                    <c:if test="${irp.fcy/10000 >= 1}">
                                                        ${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
                                                        万元
                                                    </c:if>
                                                    <c:if test="${irp.fcy/10000 < 1}">
                                                        ${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
                                                        元
                                                    </c:if>
                                                </c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.fcy}">
                                                    <c:if test="${irp.fcy/10000 >= 1}">
                                                        ${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
                                                        万元/天
                                                    </c:if>
                                                    <c:if test="${irp.fcy/10000 < 1}">
                                                        ${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
                                                        元/天
                                                    </c:if>
                                                </c:if>
											</span>
                                            </c:when>
                                            <c:when test="${empty irp.fcy && not empty irp.insurance_amount_max}">
											<span>
												<c:if test="${ empty irp.insurance_amount_max}">
                                                    -
                                                </c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.insurance_amount_max}">
                                                    <c:if test="${irp.insurance_amount_max/10000 >= 1}">
                                                        ${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
                                                        万元
                                                    </c:if>
                                                    <c:if test="${irp.insurance_amount_max/10000 < 1}">
                                                        ${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
                                                        元
                                                    </c:if>
                                                </c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.insurance_amount_max}">
                                                    <c:if test="${irp.insurance_amount_max/10000 >= 1}">
                                                        ${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
                                                        万元/天
                                                    </c:if>
                                                    <c:if test="${irp.insurance_amount_max/10000 < 1}">
                                                        ${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
                                                        元/天
                                                    </c:if>
                                                </c:if>
											</span>
                                            </c:when>
                                            <c:otherwise>
                                                <span>-</span>
                                            </c:otherwise>
                                        </c:choose>
                                    </td>
                                </tr>
                            </c:forEach>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="col-sm-12 col-xs-12">
                    <div class="row">
                        <div class="col-sm-6 col-sm-6 mt-20">
                            <div class="insure-check">
                                    <span class="check-box pull-left" id="check_span">
                                        <input type="checkbox" id="check_007" class="form-control" Data-Val="Required" />
                                        <label for="check_007" id="check_007_for"></label>
                                    </span>
                                <span class="pull-left" style="line-height: 13px;font-weight: bold;color: red">本企业理解并接受上述保障方案</span><br />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7" style="display: none;"></div>
                <div class="col-sm-12 col-xs-12" id="sifa_text_1_isHidden">
                    <p>司法管辖</p>
                    <div><span>中华人民共和国司法管辖（港澳台除外）</span></div>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
                <div class="col-sm-12 col-xs-12">
                    <p>争议处理</p>
                    <div><span>若投保人/被保险人与保险人发生争执，不能达成协议，被保险人自愿采取的解决方式：</span></div>
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="row">
                                <div class="col-sm-2 col-xs-2 rad-io mt-20">
                                    <span><input type="radio" value="0" name="specialExhibitionVo.dispute" id="dispute_radio1" onclick="checkToradio('dispute_radio1','radio');" <c:if test="${ empty vo.specialExhibitionVo.dispute || vo.specialExhibitionVo.dispute eq '0' }"> checked="checked" </c:if>><label for="dispute_radio1" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('dispute_radio1','radio');">商议或诉讼</strong></span>
                                </div>
                                <%--<div class="col-sm-2 col-xs-2 rad-io mt-20">
                                    <span><input type="radio" value="1" name="specialExhibitionVo.dispute" id="dispute_radio2" onclick="checkToradio('dispute_radio2','radio');"  <c:if test="${vo.specialExhibitionVo.dispute eq '1' }"> checked="checked" </c:if>><label for="dispute_radio2" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('dispute_radio2','radio');">仲裁，仲裁机构</strong></span>
                                </div>
                                <div class="col-sm-3 col-xs-3" <c:if test="${empty vo.specialExhibitionVo.dispute ? true : vo.specialExhibitionVo.dispute eq '0' }"> style="display: none;" </c:if>>
                                    <input type="text" name="specialExhibitionVo.arbitral_institution" id="arbitralInstitution" value="${vo.specialExhibitionVo.arbitral_institution }" class="form-control su-lo">
                                    <span class="glyphicon form-control-feedback pa-27" aria-hidden="true"></span>
                                </div>--%>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>保费</p>
                        <strong class="d-l-36" id="mPremium">${empty dto.gross_premium ? '0.00' : dto.gross_premium}元</strong>
                        <input type="hidden" name="premium" id="premium" value="${empty dto.gross_premium ? '0.00' : dto.gross_premium}"/>
                    </div>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->

        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>退保账户信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-12 col-xs-12 reminder">
                    <label>温馨提示：团意险/雇主险每期结算保费时，若有需要退回保费的情况，将往以下账户进行转账。</label>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户行省</p>
                    <select Data-Val="Required" title="省" name="roleSubjectList[0].bank_province" id="tkbankProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('bank_city_0', '', '2', this);">
                        <option value="">请选择省</option>
                        <c:forEach items="${provinceList }" var="list">
                            <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].bank_province }"> selected="selected"</c:if>>${list.named }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户行市</p>
                    <select Data-Val="Required" title="市" name="roleSubjectList[0].bank_city" id="bank_city_0" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeBankType('bank_type_0', this);">
                        <option value="">请选择市</option>
                        <c:forEach items="${bankCityList }" var="list">
                            <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].bank_city}"> selected="selected"</c:if>>${list.named }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户银行</p>
                    <select Data-Val="Required" title="市" name="roleSubjectList[0].bank_type" id="bank_type_0" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeBankAddr('bank_addr_0', 'bank_city_0', this);">
                        <option value="">请选择名称</option>
                        <c:forEach items="${bankTypeList }" var="list">
                            <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].bank_type}"> selected="selected"</c:if>>${list.named }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户行地址</p>
                    <select Data-Val="Required" title="市" name="roleSubjectList[0].bank_addr" id="bank_addr_0" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeBankName('bank_name_0', this);">
                        <option value="">请选择地址</option>
                        <c:forEach items="${bankAddrList }" var="list">
                            <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].bank_addr}"> selected="selected"</c:if>>${list.named }</option>
                        </c:forEach>
                    </select>
                    <input Data-Val="Required" type="hidden" name="roleSubjectList[0].bank_name" id="bank_name_0" value="${vo.roleSubjectList[0].bank_name}" class="form-control" />
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*账户开户类型</p>
                    <select Data-Val="Required" title="市" name="roleSubjectList[0].bank_pub_pri" id="bank_pub_pri_0" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="">请选择类型</option>
                        <option value="1" <c:if test="${'1' eq vo.roleSubjectList[0].bank_pub_pri}"> selected="selected"</c:if>>对公</option>
                        <option value="2" <c:if test="${'2' eq vo.roleSubjectList[0].bank_pub_pri}"> selected="selected"</c:if>>对私</option>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户名</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].account_name" id="account_name_0" value="${vo.roleSubjectList[0].account_name}" class="form-control" placeholder="请填写开户名" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <%--<div class="col-sm-3 col-xs-3">
                    <p>*账户开户行</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].bank_name" id="bank_name_0" value="${vo.roleSubjectList[0].bank_name}" class="form-control" placeholder="请填写账户开户行" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>--%>
                <div class="col-sm-3 col-xs-3">
                    <p>*银行账号</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].bank_account" id="bank_account_0" value="${vo.roleSubjectList[0].bank_account}" class="form-control" placeholder="请填写银行账号" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->

        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>单证信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-12 col-xs-12 reminder" style="line-height: 25px;">
                    <label>
                        温馨提示：<br/>
                        1.本产品采取电子保单/电子发票形式，投保成功后，电子保单及电子发票会实时发送到您填写的投保人邮箱中；<br/>
                        2.根据《中华人民共和国合同法》第十一条规定，数据电文是合法的合同表现形式，<span style="color:red;">电子保单与纸质保单具有同等法律效力</span>；您可以登录保险公司官网自助查询对电子保单的真实性进行验证；<br/>
                        <span style="color:red;">3.电子发票是以电子方式存储的收付款凭证，其法律效力、基本用途、基本使用规定等与税务机关监制的纸质发票相同。</span>
                    </label>
                </div>
                <div class="col-sm-6 col-xs-6 mt-20" style="margin-top: 10px;">
                    <span class="pull-left check-box">
                        <input type="checkbox" checked="checked" id="need_insur_dz" disabled/>
                        <label for="need_insur_dz"></label>
                    </span>
                    <span class="pull-left lhml5">开具电子保单<span class="label label-primary" style="margin-left: 5px;border-radius: 0;padding: .1em .3em .2em;">系统默认</span>（实时出单、安全保密、易存易查、不影响理赔）</span>
                </div>
                <div class="clear"></div>
                <div class="col-sm-6 col-xs-6 mt-20" style="margin-top: 10px;">
                    <span class="pull-left check-box">
                        <c:set var="is_send_einvoice_1" value="${(not empty vo.mailPolicyVo.is_send_einvoice && vo.mailPolicyVo.is_send_einvoice eq '1')?'1':'0'}"></c:set>
                        <input type="checkbox" value="1" id="is_send_einvoice"<c:if test="${is_send_einvoice_1 eq '1'}"> checked="checked"</c:if>/>
                        <label for="is_send_einvoice"></label>
                        <input type="hidden" name="mailPolicyVo.is_send_einvoice" value="${vo.mailPolicyVo.is_send_einvoice}" />
                    </span>
                    <span class="pull-left lhml5">开具电子发票<span class="label label-success" style="margin-left: 5px;border-radius: 0;padding: .1em .3em .2em;">推荐使用</span>（实时开具、加密防伪、长期保存、随打随用）</span>
                </div>
                <div class="clear"></div>
                <div class="col-sm-6 col-xs-6 mt-20" style="margin-top: 10px;">
                    <span class="pull-left check-box">
                        <c:set var="is_need_insur_bill" value="${(not empty vo.mailPolicyVo.need_insur_bill && vo.mailPolicyVo.need_insur_bill eq '1')?'1':'0'}"></c:set>
                        <input type="checkbox" value="1" name="mailPolicyVo.need_insur_bill" id="need_insur_bill"<c:if test="${is_need_insur_bill eq '1'}"> checked="checked"</c:if>/>
                        <label for="need_insur_bill"></label>
                    </span>
                    <span class="pull-left lhml5">开具纸质保单<span class="label label-danger" style="margin-left: 5px;border-radius: 0;padding: .1em .3em .2em;">不推荐</span>（不便于管理、开具时效 3-5 个工作日）</span>
                </div>
                <div class="clear"></div>
                <div id="mod_1" <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> style="display: none;"</c:if>>
                    <div class="col-sm-3 col-xs-3">
                        <p>*收件人名称</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.receiver_name" id="receiverName" value="${ vo.mailPolicyVo.receiver_name}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill ? true : vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*收件人手机</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.receiver_mobile" id="receiverMobile" value="${ vo.mailPolicyVo.receiver_mobile}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-6 col-xs-6">
                        <p>*收件人地址</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.receiver_address_detail" id="receiverAddressDetail" value="${ vo.mailPolicyVo.receiver_address_detail}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="clear"></div>
                    <div class="bb-mt-e7"></div>
                </div>
                <div class="col-sm-6 col-xs-6 mt-20" style="margin-top: 10px;">
                    <span class="pull-left check-box">
                        <c:set var="is_need_receipt" value="${(not empty vo.mailPolicyVo.need_receipt && vo.mailPolicyVo.need_receipt eq '1')?'1':'0'}"></c:set>
                        <input type="checkbox" value="1" id="need_receipt"<c:if test="${is_need_receipt eq '1'}"> checked="checked"</c:if>/>
                        <label for="need_receipt"></label>
                        <input type="hidden" name="mailPolicyVo.need_receipt" value="${vo.mailPolicyVo.need_receipt}" />
                    </span>
                    <span class="pull-left lhml5">开具纸质发票<span class="label label-danger" style="margin-left: 5px;border-radius: 0;padding: .1em .3em .2em;">不推荐</span>（不便于管理、开具时效 3-5 个工作日）</span>
                </div>
                <div class="clear"></div>
                <div id="mod_2" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0' || vo.mailPolicyVo.is_send_einvoice eq '0'}"> style="display: none;"</c:if>>
                    <div class="col-sm-12 col-xs-12">
                        <p>发票种类</p>
                        <div class="row">
                            <div class="col-sm-12 col-xs-12">
                                <div class="row">
                                    <div class="col-sm-2 col-xs-2 rad-io">
                                        <c:set var="is_invoice_type_1" value="${(empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' || vo.mailPolicyVo.is_send_einvoice eq '1')?'1':'0'}"></c:set>
                                        <span><input type="radio" name="mailPolicyVo.invoice_type" id="invoice_type_1" value="0"<c:if test="${is_invoice_type_1 eq '1'}"> checked="checked"</c:if>><label for="invoice_type_1" class="pull-left"></label><strong  class="pull-left">增值税普通发票</strong></span>
                                    </div>
                                    <div class="col-sm-2 col-xs-2 rad-io"<c:if test="${vo.mailPolicyVo.is_send_einvoice eq '1'}"> style="display: none;"</c:if>><%--选电子发票就隐藏该项--%>
                                        <c:set var="is_invoice_type_2" value="${(not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '1')?'1':'0'}"></c:set>
                                        <span><input type="radio" name="mailPolicyVo.invoice_type" id="invoice_type_2" value="1"<c:if test="${is_invoice_type_2 eq '1'}"> checked="checked"</c:if>><label for="invoice_type_2" class="pull-left"></label><strong  class="pull-left">增值税专用发票</strong></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-12 col-xs-12 reminder" id="mod_2_1" <c:if test="${(not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0') || vo.mailPolicyVo.is_send_einvoice eq '0' }"> style="display: none;"</c:if>>
                    <label>温馨提示：请认真填写下述信息，确保信息真实准确，以免因开票信息错误给贵司带来损失。提交信息后，我司将在1-2个工作日完成审核，请及时关注审核结果。</label>
                </div>
                <div id="mod_2_2" <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> style="display: none;"</c:if>>
                    <div class="col-sm-3 col-xs-3">
                        <p>*单位名称</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.receipt_head" id="receipt_head" value="${ vo.mailPolicyVo.receipt_head}" class="form-control" placeholder="" <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> data-status="hidden"</c:if>>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*收票人姓名</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.taker_name" id="takerName" value="${ vo.mailPolicyVo.taker_name}" class="form-control" placeholder="" <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> data-status="hidden"</c:if>>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*收票人手机</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.taker_mobile" id="takerMobile" value="${ vo.mailPolicyVo.taker_mobile}" class="form-control" placeholder=""  <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*收票人地址</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.taker_address_detail" id="takerAddressDetail" value="${ vo.mailPolicyVo.taker_address_detail}" class="form-control" placeholder="企业营业执照上的全称"  <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3" <c:if test="${vo.mailPolicyVo.invoice_type eq '1'}"> style="display: none;"</c:if>>
                        <p>*纳税人识别号</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.taxpayer_number_invoice" id="taxpayerNumberInvoice_1" value="${ vo.mailPolicyVo.taxpayer_number_invoice}" class="form-control" placeholder="企业《税务登记证》编号"  <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0' || vo.mailPolicyVo.invoice_type eq '1') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> data-status="hidden"</c:if>>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="clear"></div>
                    <div class="bb-mt-e7"></div>
                </div>
                <div id="mod_2_3" <c:if test="${empty mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> style="display: none;"</c:if>>
                    <div class="col-sm-3 col-xs-3">
                        <p>*纳税人识别号</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.taxpayer_number_invoice" id="taxpayerNumberInvoice" value="${ vo.mailPolicyVo.taxpayer_number_invoice}" class="form-control" placeholder="企业《税务登记证》编号"<c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*注册地址</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.register_address_invoice" id="registerAddressInvoice" value="${ vo.mailPolicyVo.register_address_invoice}" class="form-control" placeholder="企业营业执照上的注册地址" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*电话</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.receipt_phone" id="receiptPhone" value="${ vo.mailPolicyVo.receipt_phone}" class="form-control" placeholder="企业联系电话" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*开户银行省</p>
                        <select Data-Val="Required" title="省" name="mailPolicyVo.bank_province" id="bankProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('bankCity', '', '2', this);" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
                            <option value="">请选择省</option>
                            <c:forEach items="${provinceList }" var="list">
                                <option value="${list.codes }" <c:if test="${list.codes eq vo.mailPolicyVo.bank_province }"> selected="selected"</c:if>>${list.named }</option>
                            </c:forEach>
                        </select>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*开户银行市</p>
                        <select title="市" name="mailPolicyVo.bank_city" id="bankCity" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
                            <option value="">请选择市</option>
                            <c:forEach items="${bankCityList }" var="list">
                                <option value="${list.codes }" <c:if test="${list.codes eq vo.mailPolicyVo.bank_city}"> selected="selected"</c:if>>${list.named }</option>
                            </c:forEach>
                        </select>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*开户银行</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.bank_invoice" id="bankInvoice" value="${ vo.mailPolicyVo.bank_invoice}" class="form-control" placeholder="企业银行开户许可证上的开户银行" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*银行账号</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.bank_account_invoice" id="bankAccountInvoice" value="${ vo.mailPolicyVo.bank_account_invoice}" class="form-control" placeholder="企业开户许可证上的银行账号" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="clear"></div>
                    <div class="bb-mt-e7"></div>
                    <div class="col-sm-4 col-xs-4">
                        <p>税务登记证<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/tax.jpg')">（样例）</a></p>
                        <input type="hidden" title="" name="mailPolicyVo.tax_cert" id="tax_cert" value="${vo.mailPolicyVo.tax_cert }">
                        <div>
                            <input title="" value="${vo.mailPolicyVo.tax_cert }" name="tax_cert_file" id="tax_cert_file-5" data-drawview="${vo.mailPolicyVo.tax_cert }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                        <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                    </div>
                    <div class="col-sm-4 col-xs-4">
                        <p>一般纳税人证明</p>
                        <input type="hidden" title="" name="mailPolicyVo.tax_prove" id="tax_prove" value="${vo.mailPolicyVo.tax_prove }">
                        <div>
                            <input title="" value="${vo.mailPolicyVo.tax_prove }" name="tax_prove_file" id="tax_prove_file-5" data-drawview="${vo.mailPolicyVo.tax_prove }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                        <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                    </div>
                    <div class="col-sm-4 col-xs-4">
                        <p>银行开户许可证</p>
                        <input type="hidden" title="" name="mailPolicyVo.bank_licence" id="bank_licence" value="${vo.mailPolicyVo.bank_licence }">
                        <div>
                            <input title="" value="${vo.mailPolicyVo.bank_licence }" name="bank_licence_file" id="bank_licence_file-5" data-drawview="${vo.mailPolicyVo.bank_licence}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                        <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                    </div>
                    <div class="col-sm-4 col-xs-4">
                        <p>营业执照副本<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/open.jpg')">（样例）</a></p>
                        <input type="hidden" title="" name="mailPolicyVo.business_license" id="business_license" value="${vo.mailPolicyVo.business_license }">
                        <div>
                            <input title="" value="${vo.mailPolicyVo.business_license }" name="business_license_file" id="business_license_file-5" data-drawview="${vo.mailPolicyVo.business_license}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                        <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                    </div>
                    <div class="col-sm-4 col-xs-4">
                        <p>增票授权委托书（个人支付时需提供此委托书<a href="<c:url value='/resources/files/增票授权委托书.doc' />" target="_blank">下载</a>）</p>
                        <input type="hidden" title="" name="mailPolicyVo.auth_cert" id="auth_cert" value="${vo.mailPolicyVo.auth_cert}">
                        <div>
                            <input title="" value="${vo.mailPolicyVo.auth_cert }" name="auth_cert_file" id="auth_cert_file-5" data-drawview="${vo.mailPolicyVo.auth_cert }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                        <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                    </div>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
    </form>
    <div class="row next-step">
        <div class="col-sm-12 col-xs-12 text-right pull-right">
            <p>
                <a href="javascript:void(0);" onclick="saveLOTEInfo();" id="pendingInfo" class="save">暂存本页</a>
                <a href="javascript:void(0);" onclick="save_policy_lote();" class="ns-btn">下一步</a>
            </p>
        </div>
    </div>
</div><!-- container end -->
<input id="fileKeyName" type="hidden" value=""><!-- 上传文件的key，重要！ -->
<!-- 营业执照 start -->
<div class="modal fade" id="open" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-1f96ef">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">营业执照</h4>
            </div>
            <div class="modal-body">
                <img src="<c:url value='/resources/versions-2.0/images/product/open.jpg' />" class="img-responsive ml-14">
            </div>
        </div>
    </div>
</div>
<!-- 营业执照 end -->
<!-- 组织机构代码证 start -->
<div class="modal fade" id="org" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-1f96ef">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">组织机构代码证</h4>
            </div>
            <div class="modal-body">
                <img src="<c:url value='/resources/versions-2.0/images/product/org.jpg' />" class="img-responsive">
            </div>
        </div>
    </div>
</div>
<!-- 组织机构代码证 end -->
<!-- 税务登记证 start -->
<div class="modal fade" id="tax" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-1f96ef">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">税务登记证</h4>
            </div>
            <div class="modal-body">
                <img src="<c:url value='/resources/versions-2.0/images/product/tax.jpg' />" class="img-responsive">
            </div>
        </div>
    </div>
</div>

<!--弹窗-->
<%--
<div class="contacts_modal">
    <h2 class="contacts-title">
        选择常用联系人
        <span class="title-cancel">
            <i class="glyphicon glyphicon-remove"></i>
        </span>
    </h2>
    <ul id="userList">
    </ul>
    <div class="contacts-bottom">
        <span class="sure">填入</span>
        <span class="cancel">取消</span>
    </div>
</div>
--%>



</body>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/bootstrap.min.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/normalCheck.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/validateIdent.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/checkInputChangeStyle.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>
<script src="/static/weChat/js/weixin_g.js"></script>
<jsp:include page="../../../index/multi_init_param.jsp"/>
<script>
    function closeUMsg(){
        var _bContentHeight = $('#_bContent').scrollTop();
        console.log(_bContentHeight);
        if(_bContentHeight<1000){
            laySomenType(1,null,"“责任免除”内容请阅读到底部",0);
            return;
        }
        $('.contacts_modal_oth').hide();
        $('.black-mask-oth').hide();
    }
    function closeUMsg1(){
        var _text = $('#closeUMsg').text();
        if(_text.indexOf('(')>0){
            return;
        }
        var khgzsHeight = $('#khgzs').scrollTop();
        if(khgzsHeight<620){
            laySomenType(1,null,"“客户告知书”内容请阅读到底部",0);
            return;
        }
        var starP='<p class="MsoNormal" align="center" style="text-align:center;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:14.0000pt;mso-font-kerning:1.0000pt;">保险条款</span><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:14.0000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-bottom:7.8500pt;mso-para-margin-bottom:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;">_pcs<b><span style="font-family: 宋体; font-size: 10pt;"><o:p></o:p></span></b></p>';
        var starA='';
        <c:if test="${not empty pd.pro_clauses}">
        <c:forEach items="${fn:split(pd.pro_clauses, '#')}" var="pcs">
        starA += '<b><span style="font-family: 宋体; font-size: 12pt;">${fn:split(pcs, "::")[1]}</span></b><iframe id="frame3d" name="frame3d" frameborder="0" width="100%" height="400px" scrolling="auto" src="<c:url value='/weixin/product/clause/${fn:split(pcs, "::")[0]}' />" ></iframe>';
        </c:forEach>
        </c:if>
        starP = starP.replace('_pcs',starA);
        $('#_bContent').html('<p class="MsoNormal" align="center" style="text-align:center;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:14.0000pt;mso-font-kerning:1.0000pt;">投保须知</span><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:14.0000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">1.本产品条款备案号：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">《展览会责任保险</font>-华泰(备案)[2009]N133号-注册号：H00015430912017051921371》。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="16" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">2.本产品由华泰财产保险有限公司承保(以下简称“华泰财”),目前该公司在北京、上海、天津、重庆、江苏、广东、陕西、四川、云南、辽宁、浙江、河北、湖南、湖北、 安徽、山西、福建、山东、广西、河南、江西、深圳、青岛、大连、宁波、贵州、内蒙古、厦门、黑龙江、新疆设有分支机构。本保险产品的销售区域为全国（不含港澳台）。若您处于华泰财险无分支机构的地区，不影响您的理赔，客户从本平台购买,后续理赔等相关事务均可由我们协助您办理。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="16" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">3.本产品网上投保、网上支付、网上即时核保并出具保险凭证，您可拨打华泰保险公司客户服务热线：4006095509查询、验真，如对本保险产品有任何咨询、报案或投诉问题，也可拨打上述客户服务热线，我们将竭诚为您服务。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="16" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">4.本保险产品为互联网销售保险产品，为您提供电子保单，根据《中华人民共和国民法典》第四百六十九条规定，数据电文是合法的合同表现形式，</span><b><span style="font-family: 宋体; font-size: 10.5pt;">电子保单与纸质保单具有同等法律效力。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">5.本产品在网上投保申请后，最早次日零时生效。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">6.本产品保障自活动临建设施搭建起至活动结束临建设施拆卸完毕止，覆盖整个展会期间（具体以保单载明的起讫日期为准），但</span><b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">最长不超过</font>30天</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">7.本保单保险责任中所指的“雇请中国工作人员”，是指被保险人因组织保单载明的申报展会项目（活动）需要而临时聘请（雇佣）的短期工作人员，不包括与被保险人有固定劳动关系的工作人员。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="font-family: 宋体; font-size: 10.5pt;">8.本产品项下共同被保险人可为：参展商、参展商指定的工程项目承包搭建商及转包商（具体以工程合同为准）。</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">9.对于每次事故造成的损失，保险人在每次事故责任限额内计算赔偿，其中对每人的赔偿金额不得超过每人责任限额。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">10. 本产品如被保险人“雇请的中国工作人员”包含工程转分包人员，雇请人员所在公司与转分包人员所在公司须签订合法有效的转分包工程合同。</span><b><span style="font-family: 宋体; font-size: 10.5pt;">如被保险人在提交索赔时不能提供合法有效的转分包合同，保险人不负责赔偿转分包人员本身的任何损失以及由转分包人员造成的任何损失</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">11.请您如实填写投保信息</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">，根据《中华人民共和国保险法》第十六条规定：投保人故意或因重大过失未履行如实告知义务的，足以影响保险公司决定是否同意承保或者提高保险费率的，保险公司有权解除合同。投保人故意不履行如实告知义务的，保险公司对于合同解除前发生的保险事故，不承担赔偿或者给付保险金的责任，并不退还保险费。投保人因重大过失未履行如实告知义务，对保险事故的发生有严重影响的，保险公司对于合同解除前发生的保险事故，不承担赔偿或者给付保险金的责任，但应当退还保险费。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">12.</span><b><span style="font-family: 宋体; font-size: 10.5pt;">客户信息收集条款：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">本人授权华泰保险，除法律另有规定外，将本人提供给华泰保险的信息、享受华泰保险服务产生的信息（包括本保单签署之前提供和产生的信息）以及华泰保险根据本条约定查询、收集的信息，用于华泰保险及其因服务必须委托的合作伙伴为本人提供服务、推荐产品、开展市场调查与信息数据分析。本人授权华泰保险，除法律另有规定外，基于为本人提供更优质服务和产品的目的，向华泰保险因服务必要开展合作的伙伴提供、查询、收集本人的信息。为确保本人信息的安全，华泰保险及其合作伙伴对上述信息负有保密义务，并采取各种措施保证信息安全。本条款自本单证签署时生效，具有独立法律效力，不受合同成立与否及效力状态变化的影响。本条所称</font>“华泰保险”是指华泰保险集团股份有限公司及其直接或间接控股的公司，以及华泰保险集团股份有限公司直接或间接作为其单一最大股东的公司。如您不同意上述授权条款的部分或全部，可致电客服热线 4006095509 取消或变更授权。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" align="center" style="mso-pagination:widow-orphan;text-align:center;"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 14pt;">责任免除</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 14pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top: 7.85pt; margin-bottom: 7.85pt; margin-left: 0pt; text-indent: 21pt;"><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">下列原因造成的损失、费用和责任，保险人不负责赔偿：</font> </span><span style="font-family: Calibri; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（一）投保人、被保险人及其雇请人员的故意行为或违法行为；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（二）战争、、敌对行动、军事行为、武装冲突、罢工、骚乱、暴动、恐怖活动；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（三）核辐射、核爆炸、核污染及其他放射性污染；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（四）大气污染、土地污染、水污染及其他各种污染；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（五）行政行为或司法行为；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">第七条</font> <font face="宋体">下列损失、费用和责任，保险人不负责赔偿：</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;">（一）被保险人或其雇员的人身伤亡；</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;">（二）被保险人或其雇员所有或管理或控制的财产的损失</span></b><b><span style="font-family: Georgia-Bold; color: rgb(0, 0, 0); font-size: 10.5pt;">,</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">包括但不限于展品和设备的损失；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（三）被保险人应该承担的合同责任，但无合同存在时仍然应由被保险人承担的经济赔偿责任不在此限；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（四）罚款、罚金及惩罚性赔偿；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（五）精神损害赔偿；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（六）间接损失，包括但不限于第三者停业、停驶、停电、停水、停热、停气、通讯中断、营业中断的损失及及机器设备损坏的利润损失；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（七）本保险合同中载明的免赔额；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-left: 0pt; text-indent: 21.1pt;"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;">其他不属于本保险责任范围内的损失、费用和责任，保险人不负责赔偿。</span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" align="center" style="text-align:center;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:14.0000pt;mso-font-kerning:1.0000pt;">投保人声明</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:14.0000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-left: 0pt; text-indent: 0pt; line-height: 150%;"><!--[if !supportLists]--><span style="font-family: &quot;Times New Roman&quot;; font-size: 10.5pt;">1.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; font-size: 10.5pt;">本投保人兹声明上述各项投保内容填写属实；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-left: 0pt; text-indent: 0pt; line-height: 150%;"><!--[if !supportLists]--><span style="font-family: &quot;Times New Roman&quot;; font-size: 10.5pt;">2.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; font-size: 10.5pt;">本投保人确认购买本保险产品前，已仔细阅读并充分理解并同意接受本《投保须知》和《保险条款》、《责任免除》、《投保人声明》等，特别是其中有关责任条款及免除责任条款、退保规则、投保人和被保险人义务的内容等重大事项。</span><span style="font-family: Calibri; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p>'+starP);
        $('#closeUMsg').text('已阅读、理解并完全接受');
        $('.contacts-bottom-oth span.sureoth').removeClass('sureoth_color');
        dingshi1(10);
    }
    function goBack(){
        history.go(-1);
    }
    function dingshi(isDo){
        if(isDo > 0){
            setTimeout(function() {
                isDo --;
                $('#closeUMsg').text('已阅读并同意('+isDo+')');
                dingshi(isDo);
            },1000);
        }else{
            $('#closeUMsg').text('已阅读并同意');
            $('.contacts-bottom-oth span.sureoth').addClass('sureoth_color');
            <c:if test="${fn:contains(pd.product_code,'ZZX-HT')}">
            $('#closeUMsg').attr('onclick','closeUMsg1();');
            </c:if>
            <c:if test="${!fn:contains(pd.product_code,'ZZX-HT')}">
            $('#closeUMsg').attr('onclick','closeUMsg();');
            </c:if>
        }
    }
    function dingshi1(isDo){
        if(isDo > 0){
            setTimeout(function() {
                isDo --;
                $('#closeUMsg').text('已阅读、理解并完全接受('+isDo+')');
                dingshi1(isDo);
            },1000);
        }else{
            $('#closeUMsg').text('已阅读、理解并完全接受');
            $('.contacts-bottom-oth span.sureoth').addClass('sureoth_color');
            $('#closeUMsg').attr('onclick','closeUMsg();');
        }
    }
    $(function () {
        if('${empty dto.oid ? '0' : '1'}' == '0'){
            var khgzs = '<div class="contacts_modal_oth" style="width: 820px;top: 120px;"><h2 class="contacts-title">确认进入投保流程</h2><div id="_bContent" style="margin: 20px;height: 450px;overflow: auto;"><p style="margin-top: 0;margin-bottom: 10px;">尊敬的客户:</p><p style="margin-top: 0;margin-bottom: 10px;">&nbsp;&nbsp;&nbsp;您即将进入投保流程，请仔细阅读保险条款。本保险产品由【${pd.insurance_name}】承保，由上海亚太保险经纪有限公司提供销售和协助理赔等保险服务。</p><p style="margin-top: 0;margin-bottom: 10px;">投保前请您阅读名户告知书</p><p style="margin-top: 0;margin-bottom: 10px;">点击“已阅读并同意”，您在销售页面的操作将被依法记录和候存。</p><div style="width: 780px;height: 220px;overflow-y: scroll;" id="khgzs"><img style="width: 775px" src="/resources/images/客户告知书-亚太保险经纪（盖章件）.png"> </div></div><div class="contacts-bottom-oth"><span id="closeUMsg" class="sureoth">已阅读并同意(10)</span>&nbsp;<span onclick="history.go(-1)">返回</span></div></div><div class="black-mask-oth"></div>';
            $('body').append(khgzs);
            $('.contacts_modal_oth').show();
            $('.black-mask-oth').show();
            dingshi(10);
        }
        //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
        setParamDatas({sys_client_user_id: '${userdetail.oid}'},'/pc/commonApplicant/company/query',false,false,function(json){
            var str = "";
            if (json.length > 0){
                for (var i = 0; i < json.length; i++) {
                    str += '<li><p data-text="' + JSON.stringify(json[i]).replace(/"/ig,'\'') + '">' + json[i].company_name + '</p></li>';
                }
            }
            if(str != ""){
                var lxr_html = '<div class="contacts_modal"><h2 class="contacts-title">选择常用投保人<span class="title-cancel"><i class="glyphicon glyphicon-remove"></i></span></h2><ul id="userList"></ul><div class="contacts-bottom"><span class="sure">填入</span>&nbsp;<span class="cancel">取消</span></div></div><div class="black-mask"></div>';
                $('body').append(lxr_html);
                $("#userList").html(str);
                addCylxr();
            }
        });
        function addCylxr(){
            //点击联系人
            $('.contacts_modal ul li').click(function () {
                $('.contacts_modal ul li').removeClass('active');
                $(this).addClass('active');
                if(!$('.contacts-bottom .sure').hasClass('sure_color')){
                    $('.contacts-bottom span.sure').addClass('sure_color');
                }
            });
            //点击取消
            $('.contacts-bottom .cancel').click(function () {
                $('.contacts_modal').hide();
                $('.black-mask').hide();
                $('.contacts_modal ul li').removeClass('active');
            });
            $('.contacts_modal .title-cancel').click(function () {
                $('.contacts_modal').hide();
                $('.black-mask').hide();
                $('.contacts_modal ul li').removeClass('active');
            });
            //点击填入
            $('.contacts-bottom .sure').click(function () {
                if($(this).hasClass('sure_color')){
                    setTBR($('.contacts_modal ul li.active').find('p').attr('data-text'));
                    $('.contacts_modal').hide();
                    $('.black-mask').hide();
                    $('.contacts_modal ul li').removeClass('active');
                }else{
                    //没有点击选择联系人
                    // alert('请选择一个联系人！');
                }
            })
            var _html = '投保单位信息<a href="javascript:;" style="float: right;margin-right: 16px" onclick="showContractsModals(\'1\')">选择常用投保人</a>';
            var _html_bb = '被保险人信息<a href="javascript:;" style="float: right;margin-right: 16px" onclick="showContractsModals(\'2\')">选择常用投保人</a>';
            $("#cy_lxr").html(_html);
            $("#cy_lxr_bb").html(_html_bb);
        }
        function setTBR(_json){
            var _sg = $('.contacts-bottom .sure').attr('data-sg');
            var json = eval("(" + _json + ")");
            if(_sg == '1') {//设置投保人
                $("#role_namecn_0").val(json.company_name);//企业名称
                if($('#role_roleType_0').val() == '2'){
                    $('#special_ex_build_com_name').val(json.company_name);
                }else{
                    if($("#special_contains").val() == '0'){
                        $('#special_ex_build_com_name').val('');
                    }
                }
                $("#role_idType_0").val(json.certificate_type);//证件类型
                if(json.certificate_code != ''){
                    var cccode = json.certificate_code;
                    if(json.certificate_type == '1'){
                        cccode = json.certificate_code.substring(0,json.certificate_code.length-1)+'-'+json.certificate_code.substring(json.certificate_code.length-1,json.certificate_code.length);
                    }
                    $("#role_organizationCode_0").val(cccode);//证件号码
                }
                $("#regAddress").val(json.address);//详细地址
                console.log(json.city);
                console.log(json.district);
                $("#regProvince").val(json.province);//省
                $("#regProvince").change();
                setTimeout(function(){
                    $("#regCity").val(json.city);//市
                    $("#regCity").change();
                    setTimeout(function(){
                        $("#regDistrict").val(json.district);//区
                    },1000);
                },1000);
                $("#role_linkName_0").val(json.user_name);//联系人
                $("#role_linkTel_0").val(json.telephone);//手机
                $("#role_linkEmail_0").val(json.email);//邮箱
            }else if(_sg == '2') {//设置被保险人
                $("#role_namecn_1").val(json.company_name);//企业名称
                $("#role_idType_1").val(json.certificate_type);//证件类型
                if(json.certificate_code != ''){
                    var cccode = json.certificate_code;
                    if(json.certificate_type == '1'){
                        cccode = json.certificate_code.substring(0,json.certificate_code.length-1)+'-'+json.certificate_code.substring(json.certificate_code.length-1,json.certificate_code.length);
                    }
                    $("#role_organizationCode_1").val(cccode);//证件号码
                }
                $("#regAddress_1").val(json.address);//详细地址
                $("#regProvince_1").val(json.province);//省
                $("#regProvince_1").change();
                setTimeout(function(){
                    $("#regCity_1").val(json.city);//市
                    $("#regCity_1").change();
                    setTimeout(function(){
                        $("#regDistrict_1").val(json.district);//区
                    },1000);
                },1000);
                $("#role_linkName_1").val(json.user_name);//联系人
                $("#role_linkTel_1").val(json.telephone);//手机
            }
        }

        //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
        setParamDatas('','/pc/tb-mail-address/${userdetail.oid}',false,false,function(json){
            if(json != undefined && json != null){
                if('${dto.oid}' == ''){
                    $('#need_insur_bill').on('click',function(){//纸质发票
                        if($(this).is(":checked")){
                            $("#receiverName").val(json.user_name);
                            $("#receiverMobile").val(json.telephone);
                            $("#receiverAddressDetail").val(json.address);
                        }
                    });
                    $('#need_receipt').on('click',function(){//电子发票
                        if($(this).is(":checked")){
                            $("#takerName").val(json.user_name);
                            $("#takerMobile").val(json.telephone);
                            $("#takerAddressDetail").val(json.address);
                        }
                    });
                    $('#is_send_einvoice').on('click',function(){//电子发票
                        if($(this).is(":checked")){
                            $("#takerName").val(json.user_name);
                            $("#takerMobile").val(json.telephone);
                            $("#takerAddressDetail").val(json.address);
                        }
                    });
                }
            }

        });
        document.onmousedown = function(ev){
            ev = ev || window.event;
            var nr = '已阅读并同意 已阅读、理解并完全接受 roleSubjectList[0].reg_address appOrganizingPath_file roleSubjectList[1].reg_address appOrganizingPath1_file 【批量上传】 special_star_time special_ex_no special_ex_emp_num check_007_for roleSubjectList[0].bank_account mailPolicyVo.taxpayer_number_invoice 暂存本页 下一步 ';
            var x=ev.clientX;
            var y=ev.clientY;
            if((ev.target.childNodes.length > 0 && ev.target.childNodes[0]!=undefined && nr.indexOf(ev.target.childNodes[0].data)!=-1) || (ev.target.name != '' && nr.indexOf(ev.target.name)!=-1) || (ev.target.id != '' && ev.target.id!=undefined && nr.indexOf(ev.target.id)!=-1 )){
                insOperation('${dto.oid}','${dto.trade_serial_number}','投保信息提交');
            }
        }

    })
    //点击弹窗出现
    function showContractsModals(_sg) {
        $('.contacts_modal').show();
        $('.black-mask').show();
        $('.contacts-bottom .sure').attr('data-sg',_sg);
    }

</script>

<script type="text/javascript">
    var baseUrl = '${pageContext.request.contextPath }';

    function openImgView(img_url){
        top.layer.open({
            type: 1,
            skin: 'layui-layer-rim', //加上边框
            area: ['420px', '350px'], //宽高
            content: '<div><img src='+baseUrl+img_url+' width="100%" /></div>'
        });
    }
    var count = 2;
    $(function(){
        changeFrameSet(1,"");
        if($("#need_insur_bill").is(':checked')){
            $("#mod_1").fadeIn(1000);
        }else{
            $("#mod_1").fadeOut(1000);
        }
        if($("#need_receipt").is(':checked')){
            var _invoice_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
            $("#mod_2").fadeIn(1000);
            if(_invoice_val == "0"){//普通发票
                $("#mod_2_1").fadeIn(1000);
            }else{//专用发票,VATINVOICE
                $("#mod_2_1").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_3").fadeIn(1000);
            }
        }else if($("#is_send_einvoice").is(':checked')){
            $('#invoice_type_2').parent().parent().hide();//隐藏增值税选项
            $("#mod_2").fadeIn(1000);
            $("#mod_2_1").fadeOut(1000);
        }else{
            $("#mod_2").fadeOut(1000);
            $("#mod_2_1").fadeOut(1000);
            $("#mod_2_2").fadeOut(1000);
            $("#mod_2_3").fadeOut(1000);
        }
        changeFrameSet(0,'');//加载当前内容高度并重置iframe
    });
    function validateForms(_obj){
        var _val = $(_obj).val();
        if(_obj.id == 'special_ex_emp_num'){
            var pCode = '${dto.product_code}';
            if(pCode.indexOf('ZZX-PAC')!=-1){
                if(Number(_val)<1){
                    laySomenType(1,null,"雇员人数至少1人！",0);
                    $(_obj).val('');
                }
            }else{
                if(Number(_val)>20||Number(_val)<1){
                    laySomenType(1,null,"雇员人数在1~20人之间！",0);
                    $(_obj).val('');
                }
            }
        }
        if(_obj.id == 'special_ex_acreage'){
            if(!/^[0-9]*[1-9][0-9]*$/.test(_val)){
                laySomenType(1,null,"请输整平方数的展位总面积！",0);
                /*$(_obj).val('');*/
            }else{
                var pCode = '${dto.product_code}';//mPremium
                computePremium(pCode, _val);
            }
        }
    }

    function computePremium(pCode, _val){
        var startDate =$('#special_star_time').val();
        var endDate =$('#special_end_time').val();
        if(startDate == '' || endDate == ''){
            return;
        }
        var isBegin = new Date(startDate.replace(/-/g,"/"));
        var isEnd = new Date(endDate.replace(/-/g,"/"));
        var checkSum = isEnd - isBegin;
        if(checkSum < 0){
            loser_has('special_end_time');
            $('#special_end_time').val('');
            laySomenType(1,null,"终保日期不能小于起保日期",0);
            return;
        }
        if(pCode!='' && _val!=''){//
            $.ajax({
                type: 'POST',
                url:baseUrl + '/api/lote/policy/computePremium',
                data:{
                    "productCode":pCode,
                    "exAcreage":_val
                },
                dataType:"json",
                cache: false,
                success: function(json){
                    if(json.statusCode == '200') {
                        $("#mPremium").html(json.message+"元");
                        $("#premium").val(json.message);
                        success_has('special_ex_acreage');
                    }else{
                        laySomenType(1,null,json.message,0);
                        $('#special_ex_acreage').val('');
                        loser_has('special_ex_acreage');
                    }
                }
            });
        }
    }

    function save_policy_lote(){
        //如果校验没问题
        if(customsVerify()){
            //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
            setParamDatas($("#policyInfoForm").serialize(),baseUrl+'/api/lote/policy/pendingLOTEPolicyVoPolicy',false,true,function(json){
                if(json.statusCode == '200') {
                    //页面跳转
                    window.location.href = baseUrl + '/api/lote/policy/confirmPage/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                }else{
                    //关闭遮罩
                    laySomenType(1,null,json.message,0);
                }
            });
        }
    }
    function customsVerify(){
        var flag = true;
        $("input[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required" || dataVal == "Date Required"){
                    if($(this).val() == ''){
                        document.getElementById(this.id).scrollIntoView();
                        laySomenType(1,null,"必填项不能为空！",0);
                        flag = false;
                        return true;
                    }else{
                        if($(this).val().length>40){
                            document.getElementById(this.id).scrollIntoView();
                            laySomenType(1,null,"长度超出限制！",0);
                            flag = false;
                            return true;
                        }else{
                            var _val = $(this).val();
                            var _id = this.id;
                            if(_id == 'role_doBusinessAddress_0'||_id == 'regAddress'||_id == 'regAddress_1'){
                                if(_val.length<8||_val.length>60){
                                    document.getElementById(_id).scrollIntoView();
                                    laySomenType(1,null,"内容长度不能少于8位！",0);
                                    flag = false;
                                    return true;
                                }
                            }
                            if(_id=='special_star_time'){
                                if(Gdate.getDaysDiff(_val, Gdate.curtime())<=0){
                                    document.getElementById(_id).scrollIntoView();
                                    laySomenType(1,null,"保障时间必须大于今天！",0);
                                    flag = false;
                                    return true;
                                }
                            }
                        }
                    }

                }
            }
            if(dataVal == "FILE Required"){//FILE Required
                if($(this).val() == ''){
                    document.getElementById(this.id+'_file-5').scrollIntoView();
                    laySomenType(1,null,"上传文件不能为空！",0);
                    flag = false;
                    return true;
                }
            }
        });
        if(flag){
            $("input[Data-Val]").each(function() {
                var dataVal = $(this).attr("Data-Val");
                if ($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden") {
                    if (dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required" || dataVal == "Date Required") {
                        $(this).blur();
                        if($(this).val() == ''){
                            document.getElementById(this.id).scrollIntoView();
                            laySomenType(1,null,"请正确填写相关信息！",0);
                            flag = false;
                            return true;
                        }
                    }
                }
            });
        }
        if(flag){
            $("select[Data-Val]").each(function(){
                var dataVal = $(this).attr("Data-Val");
                if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                    if(dataVal == "Required"){
                        if($(this).val() == ''){
                            document.getElementById(this.id).scrollIntoView();
                            laySomenType(1,null,"必填项不能为空！",0);
                            flag = false;
                            return true;
                        }

                    }
                }
            });
            if(flag){
                $("textarea[Data-Val]").each(function(){
                    var dataVal = $(this).attr("Data-Val");
                    if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                        if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                            if($(this).val() == ''){
                                document.getElementById(this.id).scrollIntoView();
                                laySomenType(1,null,"必填项不能为空！",0);
                                flag = false;
                                return true;
                            }else{
                                if($(this).val().length>100){
                                    document.getElementById(this.id).scrollIntoView();
                                    laySomenType(1,null,"长度超出限制(100字符)！",0);
                                    flag = false;
                                    return true;
                                }
                            }

                        }
                    }
                });

            }
        }
        mailSet();
        return flag;
    }

    function saveLOTEInfo(){
        mailSet();
        if(isAllNull() == 1){
            //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
            setParamDatas($("#policyInfoForm").serialize(),baseUrl+'/api/lote/policy/pendingLOTEPolicyVoPolicy',false,true,function(json){
                laySomenType(1,null,json.message,0);
                if(json.statusCode == '200') {
                    window.location.href = baseUrl + '/api/lote/policy/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                }
            });
        }else{
            laySomenType(1,null,"表单未检索到数据，请完善信息后暂存！",0);
        }
    }
    function mailSet(){
        var invoice_type_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
        if(invoice_type_val == "0"){
            $("#mod_2_3").find("input").each(function(){
                if($(this).attr("type") == "hidden"){
                    if($(this).val() != ''){
                        $(this).next().find(".fileinput-remove-button").click();
                    }
                }
                loser_sty(this.id);
            });
            $("#mod_2_3").find("select").each(function(){
                $(this).val('');
            });
        }
        if(!$("#need_insur_bill").is(':checked')){
            $("#mod_1").find("input").each(function(){
                $(this).val('');
            });
        }
        if(!$("#need_receipt").is(':checked')&&!$("#is_send_einvoice").is(':checked')){
            $("#mod_2_2").find("input").each(function(){
                $(this).val('');
            });
            $("#mod_2_3").find("input").each(function(){
                if($(this).attr("type") == "hidden"){
                    if($(this).val() != ''){
                        $(this).next().find(".fileinput-remove-button").click();
                    }
                }
                loser_sty(this.id);
            });
        }
    }
    function isAllNull(){
        var values, index;
        values = $("#policyInfoForm").serializeArray();
        for (index = 0; index < values.length; ++index){
            var controls=document.getElementsByName(values[index].name);
            for(var i=0;i<controls.length;i++){
                if (!$("#"+controls[i].id).is(":hidden")&&values[index].value !=''){
                    return 1;//可见输入框存在至少一个框有填数据，暂存校验通过
                }
            }
        }
        return 0;//可见输入框不存在至少一个已填数据的框，暂存校验不通过
    }
    $(function(){
        $('[data-toggle="tooltip"]').tooltip();
        $("input[id=need_insur_bill]").on("click",function(){
            if($(this).is(':checked')){
                $("#mod_1").fadeIn(1000);
                $("#mod_1").find("input").each(function(){
                    $(this).attr("data-status","");
                });
            }else{
                $("#mod_1").fadeOut(1000);
                $("#mod_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                    $(this).val('');
                });
            }
            setTimeout('changeFrameSet(0,"")',1050);//加载当前内容高度并重置iframe
        });
        $("input[id=need_receipt]").on("click",function(){
            $('#invoice_type_2').parent().parent().show();//显示增值税选项
            $("#is_send_einvoice").attr("checked",false);
            $("input[name='mailPolicyVo.is_send_einvoice']").val('0');
            if($(this).is(':checked')){
                $("#mod_2").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("input[name='mailPolicyVo.need_receipt']").val('1');
            }else{
                $("#mod_2_3").fadeOut(1000);
                $("#mod_2_2").fadeOut(1000);
                $("#mod_2_1").fadeOut(1000);
                $("#mod_2").fadeOut(1000);
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("input[name='mailPolicyVo.need_receipt']").val('');
            }
            setTimeout('changeFrameSet(0,"")',1050);//加载当前内容高度并重置iframe
        });

        $("input[id=is_send_einvoice]").on("click",function(){
            $("#need_receipt").attr("checked",false);//纸质发票不选中
            $("input[name='mailPolicyVo.need_receipt']").val('');
            if($(this).is(':checked')){
                $('#invoice_type_1').click();
                $('#invoice_type_2').parent().parent().hide();//隐藏增值税选项
                $("#mod_2").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                mailSet();
                $("input[name='mailPolicyVo.is_send_einvoice']").val('1');
            }else{

                $("#mod_2_3").fadeOut(1000);
                $("#mod_2_2").fadeOut(1000);
                $("#mod_2_1").fadeOut(1000);
                $("#mod_2").fadeOut(1000);
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $('#invoice_type_2').parent().parent().show();//显示增值税选项
                $("input[name='mailPolicyVo.is_send_einvoice']").val('0');
            }
            setTimeout(changeFrameSet(0,''),1050);//加载当前内容高度并重置iframe
        });

        $("input[name='mailPolicyVo.invoice_type']").on("click",function(){
            if($(this).val() == "1"){
                $("#taxpayerNumberInvoice_1").parent().hide();
                $("#mod_2_1").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_3").fadeIn(1000);
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#taxpayerNumberInvoice_1").attr("data-status","hidden");
            }else{
                $("#taxpayerNumberInvoice_1").parent().show();
                $("#mod_2_3").fadeOut(1000);
                $("#mod_2_1").fadeOut(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#taxpayerNumberInvoice_1").attr("data-status","");
            }
            setTimeout('changeFrameSet(0,"")',1050);//加载当前内容高度并重置iframe
        });
        $("input[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if(dataVal == "Required"){
                var _class = $(this).attr("class");
                if(_class.indexOf('laydate-icon')!=-1){

                }else{
                    $(this).on("blur",function(){
                        var _val = $(this).val();
                        var _id = this.id;
                        if(_val == ''){
//                        被保险人信息的6个输入框匹配id字段
                            if(_id == 'role_namecn_0'){
                                laySomenType(1,null,"投保人名称不能为空！",0);
                            } else if(_id == 'role_organizationCode_0'){
                                laySomenType(1,null,"投保人证件号码不能为空！",0);
                            } else if(_id == 'role_totalEmp_0'){
                                laySomenType(1,null,"企业总人数不能为空！",0);
                            } else if(_id == 'role_doBusinessAddress_0'){
                                laySomenType(1,null,"办公地址不能为空！",0);
                            } else if(_id == 'role_phone_0'){
                                laySomenType(1,null,"办公电话不能为空！",0);
                            } else if(_id == 'role_linkName_0'){
                                laySomenType(1,null,"联系人姓名不能为空！",0);
                            } else if(_id == 'role_linkTel_0'){
                                laySomenType(1,null,"联系人手机不能为空！",0);
                            } else if(_id == 'role_linkEmail_0'){
                                laySomenType(1,null,"联系人email不能为空！",0);
                            } else if(_id == 'role_zipCode_0'){
                                laySomenType(1,null,"邮政编码不能为空！",0);
                            } else if(_id == 'regAddress'||_id == 'regAddress_1'){
                                laySomenType(1,null,"请填写具体地址（包含：镇、乡或街道）！",0);
                            } else if(_id == 'role_namecn_1'){
                                laySomenType(1,null,"名称不能为空！",0);
                            } else if(_id == 'role_organizationCode_1'){
                                laySomenType(1,null,"被保险人证件号码不能为空！",0);
                            } else if(_id == 'special_name'){
                                laySomenType(1,null,"展会名称不能为空！",0);
                            } else if(_id == 'special_star_time' || _id == 'special_end_time'){
                                laySomenType(1,null,"保障时间不能为空！",0);
                            } else if(_id == 'special_ex_province' || _id == 'special_ex_city' || _id == 'special_ex_county' || _id == 'special_ex_address'){
                                laySomenType(1,null,"展会举办地址不能为空！",0);
                            } else if(_id == 'special_ex_no'){
                                laySomenType(1,null,"展位号不能为空！",0);
                            } else if(_id == 'special_ex_acreage'){
                                laySomenType(1,null,"展位总面积不能为空！",0);
                            } else if(_id == 'receiptHead'){
                                laySomenType(1,null,"单位名称不能为空！",0);
                            } else if(_id == 'takerName'){
                                laySomenType(1,null,"收票人姓名不能为空！",0);
                            } else if(_id == 'takerMobile'){
                                laySomenType(1,null,"收票人手机不能为空！",0);
                            } else if(_id == 'takerAddressDetail'){
                                laySomenType(1,null,"收票人地址不能为空！",0);
                            } else if(_id == 'receiverName'){
                                laySomenType(1,null,"收件人名称不能为空！",0);
                            } else if(_id == 'receiverMobile'){
                                laySomenType(1,null,"收件人手机不能为空！",0);
                            } else if(_id == 'receiverAddressDetail'){
                                laySomenType(1,null,"收件人地址不能为空！",0);
                            } else if(_id == 'taxpayerNumberInvoice_1'){
                                laySomenType(1,null,"纳税人识别号不能为空！",0);
                            } else if(_id == 'taxpayerNumberInvoice'){
                                laySomenType(1,null,"纳税人识别号不能为空！",0);
                            } else if(_id == 'registerAddressInvoice'){
                                laySomenType(1,null,"注册地址不能为空！",0);
                            } else if(_id == 'receiptPhone'){
                                laySomenType(1,null,"企业电话不能为空！",0);
                            } else if(_id == 'bankProvince'){
                                laySomenType(1,null,"开户银行省不能为空！",0);
                            } else if(_id == 'bankCity'){
                                laySomenType(1,null,"开户银行市不能为空！",0);
                            } else if(_id == 'bankInvoice'){
                                laySomenType(1,null,"开户银行不能为空！",0);
                            } else if(_id == 'bankAccountInvoice'){
                                laySomenType(1,null,"企业银行账号不能为空！",0);
                            }else {
                                laySomenType(1,null,"该项为必填字段,不能为空！",0);
                            }
                            loser_has(this);
                            return;
                            /*if(_id.indexOf('_0')!=-1){
                                loser_has(this);
                            }else{
                                if(_id == 'role_regAddress_1'){
                                    loser_has(this);
                                }else{
                                    loser_has_ins(this);
                                }
                            }*/
                        }else{
                            if(_val.length>32){
                                laySomenType(1,null,"超过最长限制长度！",0);
                                loser_has(this);
                                $(this).val('');
                                return;
                            }else{
                                if(_id.indexOf("role_namecn")!=-1){
                                    if(_val.length<8){
                                        laySomenType(1,null,Number(_id.split("_")[2]) == 0 ? '请填写完整的投保人名称！' : '请填写完整的被保险人名称！',0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }else{
                                        success_has(this);
                                    }
                                }
                                if(_id == 'role_namecn_0'){
                                    if($('#role_roleType_0').val() == '2'){
                                        $('#special_ex_build_com_name').val(_val);
                                    }else{
                                        if($("#special_contains").val() == '0'){
                                            $('#special_ex_build_com_name').val('');
                                        }
                                    }
                                }
                                if(_id.indexOf("role_namecn")!=-1){
                                    var isCN = new RegExp("[\\u4E00-\\u9FFF]+","g");
                                    if(isCN.test(_val)){//中文
                                        if(_val.indexOf('(') > -1 || _val.indexOf(')') > -1){
                                            laySomenType(1,null,"中文企业名称中的括号必须使用中文！",0);
                                            loser_has(this);
                                            $(this).val('');
                                        }else{
                                            success_has(this);
                                        }
                                    }else{
                                        if(_val.indexOf('（') > -1 || _val.indexOf('）') > -1){
                                            laySomenType(1,null,"英文企业名称中的括号必须使用英文！",0);
                                            loser_has(this);
                                            $(this).val('');
                                        }else{
                                            success_has(this);
                                        }
                                    }
                                }else if(_id == 'role_linkName_0'||_id == 'role_linkName_1'){
                                    var isName=/[\u4E00-\u9FA5]{2,5}(?:·[\u4E00-\u9FA5]{2,8})*/;
                                    if(!isName.test(_val)||_val.length>13){
                                        laySomenType(1,null,"请输入正确姓名！",0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }else{
                                        success_has(this);
                                    }

                                }else if(_id == 'role_phone_0'){
                                    var isPhone=/^((0\d{2,3})-)?(\d{7,8})?(-(\d{1,4}))?$/;
                                    if(!isPhone.test(_val)){
                                        laySomenType(1,null,"格式错误，请输入格式如0592-1234567！",0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_linkTel_0'||_id == 'role_linkTel_1'){
                                    if(checkMobile(_val) == false){
                                        laySomenType(1,null,"手机号格式不正确，格式参考13800138000！",0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_doBusinessAddress_0'){
                                    if(_val.length<8||_val.length>60){
                                        laySomenType(1,null,"请输入8位以上的办公详细地址！",0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'regAddress'||_id == 'role_doBusinessAddress_0'||_id == 'regAddress_1'){
                                    if(_val.length<8||_val.length>60){
                                        laySomenType(1,null,"请输入8位以上的注册地址！",0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_zipCode_0'){
                                    if(checkZipCode(_val) == false){
                                        laySomenType(1,null,"请输入正确的邮政编码！",0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id.indexOf('role_mobile')!=-1){
                                    if(checkMobile(_val) == false){
                                        laySomenType(1,null,"手机号格式不正确，格式参考13800138000！",0);
//                                        loser_has_ins(this);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_linkEmail_0'){
                                    if(checkEmail(_val) == false){
                                        laySomenType(1,null,"电子邮箱格式不正确，格式参考：blbservice@baichuanxin.com！",0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'taxpayerNumberInvoice_1'){
                                    if(_val.length < 21 && _val.length > 9){
                                        success_has(this);
                                    }else{
                                        laySomenType(1,null,"纳税人识别号格式有误！",0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }
                                }else if(_id == 'taxpayerNumberInvoice'){
                                    if(_val.length < 21 && _val.length > 9){
                                        success_has(this);
                                    }else{
                                        laySomenType(1,null,"纳税人识别号格式有误！",0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }
                                }else if(_id == 'special_ex_no'){
                                    var flag = true;
                                    var msg = '请输入“001,002”格式的展位信息';
                                    var _no = _val;
                                    if(_no.indexOf(',,')!=-1||_no.indexOf('，，')!=-1||_no.indexOf(',，')!=-1||_no.indexOf('，,')!=-1||_no.substring(_no.length-1,_no.length).indexOf(',')!=-1||_no.substring(_no.length-1,_no.length).indexOf('，')!=-1||_no.substring(0,1).indexOf(',')!=-1||_no.substring(0,1).indexOf('，')!=-1){//不存在“-”格式不对

                                    }else{
                                        if(/^[\u4e00-\u9fa5\s,a-zA-Z0-9,\,\，\-\_]{2,300}$/.test(_val)){
                                            flag = false;
                                        }
                                    }
                                    if(!flag){
                                        success_has(this);
                                    }else{
                                        laySomenType(1,null,msg,0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }
                                }else if(_id.indexOf('role_organizationCode')!=-1){
                                    if(_id == 'role_organizationCode_0' || _id == 'role_organizationCode_1'){
                                        var _idVal = $(this).attr("GIST-ID");
                                        var _gistVal = $("#"+_idVal).val();
                                        if(_gistVal == '1'){//组织机构代码证校验
                                            if(checkOrganizingCode(_val) == 0){
                                                laySomenType(1,null,"只能包含数字或英文大写字母，必须用连字符“-”隔开！",0);
                                                loser_has(this);
                                                $(this).val('');
                                                return;
                                            }else{
                                                success_has(this);
                                            }
                                        }else if(_gistVal == '2'){//三证合一信用代码证校验
                                            if(doValidCreditCode(_val) == 0){
                                                laySomenType(1,null,"由数字或大写英文字母组成，共18位！",0);
                                                loser_has(this);
                                                $(this).val('');
                                                return;
                                            }else{
                                                success_has(this);
                                            }
                                        }else if(_gistVal == '6'){//税务登记证校验
                                            var flass = false;
                                            var reg= /^[A-Za-z]+$/;
                                            if(_val.length == 15&&checkInt1(_val)){
                                                flass = true;
                                            }else if(_val.length == 20&&(checkInt1(_val)||(checkInt1(_val.substring(0,_val.length-1))&&reg.test(_val.substring(_val.length-1,_val.length))))){
                                                flass = true;
                                            }else{
                                                if(doValidCreditCode(_val) == 0){

                                                }else{
                                                    flass = true;
                                                }
                                            }
                                            if(flass){
                                                success_has(this);
                                            }else{
                                                laySomenType(1,null,"请输入正确的税务登记证或信用代码证代码！",0);
                                                loser_has(this);
                                                $(this).val('');
                                                return;
                                            }
                                        }else if(_gistVal == '7'){//营业执照校验
                                            var reg= /^\d{15}$/;
                                            if(!reg.test(_val)){
                                                laySomenType(1,null,"只能为15位数字！",0);
                                                loser_has(this);
                                                $(this).val('');
                                                return;
                                            }else{
                                                success_has(this);
                                            }
                                        }else{
                                            laySomenType(1,null,"请先选择证件类型！",0);
                                            loser_has(this);
                                            $(this).val('');
                                            return;
                                        }
                                    }


                                }else{
                                    success_has(this);
                                    /*if(_id.indexOf('_0')!=-1){
                                        success_has(this);
                                    }else{
                                        success_has_ins(this);
                                    }*/
                                }
                            }
                        }
                    });
                }
            }
            if(dataVal == "Date Required"){
                $(this).on("change",function(){
                    if($(this).val() == ''){
                        laySomenType(1,null,"请选择起保日期！",0);
                        loser_has(this);
                        $(this).val('');
                    }else{
                        success_has(this);
                    }
                });
            }
            if(dataVal == "Point"||dataVal == "Point Required"){
                $(this).on("keyup",function(){
                    var regm = /^[0-9]+.?[0-9]*$/;
                    if(isNaN($(this).val())){
                        laySomenType(1,null,"请输入正确的数字格式！",0);
                        $(this).val('');
                    }
                });
            }
            if(dataVal == "Num"||dataVal == "Num Required"){
                $(this).on("blur",function(){
                    var _val = $(this).val();
                    if(_val != ''){
                        var regm = /^[0-9]*[0-9][0-9]*$/;
                        if(!regm.test(_val)){
                            laySomenType(1,null,"请输入正确的数字格式！",0);
                            loser_has(this);
                            $(this).val('');
                            return;
                        }else{
                            if(this.id == 'special_ex_emp_num'){
                                var pCode = '${dto.product_code}';
                                if(pCode.indexOf('ZZX-PAC')!=-1){
                                    if(Number(_val)<1){
                                        laySomenType(1,null,"雇员人数至少1人！",0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }
                                }else{
                                    if(Number(_val)>20||Number(_val)<1){
                                        laySomenType(1,null,"雇员人数在1~20人之间！",0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }
                                }
                            }
                            if(this.id == 'special_ex_acreage'){
                                if(!/^[0-9]*[1-9][0-9]*$/.test(_val)){
                                    laySomenType(1,null,"请输整平方数的展位总面积！",0);
                                    loser_has(this);
                                    $(this).val('');
                                    return;
                                }else{
                                    var pCode = '${dto.product_code}';//mPremium
                                    computePremium(pCode, _val);
                                }
                            }
                            success_has(this);
                        }
                    }else{
                        laySomenType(1,null,"必填项不能为空！",0);
                        loser_has(this);
                        $(this).val('');
                    }

                });
            }
        });
        $("select[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if(dataVal == "Required") {
                $(this).on("change", function () {
                    var _val = $(this).val();
                    var _id = this.id;
                    if (_val == '') {
                        if(_id == 'role_comNature_0'){
                            laySomenType(1,null,"请选择营业性质！",0);
                        } else if(_id == 'role_idType_0' || _id == 'role_idType_1'){
                            laySomenType(1,null,"请选择证件类型！",0);
                        }  else if(_id == 'inceptionDate'){
                            laySomenType(1,null,"起保日期不能为空！",0);
                        } else if(_id == 'regProvince' || _id == 'regCity' || _id == 'regDistrict' || _id == 'regProvince_1' || _id == 'regCity_1' || _id == 'regDistrict_1'){
                            laySomenType(1,null,"地址不能为空！",0);
                        } else if(_id == 'special_ex_province' || _id == 'special_ex_city' || _id == 'special_ex_county'){
                            laySomenType(1,null,"展会举办地址不能为空！",0);
                        }else {
                            laySomenType(1,null,"该项为必填项，不能为空！",0);
                        }
                        loser_has(this);
                        /*if (_id.indexOf('_0') != -1) {
                            loser_has(this);
                        } else {
                            loser_has_ins(this);
                        }*/
                        $(this).val('');
                    } else {
                        success_has(this);
                    }
                });
            }
        });

    });

    function changeDistrict(districtID, areaID, level, obj) {
        $("#" + districtID).empty();
        if(areaID != '') {
            $("#" + areaID).empty();
            $("#" + areaID).append("<option value=''>--请选择区县--</option>");
        }
        $.ajax({
            type: 'POST',
            url: baseUrl + '/synopsis/findCity',
            data:{"codeLevel":level,"parentCode":obj.value},
            dataType:"json",
            async: false,
            success: function(json) {
                if(level == '2') {
                    $("#" + districtID).append("<option value=''>请选择市</option>");
                } else if(level == '3') {
                    $("#" + districtID).append("<option value=''>请选择区／县</option>");
                } else {
                    $("#" + districtID).append("<option value=''>--请选择--</option>");
                }
                for(var i = 0; i < json.length; i++) {
                    var obj = json[i];
                    var appendStr = "<option value='" + obj.codes + "' ";
                    appendStr = appendStr + ">" + obj.named + "</option>"
                    $("#" + districtID).append(appendStr);
                }
            }
        });
    }
    function changeBankType(districtID, obj) {
        $("#" + districtID).empty();
        var code = obj.value;
        $.ajax({
            type: 'POST',
            url: baseUrl + '/synopsis/findBankType.json',
            data:{"area":code},
            dataType:"json",
            async: false,
            success: function(json) {
                $("#" + districtID).append("<option value=''>请选择名称</option>");
                for(var i = 0; i < json.length; i++) {
                    var obj = json[i];
                    var appendStr = "<option value='" + obj.codes + "' ";
                    appendStr = appendStr + ">" + obj.named + "</option>"
                    $("#" + districtID).append(appendStr);
                }
            }
        });
    }
    function changeBankAddr(addrID, areaID, obj) {
        $("#" + addrID).empty();
        var code = obj.options[obj.selectedIndex].text;
        var url = '/synopsis/findBankAddr.json';
        $.ajax({
            type: 'POST',
            url: baseUrl + url,
            data:{"area":$("#" + areaID).val(),"bankName":code},
            dataType:"json",
            async: false,
            success: function(json) {
                $("#" + addrID).append("<option value=''>请选择地址</option>");
                for(var i = 0; i < json.length; i++) {
                    var obj = json[i];
                    var appendStr = "<option value='" + obj.codes + "' ";
                    appendStr = appendStr + ">" + obj.named + "</option>"
                    $("#" + addrID).append(appendStr);
                }
            }
        });
    }
    function changeBankName(bankNameID, obj) {
        $("#" + bankNameID).val(obj.options[obj.selectedIndex].text);
    }

    function checkToradio(_id, type){
        var o = $("#"+_id);
        if(type=="radio"){
            o.prop('checked',true);
            if(o.val() == "1"){
                $("#arbitralInstitution").parent().show();
            }else if(o.val() == "0"){
                $("#arbitralInstitution").val('');
                $("#arbitralInstitution").parent().hide();
            }else{
                o.click();
            }
        }else if(type=="checkbox"){

            if($("#"+_id).attr('checked')) {
                o.attr('checked', false);
            } else {
                o.attr('checked', true);
            }
            o.click();
        }
    }

    function clearBase64Byinput(_el){
        var _file_id = _el.id;
        _file_id = _file_id.substring(0,_file_id.length-7);
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        $("#"+_file_id).val('');
    }
    function base64convert(_el,_file){
        var flag = false;
        var fileName = _file.name;
        var type = fileName.split(".")[fileName.split(".").length-1];

        var fileKeyName = "/policy/"+fileName;
        var _file_id = _el.attr("name").replace("_file","").trim();
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        ajaxFormDataLoad(_file,_file_id,"policy/",type);
        flag = true;
        return flag;
    }

    function ajaxFormDataLoad(file,_id,directoryName,fileType){
        var index = laySomenType(0,null,'',0);
        var _myData = new Date();
        var _times = _myData.getTime();
        var name = "/"+directoryName+_times+"."+fileType;
        var formData = new FormData();
        formData.append('file', file);
        formData.append('fileName', _times+"."+fileType);
        formData.append('directoryName', directoryName);
        var uul = baseUrl + '/file/ajaxFormDataLoad';
        $.ajax({
            type: 'POST',
            url: uul,
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(result){
                laySomenType(2,index,'',0);
                if(result.statusCode == '200'){
                    $("#"+_id).val(result.message);
                }else{
                    laySomenType(1,null,result.message,0);
                }
            }
        });
    }

    function ajaxFormDataDelete(_id){
        var formData = new FormData();
        formData.append('url', $("#"+_id).val());
        var uul = baseUrl + '/file/ajaxFormDataDelete';
        $.ajax({
            url: uul,
            type: 'POST',
            cache: false,
            data: formData,
            processData: false,
            contentType: false
        }).done(function(res) {
            $("#"+_id).val('');
        }).fail(function(res) {

        });
    }
    var special_star_time = {
        elem: '#special_star_time',
        format: 'YYYY-MM-DD',
        min: laydate.now(+1), //设定最小日期为当前日期
        max: '${dto.product_code}'.indexOf('ZZX-ZA')!=-1?laydate.now(+60):laydate.now(+90), //最大日期
        istime: true,
        istoday: false,
        choose: function(datas){
            console.log(datas);
            if(datas != ''){
                $("#special_end_time").val('');
                special_end_time.min = datas; //开始日选好后，重置结束日的最小日期
                var pday = 14;
                if('${dto.product_code}'.indexOf('ZZX-YA')!=-1||'${dto.product_code}'.indexOf('ZZX-HT')!=-1){
                    pday = 29;
                    $('#special_end_time').val(dateAddDays(datas,pday));
                }
                special_end_time.max = dateAddDays(datas,pday);
            }
        }
    };

    //日期加天数的方法
    //dataStr日期字符串
    //dayCount 要增加的天数
    //return 增加n天后的日期字符串
    function dateAddDays(dataStr,dayCount) {
        var strdate=dataStr; //日期字符串
        var isdate = new Date(strdate.replace(/-/g,"/"));  //把日期字符串转换成日期格式
        isdate = new Date((isdate/1000+(86400*dayCount))*1000);  //日期加1天
        var pdate = isdate.getFullYear()+"-"+(isdate.getMonth()+1)+"-"+(isdate.getDate());   //把日期格式转换成字符串

        return pdate;
    }

    var special_end_time = {
        elem: '#special_end_time',
        format: 'YYYY-MM-DD',
        min: '1900-01-01',
        max: '2099-06-16',
        istime: true,
        istoday: false,
        choose: function(datas){
            /*start.max = datas; //结束日选好后，充值开始日的最大日期
            bidtimeS.max = datas;*/
        }
    };
    if('${dto.product_code}'.indexOf('ZZX-YA')==-1){
        laydate(special_end_time);
    }

    $('#special_star_time').on('focus',function(){
        var c_v = $('#special_contains').val();
        if(c_v == ''){
            layer.open({content:"请先选择“是否包含拆搭建”选项",btn: '我知道了'}); return;
            return;
        }
//        $('#special_end_time').val('');
        laydate(special_star_time);
        this.click();
    })
    $('#special_contains').on('change',function(){
        if(this.value == '1'){
            $('#special_ex_build_com_name').parent().show();
            $('#special_ex_subcontracting_units').parent().show();
        }else if(this.value == ''){
            $('#special_star_time').val('');
            $('#special_end_time').val('');
        }else{
            $('#special_ex_build_com_name').parent().hide();
            $('#special_ex_subcontracting_units').parent().hide();
            $('#special_ex_build_com_name').val('');
            $('#special_ex_subcontracting_units').val('');
        }
    })

    function getInv(){
        var code = $('#role_organizationCode_0').val();
        if(code != ''){
            var typeid = $('#role_organizationCode_0').attr('GIST-ID');
            var t_val = $('#'+typeid).val();
            if(t_val == '2' || t_val == '6'){
                var nr = $('#need_receipt').val();
                if(nr == '1'){
                    $('#taxpayerNumberInvoice_1').val(code);
                    $('#taxpayerNumberInvoice').val(code);
                }
            }
        }
    }
    $(function(){
        //投保人为搭建商时，设置
        if($('#role_roleType_0').val()=='2'){
            //隐藏自动填充
//            $('#zd_tc').hide();
            //判断是否是平安产品，如果是，显示参展商
            if('${dto.product_code}'.indexOf('ZZX-PAC')>-1||'${dto.product_code}'.indexOf('ZZX-YA')>-1){
                $('#special_exhibitor_name').parent().show();
                $('#special_exhibitor_type').parent().show();
                $('#special_exhibitor_code').parent().show();
                $('#special_exhibitor_code').parent().next().next().show();
                $('#special_exhibitor_name').attr('Data-Val','Required');
                $('#special_exhibitor_type').attr('Data-Val','Required');
                $('#special_exhibitor_code').attr('Data-Val','Required');
            }else if('${dto.product_code}'.indexOf('ZZX-ZA')>-1){
                $('#p_p_1').html('参展商名称');
                $('#p_p_2').html('参展商证件类型');
                $('#p_p_3').html('参展商证件号码');
            }
        }
    });

    function roleTypeChange(obj){//自动填充被保险人信息未完成，参展商名称字段校验为完成
        if(obj.value == '2'){//搭建商
            $('#special_ex_build_com_name').val($("#role_namecn_0").val());
            //隐藏自动填充
//            $('#zd_tc').hide();
            //锁定是否拆搭建 是
            $("#special_contains").val('1');
            $("#special_contains").change();
            //判断是否是平安产品，如果是，显示参展商
            if('${dto.product_code}'.indexOf('ZZX-PAC')>-1||'${dto.product_code}'.indexOf('ZZX-YA')>-1){
                $('#special_exhibitor_name').parent().show();
                $('#special_exhibitor_type').parent().show();
                $('#special_exhibitor_code').parent().show();
                $('#special_exhibitor_code').parent().next().next().show();
                $('#special_exhibitor_name').attr('Data-Val','Required');
                $('#special_exhibitor_type').attr('Data-Val','Required');
                $('#special_exhibitor_code').attr('Data-Val','Required');
            }else if('${dto.product_code}'.indexOf('ZZX-ZA')>-1){
                $('#p_p_1').html('参展商名称');
                $('#p_p_2').html('参展商证件类型');
                $('#p_p_3').html('参展商证件号码');
            }
            changeFrameSet(0,'');
        }else{
            $('#special_ex_build_com_name').val("");
            //显示自动填充
//            $('#zd_tc').show();
            $("#special_contains").val('0');
            $("#special_contains").change();
            $('#special_exhibitor_name').parent().hide();
            $('#special_exhibitor_name').val('');
            $('#special_exhibitor_name').attr('Data-Val','');
            $('#special_exhibitor_type').parent().hide();
            $('#special_exhibitor_type').val('');
            $('#special_exhibitor_type').attr('Data-Val','');
            $('#special_exhibitor_code').parent().hide();
            $('#special_exhibitor_code').val('');
            $('#special_exhibitor_code').attr('Data-Val','');
            $('#special_exhibitor_code').parent().next().next().hide();
            removeClass($('#special_exhibitor_name').parent(),'has-feedback has-success');
            removeClass($('#special_exhibitor_name').parent(),'has-loser has-feedback');
            removeClass($('#special_exhibitor_name').next(),'glyphicon-remove');
            removeClass($('#special_exhibitor_name').next(),'glyphicon-ok');
            removeClass($('#special_exhibitor_code').parent(),'has-feedback has-success');
            removeClass($('#special_exhibitor_code').parent(),'has-loser has-feedback');
            removeClass($('#special_exhibitor_code').next(),'glyphicon-remove');
            removeClass($('#special_exhibitor_code').next(),'glyphicon-ok');
            $('#p_p_1').html('被保险人名称');
            $('#p_p_2').html('证件类型');
            $('#p_p_3').html('证件号码');
            changeFrameSet(0,'');
        }
    }
    function verifyForm(obj){
        var _val = obj.value;
        if(obj.id == 'special_exhibitor_name'){
            if(_val == ''){
                laySomenType(1,null,"请输入正确的参展商名称！",0);
                loser_has(obj);
                return;
            }
            if(_val.length<8){
                laySomenType(1,null,"请输入正确的参展商名称！",0);
                loser_has(obj);
                $(obj).val('');
                return;
            }
            success_has(obj);
        }else if(obj.id == 'special_exhibitor_type'){
            if(_val == ''){
                laySomenType(1,null,"请选择参展商证件类型！",0);
                loser_has(obj);
                return;
            }
        }else if(obj.id == 'special_exhibitor_code'){
            var _idVal = $(obj).attr("GIST-ID");
            var _gistVal = $("#"+_idVal).val();
            if(_gistVal == '1'){//组织机构代码证校验
                if(checkOrganizingCode(_val) == 0){
                    laySomenType(1,null,"只能包含数字或英文大写字母，必须用连字符“-”隔开！",0);
                    loser_has(obj);
                    $(obj).val('');
                    return;
                }
            }else if(_gistVal == '2'){//三证合一信用代码证校验
                if(doValidCreditCode(_val) == 0){
                    laySomenType(1,null,"由数字或大写英文字母组成，共18位！",0);
                    loser_has(obj);
                    $(obj).val('');
                    return;
                }
            }else if(_gistVal == '6'){//税务登记证校验
                var flass = false;
                var reg= /^[A-Za-z]+$/;
                if(_val.length == 15&&checkInt1(_val)){
                    flass = true;
                }else if(_val.length == 20&&(checkInt1(_val)||(checkInt1(_val.substring(0,_val.length-1))&&reg.test(_val.substring(_val.length-1,_val.length))))){
                    flass = true;
                }else{
                    if(doValidCreditCode(_val) == 0){

                    }else{
                        flass = true;
                    }
                }
                if(!flass){
                    laySomenType(1,null,"请输入正确的税务登记证或信用代码证代码！",0);
                    loser_has(obj);
                    $(obj).val('');
                    return;
                }
            }else if(_gistVal == '7'){//营业执照校验
                var reg= /^\d{15}$/;
                if(!reg.test(_val)){
                    laySomenType(1,null,"请输入正确的参展商营业执照！",0);
                    loser_has(obj);
                    $(obj).val('');
                    return;
                }
            }else{
                laySomenType(1,null,"请选择参展商证件类型！",0);
                loser_has(obj);
                $(obj).val('');
                return;
            }
            success_has(obj);
        }
    }

    function natureChange(_this,_id){
        var code = _this.value;
        if(code != ""){
            $.ajax({
                type: 'POST',
                url: baseUrl + '/synopsis/natureChange.json',
                data:{"nID":code},
                dataType:"json",
                async: false,
                success: function(json) {
                    $("#" + _id).empty();
                    var t = 0;
                    $("#" + _id).append("<option value=''>-请选择-</option>");
                    for (var prop in json) {
                        if (json.hasOwnProperty(prop)) {
                            t ++;
                            var appendStr = "<option value='" + prop + "' ";
                            appendStr = appendStr + ">" + json[prop] + "</option>"
                            $("#" + _id).append(appendStr);
                        }
                    }
                    if(t > 0){
                        $("#"+_id).parent().show();
                    }else{
                        $("#"+_id).parent().hide();
                    }

                }
            });
        }else{
            $("#"+_id).parent().hide();
        }
    }

    function removeClass(obj, cls) {
        if (hasClass(obj, cls)) {
            obj.attr("class",obj.attr("class").replace(cls, ''));
        }
    }
    $('#zd_tc_cb').on('click',function(){
        if($(this).is(':checked')){
            msgClone();
            $('#cy_lxr_bb').find('a').hide();
        }else{
            msgClear();
            $('#cy_lxr_bb').find('a').show();
        }
    });

    function msgClone(){
        $('#role_namecn_1').val($('#role_namecn_0').val());
        cloneHelp('role_idType_0','role_idType_1');
        $('#role_organizationCode_1').val($('#role_organizationCode_0').val());
        cloneHelp('regProvince','regProvince_1');
        cloneHelp('regCity','regCity_1');
        cloneHelp('regDistrict','regDistrict_1');
        $('#regAddress_1').val($('#regAddress').val());
        $('#role_linkName_1').val($('#role_linkName_0').val());
        $('#role_linkTel_1').val($('#role_linkTel_0').val());
    }
    function msgClear(){
        $('#role_namecn_1').val('');
        $('#role_organizationCode_1').val('');
        $('#regAddress_1').val('');
        $('#role_linkName_1').val('');
        $('#role_linkTel_1').val('');
        $('#role_idType_1').val('');
        $('#regProvince_1').val('');
        $('#regCity_1').val('');
        $('#regDistrict_1').val('');
    }
    function cloneHelp(_id0,_id1){
        var tSel = $('#'+_id0+' option');
        $('#'+_id1).empty();
        for(var i=0;i<tSel.length;i++){
            var sed = '';
            if(tSel[i].selected) sed = 'selected';
            $('#'+_id1).append("<option value='"+tSel[i].value+"' "+sed+">"+tSel[i].text+"</option>");
        }
    }
</script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js' />"></script>
</html>