<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
<head>
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" />
    <!--[if lt IE 9]>
    <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
    <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
    <![endif]-->
</head>
<body>
<div class="container"><!-- container start -->
    <ol class="breadcrumb" id="bread_crumbs">
    </ol>
    <div class="message-war"><!-- message-war start -->
        <h2>${ dto.product_name}</h2>
        <div class="w-95-auto"><!-- w-95-auto start -->
            <h5><c:if test="${ not empty dto.external_reference }">保单号码：${ dto.external_reference}</c:if><c:if test="${ empty dto.external_reference }">订单号码：${ dto.trade_serial_number}</c:if></h5>
            <div class="mess-title"><h3>推荐人信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">推荐人的手机号或编号</td>
                        <td class="col-sm-4 col-xs-4">${empty vo.recommend_code ? '无' : vo.recommend_code}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
                        <td class="col-sm-4 col-xs-4"></td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>投保人信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">投保单位</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">${vo.roleSubjectList[0].name_cn}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">注册地址</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">
                            ${reg_role}
                            ${vo.roleSubjectList[0].reg_address}
                        </td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">所属行业</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].industry}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">营业性质</td>
                        <td class="col-sm-4 col-xs-4">
                            <c:forEach items="${natureList }" var="list">
                                <c:if test="${list.value eq vo.roleSubjectList[0].com_nature}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                            <c:forEach items="${natureList }" var="list">
                                <c:if test="${list.value eq vo.roleSubjectList[0].nature_two}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                        </td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件类型</td>
                        <td class="col-sm-4 col-xs-4">
                            <c:forEach items="${typeList }" var="list">
                                <c:if test="${list.value eq vo.roleSubjectList[0].id_type}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                        </td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件号码</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].organization_code}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件有效期类型</td>
                        <td class="col-sm-4 col-xs-4">${fns:getDictLabel (vo.roleSubjectList[0].id_option,"idOption","")}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">有效期起止</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].id_star_date} ~ ${vo.roleSubjectList[0].id_end_date}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">雇员人数</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].total_emp}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人姓名</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].link_name}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人手机</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].link_tel}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人email</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].link_email}</td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>被保险人信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">投保单位</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">${vo.roleSubjectList[1].name_cn}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">注册地址</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">
                            ${reg_role_1}
                            ${vo.roleSubjectList[1].reg_address}
                        </td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">所属行业</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].industry}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">营业性质</td>
                        <td class="col-sm-4 col-xs-4">
                            <c:forEach items="${natureList }" var="list">
                                <c:if test="${list.value eq vo.roleSubjectList[1].com_nature}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                            <c:forEach items="${natureList }" var="list">
                                <c:if test="${list.value eq vo.roleSubjectList[1].nature_two}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                        </td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件类型</td>
                        <td class="col-sm-4 col-xs-4">
                            <c:forEach items="${typeList }" var="list">
                                <c:if test="${list.value eq vo.roleSubjectList[1].id_type}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                        </td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件号码</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].organization_code}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件有效期类型</td>
                        <td class="col-sm-4 col-xs-4">${fns:getDictLabel (vo.roleSubjectList[1].id_option,"idOption","")}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">有效期起止</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].id_star_date} ~ ${vo.roleSubjectList[1].id_end_date}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">雇员人数</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].total_emp}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人姓名</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].link_name}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人手机</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].link_tel}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人email</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].link_email}</td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>雇员信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-1 col-xs-1">序号</td>
                        <td class="tablebg_f5f8fa col-sm-1 col-xs-1">姓名</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件类型</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件号码</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">出生日期</td>
                        <td class="tablebg_f5f8fa col-sm-1 col-xs-1">性别</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">职业</td>
                        <td class="tablebg_f5f8fa col-sm-1 col-xs-1">手机</td>
                    </tr>
                    <c:if test="${vo.hirelingVoList!=null}">
                        <c:forEach items="${ vo.hirelingVoList }" var="hvo" varStatus="index">
                            <tr>
                                <td class="col-sm-1 col-xs-1">${index.index+1}</td>
                                <td class="col-sm-1 col-xs-1">${ hvo.name}</td>
                                <td class="col-sm-2 col-xs-2">
                                    <c:forEach items="${typeList }" var="list">
                                        <c:if test="${list.value eq hvo.id_type}">
                                            ${list.name}
                                        </c:if>
                                    </c:forEach>
                                </td>
                                <td class="col-sm-2 col-xs-2">${ hvo.id_card}</td>
                                <td class="col-sm-2 col-xs-2">${ hvo.birth_date}</td>
                                <td class="col-sm-1 col-xs-1">${empty hvo.sex ? '':hvo.sex eq '1'?'男':'女'}</td>
                                <td class="col-sm-2 col-xs-2">
                                        ${ hvo.career eq '1' ? '内勤人员' : hvo.career eq '2' ? '保安人员' : hvo.career eq '4' ? '保洁人员' : '-'}
                                </td>
                                <td class="col-sm-1 col-xs-1">${ hvo.mobile}</td>
                            </tr>
                        </c:forEach>
                    </c:if>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>投保计划信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">起保日期</td>
                        <td class="col-sm-4 col-xs-4">${ vo.inception_date }</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">保费</td>
                        <td class="col-sm-4 col-xs-4">${dto.gross_premium}</td>
                    </tr>
                    <tr>
                        <td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">保障方案</td>
                        <td colspan="3" class="col-sm-10 col-xs-10">
                            <table class="table ">
                                <tbody>
                                <tr>
                                    <td class="col-sm-4 col-xs-4">保障责任</td>
                                    <td class="col-sm-2 col-xs-2">
                                        <c:set var="irp_1" value="${ vo.responsibilityVoList[0] }"></c:set>
                                        <c:choose>
                                            <c:when test="${empty irp_1.insurance_amount_max && not empty irp_1.fcy}">
                                                保险金额
                                            </c:when>
                                            <c:when test="${empty irp_1.fcy && not empty irp_1.insurance_amount_max}">
                                                赔偿限额
                                            </c:when>
                                            <c:otherwise>
                                                保险金额
                                            </c:otherwise>
                                        </c:choose>
                                    </td>
                                    <td class="col-sm-2 col-xs-2">免赔额</td>
                                    <td class="col-sm-2 col-xs-2">赔付比例</td>
                                    <td class="col-sm-2 col-xs-2">免赔天数</td>
                                </tr>
                                <c:forEach items="${ vo.responsibilityVoList }" var="irp">
                                    <tr <c:choose>
                                        <c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '0' && irp.is_optional eq '2'}">
                                            hidden
                                        </c:when>
                                        <c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '1' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障一')}">
                                            hidden
                                        </c:when>
                                        <c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '2' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障二')}">
                                            hidden
                                        </c:when>
                                        <c:when test="${empty vo.is_contain_repo && irp.is_optional eq '2'}">
                                            hidden
                                        </c:when>
                                        <c:otherwise>

                                        </c:otherwise>
                                    </c:choose>>
                                        <td class="col-sm-4 col-xs-4" style="text-align:left; <c:if test="${irp.name eq '烈士褒扬金'}">color: red;</c:if>">${irp.name}<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="${irp.explain_product}"/></td>
                                        <td class="col-sm-2 col-xs-2" <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>
                                            <c:choose>
                                                <c:when test="${empty irp.insurance_amount_max && not empty irp.fcy}">
											<span>
												<c:if test="${ empty irp.fcy}">
                                                    -
                                                </c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.fcy}">
                                                    <c:if test="${irp.fcy/10000 >= 1}">
                                                        ${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
                                                        万元
                                                    </c:if>
                                                    <c:if test="${irp.fcy/10000 < 1}">
                                                        ${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
                                                        元
                                                    </c:if>
                                                </c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.fcy}">
                                                    <c:if test="${irp.fcy/10000 >= 1}">
                                                        ${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
                                                        万元/天
                                                    </c:if>
                                                    <c:if test="${irp.fcy/10000 < 1}">
                                                        ${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
                                                        元/天
                                                    </c:if>
                                                </c:if>
											</span>
                                                </c:when>
                                                <c:when test="${empty irp.fcy && not empty irp.insurance_amount_max}">
											<span>
												<c:if test="${ empty irp.insurance_amount_max}">
                                                    -
                                                </c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.insurance_amount_max}">
                                                    <c:if test="${irp.insurance_amount_max/10000 >= 1}">
                                                        ${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
                                                        万元
                                                    </c:if>
                                                    <c:if test="${irp.insurance_amount_max/10000 < 1}">
                                                        ${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
                                                        元
                                                    </c:if>
                                                </c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.insurance_amount_max}">
                                                    <c:if test="${irp.insurance_amount_max/10000 >= 1}">
                                                        ${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
                                                        万元/天
                                                    </c:if>
                                                    <c:if test="${irp.insurance_amount_max/10000 < 1}">
                                                        ${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
                                                        元/天
                                                    </c:if>
                                                </c:if>
											</span>
                                                </c:when>
                                                <c:otherwise>
                                                    <span>-</span>
                                                </c:otherwise>
                                            </c:choose>
                                        </td>
                                        <td class="col-sm-2 col-xs-2" >${empty irp.cumulative_deductibles ? '-' : irp.cumulative_deductibles}</td>
                                        <td class="col-sm-2 col-xs-2" >${empty irp.compensation_ratio ? '-' : irp.compensation_ratio}${not empty irp.compensation_ratio ? '%' : ''}</td>
                                        <td class="col-sm-2 col-xs-2" >${empty irp.deductible_days ? '-' : irp.deductible_days}</td>
                                    </tr>
                                </c:forEach>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">争议处理</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">若投保人/被保险人与保险人发生争执，不能达成协议，被保险人自愿采取的解决方式：${ vo.dispute eq '0' ? '诉讼' : '仲裁，仲裁机构' }&nbsp;&nbsp;${vo.dispute eq '0' ? '': vo.arbitral_institution}</td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>退保账户信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">开户名</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">${vo.roleSubjectList[0].account_name}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">账户开户行</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].bank_name}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">银行账号</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].bank_account}</td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>投保声明</h3></div>
            <div class="affirm-warr">
                <p class="mt30" style="font-weight: bold">1、投保人通过合法途径获得团体授权，向保险人投保本险种，所有投保操作和内容已获得认可，所有被保险人均为与投保单位有劳动关系的劳动者，该产品的保障内容以及保险金额已向被保险人进行了明确说明，并征得其同意。</p>
                <p style="font-weight: bold">2、投保人已就保险事宜与全部被保险人进行了宣导和沟通，凡参与该保险的全部被保险人均符合险种条款所约定（包括但不限于责任免除、投保人被保险人义务、保险金申请与给付等）的投保条件，并了解保障内容且同意由投保人统一办理投保事项，投保人已认真阅读并正确理解条款和投保须知的所有内容，并接受上述内容，同意以此作为订立保险合同的依据。</p>
                <p style="font-weight: bold">3、本产品投保填写以及所附的被保险人清单中的各项事实均属实，并作为本保险合同的组成部分，如有隐瞒或不实告知，投保人愿承担由此带来的法律后果，保险人有权解除保险合同，对于合同解除前发生的任何事故，保险人可不承担任何责任。</p>
                <p class="mb30" style="font-weight: bold">4、保险事故发生后，保险人需核实被保险人雇员与投保人单位之间的雇佣关系，确定保险责任。</p>
            </div>
        </div><!-- w-95-auto end -->
    </div><!-- message-war end -->
    <c:if test="${ not empty dto.external_reference && dto.policy_status eq '6'}">
        <div class="row next-step">
            <c:if test="${fn:contains(dto.product_code,'GZZRX-CA') && empty dto.user_insure_path}">
                <div class="col-lg-6 col-sm-6">
                    <p>您需要打印投保单将其盖上贵公司公章并到此上传。</p>
                </div>
            </c:if>
            <div class="col-sm-6 col-xs-6 text-right pull-right">
                <p>
                    <c:if test="${ not empty dto.insure_path }">
                        <a href="${dto.insure_path}" class="ns-btn">保单下载</a>
                    </c:if>
                    <c:if test="${ empty dto.insure_path }">
                        <a href="javascript:void(0);" onclick="requestEPolicy('${ dto.oid }',this);" class="ns-btn">保单下载</a>
                    </c:if>
                    <c:if test="${fn:contains(dto.product_code,'GZZRX-TB')||fn:contains(dto.product_code,'GZZRX-ZH')||fn:contains(dto.product_code,'GZZRX-PAC')||fn:contains(dto.product_code,'GZZRX-CA')||fn:contains(dto.product_code,'GZZRX-QH')}">
                        <c:if test="${ empty vo.mailPolicyVo.e_invoice_url || vo.mailPolicyVo.e_invoice_url eq '1'}">
                            <a href="javascript:void(0);" onclick="requestInvoice('${ dto.product_code }','${ dto.oid }',this);" class="ns-btn">申请电子发票</a>
                        </c:if>
                        <c:if test="${ not empty vo.mailPolicyVo.e_invoice_url && vo.mailPolicyVo.e_invoice_url != '1'}">
                            <a href="${vo.mailPolicyVo.e_invoice_url}" class="ns-btn">发票下载</a>
                        </c:if>
                    </c:if>
                    <c:if test="${fn:contains(dto.product_code,'GZZRX-CA') && empty dto.user_insure_path}">
                        <a href="javascript:void(0);" onclick="showInsureModal();" class="ns-btn" style="margin-left: 10px;">上传投保单</a>
                        <a href="javascript:void(0);" onclick="showPrintPolicyModal('${dto.oid}');" class="gray-btn" style="margin-left: 10px;">打印投保单</a>
                    </c:if>
                </p>
            </div>
        </div>
    </c:if>
</div><!-- container end -->

<div class="modal fade" id="insureModal" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-1f96ef">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">上传投保单</h4>
            </div>
            <form id="insureForm" method="post" enctype="multipart/form-data" >
                <input name="ins_insurance_slip_id" id="policyId" value="${dto.oid}" type="hidden"/>
                <div class="modal-body">
                    <div class="col-sm-12 col-xs-12" style="margin-top: 8px;">
                        <div class="col-sm-12 col-xs-12" id="insurePath_isHidden">
                            <input type="hidden" name="user_insure_path" id="user_insure_path" value="">
                            <div class="basic-file">
                                <input name="user_insure_path_file" id="user_insure_path_file-5" class="file" data-drawview="" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="mofo-sub">
                        <button type="button" class="btn pull-left cancel-btn" data-dismiss="modal">取消</button>
                        <button type="button" class="btn notarize-btn pull-right" onclick="uploadInsure();">确认</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<form id="dow-now" action="<c:url value='/synopsis/sodownload'/>" method="post">
    <input name="path" id="path-dow" type="hidden">
    <input name="name" id="name-dow" type="hidden">
</form>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<jsp:include page="../../../index/multi_init_param.jsp"/>
<script type="text/javascript">
    var baseUrl = '${pageContext.request.contextPath }';
    var win_sign = 1;//0本站内嵌，1它站内嵌
    function sodownload(path,name){
        path = path.split(".com/")[1];
        $("#path-dow").val(path);
        $("#name-dow").val(name);
        $("#dow-now").submit();
    }
    function requestEPolicy(_oid,_obj){
        var index = laySomenType(0,null,'',0);
        $.ajax({
            type: 'POST',
            url:baseUrl + '/api/gzzrx/policy/requestEPolicy/'+_oid,
            dataType:"json",
            success: function(json){
                if(json.statusCode == '200') {
                    $(_obj).attr("href",json.navTabId);
                    $(_obj).attr("onclick","");
                    window.open(json.navTabId);
                }else{
                    laySomenType(1,null,json.message,0);
                }
                laySomenType(2,index,'',0);
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                laySomenType(2,index,'',0);
                laySomenType(1,null,textStatus,0);
            }
        });
    }

    function requestInvoice(_code,_oid,_obj){
        layer.confirm('完成电子发票申请后将无法开具纸质发票，是否继续申请？', {
            btn: ['确定','取消'] //按钮
        }, function(){
            layer.closeAll();
            var index = laySomenType(0,null,'',0);
            var _url = '/ZH-API/GZZRX/PRINT_INVOICE/'+_oid;
            if(_code){
                if('TB' == _code.split('-')[1]){
                    _url = '/TB-API/GZZRX/PRINT_INVOICE/'+_oid;
                }
                if('PAC' == _code.split('-')[1]){
                    _url = '/PAC-API/GZZRX/PRINT_INVOICE/'+_oid;
                }
                if('CA' == _code.split('-')[1]){
                    _url = '/CA-API/GZZRX/PRINT_INVOICE/'+_oid;
                }
                if('QH' == _code.split('-')[1]){
                    _url = '/QH-API/GZZRX/PRINT_INVOICE/'+_oid;
                }
            }
            $.ajax({
                type: 'POST',
                url:baseUrl + _url,
                dataType:"json",
                success: function(json){
                    if(json.statusCode == '200') {
                        if(json.message == '1'){
                            layer.msg("电子发票申请不支持专票开具，请联系客服咨询");
                        }else {
                            $(_obj).attr("href",json.message);
                            $(_obj).attr("onclick","");
                            window.open(json.message);
                        }
                    }else{
                        laySomenType(1,null,json.message,0);
                    }
                    laySomenType(2,index,'',0);
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    laySomenType(2,index,'',0);
                    laySomenType(1,null,textStatus,0);
                }
            });
        });
    }
    var topWindow;
    $(function(){
        for(topWindow=window;topWindow.parent!=null && topWindow.parent!=topWindow;topWindow=topWindow.parent){
            for(var i=0;i<topWindow.parent.frames.length;i++){
                var isIframe = true;
                try {
                    topWindow.parent.frames[i].window.document;
                }catch (e) {
                    isIframe = false;
                }
                if(isIframe){
                    if(topWindow.parent.frames[i].window.document==topWindow.document){
                        var tName = topWindow.parent.frames[i].name;
                        if(tName != ''){
                            var bread_crumbs;
                            if(tName.indexOf('layui-layer-iframe')==-1){
                                win_sign = 0;
                                $("ol[class*='breadcrumb']").each(function(){
                                    $(this).html('');
                                });
                                parent.document.getElementById("frame3d").height=topWindow.document.body.offsetHeight+60;
                            }
                        }
                    }
                }
            }
        }
        $("td").each(function(){
            var _class = $(this).attr("class");
            if(_class != undefined){
                if(_class.indexOf("tablebg_f5f8fa") == -1 && _class.indexOf("col-sm") != -1){
                    if($(this).prev().length==1){
                        var preClass = $(this).prev().attr("class");
                        if(preClass.indexOf("tablebg_f5f8fa") != -1){
                            var preVal = $(this).prev().html();
                            if(preVal != ''){
                                var _val = $(this).html();
                                if(_val == ''){
                                    $(this).html('-');
                                }
                            }
                        }else{
                            var _val = $(this).html();
                            if(_val == ''){
                                $(this).html('-');
                            }
                        }
                    }else{
                        var _val = $(this).html();
                        if(_val == ''){
                            $(this).html('-');
                        }
                    }


                }
            }
        });

    });
    function laySomenType(ty,idx,msg,times){//ty:layer类型，如0打开遮盖，1消息提示，2关闭遮盖层；win_sign:当前0内嵌或1外嵌
        if(win_sign == 0){//本站内嵌
            if(ty==0){//打开遮盖
                return layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
            }else if(ty==1){//消息提示
                if(times == 0){
                    layer.msg(msg);
                }else{
                    layer.msg(msg, {time:times});
                }
            }else if(ty == 2){
                layer.close(idx);
            }
        }else{//它站内嵌
            if(ty==0){//打开遮盖
                return layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
            }else if(ty==1){//消息提示
                if(times == 0){
                    layer.msg(msg);
                }else{
                    layer.msg(msg, {time:times});
                }
            }else if(ty == 2){
                layer.close(idx);
            }
        }
        return null;
    }

    function showInsureModal(){
        $("#insureModal").modal("show");
    }

    function showPrintPolicyModal(policyId){
        layer.open({
            type: 2,
            title:'投保单预览',
            scrollbar: false,
            area : [ '70%', '90%' ],
            shade : 0.8,
            skin: 'agreementModal',
            btn: ['打印','取消'],
            content: baseUrl +'/insurance/gzzrx/transaction/printPolicy/'+policyId+'?ACCESS_TOKEN=${ACCESS_TOKEN}', //iframe的url
            yes:function(indexIframe, layero){
                var iframeWin = window[layero.find('iframe')[0]['name']]; //得到iframe页的窗口对象，执行iframe页的方法：iframeWin.method();
                iframeWin.printPage();
            }
        });
    }
    function uploadInsure(){
        var policyId = $("#policyId").val();
        var insurePath = $("#user_insure_path").val();
        if(insurePath ==""){
            layer.msg("请选择投保单");
        }
        else{
            var index = laySomenType(0,null,'',0);
            $.ajax({
                type: 'POST',
                url:baseUrl + '/insurance/gzzrx/transaction/saveSealInsuranceApplication.json',
                data:$("#insureForm").serialize(),
                dataType:"json",
                success: function(json){
                    laySomenType(2,index,'',0);
                    laySomenType(1,null,json.message,0);
                    if(json.statusCode == '200') {
                        $("#insureModal").modal("hide");
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    //关闭遮罩
                    laySomenType(2,index,'',0);
                    //返回错误信息在遮罩层上
                    laySomenType(1,null,textStatus,0);
                }
            });
        }
    }
    function clearBase64Byinput(_el){
        var _file_id = _el.id;
        _file_id = _file_id.substring(0,_file_id.length-7);
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        $("#"+_file_id).val('');
    }
    function base64convert(_el,_file){
        var flag = false;
        var fileName = _file.name;
        var type = fileName.split(".")[fileName.split(".").length-1];

        var fileKeyName = "/policy/"+fileName;
        var _file_id = _el.attr("name").replace("_file","").trim();
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        ajaxFormDataLoad(_file,_file_id,"policy/",type);
        flag = true;
        return flag;
    }

    function ajaxFormDataLoad(file,_id,directoryName,fileType){
        var index = laySomenType(0,null,'',0);
        var _myData = new Date();
        var _times = _myData.getTime();
        var name = "/"+directoryName+_times+"."+fileType;
        var formData = new FormData();
        formData.append('file', file);
        formData.append('fileName', _times+"."+fileType);
        formData.append('directoryName', directoryName);
        var uul = baseUrl + '/file/ajaxFormDataLoad';
        $.ajax({
            type: 'POST',
            url: uul,
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(result){
                laySomenType(2,index,'',0);
                if(result.statusCode == '200'){
                    $("#"+_id).val(result.message);
                }else{
                    laySomenType(1,null,result.message,0);
                }
            }
        });
    }

    function ajaxFormDataDelete(_id){
        var formData = new FormData();
        formData.append('url', $("#"+_id).val());
        var uul = baseUrl + '/file/ajaxFormDataDelete';
        $.ajax({
            url: uul,
            type: 'POST',
            cache: false,
            data: formData,
            processData: false,
            contentType: false
        }).done(function(res) {
            $("#"+_id).val('');
        }).fail(function(res) {

        });
    }
</script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/bootstrap.min.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js'/>"></script>
</body>
</html>