<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/public.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/idangerous.swiper2.7.6.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/basic.css' />" />
	<title>${productDto.product_name}</title>
</head>
<body>

<!--产品详情页内容-->
<div class="product-particulars sqe">
	<div class="partic-place">
		<p id="bread_crumbs">
			<c:if test="${fn:contains(userdetail.web_type, 'PSS')}">
				当前位置：<a href="javascript:void(0);">保障服务 > </a><a href="<c:url value='/insurance/product/gzx-product-all?ACCESS_TOKEN=${ACCESS_TOKEN}' />">产品列表 > </a>
				<a href="javascript:void(0);">产品详情</a>
			</c:if>
		</p>
		<ul class="clearfix" id="nav">
			<li class="current">
				<a href="#section-1">产品详情</a>
			</li>
			<li>
				<a href="#section-2">投保须知</a>
			</li>
			<li>
				<a href="#section-3">典型案例</a>
			</li>
			<li>
				<a href="#section-4">保险条款</a>
			</li>
			<li>
				<a href="#section-5">理赔流程</a>
			</li>
			<li>
				<a href="#section-6">常见问题</a>
			</li>
		</ul>
	</div>
	<div class="partic-content clearfix">
		<div class="partic-left fl">
			<div class="sed insur-content" id="section-1">
				<!--<div class="insur-logo">-->
				<!--<img src="<c:url value='/resources/version_new/images/taikang-green.png' />">-->
				<!--</div>-->
				<div class="insur-head clearfix">
					<p class="fl">${productDto.product_name}</p>
					<div class="insur-share fr">
                        <span class="fl">
                            <i>￥</i>
                            <em>${productDto.premium_min }起</em>
                        </span>
						<a href="javascript:;" class="share-more fl copyPathToShare">立即分享</a>
						<c:if test="${productDto.p_status eq '0'}">
							<a href="javascript:;" onclick="layer.alert('该产品目前已下架，请选择其它产品！', {skin: 'layui-layer-lan',closeBtn: 0,anim: 4});" class="insur-buy fl insur-buy-gray">立即购买</a>
						</c:if>
						<c:if test="${productDto.p_status eq '1'}">
                        	<a href="<c:url value='/api/gzx/policyInit/${productDto.oid }?recommendCode=${recommendCode}&ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="insur-buy fl">立即购买</a>
						</c:if>
					</div>
				</div>
				<input type="hidden" id="fe_text" value=""/>
				<ul class="insur-label clearfix">
					<c:if test="${fn:contains(productDto.product_label,',')}">
						<c:forEach items="${fn:split(productDto.product_label,',')}" var="lables">
							<li>${lables}</li>
						</c:forEach>
					</c:if>
					<c:if test="${fn:contains(productDto.product_label,' ')}">
						<c:forEach items="${fn:split(productDto.product_label,' ')}" var="lables">
							<li>${lables}</li>
						</c:forEach>
					</c:if>
				</ul>
				<p class="insur-p" id="insur-p-p">
				</p>
				<table cellspacing="0" cellpadding="0" class="wed">
					<tbody>
					<tr>
						<td>
							<span>保险公司</span>
						</td>
						<td>
							<span class="grey">${productDto.insurance_name}</span>
						</td>
						<td>
							<span>保险金额</span>
						</td>
						<td>
							<span class="grey">视情况而定</span>
						</td>
					</tr>
					<tr>
						<td>
							<span>适用范围</span>
						</td>
						<td>
							<span class="grey">${productDto.scope}</span>
						</td>
						<td>
							<span>限购份数</span>
						</td>
						<td>
							<span class="grey">1份</span>
						</td>
					</tr>
					<tr>
						<td>
							<span>保单形式</span>
						</td>
						<td>
							<span class="grey">${productDto.from_of_policy}</span>
						</td>
						<td>
							<span>缴费期间</span>
						</td>
						<td>
							<span class="grey">${productDto.payment_way eq '1' ? '一次性' : productDto.payment_way eq '2' ? '分期' : productDto.payment_way eq '1,2' ? '一次性或分期' : '-'}</span>
						</td>
					</tr>
					<tr>
						<td>
							<span>保障期限</span>
						</td>
						<td>
							<span class="grey">一年</span>
						</td>
						<td>
							<span>保费</span>
						</td>
						<td>
							<span class="grey">${productDto.premium_min }元起</span>
						</td>
					</tr>
					</tbody>
				</table>
				<div class="security-content">
					<p class="clearfix">
						<i class="fl"></i>
						<span class="fl">保障内容</span>
					</p>
					<table cellspacing="0" cellpadding="0">
						<thead>
						<tr>
							<th>
								<span>保障责任</span>
							</th>
							<th width="320">
								<span>保障说明</span>
							</th>
							<th>
								<c:set var="irp_1" value="${ productDto.responsibilityVoList[0] }"></c:set>
								<c:choose>
									<c:when test="${empty irp_1.insurance_amount_max && not empty irp_1.fcy}">
										<span>保险金额</span>
									</c:when>
									<c:when test="${empty irp_1.fcy && not empty irp_1.insurance_amount_max}">
										<span>赔偿限额</span>
									</c:when>
									<c:otherwise>
										<span>保险金额</span>
									</c:otherwise>
								</c:choose>
							</th>
							<th>
								<span>免赔额</span>
							</th>
							<th>
								<span>赔付比例</span>
							</th>
							<th>
								<span>免赔天数</span>
							</th>
						</tr>
						</thead>
						<tbody>
						<c:forEach items="${ productDto.responsibilityVoList }" var="irp">
							<tr class="bg-3f">
								<td class="ert">${irp.name}</td>
								<td class="text">
									<span>${irp.explain_product}</span>
								</td>
								<td>
									<c:choose>
										<c:when test="${empty irp.insurance_amount_max && not empty irp.fcy}">
											<span>
												<c:if test="${ empty irp.fcy}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元/天
													</c:if>
												</c:if>
											</span>
										</c:when>
										<c:when test="${empty irp.fcy && not empty irp.insurance_amount_max}">
											<span>
												<c:if test="${ empty irp.insurance_amount_max}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元/天
													</c:if>
												</c:if>
											</span>
										</c:when>
										<c:otherwise>
											<span>-</span>
										</c:otherwise>
									</c:choose>
								</td>
								<td>
									<span>${empty irp.cumulative_deductibles ? '-' : irp.cumulative_deductibles}</span>
								</td>
								<td>
									<span>${empty irp.compensation_ratio ? '-' : irp.compensation_ratio}${not empty irp.compensation_ratio ? '%' : ''}</span>
								</td>
								<td>
									<span>${empty irp.deductible_days ? '-' : irp.deductible_days}</span>
								</td>
							</tr>
						</c:forEach>
						</tbody>
					</table>
				</div>
			</div>
			<div class="sed insur-informa" id="section-2">
				<h2 class="clearfix">
					<i class="fl"></i>
					<span class="fl">投保须知</span>
				</h2>
				<p id="section-p-2">
					<c:if test="${fn:contains(productDto.notice_mod,'<p>')}">
						${fn:replace(fn:replace(fn:replace(fn:replace(productDto.notice_mod, '<br>', ''), '<br/>', ''), '<p>', ''), '</p>', '<br/>')}
					</c:if>
					<c:if test="${fn:contains(productDto.notice_mod,'<div>')}">
						${fn:replace(fn:replace(fn:replace(fn:replace(productDto.notice_mod, '<br>', ''), '<br/>', ''), '<div>', ''), '</div>', '<br/>')}
					</c:if>
				</p>
			</div>
			<div class="sed insur-case" id="section-3">
				<h2 class="clearfix">
					<i class="fl"></i>
					<span class="fl">典型案例</span>
				</h2>
				${productDto.sample_mod}
			</div>
			<div class="sed insur-clause" id="section-4">
				<h2 class="clearfix">
					<i class="fl"></i>
					<span class="fl">保险条款</span>
				</h2>
				<ul>
					<h2 style="font-size: 14px">特别提醒：保险责任请参考以下条款，并敬请特别留意条款中的<span style="color: red ;font-size: 14px" >"责任免除"</span>部分。</h2>
					<c:if test="${not empty productDto.pro_clauses}">
						<c:forEach items="${fn:split(productDto.pro_clauses, '#')}" var="pcs">
							<li>
								<a target="_blank" href="<c:url value='/weixin/product/clause/${fn:split(pcs, "::")[0]}' />">${fn:split(pcs, "::")[1]}</a>
								<div class="clause-cic"></div>
							</li>
						</c:forEach>
					</c:if>
				</ul>
			</div>
			<div class="sed claims-process" id="section-5">
				<h2 class="clearfix">
					<i class="fl"></i>
					<span class="fl">理赔流程</span>
				</h2>
				<div class="claims-content">
					<div class="content-img">
						<img src="<c:url value='/resources/version_new/images/claims.png'/>" alt="理赔流程图">
					</div>
					<ul class="clearfix">
						<li>
							<p>拨打报案电话</p>
							<span>根据保单信息拨打相应保险公司报案电话或拨打平台报案电话400-662-9696或根据平台要求在线填写信息</span>
						</li>
						<li class="wer">
							<p>准备材料</p>
							<span>根据服务人员告知的资料清单准备理赔资料</span>
						</li>
						<li class="wed">
							<p>理赔办理</p>
							<span>提交理赔资料</span>
						</li>
						<li>
							<p>审核</p>
							<span>保险公司审核理赔材料</span>
						</li>
						<li class="jie">
							<p>结案</p>
							<span>确属保险责任范围的事故，保险公司将在约定时效内赔付</span>
						</li>
					</ul>
				</div>
			</div>
			<div class="sed common-problems" id="section-6">
				<h2 class="clearfix">
					<i class="fl"></i>
					<span class="fl">常见问题</span>
				</h2>
				<ul id="section-6-p">
					${productDto.faq_mod}
					<%--<li>
						<h3>哪些单位可以购买展会综合责任保险？</h3>
						<p>展会综合责任险主要保障雇员在展会活动举办期间因过失等造成展览场所财产损失、第三者和雇请人员的人身伤害时依法应承担责任，所以该保障可供参展方购买，展会活动组织方和场馆方也可为参展方购买展会综合责任保险。</p>
					</li>
					<li>
						<h3>这款产品保障时间多久？</h3>
						<p>本产品保障时间可从活动临建设施搭建起至活动结束临建设施拆卸完毕止，覆盖整个展会期间，但最长不超过15天。</p>
					</li>
					<li>
						<h3>这款产品的雇员人身伤害责任包含临建设施搭建、拆除的施工人员吗？</h3>
						<p>本产品保障雇员可为活动组织方、场馆方的雇员、参展单位的雇员以及承揽其搭建、拆除工程的施工单位的雇员，但责任范围内的总雇员不能超过20个。</p>
					</li>
					<li>
						<h3>如何查询验证保单？</h3>
						<p>本产品由众安在线财产保险股份有限公司承保，为保证您的合法权益,您可拨打客户服务热线1010-9955或登入<a href="https://www.zhongan.com/open/policy/policySearch1" style="" target="_blank">https://www.zhongan.com/open/policy/policySearch1</a>,对您所投保保单的相关信息进行查询。</p>
					</li>
					<li>
						<h3>若承办方（主办方）已购买公众责任险，参展商还有必要买该产品吗？</h3>
						<p>众安展会综合责任险保障范围：
							被保险人或其雇请人员在展览会活动临建设施搭建到活动结束设施拆除期间因过失等行为造成展览场所财产损失、第三者以及雇请工作人员的人身伤害时依法应承担的经济赔偿责任。
							公众责任险保障范围：
							承办方（主办方）在展览会举办过程中，因意外事故造成第三者（非承办单位直接或间接雇用单位或人员）财产损失或人身伤害时依法应承担的经济赔偿责任。
							综上公众责任险转移的是承办方的赔偿责任风险，而并不能转移参展商、施工单位等赔偿责任。此外从保障责任上看，公众责任险不保障雇请人员人身风险，而展会责任险既包含对场馆方财产、第三者人身伤害的赔偿责任，也包含参展商及施工单位自己雇请人员的人身伤害，可有效补充公众责任险不足。</p>
					</li>--%>

				</ul>
			</div>

		</div>
		<div class="partic-right fr">
			<jsp:include page="../../../index/multi_ins_intro.jsp"/>
			<jsp:include page="../../../index/multi_hot_product_iframe.jsp"/>
		</div>
	</div>
</div>

<!--滚动轴滚动一定距离后出现固定导航栏-->
<div class="product-wed">
	<div class="wed-content">
		<ul class="clearfix" id="nav-more">
			<li class="current">
				<a href="#section-1">产品详情</a>
			</li>
			<li>
				<a href="#section-2">投保须知</a>
			</li>
			<li>
				<a href="#section-3">典型案例</a>
			</li>
			<li>
				<a href="#section-4">保险条款</a>
			</li>
			<li>
				<a href="#section-5">理赔流程</a>
			</li>
			<li>
				<a href="#section-6">常见问题</a>
			</li>
		</ul>
		<div class="share-buy fr">
            <span class="fl">
                 <i>保费</i>
                 <b>￥</b>
                 <em>${productDto.premium_min }起</em>
            </span>
			<a href="javascript:;" class="share-more fl copyPathToShare">立即分享</a>
			<c:if test="${productDto.p_status eq '0'}">
				<a href="javascript:;" onclick="layer.alert('该产品目前已下架，请选择其它产品！', {skin: 'layui-layer-lan',closeBtn: 0,anim: 4});" class="insur-buy fl insur-buy-gray">立即购买</a>
			</c:if>
			<c:if test="${productDto.p_status eq '1'}">
				<c:choose>
					<c:when test="${not empty userdetail ? ('BLB' eq userdetail.web_type) : true }">
						<a href="<c:url value='/insurance/gzx/policy/policyInit_iframe/${productDto.oid }?recommendCode=${recommendCode}&ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="insur-buy fl iframe-buy">立即购买</a>
					</c:when>
					<c:otherwise>
						<a href="<c:url value='/api/gzx/policyInit/${productDto.oid }?recommendCode=${recommendCode}&ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="insur-buy fl">立即购买</a>
					</c:otherwise>
				</c:choose>
			</c:if>
		</div>
	</div>
</div>

<!--产品链接复制弹出框-->
<div class="link-share">
	<h2 class="clearfix">提示
		<span id="link-close">
            <img src="<c:url value='/resources/version_new/images/link-close.png' />">
        </span>
	</h2>
	<div class="link-success">
		<p>
			<img src="<c:url value='/resources/version_new/images/link-success.png' />">
			<span>产品链接已复制！您可以将它分享给其他人。</span>
		</p>
		<a href="javascript:;" class="link-zhi">我知道了</a>
	</div>
</div>

<!--弹出框透明蒙板-->
<div class="link-mask"></div>

<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery-1.8.3.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/login.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery.nav.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/clipboard.min.js' />"></script>

<script>
    $(function(){
        /*var topWindow;
		for(topWindow=window;topWindow.parent!=null && topWindow.parent!=topWindow;topWindow=topWindow.parent){
			for(var i=0;i<topWindow.parent.frames.length;i++){
				var tObj = topWindow.parent.frames[i];
				if(tObj.window.document==topWindow.document){
					var tName = tObj.name;
					if(tName != ''){
					    var bread_crumbs;
						if(tName.indexOf('frame3d')!=-1){//是自己平台的iframe
                            bread_crumbs = "当前位置: <a href='<c:url value="/" />'>首页</a> > <a target='_blank' href='<c:url value="/synopsis/product/productAllView" />'>产品列表</a> > <span id='place'>产品详情</span>";
						}else{//别平台嵌入页面
                            bread_crumbs = "当前位置: 保障服务 > <a href='<c:url value="/api/gzx/product/productAllView" />'>产品列表</a> > <span id='place'>产品详情</span>";
						}
                        $("#bread_crumbs").html(bread_crumbs);
					}
				}
			}
		}*/
        //计划的切换
        $('.insur-plan ul li').click(function () {
            $('.insur-plan ul li').removeClass('on');
            $(this).addClass('on');
        });
        $("#insur-p-p").html('· '+'${productDto.intro}'.replace(/<.*?>/ig,''));
        $("#section-3").find("p").each(function(){
            $(this).html($(this).html().replace(/<.*?>/ig,''));
            $(this).attr("class","case-one");
        });
        $("#section-6-p").html(function(){
            var c=1;
            var lis = '';
            $("#section-6-p").find("p").each(function(){
                var htl = $(this).html().replace(/<.*?>/ig,'');
                if(htl != '' && htl != '&nbsp;' && htl != ' '){
                    if(c % 2 == 1){
                        lis = lis + '<li><h3>'+htl+'</h3>';
                    }else{
                        lis = lis + '<p>'+htl+'</p></li>';
                    }
                    c++;
                }
            });
            return lis;
        });
    });

</script>
</body>
</html>
