<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
	<head>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/rrweb/css/rrweb.min.css?001' />" />
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>

<body>
<div class="container"><!-- container start -->
	<ol class="breadcrumb" id="bread_crumbs">
	</ol>
	<div class="nav-list">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 active">
				<p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 pull-right">
				<p><i class="pull-left">4</i><span class="pull-left">完成投保</span></p>
			</div>
		</div>
	</div>
	<form class="form-horizontal form-create-item" action="<c:url value='/api/gmr/transaction/policyPayment?ACCESS_TOKEN=${ACCESS_TOKEN}' />" method="post" id="policyPaymentForm">
		<input name="policyId" value="${dto.oid}" type="hidden"/>
		<div class="message-war"><!-- message-war start --> 
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="p-table">
						<table class="table">
							<thead>
								<tr>
								  <th>产品名称</th>
								  <th>保障期限</th>
								  <th>保费</th> 
								</tr>
							</thead>
							<tbody>
							<tr>
								<td>${dto.product_name}</td>
								<td>${dto.inception_date} 至 ${dto.planned_end_date}</td>
								<td>${dto.gross_premium}元</td>
							</tr>
							</tbody>
						</table>
					</div>
				<p class="fs16">所需支付金额￥${dto.gross_premium}</p>
				<div class="bg-f5f8fa">支付方式</div>
				<div class="row">
					<%--<div class="col-sm-2 col-xs-2 rad-io mt-20">
						<span><input type="radio" name="payType" value="ONLINE" id="radio1" disabled><label for="radio1" class="pull-left"></label><strong  class="pull-left">在线支付</strong></span>
					</div>--%>
					<div class="col-sm-2 col-xs-2 rad-io mt-20">
						<span><input type="radio" name="payType" value="OFFLINE" id="radio2" checked="checked"><label for="radio2" class="pull-left"></label><strong  class="pull-left">线下转账</strong></span>
					</div> 
				</div> 
			</div><!-- w-95-auto end -->
		</div><!-- message-war end --> 
	</form>
	<div class="row next-step">
		<div class="col-sm-3 col-xs-3 text-right pull-right">
			<p><a href="javascript:void(0);" onclick="submitPayment();" class="ns-btn">立即支付</a></p>
		</div>
	</div>
</div><!-- container end -->
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/script/html2canvas.min.js' />"></script>
<%--<script type="text/javascript" src="<c:url value='/resources/commonJS/canvasFileUpload.js' />"></script>--%>
<jsp:include page="../../../index/multi_init_param.jsp"/>

<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb.min.js?1003' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb-save.js?1003' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/watermark.js?7' />"></script>
<script>
	window.onload = function () {
		//以后优化 频繁变更水印
		watermark.load({ watermark_txt: "${fns:getWatermark(dto.trade_serial_number)}" });
	}
	var baseUrl = '${pageContext.request.contextPath }';
	$(function(){
        var topWindow;
        for(topWindow=window;topWindow.parent!=null && topWindow.parent!=topWindow;topWindow=topWindow.parent){
            for(var i=0;i<topWindow.parent.frames.length;i++){

                var isIframe = true;
                try {
                    topWindow.parent.frames[i].window.document;
                }catch (e) {
                    isIframe = false;
                }
                if(isIframe){
                    if(topWindow.parent.frames[i].window.document==topWindow.document){
                        var tName = topWindow.parent.frames[i].name;
                        if(tName != ''){
                            var bread_crumbs;
                            if(tName.indexOf('layui-layer-iframe')==-1){
                                $("ol[class*='breadcrumb']").each(function(){
                                    $(this).html('');
                                });
                                parent.document.getElementById("frame3d").height=600;
                            }

                        }
                    }
                }

            }
        }
	});
	function submitPayment() {

		var payType = $("input[name='payType']:checked").val();
		if(payType == ''){
            layer.msg("请选择支付方式");
		}else{
            var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
			$.ajax({
				type: 'POST',
				url:baseUrl + '/api/gmr/transaction/policyPayment?ACCESS_TOKEN=${ACCESS_TOKEN}',
				data:$("#policyPaymentForm").serialize(),
				dataType:"json",
				async:false,
				success: function(json){
					if(json.statusCode == '200') {
						insOperation('${dto.oid}','','订单在线支付');
                        window.location.href = baseUrl + '/api/gmr/policy/policyPayment/${dto.oid}?user_id=${user_id}&ACCESS_TOKEN=${ACCESS_TOKEN}';
					}
					if(json.statusCode == '300') {
                        layer.close(index);
						layer.msg(json.message);
						insOperation('${dto.oid}','','订单在线支付');
					}
				}
			});
		}
	}
</script>
</body>
</html>