<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/public.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/idangerous.swiper2.7.6.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/basic.css' />" />
	<title>${productDto.product_name}</title>
	<style>
		.aProject {
			width: 92px;
			height: 32px;
			font-size: 14px;
			line-height: 32px;
			text-align: center;
			background: -moz-linear-gradient(to right, #ff8b00, #ff6600);
			background: -webkit-linear-gradient(to right, #ff8b00, #ff6600);
			background: linear-gradient(to right, #ff8b00, #ff6600);
			color: #fff;
		}
		.aProject:hover{
			opacity: .8;
			cursor: pointer;
		}
	</style>
</head>
<body>

<!--产品详情页内容-->
<div class="product-particulars sqe">
	<div class="partic-place">
		<p id="bread_crumbs">
		</p>
		<ul class="clearfix" id="nav">
			<li class="current">
				<a href="#section-1">产品详情</a>
			</li>
			<li>
				<a href="#section-2">投保须知</a>
			</li>
			<li>
				<a href="#section-3">典型案例</a>
			</li>
			<li>
				<a href="#section-4">保险条款</a>
			</li>
			<li>
				<a href="#section-5">理赔流程</a>
			</li>
			<li>
				<a href="#section-6">常见问题</a>
			</li>
		</ul>
	</div>
	<div class="partic-content clearfix">
		<div class="partic-left fl">
			<div class="sed insur-content" id="section-1">
				<!--<div class="insur-logo">-->
				<!--<img src="<c:url value='/resources/version_new/images/taikang-green.png' />">-->
				<!--</div>-->
				<div class="insur-head clearfix">
					<p class="fl">${productDto.product_name}</p>
					<div class="insur-share fr">
                        <span class="fl" type="currency">
                            <i>￥</i>
                            <em>${productDto.premium_min }</em>
                        </span>
						<c:if test="${empty userdetail.web_type || fn:contains(userdetail.web_type, 'BLB')}">
							<a href="javascript:;" class="share-more fl copyPathToShare">立即分享</a>
						</c:if>
						<c:if test="${productDto.p_status eq '0'}">
							<a href="javascript:;" onclick="layer.alert('该产品目前已下架，请选择其它产品！', {skin: 'layui-layer-lan',closeBtn: 0,anim: 4});" class="insur-buy fl insur-buy-gray">立即购买</a>
						</c:if>
						<c:if test="${productDto.p_status eq '1'}">
                        	<a href="<c:url value='/api/gmr/policyInit/${productDto.oid }?recommendCode=${recommendCode}&ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="insur-buy fl">立即购买</a>
						</c:if>
					</div>
				</div>
				<input type="hidden" id="fe_text" value=""/>
				<ul class="insur-label clearfix">
					<c:if test="${fn:contains(productDto.product_label,',')}">
						<c:forEach items="${fn:split(productDto.product_label,',')}" var="lables">
							<li>${lables}</li>
						</c:forEach>
					</c:if>
					<c:if test="${fn:contains(productDto.product_label,' ')}">
						<c:forEach items="${fn:split(productDto.product_label,' ')}" var="lables">
							<li>${lables}</li>
						</c:forEach>
					</c:if>
				</ul>
				<p class="insur-p" id="insur-p-p">
				</p>
				<table cellspacing="0" cellpadding="0" class="wed">
					<tbody>
					<tr>
						<td>
							<span>保险公司</span>
						</td>
						<td>
							<span class="grey">${productDto.insurance_name}</span>
						</td>
						<td>
							<span>保险金额</span>
						</td>
						<td>
							<span class="grey">${productDto.dl_coverage}</span>
						</td>
					</tr>
					<tr>
						<td>
							<span>适用范围</span>
						</td>
						<td>
							<span class="grey">${productDto.scope}</span>
						</td>
						<td>
							<span>限购份数</span>
						</td>
						<td>
							<span class="grey">1份</span>
						</td>
					</tr>
					<tr>
						<td>
							<span>保单形式</span>
						</td>
						<td>
							<span class="grey">${productDto.from_of_policy}</span>
						</td>
						<td>
							<span>缴费期间</span>
						</td>
						<td>
							<span class="grey">${productDto.payment_way eq '1' ? '一次性' : productDto.payment_way eq '2' ? '分期' : productDto.payment_way eq '1,2' ? '一次性或分期' : '-'}</span>
						</td>
					</tr>
					<tr>
						<td>
							<span>保障期限</span>
						</td>
						<td>
							<span class="grey">${productDto.dl_rep_time}</span>
						</td>
						<td>
							<span>保费</span>
						</td>
						<td>
							<span class="grey">${productDto.dl_priem}</span>
						</td>
					</tr>
					<tr>
						<td>
							<span>承保年龄</span>
						</td>
						<td>
							<span class="grey">16-65周岁</span>
						</td>
						<td>
							<span>承保职业</span>
						</td>
						<td>
							<span class="grey">保安服务业</span>
						</td>
					</tr>
					</tbody>
				</table>
				<div class="insur-plan clearfix">
                    <span class="fl plan">
                        保险计划
                    </span>
					<ul class="clearfix fl" id="bx_jh">
					</ul>
				</div>
				<%--<div class="security-content">
					<p class="clearfix">
						<i class="fl"></i>
						<span class="fl">保费测算</span>
					</p>
					<div class="insur-plan clearfix" style="padding-left: 60px; margin-top: 10px">
						<span class="fl plan">
							标准方案
						</span>
						<div class="clearfix fl" style="margin-top: 5px;margin-left: 40px;font-size: 14px;width: 630px; word-break: break-all; word-wrap: break-word;">
							意外身故/伤残+意外医疗+意外住院津贴+烈士褒扬金+营运汽车意外身故/伤残+轨道列车意外身故/伤残
							+飞机意外身故/伤残+轮船意外身故/伤残
						</div>
					</div>
					<div class="insur-plan clearfix" style="padding-left: 60px; margin-top: 10px">
						<span class="fl plan">
							购买人数
						</span>
						<div class="clearfix fl" style="margin-left: 40px;">
							<input type="number" id="rs" class="form-control" style="width: 150px;height: 30px" placeholder="不低于3人">
						</div>
					</div>
					<div class="insur-plan clearfix" style="padding-left: 62px; margin-top: 10px">
						<span class="fl plan">
							&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
						</span>
						<div class="clearfix fl aProject" style="margin-top: 5px;margin-left: 40px;" onclick="bfcs();">
							测算
						</div>
					</div>
					<div class="insur-plan clearfix" style="padding-left: 65px;margin-top: 20px">
						<span class="fl plan">
							&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;保费
						</span>
						<div class="clearfix fl" style="margin-left: 40px;">
							<strong style="font-size: 20px" id="zbf">￥${productDto.premium_min }</strong>
						</div>
					</div>
				</div>--%>
				<div class="security-content">
					<p class="clearfix">
						<i class="fl"></i>
						<span class="fl">保障内容</span>
					</p>
					<table cellspacing="0" cellpadding="0">
						<thead>
						<tr>
							<th>
								<span>保障责任</span>
							</th>
							<th width="320">
								<span>保障说明</span>
							</th>
							<th>
								<span>保险金额</span>
							</th>
							<th>
								<span>免赔额</span>
							</th>
							<th>
								<span>赔付比例</span>
							</th>
							<th>
								<span>免赔天数</span>
							</th>
						</tr>
						</thead>
						<tbody>
						<c:forEach items="${ productDto.responsibilityVoList }" var="irp">
							<tr class="bg-3f" <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>
								<td class="ert">${irp.name}</td>
								<td class="text">
									<span <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>${irp.explain_product}</span>
								</td>
								<td>
									<span <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>
										<c:if test="${ empty irp.fcy}">
											-
										</c:if>
										<c:if test="${empty irp.compensation_days && not empty irp.fcy}">
											<c:if test="${irp.fcy/10000 >= 1}">
												${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
												万元
											</c:if>
											<c:if test="${irp.fcy/10000 < 1}">
												${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
												元
											</c:if>
										</c:if>
										<c:if test="${not empty irp.compensation_days && not empty irp.fcy}">
											<c:if test="${irp.fcy/10000 >= 1}">
												${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
												万元/天
											</c:if>
											<c:if test="${irp.fcy/10000 < 1}">
												${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
												元/天
											</c:if>
										</c:if>
									</span>
								</td>
								<td>
									<span>${empty irp.cumulative_deductibles ? '-' : irp.cumulative_deductibles}</span>
								</td>
								<td>
									<span>${empty irp.compensation_ratio ? '-' : irp.compensation_ratio}${not empty irp.compensation_ratio ? '%' : ''}</span>
								</td>
								<td>
									<span>${empty irp.deductible_days ? '-' : irp.deductible_days}</span>
								</td>
							</tr>
						</c:forEach>
						</tbody>
					</table>
				</div>
			</div>
			<div class="sed insur-informa" id="section-2">
				<h2 class="clearfix">
					<i class="fl"></i>
					<span class="fl">投保须知</span>
				</h2>
				<p id="section-p-2">
					<c:if test="${fn:contains(productDto.notice_mod,'<p>')}">
						${fn:replace(fn:replace(fn:replace(fn:replace(fn:replace(productDto.notice_mod, '<br>', ''), '<br/>', ''), '<p></p>', ''), '<p>', ''), '</p>', '<br/>')}
					</c:if>
					<c:if test="${fn:contains(productDto.notice_mod,'<div>')}">
						${fn:replace(fn:replace(fn:replace(fn:replace(fn:replace(productDto.notice_mod, '<br>', ''), '<br/>', ''), '<div></div>', ''), '<div>', ''), '</div>', '<br/>')}
					</c:if>
				</p>
				<%--<p>
					<span style="color: red">*</span> 隐私保护声明：您提供的个人信息、数据和隐私我们不会提供给任何未获授权的第三方。<br/>
					1.  本产品由平安养老保险股份有限公司承保,销售区域为全国。客户从本平台购买,后续理赔等相关事务均可由我们协助您办理。<br/>
					2.  本产品提供电子保单，也可根据客户需求提供纸质保单。<br/>
					3.  本产品为网络销售的保险产品组合计划，网上投保、网上支付、网上即时核保并出具保险凭证，您可拨打平安养老保险公司电话95511查询、验真。<br/>
					4.  平安养老保险股份有限公司2017年二季度的综合偿付能力充足率264.79%，最近一期风险综合评级为A，偿付能力充足率达到监管要求。<br/>
					5.  本计划最低投保人数为3人。<br/>
					6.  本产品在网上投保申请后，最早次日零时生效。<br/>
					7.   每一被保险人最高可投保意外身故保险金额为60万，若被保险人在平安养老保险股份有限公司拥有多份保单，每个被保险人意外身故保额累计不超过200万元，多投超出部分无效。<br/>
					8.  投保人所填写及告知内容，将作为保险公司签发保险单的依据及列为保险合同的组成部分，须保证属实。如投保人有隐瞒或者告知不实，保险公司有权解除保险合同，并不承担任何责任。<br/>
					9.  本计划中的医疗相关保障限定就诊医院为：中华人民共和国境内（港、澳、台地区除外）合法经营的二级以上（含二级）公立医院。<br/>
					10.  本产品承保被保险人为年龄16-65周岁的保安公司保安人员及非从事保安工作人员。保安人员需持有有效保安员证并与投保单位签署劳动合同；非从事保安工作人员需为与投保单位签署劳动合同的1-4类职业人员。可承保行业详情请点击下方<a href="<c:url value='/occupation_table' />" target="_blank" style="color: blue">职业分类表</a>，若被保险人从事5类及5类以上职业或拒保职业的工作发生意外事故，不属于保险责任范围。
				</p>--%>
			</div>
			<div class="sed insur-case" id="section-3">
				<h2 class="clearfix">
					<i class="fl"></i>
					<span class="fl">典型案例</span>
				</h2>
				${productDto.sample_mod}
				<%--<p class="case-one">
					北京某保安公司派遣保安人员常驻在住宅小区提供安全保卫工作，考虑到保安人员流动性大且执勤期间存在一定风险，于是在平台购买了一份
					<i>平安是福保安团意险计划二（团体保障）</i>，保费<i>260元/人</i>，在保险期间如有人员变更，可在线申请加人、减人或换人，同时享受保障：
				</p>
				<div class="insur-wer">
					<p>
						意外身故(伤残)-<span>30万</span>
					</p>
					<p>
						烈士褒扬金-<span>30万</span>
					</p>
					<p>
						飞机意外-<span>30万</span>
					</p>
					<p>
						火车/轮船/轨道交通意外-<span>30万</span>
					</p>
					<p>
						营运汽车交通意外-<span>10万</span>
					</p>
					<p>
						意外医疗-<span>3万</span>
					</p>
					<p>
						住院津贴-<span>100/天</span>
					</p>
				</div>
				<p class="case-two">
					保险期间内，保安人员王某在夜晚巡检时被三轮车撞到，导致腿部受伤并入院治疗8天，在合理用药范围内花费医疗费用3万元。
					保险公司经核实符合保险责任范围，做出如下赔付：
				</p>
				<span class="case-number">支付意外医疗费用（30000-100）*100%=29900元（100元免赔，100%报销）</span>
				<span class="case-number">支付住院津贴100元/天*8天=800元</span>
				<p class="case-two">
					合计获得保险金30700元。
				</p>--%>
			</div>
			<div class="sed insur-clause" id="section-4">
				<h2 class="clearfix">
					<i class="fl"></i>
					<span class="fl">保险条款</span>
				</h2>
				<ul>
					<h2 style="font-size: 14px">特别提醒：保险责任请参考以下条款，并敬请特别留意条款中的<span style="color: red ;font-size: 14px" >"责任免除"</span>部分。</h2>
					<%--<li>
						<a target="_blank" href="<c:url value='/resources/files/P1421 平安交通团体意外伤害保险（2013版）条款.pdf' />">P1421 平安交通团体意外伤害保险（2013版）条款</a>
						<div class="clause-cic"></div>
					</li>
					<li>
						<a target="_blank" href="<c:url value='/resources/files/P1445 平安团体意外伤害保险（2013版）条款.pdf' />">P1445 平安团体意外伤害保险（2013版）条款</a>
						<div class="clause-cic cic"></div>
					</li>
					<li>
						<a target="_blank" href="<c:url value='/resources/files/P0512 平安附加意外伤害团体医疗保险条款.pdf' />">P0512 平安附加意外伤害团体医疗保险条款</a>
						<div class="clause-cic cic"></div>
					</li>
					<li>
						<a target="_blank" href="<c:url value='/resources/files/P0610 平安附加意外伤害住院现金补贴团体医疗保险条款.pdf' />">P0610 平安附加意外伤害住院现金补贴团体医疗保险条款</a>
						<div class="clause-cic cic"></div>
					</li>
					<li>
						<a target="_blank" href="<c:url value='/resources/files/《烈士褒扬条例》.pdf' />">《烈士褒扬条例》</a>
						<div class="clause-cic cic"></div>
					</li>--%>
					<c:if test="${not empty productDto.pro_clauses}">
						<c:forEach items="${fn:split(productDto.pro_clauses, '#')}" var="pcs">
							<li>
								<a target="_blank" href="<c:url value='/weixin/product/clause/${fn:split(pcs, "::")[0]}' />">${fn:split(pcs, "::")[1]}</a>
								<div class="clause-cic"></div>
							</li>
						</c:forEach>
					</c:if>
				</ul>
			</div>
			<div class="sed claims-process" id="section-5">
				<h2 class="clearfix">
					<i class="fl"></i>
					<span class="fl">理赔流程</span>
				</h2>
				<div class="claims-content">
					<div class="content-img">
						<img src="<c:url value='/resources/version_new/images/claims.png'/>" alt="理赔流程图">
					</div>
					<ul class="clearfix">
						<li>
							<p>拨打报案电话</p>
							<span>根据保单信息拨打相应保险公司报案电话或拨打平台报案电话400-662-9696或根据平台要求在线填写信息</span>
						</li>
						<li class="wer">
							<p>准备材料</p>
							<span>根据服务人员告知的资料清单准备理赔资料</span>
						</li>
						<li class="wed">
							<p>理赔办理</p>
							<span>提交理赔资料</span>
						</li>
						<li>
							<p>审核</p>
							<span>保险公司审核理赔材料</span>
						</li>
						<li class="jie">
							<p>结案</p>
							<span>确属保险责任范围的事故，保险公司将在约定时效内赔付</span>
						</li>
					</ul>
				</div>
			</div>
			<div class="sed common-problems" id="section-6">
				<h2 class="clearfix">
					<i class="fl"></i>
					<span class="fl">常见问题</span>
				</h2>
				<ul id="section-6-p">
					${productDto.faq_mod}
					<%--<li>
						<h3>有必要给保安人员买团体意外险吗？</h3>
						<p>首先，国务院颁布的《保安服务管理条例》中，第二十条明确规定“保安从业单位应当根据保安服务岗位的风险程度为保安员投保意外伤害保险。”同时，保安工作较一般工作风险性高，为保安人员投保团体意外险，即可保障保安人员人身损伤，又可转移保安从业单位的管理风险。</p>
					</li>
					<li>
						<h3>电子保单靠谱吗？</h3>
						<p>根据《中华人民共和国合同法》第十一条规定，数据电文是合法的合同表现形式，电子保单与纸质保单具有同等法律效力。</p>
					</li>
					<li>
						<h3>最少可以多少人起投保？</h3>
						<p>该产品最低投保人数为3人。</p>
					</li>
					<li>
						<h3>如何查询验证保单？</h3>
						<p>投保完成后,您可在账户内查看下载电子保单。为保证您的合法权益,您可通过访问平安养老保险网址<a href="http://annuity.pingan.com/kehufuwu/fuwugongju/duanqiyiwaixianchayan.shtml" style="" target="_blank">http://annuity.pingan.com/kehufuwu/fuwugongju/duanqiyiwaixianchayan.shtml</a>或拨打客户服务热线95511,对您所投保保单的相关信息进行查询。</p>
					</li>
					<li>
						<h3>信息或人员变化后能够在线修改？</h3>
						<p>在保险期间内，我们提供在线变更投保信息及人员增、减、替换服务，您可在保单服务里提交批改申请，由保险公司后台快速审核通过。</p>
					</li>
					<li>
						<h3>可以在什么医院就诊？</h3>
						<p>可在平安养老与投保人约定的定点医院就诊治疗，未约定定点医院的，则应在中华人民共和国境内（港、澳、台地区除外）合法经营的二级以上（含二级）公立医院就诊治疗。</p>
					</li>
					<li>
						<h3>烈士褒扬金的给付条件是什么，能否与意外身故金同时给付？</h3>
						<p>保安人员在执行安全工作时遭受意外事故，并自事故发生之日起180日内因该事故身故的，且根据中华人民共和国国务院公布的《烈士褒扬条例》评定情形，被评定为烈士的，可享有烈士褒扬金，同时仍可获得意外身故金的给付。</p>
					</li>--%>
				</ul>
			</div>

		</div>
		<div class="partic-right fr">
			<jsp:include page="../../../index/multi_ins_intro.jsp"/>
			<jsp:include page="../../../index/multi_hot_product_iframe.jsp"/>
		</div>
	</div>
</div>

<!--滚动轴滚动一定距离后出现固定导航栏-->
<div class="product-wed">
	<div class="wed-content">
		<ul class="clearfix" id="nav-more">
			<li class="current">
				<a href="#section-1">产品详情</a>
			</li>
			<li>
				<a href="#section-2">投保须知</a>
			</li>
			<li>
				<a href="#section-3">典型案例</a>
			</li>
			<li>
				<a href="#section-4">保险条款</a>
			</li>
			<li>
				<a href="#section-5">理赔流程</a>
			</li>
			<li>
				<a href="#section-6">常见问题</a>
			</li>
		</ul>
		<div class="share-buy fr">
            <span class="fl">
                 <i>保费</i>
                 <b>￥</b>
                 <em>${productDto.premium_min }</em>
            </span>
			<a href="javascript:;" class="share-more fl copyPathToShare">立即分享</a>
			<c:if test="${productDto.p_status eq '0'}">
				<a href="javascript:;" onclick="layer.alert('该产品目前已下架，请选择其它产品！', {skin: 'layui-layer-lan',closeBtn: 0,anim: 4});" class="insur-buy fl insur-buy-gray">立即购买</a>
			</c:if>
			<c:if test="${productDto.p_status eq '1'}">
				<c:choose>
					<c:when test="${not empty userdetail ? ('BLB' eq userdetail.web_type) : true }">
						<a href="<c:url value='/insurance/gmr/policy/policyInit_iframe/${productDto.oid }?recommendCode=${recommendCode}&ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="insur-buy fl iframe-buy">立即购买</a>
					</c:when>
					<c:otherwise>
						<a href="<c:url value='/api/gmr/policyInit/${productDto.oid }?recommendCode=${recommendCode}&ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="insur-buy fl">立即购买</a>
					</c:otherwise>
				</c:choose>
			</c:if>
		</div>
	</div>
</div>

<!--产品链接复制弹出框-->
<div class="link-share">
	<h2 class="clearfix">提示
		<span id="link-close">
            <img src="<c:url value='/resources/version_new/images/link-close.png' />">
        </span>
	</h2>
	<div class="link-success">
		<p>
			<img src="<c:url value='/resources/version_new/images/link-success.png' />">
			<span>产品链接已复制！您可以将它分享给其他人。</span>
		</p>
		<a href="javascript:;" onclick="$(this).parent().parent().hide();$('.link-mask').hide();" class="link-zhi">我知道了</a>
	</div>
</div>

<!--弹出框透明蒙板-->
<div class="link-mask"></div>

<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery-1.8.3.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/login.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery.nav.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/clipboard.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>
<jsp:include page="../../../index/multi_init_param.jsp"/>

<script>
    var baseUrl = '${pageContext.request.contextPath }';
    $(function(){
		<%--<c:if test="${empty userdetail.web_type || fn:contains(userdetail.web_type, 'BLB')}">
			var _ph = window.parent.$('#frame3d').attr('src');
			if(_ph != undefined && _ph != ''){
				window.parent.$('#link-share-more').remove();
				window.parent.$('#link-mask-more').remove();
				window.parent.$('#tag-top').remove();
				$('#link-share-more').remove();
				$('#link-mask-more').remove();
				$('#tag-top').remove();
			}
		</c:if>--%>
        //计划的切换
        $('.insur-plan ul li').click(function () {
            $('.insur-plan ul li').removeClass('on');
            $(this).addClass('on');
        });
		//点击复制链接
        var s_url = '${sharePath }';

        var clipboard = new Clipboard('.copyPathToShare', {
            text: function() {
                return s_url;
            }
        });

        clipboard.on('success', function(e) {
            $('.link-share').show();
            $('.link-mask').show();
        });
        $('#link-close').click(function () {
            $('.link-share').hide();
            $('.link-mask').hide();
        });

        $('#link-zhi').click(function () {
            $('.link-share').hide();
            $('.link-mask').hide();
        });
        $("#insur-p-p").html('· '+'${productDto.intro}'.replace(/<.*?>/ig,''));
		$("#section-3").find("p").each(function(){
            $(this).html($(this).html().replace(/<.*?>/ig,''));
            $(this).attr("class","case-one");
        });
        $("#section-6-p").html(function(){
            var c=1;
            var lis = '';
            $("#section-6-p").find("p").each(function(){
                var htl = $(this).html().replace(/<.*?>/ig,'');
                if(htl != '' && htl != '&nbsp;' && htl != ' '){
                    if(c % 2 == 1){
                        lis = lis + '<li><h3>'+htl+'</h3>';
                    }else{
                        lis = lis + '<p>'+htl+'</p></li>';
                    }
                    c++;
                }
            });
            return lis;
        });
        //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
        setParamDatas('',baseUrl+'/synopsis/product/productListByCode/TYX-PAS',true,false,function(data){
            var _hs = '';
            $.each(data, function(i, obj){
                if(obj.product_code != ''&&obj.product_code!=null&&obj.product_code!=undefined){
                    if(obj.product_code.indexOf('TYX-PAS')!=-1){
                        var sg = obj.product_code.split('-')[obj.product_code.split('-').length-1];
                        var _u = baseUrl + "/api/gmr/product/productInfo/" + obj.oid+"?ACCESS_TOKEN=${ACCESS_TOKEN}";
                        var _liC;
                        if('${productDto.oid}' == obj.oid){
                            _liC = "class='on'";
                        }else{
                            _liC = "onclick='javascript:location.href=\""+_u+"\";'";
                        }
                        _hs = _hs + "<li "+_liC+"><span>"+ getName(sg) +"</span><div class='plan-gou'></div></li>";
                    }
                }
            });
            if(_hs != ''){
                $("#bx_jh").html(_hs);
            }
        });
    });
    function getName(_num){
        return _num == '1' ? '计划一' : _num == '2' ? '计划二' : _num == '3' ? '计划三' : _num == '4' ? '计划四' : _num == '5' ? '计划五' : _num == '6' ? '计划六' : _num == '7' ? '计划七' : _num == '8' ? '计划八' : _num == '9' ? '计划九' : '';
    }
    function bfcs(){
        var rs = $('#rs').val();
        var reg = /^[1-9]\d*$/;
        if(rs == ''||!reg.test(rs)||rs.length>4||Number(rs)<3){
            layer.msg("请正确输入购买人数，限制3~10000人");
            return;
        }
        var person_num = $('#rs').val();
        var doNum = Number(person_num);
        var zbf = doNum * parseFloat('${productDto.premium_min}');
        $('#zbf').html('￥'+zbf+'.00');
    }
</script>
</body>
</html>
