<%@ page language="java" contentType="text/html;charset=UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=edge"/>
	<meta name="viewport" content="width=device-width, initial-scale=1"/>
	<title>保障服务－我的保单</title>
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/bootstrap.min.css' />"/>
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/font-awesome.css' />"/>
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/common.css' />"/>
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/product.css' />"/>
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/newslist.css' />"/>
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/fileinput.css' />"/>
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/select2.css' />"/>
	<link type="text/css" rel="stylesheet"
		  href="<c:url value='/resources/version_new/css/jquery.datetimepicker.css' />"/>
	<link type="text/css" rel="stylesheet"
		  href="<c:url value='/resources/version_new/css/hdsb.css' />"/>
	<!--[if lt IE 9]>
	<script src="//cdn.bootcss.com/html5shiv/3.7.2/html5shiv.min.js"></script>
	<script src="//cdn.bootcss.com/respond.js/1.4.2/respond.min.js"></script>
	<![endif]-->

</head>
<body<%-- style="overflow-y: hidden;"--%>>
<c:if test="${fn:contains(userdetail.web_type, 'PSS')}">
	<div class="order-header ert-header clearfix" style="width: 1230px;">
		<span>当前位置：</span>
		<a href="javascript:void(0);">保障服务></a>
		<a href="<c:url value='/api/order/myOrder?ACCESS_TOKEN=${ACCESS_TOKEN}' />">我的订单></a>
		<a href="javascript:void(0);">订单详情</a>
	</div>
</c:if>
<div class="wer">
<div class="main product-we">

	<%--<div class="row">--%>
		<%--<ol class="breadcrumb pull-left">--%>
			<%--<li><span>当前位置：</span></li>--%>
			<%--<li><a href="<c:url value='/pc/order/myOrder' />" class="active">保单列表</a></li>--%>
			<%--<li><span class="active">投保详情</span></li>--%>
		<%--</ol>--%>
	<%--</div>--%>
	<div class="row main-title clearfix mt20">
		<div class="main-title-name pull-left">公众责任保险</div>
	</div>
	<div class="row bgf">
		<p class="mt20 text-center">订单号码：${dto.trade_serial_number}</p>
		<p class="mt20 text-center">保单号码：${dto.external_reference}</p>
		<div class="col-md-12  table-responsive">
			<table class="table message-table">
				<tbody>
				<tr>
					<td rowspan="5" class="col-sm-2 pt46"><strong>投保人信息</strong></td>
					<td class="col-sm-2 bg-f9fafc">投保人名称</td>
					<td class="col-sm-2">${vo.roleSubjectList[0].name_cn}</td>
					<td class="col-sm-2 bg-f9fafc" >投保人地址</td>
					<td class="col-sm-3" colspan="2">${reg_role}${vo.roleSubjectList[0].reg_address}</td>
				</tr>
				<tr>
					<td class="col-sm-2 bg-f9fafc">联系人</td>
					<td class="col-sm-2">${vo.roleSubjectList[0].link_name}</td>
					<td class="col-sm-2 bg-f9fafc">联系电话</td>
					<td class="col-sm-3" colspan="2">${vo.roleSubjectList[0].link_phone}</td>
				</tr>
				<tr>
					<td class="col-sm-2 bg-f9fafc">投保人证件类型</td>
					<td class="col-sm-2">
						<c:if test="${vo.roleSubjectList[0].id_type eq '7'}">
						营业执照
						</c:if>
						<c:if test="${vo.roleSubjectList[0].id_type eq '8'}">
							税务登记证
						</c:if>
						<c:if test="${vo.roleSubjectList[0].id_type eq '9'}">
							组织机构代码证
						</c:if>
					</td>
					<td class="col-sm-2 bg-f9fafc">投保人证件号码</td>
					<td class="col-sm-3" colspan="2">${vo.roleSubjectList[0].organization_code}</td>
				</tr>
				<tr>
					<td class="col-sm-2 bg-f9fafc">产品名称</td>
					<td class="col-sm-3">${pd.product_name}</td>
					<td class="col-sm-1 bg-f9fafc">保费（元）</td>
					<td class="col-sm-2">￥${dto.gross_premium}</td>
				</tr>
				<tr>
					<td class="col-sm-2 bg-f9fafc">保障期限</td>
					<td class="col-sm-2"> ${vo.inception_date}
						零时起至
						${vo.planned_end_date}二十四时止</td>
				</tr>
				<tr>
					<td rowspan="4" class="col-sm-2 pt46"><strong>被保险人信息</strong></td>
					<td class="col-sm-2 bg-f9fafc">被保险人名称</td>
					<td class="col-sm-2">${vo.roleSubjectList[1].name_cn}</td>
					<td class="col-sm-2 bg-f9fafc">被保险人地址</td>
					<td class="col-sm-3" colspan="2">${reg_role_1}${vo.roleSubjectList[1].reg_address}</td>
				</tr>
				<tr>
					<td class="col-sm-2 bg-f9fafc">联系人</td>
					<td class="col-sm-2">${vo.roleSubjectList[1].link_name}</td>
					<td class="col-sm-2 bg-f9fafc">联系电话</td>
					<td class="col-sm-3" colspan="2">${vo.roleSubjectList[1].link_phone}</td>
				</tr>
				<tr>
					<td class="bg-f9fafc">营业性质</td>
					<td width="18%">${vo.roleSubjectList[1].com_type}</td>
					<td class="col-sm-2 bg-f9fafc">被保险人证件类型</td>
					<td class="col-sm-2">
						<c:if test="${vo.roleSubjectList[1].id_type eq '7'}">
							营业执照
						</c:if>
						<c:if test="${vo.roleSubjectList[1].id_type eq '8'}">
							税务登记证
						</c:if>
						<c:if test="${vo.roleSubjectList[1].id_type eq '9'}">
							组织机构代码证
						</c:if>
					</td>
				</tr>
				<tr>
					<td class="col-sm-2 bg-f9fafc">被保险人证件号码</td>
					<td class="col-sm-3" colspan="2">${vo.roleSubjectList[1].organization_code}</td>
				</tr>
				<tr>
					<td rowspan="4" class="col-sm-2 pt46"><strong>活动信息</strong></td>
					<td class="col-sm-2 bg-f9fafc">活动名称</td>
					<td class="col-sm-2">${vo.report_name}</td>
					<td class="col-sm-2 bg-f9fafc">活动类型</td>
					<td class="col-sm-3" colspan="2">
						<c:if test="${vo.report_active eq 'ZL'}">
							展览展销类
						</c:if>
						<c:if test="${vo.report_active eq 'WY'}">
							文艺演出类
						</c:if>
						<c:if test="${vo.report_active eq 'TY'}">
							体育赛事类
						</c:if>
						<c:if test="${vo.report_active eq 'QT'}">
							其他类活动
						</c:if>
					</td>
				</tr>
				<tr>
					<td class="col-sm-2 bg-f9fafc">活动时间</td>
					<td class="col-sm-2">${vo.report_begin_date}—${vo.report_end_date}</td>
					<td class="col-sm-2 bg-f9fafc">承保区域</td>
					<td class="col-sm-3" colspan="2">
						<c:if test="${vo.activity_local eq 'INDOOR'}">
							室内场馆
						</c:if>
						<c:if test="${vo.activity_local eq 'OPEN'}">
							露天场馆
						</c:if>
						<c:if test="${vo.activity_local eq 'OUTDOOR'}">
							户外场馆
						</c:if>
					</td>
				</tr>
				<tr>
					<td class="col-sm-2 bg-f9fafc">活动场所消防情况</td>
					<td class="col-sm-2">
						<c:if test="${vo.activity_fire_fight eq 'ACCEPTANCE'}">
							有消防验收
						</c:if>
						<c:if test="${vo.activity_fire_fight eq 'EXTINGUISHER'}">
							无消防验收但配备灭火器
						</c:if>
						<c:if test="${vo.activity_fire_fight eq 'NO_EXTINGUISHER'}">
							无消防验收无灭火器
						</c:if>
					</td>
					<td class="col-sm-2 bg-f9fafc">有无危险环节（如烟花）</td>
					<td class="col-sm-3" colspan="2">
						<c:if test="${vo.danger eq 'HAVE'}">
							有
						</c:if>
						<c:if test="${vo.danger eq 'WITHOUT'}">
							无
						</c:if>
					</td>
				</tr>
				<tr>
					<td class="col-sm-2 bg-f9fafc">预计活动参与总人数</td>
					<td class="col-sm-2">${vo.people_num}</td>
					<td class="col-sm-2 bg-f9fafc">预计天数</td>
					<td class="col-sm-3" colspan="2">${vo.activity_days}</td>
				</tr>
				<tr>
					<td rowspan="2" class="col-sm-2 pt46"><strong>保险方案</strong></td>
					<td class="col-sm-2 bg-f9fafc">每人每次事故赔偿限额</td>
					<td class="col-sm-2">25万元</td>
					<td class="col-sm-2 bg-f9fafc">每次事故及累计赔偿限额</td>
					<td class="col-sm-2" colspan="2">${vo.insured_amount/10000}万</td>
				</tr>
				<tr>
					<td class="col-sm-2 bg-f9fafc">免赔设定</td>
					<td class="col-sm-3" colspan="8">财产损失500元，人身伤害无免赔</td>
				</tr>
				<tr>
					<td class="col-sm-2 bg-f9fafc"><strong>保险期间</strong></td>
					<td colspan="8">自
						${vo.inception_date}
						零时起至
						${vo.planned_end_date}二十四时止</td>
				</tr>
				<tr>
					<td class="col-sm-2 bg-f9fafc"><strong>总保险费</strong></td>
					<td colspan="8">￥${dto.gross_premium}元</td>
				</tr>
				<tr>
					<td class="col-sm-2 bg-f9fafc pt46"><strong>附加条款</strong><br>
						<span>（赔偿限额同主条款）</span></td>
					<td colspan="8">
						<ul>
							<li>下列附加条款适用于本保险单的各个部分，若其与本保险单的其他规定相冲突，则以下列附加条款为准。</li>
							<li>交叉责任条款</li>
							<li>罢工、暴乱、民众骚动及恶意破坏条款</li>
							<li>火灾和爆炸责任条款</li>
							<li>急救费用条款</li>
							<li>广告及装饰装置责任条款</li>
						</ul>
					</td>
				</tr>
				<tr>
					<td class="col-sm-2 bg-f9fafc pt46"><strong>争议处理</strong></td>
					<td colspan="8">
						<ul>
							<li>解决方式：</li>

							<li><c:if test="${vo.dispute eq '1'}">仲裁:${vo.policy_extra_dispute}</c:if>
								<c:if test="${vo.dispute eq '0'}">诉讼</c:if></li>


						</ul>
					</td>
				</tr>
				<tr>
					<td class="col-sm-2 bg-f9fafc pt46"><strong>特别约定</strong></td>
					<td colspan="8">
						<ul>
							<li>1、本保单不负责赔偿由于第三者自身原因（包括但不限于自身疾病、自身运动损伤、自身体质等）导致的人身伤亡或财产损失事故，被保险人所承担的经济赔偿责任。</li>
							<li>2、参与文艺演出、体育赛事的演员、运动员不在本保单承保范围内。</li>

							<li>用于展出的展品遭受的任何损失，不在本保单承保范围内。</li>

						</ul>
					</td>
				</tr>
				</tbody>
			</table>

			<div class="col-sm-12 col-xs-12 clearfix">

				<div class="mtb20 text-right btn-paymethod-group">

					<c:if test="${not empty dto.insure_path}">
						<a href="${dto.insure_path}" class="btn btn-lightblue " id="btn_confirm_pay">下载电子保单</a>
						<a href="#" onclick="tanchuan()" class="btn btn-lightblue " id="btn_confirm_pay">申请理赔</a>
					</c:if>

				<%--	<a href="#" target="_blank" class="btn btn-lightblue">立即支付</a>--%>
				</div>
			</div>
		</div>
	</div>

</div>
</div>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery.min.js' />"></script>
<!--<script type="text/javascript" src="../static/js/bootstrap.min.js"></script>-->
<!--<script type="text/javascript" src="../static/js/product.js"></script>-->

<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery.form.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/layer.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/enter.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/select2.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery.datetimepicker.full.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/footerwarp.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/popup-bottom.js' />"></script>
<jsp:include page="../../../index/multi_init_param.jsp"/>


<script type="text/javascript">
	function  tanchuan(){
		parent.layer.open({
			title: '  您可以通过以下方式进行报案理赔'
			,content: '拨打华泰财险的全国热线（95509）<br/>   拨打百川信7×24小时客服热线（400-662-9696）'
		});
	}

	window.onload = function () {
		$('#frame3d',parent.document).css("height",1330+'px');
	}
</script>

</body>

</html>
